/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2026-01-31 05:54:00 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `claim_id_status_priority_scheduled_date_gmt` (`claim_id`,`status`,`priority`,`scheduled_date_gmt`),
  KEY `status_last_attempt_gmt` (`status`,`last_attempt_gmt`),
  KEY `status_claim_id` (`status`,`claim_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11205 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=24212 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=33557 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aioseo_ai_insights_keyword_reports` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(40) NOT NULL,
  `keyword` varchar(255) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  `brands` longtext DEFAULT NULL,
  `brands_mentioned` int(11) DEFAULT 0,
  `results` longtext DEFAULT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ndx_aioseo_ai_insights_keyword_reports_uuid` (`uuid`),
  KEY `ndx_aioseo_ai_insights_keyword_reports_keyword` (`keyword`),
  KEY `ndx_aioseo_ai_insights_keyword_reports_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aioseo_cache` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(80) NOT NULL,
  `value` longtext NOT NULL,
  `is_object` tinyint(1) DEFAULT 0,
  `expiration` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ndx_aioseo_cache_key` (`key`),
  KEY `ndx_aioseo_cache_expiration` (`expiration`)
) ENGINE=InnoDB AUTO_INCREMENT=162 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aioseo_crawl_cleanup_blocked_args` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `key` text DEFAULT NULL,
  `value` text DEFAULT NULL,
  `key_value_hash` varchar(40) DEFAULT NULL,
  `regex` varchar(150) DEFAULT NULL,
  `hits` int(20) NOT NULL DEFAULT 0,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ndx_aioseo_crawl_cleanup_blocked_args_key_value_hash` (`key_value_hash`),
  UNIQUE KEY `ndx_aioseo_crawl_cleanup_blocked_args_regex` (`regex`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aioseo_crawl_cleanup_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` text NOT NULL,
  `key` text NOT NULL,
  `value` text DEFAULT NULL,
  `hash` varchar(40) NOT NULL,
  `hits` int(20) NOT NULL DEFAULT 1,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ndx_aioseo_crawl_cleanup_logs_hash` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aioseo_notifications` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(13) NOT NULL,
  `addon` varchar(64) DEFAULT NULL,
  `title` text NOT NULL,
  `content` longtext NOT NULL,
  `type` varchar(64) NOT NULL,
  `level` text NOT NULL,
  `notification_id` bigint(20) unsigned DEFAULT NULL,
  `notification_name` varchar(255) DEFAULT NULL,
  `start` datetime DEFAULT NULL,
  `end` datetime DEFAULT NULL,
  `button1_label` varchar(255) DEFAULT NULL,
  `button1_action` varchar(255) DEFAULT NULL,
  `button2_label` varchar(255) DEFAULT NULL,
  `button2_action` varchar(255) DEFAULT NULL,
  `dismissed` tinyint(1) NOT NULL DEFAULT 0,
  `new` tinyint(1) NOT NULL DEFAULT 1,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ndx_aioseo_notifications_slug` (`slug`),
  KEY `ndx_aioseo_notifications_dates` (`start`,`end`),
  KEY `ndx_aioseo_notifications_type` (`type`),
  KEY `ndx_aioseo_notifications_dismissed` (`dismissed`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aioseo_posts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL,
  `title` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `keywords` mediumtext DEFAULT NULL,
  `keyphrases` longtext DEFAULT NULL,
  `page_analysis` longtext DEFAULT NULL,
  `primary_term` longtext DEFAULT NULL,
  `canonical_url` text DEFAULT NULL,
  `og_title` text DEFAULT NULL,
  `og_description` text DEFAULT NULL,
  `og_object_type` varchar(64) DEFAULT 'default',
  `og_image_type` varchar(64) DEFAULT 'default',
  `og_image_url` text DEFAULT NULL,
  `og_image_width` int(11) DEFAULT NULL,
  `og_image_height` int(11) DEFAULT NULL,
  `og_image_custom_url` text DEFAULT NULL,
  `og_image_custom_fields` text DEFAULT NULL,
  `og_video` varchar(255) DEFAULT NULL,
  `og_custom_url` text DEFAULT NULL,
  `og_article_section` text DEFAULT NULL,
  `og_article_tags` text DEFAULT NULL,
  `twitter_use_og` tinyint(1) DEFAULT 0,
  `twitter_card` varchar(64) DEFAULT 'default',
  `twitter_image_type` varchar(64) DEFAULT 'default',
  `twitter_image_url` text DEFAULT NULL,
  `twitter_image_custom_url` text DEFAULT NULL,
  `twitter_image_custom_fields` text DEFAULT NULL,
  `twitter_title` text DEFAULT NULL,
  `twitter_description` text DEFAULT NULL,
  `seo_score` int(11) NOT NULL DEFAULT 0,
  `schema` longtext DEFAULT NULL,
  `schema_type` varchar(20) DEFAULT 'default',
  `schema_type_options` longtext DEFAULT NULL,
  `pillar_content` tinyint(1) DEFAULT NULL,
  `robots_default` tinyint(1) NOT NULL DEFAULT 1,
  `robots_noindex` tinyint(1) NOT NULL DEFAULT 0,
  `robots_noarchive` tinyint(1) NOT NULL DEFAULT 0,
  `robots_nosnippet` tinyint(1) NOT NULL DEFAULT 0,
  `robots_nofollow` tinyint(1) NOT NULL DEFAULT 0,
  `robots_noimageindex` tinyint(1) NOT NULL DEFAULT 0,
  `robots_noodp` tinyint(1) NOT NULL DEFAULT 0,
  `robots_notranslate` tinyint(1) NOT NULL DEFAULT 0,
  `robots_max_snippet` int(11) DEFAULT NULL,
  `robots_max_videopreview` int(11) DEFAULT NULL,
  `robots_max_imagepreview` varchar(20) DEFAULT 'large',
  `images` longtext DEFAULT NULL,
  `image_scan_date` datetime DEFAULT NULL,
  `priority` float DEFAULT NULL,
  `frequency` tinytext DEFAULT NULL,
  `videos` longtext DEFAULT NULL,
  `video_thumbnail` text DEFAULT NULL,
  `video_scan_date` datetime DEFAULT NULL,
  `local_seo` longtext DEFAULT NULL,
  `breadcrumb_settings` longtext DEFAULT NULL,
  `limit_modified_date` tinyint(1) NOT NULL DEFAULT 0,
  `options` longtext DEFAULT NULL,
  `ai` longtext DEFAULT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ndx_aioseo_posts_post_id` (`post_id`),
  KEY `ndx_aioseo_posts_pillar_content` (`pillar_content`)
) ENGINE=InnoDB AUTO_INCREMENT=85 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aioseo_seo_analyzer_results` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `data` text NOT NULL,
  `score` varchar(255) DEFAULT NULL,
  `competitor_url` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ndx_aioseo_seo_analyzer_results_competitor_url` (`competitor_url`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aioseo_writing_assistant_keywords` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(40) NOT NULL,
  `keyword` varchar(255) NOT NULL,
  `country` varchar(10) NOT NULL DEFAULT 'us',
  `language` varchar(10) NOT NULL DEFAULT 'en',
  `progress` tinyint(3) DEFAULT 0,
  `keywords` mediumtext DEFAULT NULL,
  `competitors` mediumtext DEFAULT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ndx_aioseo_writing_assistant_keywords_uuid` (`uuid`),
  KEY `ndx_aioseo_writing_assistant_keywords_keyword` (`keyword`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aioseo_writing_assistant_posts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `keyword_id` bigint(20) unsigned DEFAULT NULL,
  `content_analysis_hash` varchar(40) DEFAULT NULL,
  `content_analysis` text DEFAULT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ndx_aioseo_writing_assistant_posts_post_id` (`post_id`),
  KEY `ndx_aioseo_writing_assistant_posts_keyword_id` (`keyword_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_litespeed_url` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `url` varchar(500) NOT NULL,
  `cache_tags` varchar(1000) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `url` (`url`(191)),
  KEY `cache_tags` (`cache_tags`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_litespeed_url_file` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `url_id` bigint(20) NOT NULL,
  `vary` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5 of final vary',
  `filename` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5 of file content',
  `type` tinyint(4) NOT NULL COMMENT 'css=1,js=2,ccss=3,ucss=4',
  `mobile` tinyint(4) NOT NULL COMMENT 'mobile=1',
  `webp` tinyint(4) NOT NULL COMMENT 'webp=1',
  `expired` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `filename` (`filename`),
  KEY `type` (`type`),
  KEY `url_id_2` (`url_id`,`vary`,`type`),
  KEY `filename_2` (`filename`,`expired`),
  KEY `url_id` (`url_id`,`expired`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=50638 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2566 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=2893 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_srfm_entries` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) unsigned DEFAULT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `form_data` longtext DEFAULT NULL,
  `logs` longtext DEFAULT NULL,
  `notes` longtext DEFAULT NULL,
  `submission_info` longtext DEFAULT NULL,
  `status` varchar(10) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `extras` longtext DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`ID`),
  KEY `idx_form_id` (`form_id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_form_id_created_at_status` (`form_id`,`created_at`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=128 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpforms_logs` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `message` longtext NOT NULL,
  `types` varchar(255) NOT NULL,
  `create_at` datetime NOT NULL,
  `form_id` bigint(20) DEFAULT NULL,
  `entry_id` bigint(20) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpforms_payment_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `payment_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payment_id` (`payment_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `meta_value` (`meta_value`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpforms_payments` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) NOT NULL,
  `status` varchar(10) NOT NULL DEFAULT '',
  `subtotal_amount` decimal(26,8) NOT NULL DEFAULT 0.00000000,
  `discount_amount` decimal(26,8) NOT NULL DEFAULT 0.00000000,
  `total_amount` decimal(26,8) NOT NULL DEFAULT 0.00000000,
  `currency` varchar(3) NOT NULL DEFAULT '',
  `entry_id` bigint(20) NOT NULL DEFAULT 0,
  `gateway` varchar(20) NOT NULL DEFAULT '',
  `type` varchar(12) NOT NULL DEFAULT '',
  `mode` varchar(4) NOT NULL DEFAULT '',
  `transaction_id` varchar(40) NOT NULL DEFAULT '',
  `customer_id` varchar(40) NOT NULL DEFAULT '',
  `subscription_id` varchar(40) NOT NULL DEFAULT '',
  `subscription_status` varchar(10) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `date_created_gmt` datetime NOT NULL,
  `date_updated_gmt` datetime NOT NULL,
  `is_published` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`),
  KEY `status` (`status`(8)),
  KEY `total_amount` (`total_amount`),
  KEY `type` (`type`(8)),
  KEY `transaction_id` (`transaction_id`(32)),
  KEY `customer_id` (`customer_id`(32)),
  KEY `subscription_id` (`subscription_id`(32)),
  KEY `subscription_status` (`subscription_status`(8)),
  KEY `title` (`title`(64))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpforms_tasks_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `action` varchar(255) NOT NULL,
  `data` longtext NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=77 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("2286", "wpforms_admin_addons_cache_update", "failed", "2025-06-03 11:16:56", "2025-06-03 11:16:56", "10", "{\"tasks_meta_id\":33}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748949416;s:18:\"\0*\0first_timestamp\";i:1746520869;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748949416;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2025-06-03 11:18:30", "2025-06-03 11:18:30", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2287", "wpforms_admin_builder_templates_cache_update", "failed", "2025-06-03 11:16:56", "2025-06-03 11:16:56", "10", "{\"tasks_meta_id\":34}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748949416;s:18:\"\0*\0first_timestamp\";i:1746520869;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748949416;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2025-06-03 11:18:30", "2025-06-03 11:18:30", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2516", "wpforms_admin_addons_cache_update", "failed", "2025-06-10 11:18:30", "2025-06-10 11:18:30", "10", "{\"tasks_meta_id\":33}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749554310;s:18:\"\0*\0first_timestamp\";i:1746520869;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749554310;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2025-06-10 11:39:24", "2025-06-10 11:39:24", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2517", "wpforms_admin_builder_templates_cache_update", "failed", "2025-06-10 11:18:30", "2025-06-10 11:18:30", "10", "{\"tasks_meta_id\":34}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749554310;s:18:\"\0*\0first_timestamp\";i:1746520869;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749554310;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2025-06-10 11:39:24", "2025-06-10 11:39:24", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2777", "wpforms_admin_addons_cache_update", "failed", "2025-06-17 11:39:24", "2025-06-17 11:39:24", "10", "{\"tasks_meta_id\":33}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750160364;s:18:\"\0*\0first_timestamp\";i:1746520869;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750160364;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2025-06-17 11:52:34", "2025-06-17 11:52:34", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2778", "wpforms_admin_builder_templates_cache_update", "failed", "2025-06-17 11:39:24", "2025-06-17 11:39:24", "10", "{\"tasks_meta_id\":34}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750160364;s:18:\"\0*\0first_timestamp\";i:1746520869;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750160364;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2025-06-17 11:52:34", "2025-06-17 11:52:34", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3322", "wpforms_admin_addons_cache_update", "failed", "2025-07-01 12:07:51", "2025-07-01 12:07:51", "10", "{\"tasks_meta_id\":33}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1751371671;s:18:\"\0*\0first_timestamp\";i:1746520869;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1751371671;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2025-07-01 13:41:10", "2025-07-01 13:41:10", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3323", "wpforms_admin_builder_templates_cache_update", "failed", "2025-07-01 12:07:52", "2025-07-01 12:07:52", "10", "{\"tasks_meta_id\":34}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1751371672;s:18:\"\0*\0first_timestamp\";i:1746520869;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1751371672;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2025-07-01 13:41:10", "2025-07-01 13:41:10", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3611", "wpforms_admin_addons_cache_update", "failed", "2025-07-08 13:41:10", "2025-07-08 13:41:10", "10", "{\"tasks_meta_id\":33}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1751982070;s:18:\"\0*\0first_timestamp\";i:1746520869;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1751982070;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2025-07-08 14:17:29", "2025-07-08 14:17:29", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3612", "wpforms_admin_builder_templates_cache_update", "failed", "2025-07-08 13:41:10", "2025-07-08 13:41:10", "10", "{\"tasks_meta_id\":34}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1751982070;s:18:\"\0*\0first_timestamp\";i:1746520869;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1751982070;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2025-07-08 14:17:29", "2025-07-08 14:17:29", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4160", "wpforms_admin_addons_cache_update", "failed", "2025-07-22 14:27:29", "2025-07-22 14:27:29", "10", "{\"tasks_meta_id\":33}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753194449;s:18:\"\0*\0first_timestamp\";i:1746520869;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753194449;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2025-07-22 14:36:12", "2025-07-22 14:36:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4161", "wpforms_admin_builder_templates_cache_update", "failed", "2025-07-22 14:27:29", "2025-07-22 14:27:29", "10", "{\"tasks_meta_id\":34}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753194449;s:18:\"\0*\0first_timestamp\";i:1746520869;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753194449;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2025-07-22 14:36:12", "2025-07-22 14:36:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("5447", "wpforms_admin_addons_cache_update", "failed", "2025-08-19 15:32:22", "2025-08-19 15:32:22", "10", "{\"tasks_meta_id\":33}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755617542;s:18:\"\0*\0first_timestamp\";i:1746520869;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755617542;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2025-08-19 16:57:22", "2025-08-19 16:57:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("5448", "wpforms_admin_builder_templates_cache_update", "failed", "2025-08-19 15:32:22", "2025-08-19 15:32:22", "10", "{\"tasks_meta_id\":34}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755617542;s:18:\"\0*\0first_timestamp\";i:1746520869;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755617542;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2025-08-19 16:57:22", "2025-08-19 16:57:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10023", "wpforms_email_summaries_fetch_info_blocks", "complete", "2026-01-01 17:25:36", "2026-01-01 17:25:36", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767288336;s:18:\"\0*\0first_timestamp\";i:1740488041;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767288336;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2026-01-01 19:04:57", "2026-01-01 19:04:57", "22740", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10065", "wpforms_email_summaries_fetch_info_blocks", "complete", "2026-01-02 22:47:14", "2026-01-02 22:47:14", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767394034;s:18:\"\0*\0first_timestamp\";i:1747978440;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767394034;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2026-01-02 23:55:14", "2026-01-02 23:55:14", "22784", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10172", "wpforms_process_forms_locator_scan", "complete", "2025-12-31 19:34:03", "2025-12-31 19:34:03", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767209643;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767209643;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-31 21:49:49", "2025-12-31 21:49:49", "22702", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10173", "wpforms_process_purge_spam", "complete", "2025-12-31 19:34:03", "2025-12-31 19:34:03", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767209643;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767209643;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-31 21:49:49", "2025-12-31 21:49:49", "22702", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10174", "srfm_daily_scheduled_action", "complete", "2025-12-31 19:34:03", "2025-12-31 19:34:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767209643;s:18:\"\0*\0first_timestamp\";i:1740700800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767209643;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-31 21:49:49", "2025-12-31 21:49:49", "22702", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10176", "srfm_daily_scheduled_action", "complete", "2025-12-31 19:34:03", "2025-12-31 19:34:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767209643;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767209643;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-31 21:49:49", "2025-12-31 21:49:49", "22702", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10177", "srfm_daily_scheduled_action", "complete", "2025-12-31 19:34:03", "2025-12-31 19:34:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767209643;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767209643;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-31 21:49:49", "2025-12-31 21:49:49", "22702", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10178", "srfm_daily_scheduled_action", "complete", "2025-12-31 19:34:03", "2025-12-31 19:34:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767209643;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767209643;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-31 21:49:49", "2025-12-31 21:49:49", "22702", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10179", "srfm_daily_scheduled_action", "complete", "2025-12-31 19:34:03", "2025-12-31 19:34:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767209643;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767209643;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-31 21:49:49", "2025-12-31 21:49:49", "22702", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10180", "srfm_daily_scheduled_action", "complete", "2025-12-31 19:34:03", "2025-12-31 19:34:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767209643;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767209643;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-31 21:49:49", "2025-12-31 21:49:49", "22702", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10181", "srfm_daily_scheduled_action", "complete", "2025-12-31 19:34:03", "2025-12-31 19:34:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767209643;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767209643;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-31 21:49:49", "2025-12-31 21:49:49", "22702", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10185", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-31 19:34:04", "2025-12-31 19:34:04", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767209644;s:18:\"\0*\0first_timestamp\";i:1763817196;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767209644;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-12-31 21:49:49", "2025-12-31 21:49:49", "22702", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10203", "wpforms_process_forms_locator_scan", "complete", "2026-01-01 21:49:49", "2026-01-01 21:49:49", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767304189;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767304189;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-02 00:52:35", "2026-01-02 00:52:35", "22751", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10204", "wpforms_process_purge_spam", "complete", "2026-01-01 21:49:49", "2026-01-01 21:49:49", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767304189;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767304189;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-02 00:52:35", "2026-01-02 00:52:35", "22751", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10205", "srfm_daily_scheduled_action", "complete", "2026-01-01 21:49:49", "2026-01-01 21:49:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767304189;s:18:\"\0*\0first_timestamp\";i:1740700800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767304189;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-02 00:52:35", "2026-01-02 00:52:35", "22751", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10207", "srfm_daily_scheduled_action", "complete", "2026-01-01 21:49:49", "2026-01-01 21:49:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767304189;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767304189;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-02 00:52:35", "2026-01-02 00:52:35", "22751", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10208", "srfm_daily_scheduled_action", "complete", "2026-01-01 21:49:49", "2026-01-01 21:49:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767304189;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767304189;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-02 00:52:35", "2026-01-02 00:52:35", "22751", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10209", "srfm_daily_scheduled_action", "complete", "2026-01-01 21:49:49", "2026-01-01 21:49:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767304189;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767304189;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-02 00:52:35", "2026-01-02 00:52:35", "22751", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10210", "srfm_daily_scheduled_action", "complete", "2026-01-01 21:49:49", "2026-01-01 21:49:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767304189;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767304189;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-02 00:52:35", "2026-01-02 00:52:35", "22751", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10211", "srfm_daily_scheduled_action", "complete", "2026-01-01 21:49:49", "2026-01-01 21:49:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767304189;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767304189;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-02 00:52:35", "2026-01-02 00:52:35", "22751", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10212", "srfm_daily_scheduled_action", "complete", "2026-01-01 21:49:49", "2026-01-01 21:49:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767304189;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767304189;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-02 00:52:35", "2026-01-02 00:52:35", "22751", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10216", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-01 21:49:49", "2026-01-01 21:49:49", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767304189;s:18:\"\0*\0first_timestamp\";i:1763817196;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767304189;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-02 00:52:36", "2026-01-02 00:52:36", "22751", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10231", "wpforms_email_summaries_fetch_info_blocks", "complete", "2026-01-08 19:04:57", "2026-01-08 19:04:57", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767899097;s:18:\"\0*\0first_timestamp\";i:1740488041;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767899097;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2026-01-08 19:43:42", "2026-01-08 19:43:42", "23176", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10237", "wpforms_process_forms_locator_scan", "complete", "2026-01-03 00:52:35", "2026-01-03 00:52:35", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767401555;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767401555;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-03 04:00:29", "2026-01-03 04:00:29", "22786", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10238", "wpforms_process_purge_spam", "complete", "2026-01-03 00:52:35", "2026-01-03 00:52:35", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767401555;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767401555;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-03 04:00:29", "2026-01-03 04:00:29", "22786", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10239", "srfm_daily_scheduled_action", "complete", "2026-01-03 00:52:35", "2026-01-03 00:52:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767401555;s:18:\"\0*\0first_timestamp\";i:1740700800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767401555;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-03 04:00:29", "2026-01-03 04:00:29", "22786", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10241", "srfm_daily_scheduled_action", "complete", "2026-01-03 00:52:35", "2026-01-03 00:52:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767401555;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767401555;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-03 04:00:29", "2026-01-03 04:00:29", "22786", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10242", "srfm_daily_scheduled_action", "complete", "2026-01-03 00:52:35", "2026-01-03 00:52:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767401555;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767401555;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-03 04:00:29", "2026-01-03 04:00:29", "22786", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10243", "srfm_daily_scheduled_action", "complete", "2026-01-03 00:52:35", "2026-01-03 00:52:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767401555;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767401555;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-03 04:00:29", "2026-01-03 04:00:29", "22786", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10244", "srfm_daily_scheduled_action", "complete", "2026-01-03 00:52:35", "2026-01-03 00:52:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767401555;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767401555;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-03 04:00:29", "2026-01-03 04:00:29", "22786", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10245", "srfm_daily_scheduled_action", "complete", "2026-01-03 00:52:35", "2026-01-03 00:52:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767401555;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767401555;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-03 04:00:29", "2026-01-03 04:00:29", "22786", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10246", "srfm_daily_scheduled_action", "complete", "2026-01-03 00:52:35", "2026-01-03 00:52:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767401555;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767401555;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-03 04:00:29", "2026-01-03 04:00:29", "22786", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10249", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-03 00:52:36", "2026-01-03 00:52:36", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767401556;s:18:\"\0*\0first_timestamp\";i:1763817196;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767401556;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-03 04:00:30", "2026-01-03 04:00:30", "22786", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10264", "wpforms_email_summaries_fetch_info_blocks", "complete", "2026-01-09 23:55:14", "2026-01-09 23:55:14", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768002914;s:18:\"\0*\0first_timestamp\";i:1747978440;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768002914;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2026-01-10 04:20:50", "2026-01-10 04:20:50", "23258", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10267", "wpforms_process_forms_locator_scan", "complete", "2026-01-04 04:00:29", "2026-01-04 04:00:29", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767499229;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767499229;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-04 04:00:54", "2026-01-04 04:00:54", "22875", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10268", "wpforms_process_purge_spam", "complete", "2026-01-04 04:00:29", "2026-01-04 04:00:29", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767499229;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767499229;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-04 04:00:54", "2026-01-04 04:00:54", "22875", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10269", "srfm_daily_scheduled_action", "complete", "2026-01-04 04:00:29", "2026-01-04 04:00:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767499229;s:18:\"\0*\0first_timestamp\";i:1740700800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767499229;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-04 04:00:54", "2026-01-04 04:00:54", "22875", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10271", "srfm_daily_scheduled_action", "complete", "2026-01-04 04:00:29", "2026-01-04 04:00:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767499229;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767499229;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-04 04:00:54", "2026-01-04 04:00:54", "22875", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10272", "srfm_daily_scheduled_action", "complete", "2026-01-04 04:00:29", "2026-01-04 04:00:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767499229;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767499229;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-04 04:00:54", "2026-01-04 04:00:54", "22875", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10273", "srfm_daily_scheduled_action", "complete", "2026-01-04 04:00:29", "2026-01-04 04:00:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767499229;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767499229;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-04 04:00:54", "2026-01-04 04:00:54", "22875", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10274", "srfm_daily_scheduled_action", "complete", "2026-01-04 04:00:29", "2026-01-04 04:00:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767499229;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767499229;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-04 04:00:54", "2026-01-04 04:00:54", "22875", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10275", "srfm_daily_scheduled_action", "complete", "2026-01-04 04:00:29", "2026-01-04 04:00:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767499229;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767499229;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-04 04:00:54", "2026-01-04 04:00:54", "22875", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10276", "srfm_daily_scheduled_action", "complete", "2026-01-04 04:00:29", "2026-01-04 04:00:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767499229;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767499229;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-04 04:00:54", "2026-01-04 04:00:54", "22875", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10279", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-04 04:00:30", "2026-01-04 04:00:30", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767499230;s:18:\"\0*\0first_timestamp\";i:1763817196;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767499230;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-04 04:00:54", "2026-01-04 04:00:54", "22875", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10305", "wpforms_process_forms_locator_scan", "complete", "2026-01-05 04:00:54", "2026-01-05 04:00:54", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767585654;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767585654;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-05 04:48:45", "2026-01-05 04:48:45", "22981", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10306", "wpforms_process_purge_spam", "complete", "2026-01-05 04:00:54", "2026-01-05 04:00:54", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767585654;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767585654;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-05 04:48:45", "2026-01-05 04:48:45", "22981", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10307", "srfm_daily_scheduled_action", "complete", "2026-01-05 04:00:54", "2026-01-05 04:00:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767585654;s:18:\"\0*\0first_timestamp\";i:1740700800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767585654;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-05 04:48:45", "2026-01-05 04:48:45", "22981", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10309", "srfm_daily_scheduled_action", "complete", "2026-01-05 04:00:54", "2026-01-05 04:00:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767585654;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767585654;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-05 04:48:45", "2026-01-05 04:48:45", "22981", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10310", "srfm_daily_scheduled_action", "complete", "2026-01-05 04:00:54", "2026-01-05 04:00:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767585654;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767585654;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-05 04:48:45", "2026-01-05 04:48:45", "22981", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10311", "srfm_daily_scheduled_action", "complete", "2026-01-05 04:00:54", "2026-01-05 04:00:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767585654;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767585654;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-05 04:48:45", "2026-01-05 04:48:45", "22981", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10312", "srfm_daily_scheduled_action", "complete", "2026-01-05 04:00:54", "2026-01-05 04:00:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767585654;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767585654;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-05 04:48:45", "2026-01-05 04:48:45", "22981", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10313", "srfm_daily_scheduled_action", "complete", "2026-01-05 04:00:54", "2026-01-05 04:00:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767585654;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767585654;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-05 04:48:45", "2026-01-05 04:48:45", "22981", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10314", "srfm_daily_scheduled_action", "complete", "2026-01-05 04:00:54", "2026-01-05 04:00:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767585654;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767585654;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-05 04:48:45", "2026-01-05 04:48:45", "22981", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10317", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-05 04:00:54", "2026-01-05 04:00:54", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767585654;s:18:\"\0*\0first_timestamp\";i:1763817196;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767585654;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-05 04:48:46", "2026-01-05 04:48:46", "22981", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10341", "wpforms_process_forms_locator_scan", "complete", "2026-01-06 04:48:45", "2026-01-06 04:48:45", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767674925;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767674925;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-06 05:13:39", "2026-01-06 05:13:39", "23038", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10342", "wpforms_process_purge_spam", "complete", "2026-01-06 04:48:45", "2026-01-06 04:48:45", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767674925;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767674925;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-06 05:13:39", "2026-01-06 05:13:39", "23038", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10343", "srfm_daily_scheduled_action", "complete", "2026-01-06 04:48:45", "2026-01-06 04:48:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767674925;s:18:\"\0*\0first_timestamp\";i:1740700800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767674925;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-06 05:13:39", "2026-01-06 05:13:39", "23038", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10345", "srfm_daily_scheduled_action", "complete", "2026-01-06 04:48:45", "2026-01-06 04:48:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767674925;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767674925;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-06 05:13:39", "2026-01-06 05:13:39", "23038", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10346", "srfm_daily_scheduled_action", "complete", "2026-01-06 04:48:45", "2026-01-06 04:48:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767674925;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767674925;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-06 05:13:39", "2026-01-06 05:13:39", "23038", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10347", "srfm_daily_scheduled_action", "complete", "2026-01-06 04:48:45", "2026-01-06 04:48:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767674925;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767674925;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-06 05:13:39", "2026-01-06 05:13:39", "23038", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10348", "srfm_daily_scheduled_action", "complete", "2026-01-06 04:48:45", "2026-01-06 04:48:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767674925;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767674925;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-06 05:13:39", "2026-01-06 05:13:39", "23038", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10349", "srfm_daily_scheduled_action", "complete", "2026-01-06 04:48:45", "2026-01-06 04:48:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767674925;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767674925;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-06 05:13:39", "2026-01-06 05:13:39", "23038", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10350", "srfm_daily_scheduled_action", "complete", "2026-01-06 04:48:45", "2026-01-06 04:48:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767674925;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767674925;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-06 05:13:39", "2026-01-06 05:13:39", "23038", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10353", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-06 04:48:46", "2026-01-06 04:48:46", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767674926;s:18:\"\0*\0first_timestamp\";i:1763817196;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767674926;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-06 05:13:39", "2026-01-06 05:13:39", "23038", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10376", "wpforms_process_forms_locator_scan", "complete", "2026-01-07 05:13:39", "2026-01-07 05:13:39", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767762819;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767762819;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-07 05:35:35", "2026-01-07 05:35:35", "23096", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10377", "wpforms_process_purge_spam", "complete", "2026-01-07 05:13:39", "2026-01-07 05:13:39", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767762819;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767762819;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-07 05:35:35", "2026-01-07 05:35:35", "23096", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10378", "srfm_daily_scheduled_action", "complete", "2026-01-07 05:13:39", "2026-01-07 05:13:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767762819;s:18:\"\0*\0first_timestamp\";i:1740700800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767762819;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-07 05:35:35", "2026-01-07 05:35:35", "23096", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10380", "srfm_daily_scheduled_action", "complete", "2026-01-07 05:13:39", "2026-01-07 05:13:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767762819;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767762819;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-07 05:35:35", "2026-01-07 05:35:35", "23096", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10381", "srfm_daily_scheduled_action", "complete", "2026-01-07 05:13:39", "2026-01-07 05:13:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767762819;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767762819;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-07 05:35:35", "2026-01-07 05:35:35", "23096", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10382", "srfm_daily_scheduled_action", "complete", "2026-01-07 05:13:39", "2026-01-07 05:13:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767762819;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767762819;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-07 05:35:35", "2026-01-07 05:35:35", "23096", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10383", "srfm_daily_scheduled_action", "complete", "2026-01-07 05:13:39", "2026-01-07 05:13:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767762819;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767762819;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-07 05:35:35", "2026-01-07 05:35:35", "23096", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10384", "srfm_daily_scheduled_action", "complete", "2026-01-07 05:13:39", "2026-01-07 05:13:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767762819;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767762819;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-07 05:35:35", "2026-01-07 05:35:35", "23096", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10385", "srfm_daily_scheduled_action", "complete", "2026-01-07 05:13:39", "2026-01-07 05:13:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767762819;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767762819;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-07 05:35:35", "2026-01-07 05:35:35", "23096", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10389", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-07 05:13:39", "2026-01-07 05:13:39", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767762819;s:18:\"\0*\0first_timestamp\";i:1763817196;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767762819;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-07 05:35:35", "2026-01-07 05:35:35", "23096", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10414", "wpforms_process_forms_locator_scan", "complete", "2026-01-08 05:35:35", "2026-01-08 05:35:35", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767850535;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767850535;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-08 05:43:16", "2026-01-08 05:43:16", "23143", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10415", "wpforms_process_purge_spam", "complete", "2026-01-08 05:35:35", "2026-01-08 05:35:35", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767850535;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767850535;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-08 05:43:16", "2026-01-08 05:43:16", "23143", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10416", "srfm_daily_scheduled_action", "complete", "2026-01-08 05:35:35", "2026-01-08 05:35:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767850535;s:18:\"\0*\0first_timestamp\";i:1740700800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767850535;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-08 05:43:16", "2026-01-08 05:43:16", "23143", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10418", "srfm_daily_scheduled_action", "complete", "2026-01-08 05:35:35", "2026-01-08 05:35:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767850535;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767850535;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-08 05:43:16", "2026-01-08 05:43:16", "23143", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10419", "srfm_daily_scheduled_action", "complete", "2026-01-08 05:35:35", "2026-01-08 05:35:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767850535;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767850535;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-08 05:43:16", "2026-01-08 05:43:16", "23143", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10420", "srfm_daily_scheduled_action", "complete", "2026-01-08 05:35:35", "2026-01-08 05:35:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767850535;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767850535;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-08 05:43:16", "2026-01-08 05:43:16", "23143", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10421", "srfm_daily_scheduled_action", "complete", "2026-01-08 05:35:35", "2026-01-08 05:35:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767850535;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767850535;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-08 05:43:16", "2026-01-08 05:43:16", "23143", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10422", "srfm_daily_scheduled_action", "complete", "2026-01-08 05:35:35", "2026-01-08 05:35:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767850535;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767850535;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-08 05:43:16", "2026-01-08 05:43:16", "23143", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10423", "srfm_daily_scheduled_action", "complete", "2026-01-08 05:35:35", "2026-01-08 05:35:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767850535;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767850535;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-08 05:43:16", "2026-01-08 05:43:16", "23143", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10426", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-08 05:35:35", "2026-01-08 05:35:35", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767850535;s:18:\"\0*\0first_timestamp\";i:1763817196;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767850535;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-08 05:43:16", "2026-01-08 05:43:16", "23143", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10448", "wpforms_process_forms_locator_scan", "complete", "2026-01-09 05:43:16", "2026-01-09 05:43:16", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767937396;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767937396;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-09 07:47:59", "2026-01-09 07:47:59", "23211", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10449", "wpforms_process_purge_spam", "complete", "2026-01-09 05:43:16", "2026-01-09 05:43:16", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767937396;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767937396;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-09 07:47:59", "2026-01-09 07:47:59", "23211", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10450", "srfm_daily_scheduled_action", "complete", "2026-01-09 05:43:16", "2026-01-09 05:43:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767937396;s:18:\"\0*\0first_timestamp\";i:1740700800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767937396;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-09 07:47:59", "2026-01-09 07:47:59", "23211", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10452", "srfm_daily_scheduled_action", "complete", "2026-01-09 05:43:16", "2026-01-09 05:43:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767937396;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767937396;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-09 07:47:59", "2026-01-09 07:47:59", "23211", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10453", "srfm_daily_scheduled_action", "complete", "2026-01-09 05:43:16", "2026-01-09 05:43:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767937396;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767937396;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-09 07:47:59", "2026-01-09 07:47:59", "23211", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10454", "srfm_daily_scheduled_action", "complete", "2026-01-09 05:43:16", "2026-01-09 05:43:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767937396;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767937396;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-09 07:47:59", "2026-01-09 07:47:59", "23211", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10455", "srfm_daily_scheduled_action", "complete", "2026-01-09 05:43:16", "2026-01-09 05:43:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767937396;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767937396;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-09 07:47:59", "2026-01-09 07:47:59", "23211", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10456", "srfm_daily_scheduled_action", "complete", "2026-01-09 05:43:16", "2026-01-09 05:43:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767937396;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767937396;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-09 07:47:59", "2026-01-09 07:47:59", "23211", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10457", "srfm_daily_scheduled_action", "complete", "2026-01-09 05:43:16", "2026-01-09 05:43:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767937396;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767937396;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-09 07:47:59", "2026-01-09 07:47:59", "23211", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10460", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-09 05:43:16", "2026-01-09 05:43:16", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767937396;s:18:\"\0*\0first_timestamp\";i:1763817196;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767937396;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-09 07:48:00", "2026-01-09 07:48:00", "23211", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10474", "wpforms_email_summaries_fetch_info_blocks", "complete", "2026-01-15 19:43:42", "2026-01-15 19:43:42", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768506222;s:18:\"\0*\0first_timestamp\";i:1740488041;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768506222;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2026-01-15 19:52:02", "2026-01-15 19:52:02", "23556", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10488", "wpforms_process_forms_locator_scan", "complete", "2026-01-10 07:47:59", "2026-01-10 07:47:59", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768031279;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768031279;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-10 08:24:28", "2026-01-10 08:24:28", "23264", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10489", "wpforms_process_purge_spam", "complete", "2026-01-10 07:47:59", "2026-01-10 07:47:59", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768031279;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768031279;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-10 08:24:28", "2026-01-10 08:24:28", "23264", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10490", "srfm_daily_scheduled_action", "complete", "2026-01-10 07:47:59", "2026-01-10 07:47:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768031279;s:18:\"\0*\0first_timestamp\";i:1740700800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768031279;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-10 08:24:28", "2026-01-10 08:24:28", "23264", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10492", "srfm_daily_scheduled_action", "complete", "2026-01-10 07:47:59", "2026-01-10 07:47:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768031279;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768031279;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-10 08:24:28", "2026-01-10 08:24:28", "23264", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10493", "srfm_daily_scheduled_action", "complete", "2026-01-10 07:47:59", "2026-01-10 07:47:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768031279;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768031279;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-10 08:24:28", "2026-01-10 08:24:28", "23264", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10494", "srfm_daily_scheduled_action", "complete", "2026-01-10 07:47:59", "2026-01-10 07:47:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768031279;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768031279;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-10 08:24:28", "2026-01-10 08:24:28", "23264", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10495", "srfm_daily_scheduled_action", "complete", "2026-01-10 07:47:59", "2026-01-10 07:47:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768031279;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768031279;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-10 08:24:28", "2026-01-10 08:24:28", "23264", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10496", "srfm_daily_scheduled_action", "complete", "2026-01-10 07:47:59", "2026-01-10 07:47:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768031279;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768031279;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-10 08:24:28", "2026-01-10 08:24:28", "23264", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10497", "srfm_daily_scheduled_action", "complete", "2026-01-10 07:47:59", "2026-01-10 07:47:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768031279;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768031279;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-10 08:24:28", "2026-01-10 08:24:28", "23264", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10500", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-10 07:48:00", "2026-01-10 07:48:00", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768031280;s:18:\"\0*\0first_timestamp\";i:1763817196;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768031280;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-10 08:24:29", "2026-01-10 08:24:29", "23264", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10520", "wpforms_email_summaries_fetch_info_blocks", "complete", "2026-01-17 04:20:50", "2026-01-17 04:20:50", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768623650;s:18:\"\0*\0first_timestamp\";i:1747978440;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768623650;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2026-01-17 05:32:19", "2026-01-17 05:32:19", "23598", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10525", "wpforms_process_forms_locator_scan", "complete", "2026-01-11 08:24:28", "2026-01-11 08:24:28", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768119868;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768119868;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-11 09:58:19", "2026-01-11 09:58:19", "23313", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10526", "wpforms_process_purge_spam", "complete", "2026-01-11 08:24:28", "2026-01-11 08:24:28", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768119868;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768119868;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-11 09:58:19", "2026-01-11 09:58:19", "23313", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10527", "srfm_daily_scheduled_action", "complete", "2026-01-11 08:24:28", "2026-01-11 08:24:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768119868;s:18:\"\0*\0first_timestamp\";i:1740700800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768119868;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-11 09:58:19", "2026-01-11 09:58:19", "23313", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10529", "srfm_daily_scheduled_action", "complete", "2026-01-11 08:24:28", "2026-01-11 08:24:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768119868;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768119868;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-11 09:58:19", "2026-01-11 09:58:19", "23313", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10530", "srfm_daily_scheduled_action", "complete", "2026-01-11 08:24:28", "2026-01-11 08:24:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768119868;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768119868;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-11 09:58:19", "2026-01-11 09:58:19", "23313", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10531", "srfm_daily_scheduled_action", "complete", "2026-01-11 08:24:28", "2026-01-11 08:24:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768119868;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768119868;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-11 09:58:19", "2026-01-11 09:58:19", "23313", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10532", "srfm_daily_scheduled_action", "complete", "2026-01-11 08:24:28", "2026-01-11 08:24:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768119868;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768119868;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-11 09:58:19", "2026-01-11 09:58:19", "23313", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10533", "srfm_daily_scheduled_action", "complete", "2026-01-11 08:24:28", "2026-01-11 08:24:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768119868;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768119868;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-11 09:58:19", "2026-01-11 09:58:19", "23313", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10534", "srfm_daily_scheduled_action", "complete", "2026-01-11 08:24:28", "2026-01-11 08:24:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768119868;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768119868;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-11 09:58:19", "2026-01-11 09:58:19", "23313", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10537", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-11 08:24:29", "2026-01-11 08:24:29", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768119869;s:18:\"\0*\0first_timestamp\";i:1763817196;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768119869;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-11 09:58:19", "2026-01-11 09:58:19", "23313", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10559", "wpforms_process_forms_locator_scan", "complete", "2026-01-12 09:58:19", "2026-01-12 09:58:19", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768211899;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768211899;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-12 10:28:49", "2026-01-12 10:28:49", "23370", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10560", "wpforms_process_purge_spam", "complete", "2026-01-12 09:58:19", "2026-01-12 09:58:19", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768211899;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768211899;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-12 10:28:49", "2026-01-12 10:28:49", "23370", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10561", "srfm_daily_scheduled_action", "complete", "2026-01-12 09:58:19", "2026-01-12 09:58:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768211899;s:18:\"\0*\0first_timestamp\";i:1740700800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768211899;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-12 10:28:49", "2026-01-12 10:28:49", "23370", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10563", "srfm_daily_scheduled_action", "complete", "2026-01-12 09:58:19", "2026-01-12 09:58:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768211899;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768211899;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-12 10:28:49", "2026-01-12 10:28:49", "23370", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10564", "srfm_daily_scheduled_action", "complete", "2026-01-12 09:58:19", "2026-01-12 09:58:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768211899;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768211899;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-12 10:28:49", "2026-01-12 10:28:49", "23370", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10565", "srfm_daily_scheduled_action", "complete", "2026-01-12 09:58:19", "2026-01-12 09:58:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768211899;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768211899;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-12 10:28:49", "2026-01-12 10:28:49", "23370", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10566", "srfm_daily_scheduled_action", "complete", "2026-01-12 09:58:19", "2026-01-12 09:58:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768211899;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768211899;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-12 10:28:49", "2026-01-12 10:28:49", "23370", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10567", "srfm_daily_scheduled_action", "complete", "2026-01-12 09:58:19", "2026-01-12 09:58:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768211899;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768211899;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-12 10:28:49", "2026-01-12 10:28:49", "23370", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10568", "srfm_daily_scheduled_action", "complete", "2026-01-12 09:58:19", "2026-01-12 09:58:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768211899;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768211899;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-12 10:28:49", "2026-01-12 10:28:49", "23370", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10571", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-12 09:58:19", "2026-01-12 09:58:19", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768211899;s:18:\"\0*\0first_timestamp\";i:1763817196;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768211899;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-12 10:28:50", "2026-01-12 10:28:50", "23370", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10593", "wpforms_process_forms_locator_scan", "complete", "2026-01-13 10:28:49", "2026-01-13 10:28:49", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768300129;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768300129;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-13 11:57:51", "2026-01-13 11:57:51", "23417", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10594", "wpforms_process_purge_spam", "complete", "2026-01-13 10:28:49", "2026-01-13 10:28:49", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768300129;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768300129;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-13 11:57:51", "2026-01-13 11:57:51", "23417", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10595", "srfm_daily_scheduled_action", "complete", "2026-01-13 10:28:49", "2026-01-13 10:28:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768300129;s:18:\"\0*\0first_timestamp\";i:1740700800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768300129;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-13 11:57:51", "2026-01-13 11:57:51", "23417", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10597", "srfm_daily_scheduled_action", "complete", "2026-01-13 10:28:49", "2026-01-13 10:28:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768300129;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768300129;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-13 11:57:51", "2026-01-13 11:57:51", "23417", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10598", "srfm_daily_scheduled_action", "complete", "2026-01-13 10:28:49", "2026-01-13 10:28:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768300129;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768300129;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-13 11:57:51", "2026-01-13 11:57:51", "23417", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10599", "srfm_daily_scheduled_action", "complete", "2026-01-13 10:28:49", "2026-01-13 10:28:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768300129;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768300129;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-13 11:57:51", "2026-01-13 11:57:51", "23417", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10600", "srfm_daily_scheduled_action", "complete", "2026-01-13 10:28:49", "2026-01-13 10:28:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768300129;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768300129;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-13 11:57:51", "2026-01-13 11:57:51", "23417", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10601", "srfm_daily_scheduled_action", "complete", "2026-01-13 10:28:49", "2026-01-13 10:28:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768300129;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768300129;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-13 11:57:51", "2026-01-13 11:57:51", "23417", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10602", "srfm_daily_scheduled_action", "complete", "2026-01-13 10:28:49", "2026-01-13 10:28:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768300129;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768300129;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-13 11:57:51", "2026-01-13 11:57:51", "23417", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10605", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-13 10:28:50", "2026-01-13 10:28:50", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768300130;s:18:\"\0*\0first_timestamp\";i:1763817196;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768300130;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-13 11:57:52", "2026-01-13 11:57:52", "23417", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10625", "wpforms_process_forms_locator_scan", "complete", "2026-01-14 11:57:51", "2026-01-14 11:57:51", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768391871;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768391871;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-14 14:04:29", "2026-01-14 14:04:29", "23479", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10626", "wpforms_process_purge_spam", "complete", "2026-01-14 11:57:51", "2026-01-14 11:57:51", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768391871;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768391871;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-14 14:04:29", "2026-01-14 14:04:29", "23479", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10627", "srfm_daily_scheduled_action", "complete", "2026-01-14 11:57:51", "2026-01-14 11:57:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768391871;s:18:\"\0*\0first_timestamp\";i:1740700800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768391871;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-14 14:04:29", "2026-01-14 14:04:29", "23479", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10629", "srfm_daily_scheduled_action", "complete", "2026-01-14 11:57:51", "2026-01-14 11:57:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768391871;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768391871;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-14 14:04:29", "2026-01-14 14:04:29", "23479", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10630", "srfm_daily_scheduled_action", "complete", "2026-01-14 11:57:51", "2026-01-14 11:57:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768391871;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768391871;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-14 14:04:29", "2026-01-14 14:04:29", "23479", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10631", "srfm_daily_scheduled_action", "complete", "2026-01-14 11:57:51", "2026-01-14 11:57:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768391871;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768391871;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-14 14:04:29", "2026-01-14 14:04:29", "23479", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10632", "srfm_daily_scheduled_action", "complete", "2026-01-14 11:57:51", "2026-01-14 11:57:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768391871;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768391871;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-14 14:04:29", "2026-01-14 14:04:29", "23479", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10633", "srfm_daily_scheduled_action", "complete", "2026-01-14 11:57:51", "2026-01-14 11:57:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768391871;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768391871;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-14 14:04:29", "2026-01-14 14:04:29", "23479", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10634", "srfm_daily_scheduled_action", "complete", "2026-01-14 11:57:51", "2026-01-14 11:57:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768391871;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768391871;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-14 14:04:29", "2026-01-14 14:04:29", "23479", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10637", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-14 11:57:52", "2026-01-14 11:57:52", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768391872;s:18:\"\0*\0first_timestamp\";i:1763817196;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768391872;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-14 14:04:29", "2026-01-14 14:04:29", "23479", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10663", "wpforms_process_forms_locator_scan", "complete", "2026-01-15 14:04:29", "2026-01-15 14:04:29", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768485869;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768485869;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-15 14:38:49", "2026-01-15 14:38:49", "23542", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10664", "wpforms_process_purge_spam", "complete", "2026-01-15 14:04:29", "2026-01-15 14:04:29", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768485869;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768485869;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-15 14:38:49", "2026-01-15 14:38:49", "23542", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10665", "srfm_daily_scheduled_action", "complete", "2026-01-15 14:04:29", "2026-01-15 14:04:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768485869;s:18:\"\0*\0first_timestamp\";i:1740700800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768485869;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-15 14:38:49", "2026-01-15 14:38:49", "23542", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10667", "srfm_daily_scheduled_action", "complete", "2026-01-15 14:04:29", "2026-01-15 14:04:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768485869;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768485869;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-15 14:38:49", "2026-01-15 14:38:49", "23542", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10668", "srfm_daily_scheduled_action", "complete", "2026-01-15 14:04:29", "2026-01-15 14:04:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768485869;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768485869;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-15 14:38:49", "2026-01-15 14:38:49", "23542", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10669", "srfm_daily_scheduled_action", "complete", "2026-01-15 14:04:29", "2026-01-15 14:04:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768485869;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768485869;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-15 14:38:49", "2026-01-15 14:38:49", "23542", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10670", "srfm_daily_scheduled_action", "complete", "2026-01-15 14:04:29", "2026-01-15 14:04:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768485869;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768485869;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-15 14:38:49", "2026-01-15 14:38:49", "23542", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10671", "srfm_daily_scheduled_action", "complete", "2026-01-15 14:04:29", "2026-01-15 14:04:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768485869;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768485869;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-15 14:38:49", "2026-01-15 14:38:49", "23542", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10672", "srfm_daily_scheduled_action", "complete", "2026-01-15 14:04:29", "2026-01-15 14:04:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768485869;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768485869;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-15 14:38:49", "2026-01-15 14:38:49", "23542", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10675", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-15 14:04:29", "2026-01-15 14:04:29", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768485869;s:18:\"\0*\0first_timestamp\";i:1763817196;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768485869;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-15 14:38:50", "2026-01-15 14:38:50", "23542", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10699", "wpforms_process_forms_locator_scan", "complete", "2026-01-16 14:38:49", "2026-01-16 14:38:49", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768574329;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768574329;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-16 14:42:33", "2026-01-16 14:42:33", "23577", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10700", "wpforms_process_purge_spam", "complete", "2026-01-16 14:38:49", "2026-01-16 14:38:49", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768574329;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768574329;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-16 14:42:33", "2026-01-16 14:42:33", "23577", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10701", "srfm_daily_scheduled_action", "complete", "2026-01-16 14:38:49", "2026-01-16 14:38:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768574329;s:18:\"\0*\0first_timestamp\";i:1740700800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768574329;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-16 14:42:33", "2026-01-16 14:42:33", "23577", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10703", "srfm_daily_scheduled_action", "complete", "2026-01-16 14:38:49", "2026-01-16 14:38:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768574329;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768574329;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-16 14:42:33", "2026-01-16 14:42:33", "23577", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10704", "srfm_daily_scheduled_action", "complete", "2026-01-16 14:38:49", "2026-01-16 14:38:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768574329;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768574329;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-16 14:42:33", "2026-01-16 14:42:33", "23577", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10705", "srfm_daily_scheduled_action", "complete", "2026-01-16 14:38:49", "2026-01-16 14:38:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768574329;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768574329;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-16 14:42:33", "2026-01-16 14:42:33", "23577", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10706", "srfm_daily_scheduled_action", "complete", "2026-01-16 14:38:49", "2026-01-16 14:38:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768574329;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768574329;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-16 14:42:33", "2026-01-16 14:42:33", "23577", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10707", "srfm_daily_scheduled_action", "complete", "2026-01-16 14:38:49", "2026-01-16 14:38:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768574329;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768574329;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-16 14:42:33", "2026-01-16 14:42:33", "23577", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10708", "srfm_daily_scheduled_action", "complete", "2026-01-16 14:38:49", "2026-01-16 14:38:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768574329;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768574329;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-16 14:42:33", "2026-01-16 14:42:33", "23577", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10711", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-16 14:38:50", "2026-01-16 14:38:50", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768574330;s:18:\"\0*\0first_timestamp\";i:1763817196;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768574330;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-16 14:42:34", "2026-01-16 14:42:34", "23577", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10718", "wpforms_email_summaries_fetch_info_blocks", "complete", "2026-01-22 19:52:02", "2026-01-22 19:52:02", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769111522;s:18:\"\0*\0first_timestamp\";i:1740488041;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769111522;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2026-01-22 19:53:22", "2026-01-22 19:53:22", "23800", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10729", "wpforms_process_forms_locator_scan", "complete", "2026-01-17 14:42:33", "2026-01-17 14:42:33", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768660953;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768660953;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-17 15:10:06", "2026-01-17 15:10:06", "23610", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10730", "wpforms_process_purge_spam", "complete", "2026-01-17 14:42:33", "2026-01-17 14:42:33", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768660953;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768660953;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-17 15:10:06", "2026-01-17 15:10:06", "23610", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10731", "srfm_daily_scheduled_action", "complete", "2026-01-17 14:42:33", "2026-01-17 14:42:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768660953;s:18:\"\0*\0first_timestamp\";i:1740700800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768660953;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-17 15:10:06", "2026-01-17 15:10:06", "23610", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10733", "srfm_daily_scheduled_action", "complete", "2026-01-17 14:42:33", "2026-01-17 14:42:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768660953;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768660953;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-17 15:10:06", "2026-01-17 15:10:06", "23610", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10734", "srfm_daily_scheduled_action", "complete", "2026-01-17 14:42:33", "2026-01-17 14:42:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768660953;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768660953;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-17 15:10:06", "2026-01-17 15:10:06", "23610", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10735", "srfm_daily_scheduled_action", "complete", "2026-01-17 14:42:33", "2026-01-17 14:42:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768660953;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768660953;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-17 15:10:06", "2026-01-17 15:10:06", "23610", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10736", "srfm_daily_scheduled_action", "complete", "2026-01-17 14:42:33", "2026-01-17 14:42:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768660953;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768660953;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-17 15:10:06", "2026-01-17 15:10:06", "23610", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10737", "srfm_daily_scheduled_action", "complete", "2026-01-17 14:42:33", "2026-01-17 14:42:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768660953;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768660953;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-17 15:10:06", "2026-01-17 15:10:06", "23610", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10738", "srfm_daily_scheduled_action", "complete", "2026-01-17 14:42:33", "2026-01-17 14:42:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768660953;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768660953;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-17 15:10:06", "2026-01-17 15:10:06", "23610", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10741", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-17 14:42:34", "2026-01-17 14:42:34", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768660954;s:18:\"\0*\0first_timestamp\";i:1763817196;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768660954;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-17 15:10:07", "2026-01-17 15:10:07", "23610", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10751", "wpforms_email_summaries_fetch_info_blocks", "complete", "2026-01-24 05:32:19", "2026-01-24 05:32:19", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769232739;s:18:\"\0*\0first_timestamp\";i:1747978440;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769232739;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2026-01-24 06:12:31", "2026-01-24 06:12:31", "23867", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10759", "wpforms_process_forms_locator_scan", "complete", "2026-01-18 15:10:06", "2026-01-18 15:10:06", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768749006;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768749006;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-18 20:57:04", "2026-01-18 20:57:04", "23640", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10760", "wpforms_process_purge_spam", "complete", "2026-01-18 15:10:06", "2026-01-18 15:10:06", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768749006;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768749006;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-18 20:57:04", "2026-01-18 20:57:04", "23640", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10761", "srfm_daily_scheduled_action", "complete", "2026-01-18 15:10:06", "2026-01-18 15:10:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768749006;s:18:\"\0*\0first_timestamp\";i:1740700800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768749006;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-18 20:57:04", "2026-01-18 20:57:04", "23640", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10763", "srfm_daily_scheduled_action", "complete", "2026-01-18 15:10:06", "2026-01-18 15:10:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768749006;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768749006;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-18 20:57:04", "2026-01-18 20:57:04", "23640", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10764", "srfm_daily_scheduled_action", "complete", "2026-01-18 15:10:06", "2026-01-18 15:10:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768749006;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768749006;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-18 20:57:04", "2026-01-18 20:57:04", "23640", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10765", "srfm_daily_scheduled_action", "complete", "2026-01-18 15:10:06", "2026-01-18 15:10:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768749006;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768749006;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-18 20:57:04", "2026-01-18 20:57:04", "23640", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10766", "srfm_daily_scheduled_action", "complete", "2026-01-18 15:10:06", "2026-01-18 15:10:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768749006;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768749006;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-18 20:57:04", "2026-01-18 20:57:04", "23640", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10767", "srfm_daily_scheduled_action", "complete", "2026-01-18 15:10:06", "2026-01-18 15:10:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768749006;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768749006;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-18 20:57:04", "2026-01-18 20:57:04", "23640", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10768", "srfm_daily_scheduled_action", "complete", "2026-01-18 15:10:06", "2026-01-18 15:10:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768749006;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768749006;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-18 20:57:04", "2026-01-18 20:57:04", "23640", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10771", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-18 15:10:07", "2026-01-18 15:10:07", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768749007;s:18:\"\0*\0first_timestamp\";i:1763817196;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768749007;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-18 20:57:05", "2026-01-18 20:57:05", "23640", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10787", "wpforms_process_forms_locator_scan", "complete", "2026-01-19 20:57:04", "2026-01-19 20:57:04", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768856224;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768856224;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-19 20:59:21", "2026-01-19 20:59:21", "23665", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10788", "wpforms_process_purge_spam", "complete", "2026-01-19 20:57:04", "2026-01-19 20:57:04", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768856224;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768856224;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-19 20:59:21", "2026-01-19 20:59:21", "23665", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10789", "srfm_daily_scheduled_action", "complete", "2026-01-19 20:57:04", "2026-01-19 20:57:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768856224;s:18:\"\0*\0first_timestamp\";i:1740700800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768856224;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-19 20:59:21", "2026-01-19 20:59:21", "23665", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10791", "srfm_daily_scheduled_action", "complete", "2026-01-19 20:57:04", "2026-01-19 20:57:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768856224;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768856224;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-19 20:59:21", "2026-01-19 20:59:21", "23665", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10792", "srfm_daily_scheduled_action", "complete", "2026-01-19 20:57:04", "2026-01-19 20:57:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768856224;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768856224;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-19 20:59:21", "2026-01-19 20:59:21", "23665", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10793", "srfm_daily_scheduled_action", "complete", "2026-01-19 20:57:04", "2026-01-19 20:57:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768856224;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768856224;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-19 20:59:21", "2026-01-19 20:59:21", "23665", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10794", "srfm_daily_scheduled_action", "complete", "2026-01-19 20:57:04", "2026-01-19 20:57:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768856224;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768856224;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-19 20:59:21", "2026-01-19 20:59:21", "23665", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10795", "srfm_daily_scheduled_action", "complete", "2026-01-19 20:57:04", "2026-01-19 20:57:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768856224;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768856224;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-19 20:59:21", "2026-01-19 20:59:21", "23665", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10796", "srfm_daily_scheduled_action", "complete", "2026-01-19 20:57:04", "2026-01-19 20:57:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768856224;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768856224;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-19 20:59:21", "2026-01-19 20:59:21", "23665", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10799", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-19 20:57:05", "2026-01-19 20:57:05", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768856225;s:18:\"\0*\0first_timestamp\";i:1763817196;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768856225;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-19 20:59:21", "2026-01-19 20:59:21", "23665", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10812", "wpforms_process_forms_locator_scan", "complete", "2026-01-20 20:59:21", "2026-01-20 20:59:21", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768942761;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768942761;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-20 21:55:33", "2026-01-20 21:55:33", "23707", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10813", "wpforms_process_purge_spam", "complete", "2026-01-20 20:59:21", "2026-01-20 20:59:21", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768942761;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768942761;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-20 21:55:33", "2026-01-20 21:55:33", "23707", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10814", "srfm_daily_scheduled_action", "complete", "2026-01-20 20:59:21", "2026-01-20 20:59:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768942761;s:18:\"\0*\0first_timestamp\";i:1740700800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768942761;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-20 21:55:33", "2026-01-20 21:55:33", "23707", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10816", "srfm_daily_scheduled_action", "complete", "2026-01-20 20:59:21", "2026-01-20 20:59:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768942761;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768942761;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-20 21:55:33", "2026-01-20 21:55:33", "23707", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10817", "srfm_daily_scheduled_action", "complete", "2026-01-20 20:59:21", "2026-01-20 20:59:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768942761;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768942761;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-20 21:55:33", "2026-01-20 21:55:33", "23707", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10818", "srfm_daily_scheduled_action", "complete", "2026-01-20 20:59:21", "2026-01-20 20:59:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768942761;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768942761;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-20 21:55:33", "2026-01-20 21:55:33", "23707", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10819", "srfm_daily_scheduled_action", "complete", "2026-01-20 20:59:21", "2026-01-20 20:59:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768942761;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768942761;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-20 21:55:33", "2026-01-20 21:55:33", "23707", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10820", "srfm_daily_scheduled_action", "complete", "2026-01-20 20:59:21", "2026-01-20 20:59:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768942761;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768942761;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-20 21:55:33", "2026-01-20 21:55:33", "23707", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10821", "srfm_daily_scheduled_action", "complete", "2026-01-20 20:59:21", "2026-01-20 20:59:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768942761;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768942761;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-20 21:55:33", "2026-01-20 21:55:33", "23707", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10824", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-20 20:59:21", "2026-01-20 20:59:21", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768942761;s:18:\"\0*\0first_timestamp\";i:1763817196;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768942761;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-20 21:55:33", "2026-01-20 21:55:33", "23707", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10844", "wpforms_process_forms_locator_scan", "complete", "2026-01-21 21:55:33", "2026-01-21 21:55:33", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769032533;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769032533;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-21 22:42:13", "2026-01-21 22:42:13", "23749", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10845", "wpforms_process_purge_spam", "complete", "2026-01-21 21:55:33", "2026-01-21 21:55:33", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769032533;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769032533;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-21 22:42:13", "2026-01-21 22:42:13", "23749", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10846", "srfm_daily_scheduled_action", "complete", "2026-01-21 21:55:33", "2026-01-21 21:55:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769032533;s:18:\"\0*\0first_timestamp\";i:1740700800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769032533;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-21 22:42:13", "2026-01-21 22:42:13", "23749", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10848", "srfm_daily_scheduled_action", "complete", "2026-01-21 21:55:33", "2026-01-21 21:55:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769032533;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769032533;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-21 22:42:13", "2026-01-21 22:42:13", "23749", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10849", "srfm_daily_scheduled_action", "complete", "2026-01-21 21:55:33", "2026-01-21 21:55:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769032533;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769032533;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-21 22:42:13", "2026-01-21 22:42:13", "23749", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10850", "srfm_daily_scheduled_action", "complete", "2026-01-21 21:55:33", "2026-01-21 21:55:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769032533;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769032533;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-21 22:42:13", "2026-01-21 22:42:13", "23749", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10851", "srfm_daily_scheduled_action", "complete", "2026-01-21 21:55:33", "2026-01-21 21:55:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769032533;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769032533;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-21 22:42:13", "2026-01-21 22:42:13", "23749", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10852", "srfm_daily_scheduled_action", "complete", "2026-01-21 21:55:33", "2026-01-21 21:55:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769032533;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769032533;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-21 22:42:13", "2026-01-21 22:42:13", "23749", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10853", "srfm_daily_scheduled_action", "complete", "2026-01-21 21:55:33", "2026-01-21 21:55:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769032533;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769032533;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-21 22:42:13", "2026-01-21 22:42:13", "23749", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10856", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-21 21:55:33", "2026-01-21 21:55:33", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769032533;s:18:\"\0*\0first_timestamp\";i:1763817196;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769032533;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-21 22:42:14", "2026-01-21 22:42:14", "23749", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10878", "wpforms_process_forms_locator_scan", "complete", "2026-01-22 22:42:13", "2026-01-22 22:42:13", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769121733;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769121733;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-22 23:39:47", "2026-01-22 23:39:47", "23807", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10879", "wpforms_process_purge_spam", "complete", "2026-01-22 22:42:13", "2026-01-22 22:42:13", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769121733;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769121733;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-22 23:39:47", "2026-01-22 23:39:47", "23807", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10880", "srfm_daily_scheduled_action", "complete", "2026-01-22 22:42:13", "2026-01-22 22:42:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769121733;s:18:\"\0*\0first_timestamp\";i:1740700800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769121733;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-22 23:39:47", "2026-01-22 23:39:47", "23807", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10882", "srfm_daily_scheduled_action", "complete", "2026-01-22 22:42:13", "2026-01-22 22:42:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769121733;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769121733;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-22 23:39:47", "2026-01-22 23:39:47", "23807", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10883", "srfm_daily_scheduled_action", "complete", "2026-01-22 22:42:13", "2026-01-22 22:42:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769121733;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769121733;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-22 23:39:47", "2026-01-22 23:39:47", "23807", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10884", "srfm_daily_scheduled_action", "complete", "2026-01-22 22:42:13", "2026-01-22 22:42:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769121733;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769121733;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-22 23:39:47", "2026-01-22 23:39:47", "23807", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10885", "srfm_daily_scheduled_action", "complete", "2026-01-22 22:42:13", "2026-01-22 22:42:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769121733;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769121733;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-22 23:39:47", "2026-01-22 23:39:47", "23807", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10886", "srfm_daily_scheduled_action", "complete", "2026-01-22 22:42:13", "2026-01-22 22:42:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769121733;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769121733;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-22 23:39:47", "2026-01-22 23:39:47", "23807", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10887", "srfm_daily_scheduled_action", "complete", "2026-01-22 22:42:13", "2026-01-22 22:42:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769121733;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769121733;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-22 23:39:47", "2026-01-22 23:39:47", "23807", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10890", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-22 22:42:14", "2026-01-22 22:42:14", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769121734;s:18:\"\0*\0first_timestamp\";i:1763817196;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769121734;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-22 23:39:48", "2026-01-22 23:39:48", "23807", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10913", "wpforms_email_summaries_fetch_info_blocks", "complete", "2026-01-29 19:53:22", "2026-01-29 19:53:22", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769716402;s:18:\"\0*\0first_timestamp\";i:1740488041;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769716402;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2026-01-29 20:04:37", "2026-01-29 20:04:37", "24114", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10917", "wpforms_process_forms_locator_scan", "complete", "2026-01-23 23:39:47", "2026-01-23 23:39:47", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769211587;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769211587;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-24 01:31:47", "2026-01-24 01:31:47", "23861", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10918", "wpforms_process_purge_spam", "complete", "2026-01-23 23:39:47", "2026-01-23 23:39:47", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769211587;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769211587;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-24 01:31:47", "2026-01-24 01:31:47", "23861", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10919", "srfm_daily_scheduled_action", "complete", "2026-01-23 23:39:47", "2026-01-23 23:39:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769211587;s:18:\"\0*\0first_timestamp\";i:1740700800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769211587;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-24 01:31:47", "2026-01-24 01:31:47", "23861", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10921", "srfm_daily_scheduled_action", "complete", "2026-01-23 23:39:47", "2026-01-23 23:39:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769211587;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769211587;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-24 01:31:47", "2026-01-24 01:31:47", "23861", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10922", "srfm_daily_scheduled_action", "complete", "2026-01-23 23:39:47", "2026-01-23 23:39:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769211587;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769211587;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-24 01:31:47", "2026-01-24 01:31:47", "23861", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10923", "srfm_daily_scheduled_action", "complete", "2026-01-23 23:39:47", "2026-01-23 23:39:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769211587;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769211587;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-24 01:31:47", "2026-01-24 01:31:47", "23861", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10924", "srfm_daily_scheduled_action", "complete", "2026-01-23 23:39:47", "2026-01-23 23:39:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769211587;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769211587;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-24 01:31:47", "2026-01-24 01:31:47", "23861", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10925", "srfm_daily_scheduled_action", "complete", "2026-01-23 23:39:47", "2026-01-23 23:39:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769211587;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769211587;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-24 01:31:47", "2026-01-24 01:31:47", "23861", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10926", "srfm_daily_scheduled_action", "complete", "2026-01-23 23:39:47", "2026-01-23 23:39:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769211587;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769211587;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-24 01:31:47", "2026-01-24 01:31:47", "23861", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10929", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-23 23:39:48", "2026-01-23 23:39:48", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769211588;s:18:\"\0*\0first_timestamp\";i:1763817196;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769211588;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-24 01:31:47", "2026-01-24 01:31:47", "23861", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10954", "wpforms_process_forms_locator_scan", "complete", "2026-01-25 01:31:47", "2026-01-25 01:31:47", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769304707;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769304707;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-25 02:46:24", "2026-01-25 02:46:24", "23904", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10955", "wpforms_process_purge_spam", "complete", "2026-01-25 01:31:47", "2026-01-25 01:31:47", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769304707;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769304707;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-25 02:46:24", "2026-01-25 02:46:24", "23904", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10956", "srfm_daily_scheduled_action", "complete", "2026-01-25 01:31:47", "2026-01-25 01:31:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769304707;s:18:\"\0*\0first_timestamp\";i:1740700800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769304707;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-25 02:46:24", "2026-01-25 02:46:24", "23904", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10958", "srfm_daily_scheduled_action", "complete", "2026-01-25 01:31:47", "2026-01-25 01:31:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769304707;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769304707;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-25 02:46:24", "2026-01-25 02:46:24", "23904", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10959", "srfm_daily_scheduled_action", "complete", "2026-01-25 01:31:47", "2026-01-25 01:31:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769304707;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769304707;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-25 02:46:24", "2026-01-25 02:46:24", "23904", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10960", "srfm_daily_scheduled_action", "complete", "2026-01-25 01:31:47", "2026-01-25 01:31:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769304707;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769304707;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-25 02:46:24", "2026-01-25 02:46:24", "23904", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10961", "srfm_daily_scheduled_action", "complete", "2026-01-25 01:31:47", "2026-01-25 01:31:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769304707;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769304707;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-25 02:46:24", "2026-01-25 02:46:24", "23904", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10962", "srfm_daily_scheduled_action", "complete", "2026-01-25 01:31:47", "2026-01-25 01:31:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769304707;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769304707;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-25 02:46:24", "2026-01-25 02:46:24", "23904", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10963", "srfm_daily_scheduled_action", "complete", "2026-01-25 01:31:47", "2026-01-25 01:31:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769304707;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769304707;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-25 02:46:24", "2026-01-25 02:46:24", "23904", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10967", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-25 01:31:47", "2026-01-25 01:31:47", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769304707;s:18:\"\0*\0first_timestamp\";i:1763817196;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769304707;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-25 02:46:25", "2026-01-25 02:46:25", "23904", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10971", "wpforms_email_summaries_fetch_info_blocks", "pending", "2026-01-31 06:12:31", "2026-01-31 06:12:31", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769839951;s:18:\"\0*\0first_timestamp\";i:1747978440;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769839951;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10989", "wpforms_process_forms_locator_scan", "complete", "2026-01-26 02:46:24", "2026-01-26 02:46:24", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769395584;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769395584;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-26 05:02:19", "2026-01-26 05:02:19", "23945", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10990", "wpforms_process_purge_spam", "complete", "2026-01-26 02:46:24", "2026-01-26 02:46:24", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769395584;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769395584;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-26 05:02:19", "2026-01-26 05:02:19", "23945", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10991", "srfm_daily_scheduled_action", "complete", "2026-01-26 02:46:24", "2026-01-26 02:46:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769395584;s:18:\"\0*\0first_timestamp\";i:1740700800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769395584;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-26 05:02:19", "2026-01-26 05:02:19", "23945", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10993", "srfm_daily_scheduled_action", "complete", "2026-01-26 02:46:24", "2026-01-26 02:46:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769395584;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769395584;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-26 05:02:19", "2026-01-26 05:02:19", "23945", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10994", "srfm_daily_scheduled_action", "complete", "2026-01-26 02:46:24", "2026-01-26 02:46:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769395584;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769395584;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-26 05:02:19", "2026-01-26 05:02:19", "23945", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10995", "srfm_daily_scheduled_action", "complete", "2026-01-26 02:46:24", "2026-01-26 02:46:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769395584;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769395584;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-26 05:02:19", "2026-01-26 05:02:19", "23945", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10996", "srfm_daily_scheduled_action", "complete", "2026-01-26 02:46:24", "2026-01-26 02:46:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769395584;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769395584;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-26 05:02:19", "2026-01-26 05:02:19", "23945", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10997", "srfm_daily_scheduled_action", "complete", "2026-01-26 02:46:24", "2026-01-26 02:46:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769395584;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769395584;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-26 05:02:19", "2026-01-26 05:02:19", "23945", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10998", "srfm_daily_scheduled_action", "complete", "2026-01-26 02:46:24", "2026-01-26 02:46:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769395584;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769395584;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-26 05:02:19", "2026-01-26 05:02:19", "23945", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11001", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-26 02:46:25", "2026-01-26 02:46:25", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769395585;s:18:\"\0*\0first_timestamp\";i:1763817196;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769395585;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-26 05:02:20", "2026-01-26 05:02:20", "23945", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11020", "wpforms_process_forms_locator_scan", "complete", "2026-01-27 05:02:19", "2026-01-27 05:02:19", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769490139;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769490139;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-27 05:45:18", "2026-01-27 05:45:18", "23988", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11021", "wpforms_process_purge_spam", "complete", "2026-01-27 05:02:19", "2026-01-27 05:02:19", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769490139;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769490139;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-27 05:45:18", "2026-01-27 05:45:18", "23988", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11022", "srfm_daily_scheduled_action", "complete", "2026-01-27 05:02:19", "2026-01-27 05:02:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769490139;s:18:\"\0*\0first_timestamp\";i:1740700800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769490139;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-27 05:45:18", "2026-01-27 05:45:18", "23988", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11024", "srfm_daily_scheduled_action", "complete", "2026-01-27 05:02:19", "2026-01-27 05:02:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769490139;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769490139;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-27 05:45:18", "2026-01-27 05:45:18", "23988", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11025", "srfm_daily_scheduled_action", "complete", "2026-01-27 05:02:19", "2026-01-27 05:02:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769490139;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769490139;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-27 05:45:18", "2026-01-27 05:45:18", "23988", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11026", "srfm_daily_scheduled_action", "complete", "2026-01-27 05:02:19", "2026-01-27 05:02:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769490139;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769490139;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-27 05:45:18", "2026-01-27 05:45:18", "23988", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11027", "srfm_daily_scheduled_action", "complete", "2026-01-27 05:02:19", "2026-01-27 05:02:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769490139;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769490139;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-27 05:45:18", "2026-01-27 05:45:18", "23988", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11028", "srfm_daily_scheduled_action", "complete", "2026-01-27 05:02:19", "2026-01-27 05:02:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769490139;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769490139;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-27 05:45:18", "2026-01-27 05:45:18", "23988", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11029", "srfm_daily_scheduled_action", "complete", "2026-01-27 05:02:19", "2026-01-27 05:02:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769490139;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769490139;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-27 05:45:18", "2026-01-27 05:45:18", "23988", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11032", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-27 05:02:20", "2026-01-27 05:02:20", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769490140;s:18:\"\0*\0first_timestamp\";i:1763817196;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769490140;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-27 05:45:18", "2026-01-27 05:45:18", "23988", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11054", "wpforms_process_forms_locator_scan", "complete", "2026-01-28 05:45:18", "2026-01-28 05:45:18", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769579118;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769579118;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-28 06:06:42", "2026-01-28 06:06:42", "24033", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11055", "wpforms_process_purge_spam", "complete", "2026-01-28 05:45:18", "2026-01-28 05:45:18", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769579118;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769579118;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-28 06:06:42", "2026-01-28 06:06:42", "24033", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11056", "srfm_daily_scheduled_action", "complete", "2026-01-28 05:45:18", "2026-01-28 05:45:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769579118;s:18:\"\0*\0first_timestamp\";i:1740700800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769579118;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-28 06:06:42", "2026-01-28 06:06:42", "24033", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11058", "srfm_daily_scheduled_action", "complete", "2026-01-28 05:45:18", "2026-01-28 05:45:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769579118;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769579118;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-28 06:06:42", "2026-01-28 06:06:42", "24033", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11059", "srfm_daily_scheduled_action", "complete", "2026-01-28 05:45:18", "2026-01-28 05:45:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769579118;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769579118;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-28 06:06:42", "2026-01-28 06:06:42", "24033", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11060", "srfm_daily_scheduled_action", "complete", "2026-01-28 05:45:18", "2026-01-28 05:45:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769579118;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769579118;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-28 06:06:42", "2026-01-28 06:06:42", "24033", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11061", "srfm_daily_scheduled_action", "complete", "2026-01-28 05:45:18", "2026-01-28 05:45:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769579118;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769579118;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-28 06:06:42", "2026-01-28 06:06:42", "24033", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11062", "srfm_daily_scheduled_action", "complete", "2026-01-28 05:45:18", "2026-01-28 05:45:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769579118;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769579118;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-28 06:06:42", "2026-01-28 06:06:42", "24033", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11063", "srfm_daily_scheduled_action", "complete", "2026-01-28 05:45:18", "2026-01-28 05:45:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769579118;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769579118;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-28 06:06:42", "2026-01-28 06:06:42", "24033", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11066", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-28 05:45:18", "2026-01-28 05:45:18", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769579118;s:18:\"\0*\0first_timestamp\";i:1763817196;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769579118;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-28 06:06:43", "2026-01-28 06:06:43", "24033", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11075", "aioseo_report_summary", "pending", "2026-02-26 21:05:12", "2026-02-26 21:05:12", "10", "{\"frequency\":\"monthly\"}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772139912;s:18:\"\0*\0first_timestamp\";i:1740998880;s:13:\"\0*\0recurrence\";i:2592000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772139912;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:2592000;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11088", "wpforms_process_forms_locator_scan", "complete", "2026-01-29 06:06:42", "2026-01-29 06:06:42", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769666802;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769666802;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-29 06:26:32", "2026-01-29 06:26:32", "24078", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11089", "wpforms_process_purge_spam", "complete", "2026-01-29 06:06:42", "2026-01-29 06:06:42", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769666802;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769666802;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-29 06:26:32", "2026-01-29 06:26:32", "24078", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11090", "srfm_daily_scheduled_action", "complete", "2026-01-29 06:06:42", "2026-01-29 06:06:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769666802;s:18:\"\0*\0first_timestamp\";i:1740700800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769666802;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-29 06:26:32", "2026-01-29 06:26:32", "24078", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11092", "srfm_daily_scheduled_action", "complete", "2026-01-29 06:06:42", "2026-01-29 06:06:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769666802;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769666802;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-29 06:26:32", "2026-01-29 06:26:32", "24078", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11093", "srfm_daily_scheduled_action", "complete", "2026-01-29 06:06:42", "2026-01-29 06:06:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769666802;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769666802;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-29 06:26:32", "2026-01-29 06:26:32", "24078", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11094", "srfm_daily_scheduled_action", "complete", "2026-01-29 06:06:42", "2026-01-29 06:06:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769666802;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769666802;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-29 06:26:32", "2026-01-29 06:26:32", "24078", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11095", "srfm_daily_scheduled_action", "complete", "2026-01-29 06:06:42", "2026-01-29 06:06:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769666802;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769666802;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-29 06:26:32", "2026-01-29 06:26:32", "24078", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11096", "srfm_daily_scheduled_action", "complete", "2026-01-29 06:06:42", "2026-01-29 06:06:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769666802;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769666802;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-29 06:26:32", "2026-01-29 06:26:32", "24078", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11097", "srfm_daily_scheduled_action", "complete", "2026-01-29 06:06:42", "2026-01-29 06:06:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769666802;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769666802;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-29 06:26:32", "2026-01-29 06:26:32", "24078", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11100", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-29 06:06:43", "2026-01-29 06:06:43", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769666803;s:18:\"\0*\0first_timestamp\";i:1763817196;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769666803;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-29 06:26:33", "2026-01-29 06:26:33", "24078", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11114", "aioseo_report_summary", "pending", "2026-02-04 20:17:44", "2026-02-04 20:17:44", "10", "{\"frequency\":\"weekly\"}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770236264;s:18:\"\0*\0first_timestamp\";i:1740998880;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770236264;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11124", "wpforms_process_forms_locator_scan", "complete", "2026-01-30 06:26:32", "2026-01-30 06:26:32", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769754392;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769754392;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-30 06:34:20", "2026-01-30 06:34:20", "24131", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11125", "wpforms_process_purge_spam", "complete", "2026-01-30 06:26:32", "2026-01-30 06:26:32", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769754392;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769754392;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-30 06:34:20", "2026-01-30 06:34:20", "24131", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11126", "srfm_daily_scheduled_action", "complete", "2026-01-30 06:26:32", "2026-01-30 06:26:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769754392;s:18:\"\0*\0first_timestamp\";i:1740700800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769754392;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-30 06:34:20", "2026-01-30 06:34:20", "24131", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11128", "srfm_daily_scheduled_action", "complete", "2026-01-30 06:26:32", "2026-01-30 06:26:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769754392;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769754392;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-30 06:34:20", "2026-01-30 06:34:20", "24131", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11129", "srfm_daily_scheduled_action", "complete", "2026-01-30 06:26:32", "2026-01-30 06:26:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769754392;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769754392;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-30 06:34:20", "2026-01-30 06:34:20", "24131", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11130", "srfm_daily_scheduled_action", "complete", "2026-01-30 06:26:32", "2026-01-30 06:26:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769754392;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769754392;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-30 06:34:20", "2026-01-30 06:34:20", "24131", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11131", "srfm_daily_scheduled_action", "complete", "2026-01-30 06:26:32", "2026-01-30 06:26:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769754392;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769754392;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-30 06:34:20", "2026-01-30 06:34:20", "24131", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11132", "srfm_daily_scheduled_action", "complete", "2026-01-30 06:26:32", "2026-01-30 06:26:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769754392;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769754392;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-30 06:34:20", "2026-01-30 06:34:20", "24131", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11133", "srfm_daily_scheduled_action", "complete", "2026-01-30 06:26:32", "2026-01-30 06:26:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769754392;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769754392;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-30 06:34:20", "2026-01-30 06:34:20", "24131", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11136", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-30 06:26:33", "2026-01-30 06:26:33", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769754393;s:18:\"\0*\0first_timestamp\";i:1763817196;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769754393;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-30 06:34:20", "2026-01-30 06:34:20", "24131", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11153", "wpforms_email_summaries_fetch_info_blocks", "pending", "2026-02-05 20:04:37", "2026-02-05 20:04:37", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770321877;s:18:\"\0*\0first_timestamp\";i:1740488041;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770321877;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11160", "aioseo_cache_prune", "pending", "2026-01-31 06:34:20", "2026-01-31 06:34:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769841260;s:18:\"\0*\0first_timestamp\";i:1740653370;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769841260;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11161", "wpforms_process_forms_locator_scan", "pending", "2026-01-31 06:34:20", "2026-01-31 06:34:20", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769841260;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769841260;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11162", "wpforms_process_purge_spam", "pending", "2026-01-31 06:34:20", "2026-01-31 06:34:20", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769841260;s:18:\"\0*\0first_timestamp\";i:1740653445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769841260;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11163", "srfm_daily_scheduled_action", "pending", "2026-01-31 06:34:20", "2026-01-31 06:34:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769841260;s:18:\"\0*\0first_timestamp\";i:1740700800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769841260;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11164", "aioseo_cache_prune", "pending", "2026-01-31 06:34:20", "2026-01-31 06:34:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769841260;s:18:\"\0*\0first_timestamp\";i:1746816519;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769841260;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11165", "srfm_daily_scheduled_action", "pending", "2026-01-31 06:34:20", "2026-01-31 06:34:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769841260;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769841260;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11166", "srfm_daily_scheduled_action", "pending", "2026-01-31 06:34:20", "2026-01-31 06:34:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769841260;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769841260;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11167", "srfm_daily_scheduled_action", "pending", "2026-01-31 06:34:20", "2026-01-31 06:34:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769841260;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769841260;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11168", "srfm_daily_scheduled_action", "pending", "2026-01-31 06:34:20", "2026-01-31 06:34:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769841260;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769841260;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11169", "srfm_daily_scheduled_action", "pending", "2026-01-31 06:34:20", "2026-01-31 06:34:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769841260;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769841260;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11170", "srfm_daily_scheduled_action", "pending", "2026-01-31 06:34:20", "2026-01-31 06:34:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769841260;s:18:\"\0*\0first_timestamp\";i:1744934400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769841260;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11171", "aioseo_ai_update_credits", "pending", "2026-01-31 06:34:20", "2026-01-31 06:34:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769841260;s:18:\"\0*\0first_timestamp\";i:1758971095;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769841260;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11172", "aioseo_generate_llms_txt", "pending", "2026-01-31 06:34:20", "2026-01-31 06:34:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769841260;s:18:\"\0*\0first_timestamp\";i:1763723254;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769841260;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11173", "action_scheduler_run_recurring_actions_schedule_hook", "pending", "2026-01-31 06:34:20", "2026-01-31 06:34:20", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769841260;s:18:\"\0*\0first_timestamp\";i:1763817196;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769841260;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11180", "wpforms_admin_notifications_update", "complete", "2026-01-30 10:57:42", "2026-01-30 10:57:42", "10", "{\"tasks_meta_id\":76}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-30 10:58:35", "2026-01-30 10:58:35", "24149", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11192", "aioseo_image_sitemap_scan", "complete", "2026-01-30 18:41:43", "2026-01-30 18:41:43", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769798503;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769798503;}", "2", "1", "2026-01-30 19:08:49", "2026-01-30 19:08:49", "24184", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11193", "aioseo_image_sitemap_scan", "complete", "2026-01-30 19:23:49", "2026-01-30 19:23:49", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769801029;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769801029;}", "2", "1", "2026-01-30 19:43:45", "2026-01-30 19:43:45", "24186", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11194", "aioseo_image_sitemap_scan", "complete", "2026-01-30 19:58:45", "2026-01-30 19:58:45", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769803125;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769803125;}", "2", "1", "2026-01-30 20:31:13", "2026-01-30 20:31:13", "24189", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11195", "aioseo_image_sitemap_scan", "complete", "2026-01-30 20:46:13", "2026-01-30 20:46:13", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769805973;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769805973;}", "2", "1", "2026-01-30 20:46:57", "2026-01-30 20:46:57", "24191", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11196", "aioseo_image_sitemap_scan", "complete", "2026-01-30 21:01:57", "2026-01-30 21:01:57", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769806917;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769806917;}", "2", "1", "2026-01-30 21:02:04", "2026-01-30 21:02:04", "24193", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11197", "aioseo_image_sitemap_scan", "complete", "2026-01-30 21:17:04", "2026-01-30 21:17:04", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769807824;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769807824;}", "2", "1", "2026-01-30 23:23:49", "2026-01-30 23:23:49", "24195", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11198", "aioseo_image_sitemap_scan", "complete", "2026-01-30 23:38:49", "2026-01-30 23:38:49", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769816329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769816329;}", "2", "1", "2026-01-31 01:01:02", "2026-01-31 01:01:02", "24197", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11199", "aioseo_image_sitemap_scan", "complete", "2026-01-31 01:16:02", "2026-01-31 01:16:02", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769822162;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769822162;}", "2", "1", "2026-01-31 02:41:34", "2026-01-31 02:41:34", "24199", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11200", "aioseo_image_sitemap_scan", "complete", "2026-01-31 02:56:34", "2026-01-31 02:56:34", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769828194;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769828194;}", "2", "1", "2026-01-31 03:47:07", "2026-01-31 03:47:07", "24201", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11201", "aioseo_image_sitemap_scan", "complete", "2026-01-31 04:02:07", "2026-01-31 04:02:07", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769832127;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769832127;}", "2", "1", "2026-01-31 05:18:39", "2026-01-31 05:18:39", "24203", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11202", "aioseo_image_sitemap_scan", "complete", "2026-01-31 05:33:39", "2026-01-31 05:33:39", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769837619;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769837619;}", "2", "1", "2026-01-31 05:49:38", "2026-01-31 05:49:38", "24205", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11203", "aioseo_image_sitemap_scan", "pending", "2026-01-31 06:04:38", "2026-01-31 06:04:38", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769839478;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769839478;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11204", "aioseo_admin_notifications_update", "complete", "2026-01-31 05:51:18", "2026-01-31 05:51:18", "10", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2026-01-31 05:51:18", "2026-01-31 05:51:18", "24207", NULL);

/* INSERT TABLE DATA: wp_actionscheduler_claims */
INSERT INTO `wp_actionscheduler_claims` VALUES("3915", "2025-04-27 11:16:18");
INSERT INTO `wp_actionscheduler_claims` VALUES("5468", "2025-05-20 13:42:43");
INSERT INTO `wp_actionscheduler_claims` VALUES("6305", "2025-06-03 13:39:46");
INSERT INTO `wp_actionscheduler_claims` VALUES("6369", "2025-06-03 18:00:48");
INSERT INTO `wp_actionscheduler_claims` VALUES("6470", "2025-06-04 06:02:56");
INSERT INTO `wp_actionscheduler_claims` VALUES("7390", "2025-06-16 09:20:44");
INSERT INTO `wp_actionscheduler_claims` VALUES("8769", "2025-06-30 06:02:43");
INSERT INTO `wp_actionscheduler_claims` VALUES("8823", "2025-06-30 15:04:27");
INSERT INTO `wp_actionscheduler_claims` VALUES("9731", "2025-07-13 04:06:01");
INSERT INTO `wp_actionscheduler_claims` VALUES("10308", "2025-07-16 00:57:42");
INSERT INTO `wp_actionscheduler_claims` VALUES("11008", "2025-07-22 11:59:27");
INSERT INTO `wp_actionscheduler_claims` VALUES("12004", "2025-07-28 18:13:43");

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "aioseo");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "sureforms");
INSERT INTO `wp_actionscheduler_groups` VALUES("4", "wpforms");
INSERT INTO `wp_actionscheduler_groups` VALUES("5", "ActionScheduler");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("6811", "2286", "action created", "2025-05-27 11:16:56", "2025-05-27 11:16:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("6814", "2287", "action created", "2025-05-27 11:16:56", "2025-05-27 11:16:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("7499", "2286", "action started via Async Request", "2025-06-03 11:18:30", "2025-06-03 11:18:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("7500", "2286", "action failed via Async Request: Scheduled action for wpforms_admin_addons_cache_update will not be executed as no callbacks are registered.", "2025-06-03 11:18:30", "2025-06-03 11:18:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("7501", "2516", "action created", "2025-06-03 11:18:30", "2025-06-03 11:18:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("7502", "2287", "action started via Async Request", "2025-06-03 11:18:30", "2025-06-03 11:18:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("7503", "2287", "action failed via Async Request: Scheduled action for wpforms_admin_builder_templates_cache_update will not be executed as no callbacks are registered.", "2025-06-03 11:18:30", "2025-06-03 11:18:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("7504", "2517", "action created", "2025-06-03 11:18:30", "2025-06-03 11:18:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("8279", "2516", "action started via Async Request", "2025-06-10 11:39:24", "2025-06-10 11:39:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8280", "2516", "action failed via Async Request: Scheduled action for wpforms_admin_addons_cache_update will not be executed as no callbacks are registered.", "2025-06-10 11:39:24", "2025-06-10 11:39:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8281", "2777", "action created", "2025-06-10 11:39:24", "2025-06-10 11:39:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8282", "2517", "action started via Async Request", "2025-06-10 11:39:24", "2025-06-10 11:39:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8283", "2517", "action failed via Async Request: Scheduled action for wpforms_admin_builder_templates_cache_update will not be executed as no callbacks are registered.", "2025-06-10 11:39:24", "2025-06-10 11:39:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8284", "2778", "action created", "2025-06-10 11:39:24", "2025-06-10 11:39:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8929", "2777", "action started via Async Request", "2025-06-17 11:52:34", "2025-06-17 11:52:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("8930", "2777", "action failed via Async Request: Scheduled action for wpforms_admin_addons_cache_update will not be executed as no callbacks are registered.", "2025-06-17 11:52:34", "2025-06-17 11:52:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("8932", "2778", "action started via Async Request", "2025-06-17 11:52:34", "2025-06-17 11:52:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("8933", "2778", "action failed via Async Request: Scheduled action for wpforms_admin_builder_templates_cache_update will not be executed as no callbacks are registered.", "2025-06-17 11:52:34", "2025-06-17 11:52:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("9915", "3322", "action created", "2025-06-24 12:07:51", "2025-06-24 12:07:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("9918", "3323", "action created", "2025-06-24 12:07:52", "2025-06-24 12:07:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("10778", "3322", "action started via Async Request", "2025-07-01 13:41:10", "2025-07-01 13:41:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("10779", "3322", "action failed via Async Request: Scheduled action for wpforms_admin_addons_cache_update will not be executed as no callbacks are registered.", "2025-07-01 13:41:10", "2025-07-01 13:41:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("10780", "3611", "action created", "2025-07-01 13:41:10", "2025-07-01 13:41:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("10781", "3323", "action started via Async Request", "2025-07-01 13:41:10", "2025-07-01 13:41:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("10782", "3323", "action failed via Async Request: Scheduled action for wpforms_admin_builder_templates_cache_update will not be executed as no callbacks are registered.", "2025-07-01 13:41:10", "2025-07-01 13:41:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("10783", "3612", "action created", "2025-07-01 13:41:10", "2025-07-01 13:41:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11498", "3611", "action started via Async Request", "2025-07-08 14:17:29", "2025-07-08 14:17:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("11499", "3611", "action failed via Async Request: Scheduled action for wpforms_admin_addons_cache_update will not be executed as no callbacks are registered.", "2025-07-08 14:17:29", "2025-07-08 14:17:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("11501", "3612", "action started via Async Request", "2025-07-08 14:17:29", "2025-07-08 14:17:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("11502", "3612", "action failed via Async Request: Scheduled action for wpforms_admin_builder_templates_cache_update will not be executed as no callbacks are registered.", "2025-07-08 14:17:29", "2025-07-08 14:17:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("12426", "4160", "action created", "2025-07-15 14:27:29", "2025-07-15 14:27:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("12429", "4161", "action created", "2025-07-15 14:27:29", "2025-07-15 14:27:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("13344", "4160", "action started via Async Request", "2025-07-22 14:36:12", "2025-07-22 14:36:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("13345", "4160", "action failed via Async Request: Scheduled action for wpforms_admin_addons_cache_update will not be executed as no callbacks are registered.", "2025-07-22 14:36:12", "2025-07-22 14:36:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("13347", "4161", "action started via Async Request", "2025-07-22 14:36:12", "2025-07-22 14:36:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("13348", "4161", "action failed via Async Request: Scheduled action for wpforms_admin_builder_templates_cache_update will not be executed as no callbacks are registered.", "2025-07-22 14:36:12", "2025-07-22 14:36:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("16285", "5447", "action created", "2025-08-12 15:32:22", "2025-08-12 15:32:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("16288", "5448", "action created", "2025-08-12 15:32:22", "2025-08-12 15:32:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("17013", "5447", "action started via Async Request", "2025-08-19 16:57:22", "2025-08-19 16:57:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("17014", "5447", "action failed via Async Request: Scheduled action for wpforms_admin_addons_cache_update will not be executed as no callbacks are registered.", "2025-08-19 16:57:22", "2025-08-19 16:57:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("17015", "5447", "This action appears to be consistently failing. A new instance will not be scheduled.", "2025-08-19 16:57:22", "2025-08-19 16:57:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("17016", "5448", "action started via Async Request", "2025-08-19 16:57:22", "2025-08-19 16:57:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("17017", "5448", "action failed via Async Request: Scheduled action for wpforms_admin_builder_templates_cache_update will not be executed as no callbacks are registered.", "2025-08-19 16:57:22", "2025-08-19 16:57:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("17018", "5448", "This action appears to be consistently failing. A new instance will not be scheduled.", "2025-08-19 16:57:22", "2025-08-19 16:57:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("30013", "10023", "action created", "2025-12-25 17:25:36", "2025-12-25 17:25:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("30139", "10065", "action created", "2025-12-26 22:47:14", "2025-12-26 22:47:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("30460", "10172", "action created", "2025-12-30 19:34:03", "2025-12-30 19:34:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("30463", "10173", "action created", "2025-12-30 19:34:03", "2025-12-30 19:34:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("30466", "10174", "action created", "2025-12-30 19:34:03", "2025-12-30 19:34:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("30472", "10176", "action created", "2025-12-30 19:34:03", "2025-12-30 19:34:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("30475", "10177", "action created", "2025-12-30 19:34:03", "2025-12-30 19:34:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("30478", "10178", "action created", "2025-12-30 19:34:03", "2025-12-30 19:34:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("30481", "10179", "action created", "2025-12-30 19:34:03", "2025-12-30 19:34:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("30484", "10180", "action created", "2025-12-30 19:34:03", "2025-12-30 19:34:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("30487", "10181", "action created", "2025-12-30 19:34:03", "2025-12-30 19:34:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("30499", "10185", "action created", "2025-12-30 19:34:04", "2025-12-30 19:34:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("30551", "10172", "action started via WP Cron", "2025-12-31 21:49:49", "2025-12-31 21:49:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("30552", "10172", "action complete via WP Cron", "2025-12-31 21:49:49", "2025-12-31 21:49:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("30553", "10203", "action created", "2025-12-31 21:49:49", "2025-12-31 21:49:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("30554", "10173", "action started via WP Cron", "2025-12-31 21:49:49", "2025-12-31 21:49:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("30555", "10173", "action complete via WP Cron", "2025-12-31 21:49:49", "2025-12-31 21:49:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("30556", "10204", "action created", "2025-12-31 21:49:49", "2025-12-31 21:49:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("30557", "10174", "action started via WP Cron", "2025-12-31 21:49:49", "2025-12-31 21:49:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("30558", "10174", "action complete via WP Cron", "2025-12-31 21:49:49", "2025-12-31 21:49:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("30559", "10205", "action created", "2025-12-31 21:49:49", "2025-12-31 21:49:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("30563", "10176", "action started via WP Cron", "2025-12-31 21:49:49", "2025-12-31 21:49:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("30564", "10176", "action complete via WP Cron", "2025-12-31 21:49:49", "2025-12-31 21:49:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("30565", "10207", "action created", "2025-12-31 21:49:49", "2025-12-31 21:49:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("30566", "10177", "action started via WP Cron", "2025-12-31 21:49:49", "2025-12-31 21:49:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("30567", "10177", "action complete via WP Cron", "2025-12-31 21:49:49", "2025-12-31 21:49:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("30568", "10208", "action created", "2025-12-31 21:49:49", "2025-12-31 21:49:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("30569", "10178", "action started via WP Cron", "2025-12-31 21:49:49", "2025-12-31 21:49:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("30570", "10178", "action complete via WP Cron", "2025-12-31 21:49:49", "2025-12-31 21:49:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("30571", "10209", "action created", "2025-12-31 21:49:49", "2025-12-31 21:49:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("30572", "10179", "action started via WP Cron", "2025-12-31 21:49:49", "2025-12-31 21:49:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("30573", "10179", "action complete via WP Cron", "2025-12-31 21:49:49", "2025-12-31 21:49:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("30574", "10210", "action created", "2025-12-31 21:49:49", "2025-12-31 21:49:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("30575", "10180", "action started via WP Cron", "2025-12-31 21:49:49", "2025-12-31 21:49:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("30576", "10180", "action complete via WP Cron", "2025-12-31 21:49:49", "2025-12-31 21:49:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("30577", "10211", "action created", "2025-12-31 21:49:49", "2025-12-31 21:49:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("30578", "10181", "action started via WP Cron", "2025-12-31 21:49:49", "2025-12-31 21:49:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("30579", "10181", "action complete via WP Cron", "2025-12-31 21:49:49", "2025-12-31 21:49:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("30580", "10212", "action created", "2025-12-31 21:49:49", "2025-12-31 21:49:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("30590", "10185", "action started via WP Cron", "2025-12-31 21:49:49", "2025-12-31 21:49:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("30591", "10185", "action complete via WP Cron", "2025-12-31 21:49:49", "2025-12-31 21:49:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("30592", "10216", "action created", "2025-12-31 21:49:49", "2025-12-31 21:49:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("30635", "10023", "action started via WP Cron", "2026-01-01 19:04:57", "2026-01-01 19:04:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("30636", "10023", "action complete via WP Cron", "2026-01-01 19:04:57", "2026-01-01 19:04:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("30637", "10231", "action created", "2026-01-01 19:04:57", "2026-01-01 19:04:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("30653", "10203", "action started via WP Cron", "2026-01-02 00:52:35", "2026-01-02 00:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("30654", "10203", "action complete via WP Cron", "2026-01-02 00:52:35", "2026-01-02 00:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("30655", "10237", "action created", "2026-01-02 00:52:35", "2026-01-02 00:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("30656", "10204", "action started via WP Cron", "2026-01-02 00:52:35", "2026-01-02 00:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("30657", "10204", "action complete via WP Cron", "2026-01-02 00:52:35", "2026-01-02 00:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("30658", "10238", "action created", "2026-01-02 00:52:35", "2026-01-02 00:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("30659", "10205", "action started via WP Cron", "2026-01-02 00:52:35", "2026-01-02 00:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("30660", "10205", "action complete via WP Cron", "2026-01-02 00:52:35", "2026-01-02 00:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("30661", "10239", "action created", "2026-01-02 00:52:35", "2026-01-02 00:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("30665", "10207", "action started via WP Cron", "2026-01-02 00:52:35", "2026-01-02 00:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("30666", "10207", "action complete via WP Cron", "2026-01-02 00:52:35", "2026-01-02 00:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("30667", "10241", "action created", "2026-01-02 00:52:35", "2026-01-02 00:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("30668", "10208", "action started via WP Cron", "2026-01-02 00:52:35", "2026-01-02 00:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("30669", "10208", "action complete via WP Cron", "2026-01-02 00:52:35", "2026-01-02 00:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("30670", "10242", "action created", "2026-01-02 00:52:35", "2026-01-02 00:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("30671", "10209", "action started via WP Cron", "2026-01-02 00:52:35", "2026-01-02 00:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("30672", "10209", "action complete via WP Cron", "2026-01-02 00:52:35", "2026-01-02 00:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("30673", "10243", "action created", "2026-01-02 00:52:35", "2026-01-02 00:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("30674", "10210", "action started via WP Cron", "2026-01-02 00:52:35", "2026-01-02 00:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("30675", "10210", "action complete via WP Cron", "2026-01-02 00:52:35", "2026-01-02 00:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("30676", "10244", "action created", "2026-01-02 00:52:35", "2026-01-02 00:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("30677", "10211", "action started via WP Cron", "2026-01-02 00:52:35", "2026-01-02 00:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("30678", "10211", "action complete via WP Cron", "2026-01-02 00:52:35", "2026-01-02 00:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("30679", "10245", "action created", "2026-01-02 00:52:35", "2026-01-02 00:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("30680", "10212", "action started via WP Cron", "2026-01-02 00:52:35", "2026-01-02 00:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("30681", "10212", "action complete via WP Cron", "2026-01-02 00:52:35", "2026-01-02 00:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("30682", "10246", "action created", "2026-01-02 00:52:35", "2026-01-02 00:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("30689", "10216", "action started via WP Cron", "2026-01-02 00:52:36", "2026-01-02 00:52:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("30690", "10216", "action complete via WP Cron", "2026-01-02 00:52:36", "2026-01-02 00:52:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("30691", "10249", "action created", "2026-01-02 00:52:36", "2026-01-02 00:52:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("30734", "10065", "action started via WP Cron", "2026-01-02 23:55:14", "2026-01-02 23:55:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("30735", "10065", "action complete via WP Cron", "2026-01-02 23:55:14", "2026-01-02 23:55:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("30736", "10264", "action created", "2026-01-02 23:55:14", "2026-01-02 23:55:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("30743", "10237", "action started via WP Cron", "2026-01-03 04:00:29", "2026-01-03 04:00:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("30744", "10237", "action complete via WP Cron", "2026-01-03 04:00:29", "2026-01-03 04:00:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("30745", "10267", "action created", "2026-01-03 04:00:29", "2026-01-03 04:00:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("30746", "10238", "action started via WP Cron", "2026-01-03 04:00:29", "2026-01-03 04:00:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("30747", "10238", "action complete via WP Cron", "2026-01-03 04:00:29", "2026-01-03 04:00:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("30748", "10268", "action created", "2026-01-03 04:00:29", "2026-01-03 04:00:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("30749", "10239", "action started via WP Cron", "2026-01-03 04:00:29", "2026-01-03 04:00:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("30750", "10239", "action complete via WP Cron", "2026-01-03 04:00:29", "2026-01-03 04:00:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("30751", "10269", "action created", "2026-01-03 04:00:29", "2026-01-03 04:00:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("30755", "10241", "action started via WP Cron", "2026-01-03 04:00:29", "2026-01-03 04:00:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("30756", "10241", "action complete via WP Cron", "2026-01-03 04:00:29", "2026-01-03 04:00:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("30757", "10271", "action created", "2026-01-03 04:00:29", "2026-01-03 04:00:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("30758", "10242", "action started via WP Cron", "2026-01-03 04:00:29", "2026-01-03 04:00:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("30759", "10242", "action complete via WP Cron", "2026-01-03 04:00:29", "2026-01-03 04:00:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("30760", "10272", "action created", "2026-01-03 04:00:29", "2026-01-03 04:00:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("30761", "10243", "action started via WP Cron", "2026-01-03 04:00:29", "2026-01-03 04:00:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("30762", "10243", "action complete via WP Cron", "2026-01-03 04:00:29", "2026-01-03 04:00:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("30763", "10273", "action created", "2026-01-03 04:00:29", "2026-01-03 04:00:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("30764", "10244", "action started via WP Cron", "2026-01-03 04:00:29", "2026-01-03 04:00:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("30765", "10244", "action complete via WP Cron", "2026-01-03 04:00:29", "2026-01-03 04:00:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("30766", "10274", "action created", "2026-01-03 04:00:29", "2026-01-03 04:00:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("30767", "10245", "action started via WP Cron", "2026-01-03 04:00:29", "2026-01-03 04:00:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("30768", "10245", "action complete via WP Cron", "2026-01-03 04:00:29", "2026-01-03 04:00:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("30769", "10275", "action created", "2026-01-03 04:00:29", "2026-01-03 04:00:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("30770", "10246", "action started via WP Cron", "2026-01-03 04:00:29", "2026-01-03 04:00:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("30771", "10246", "action complete via WP Cron", "2026-01-03 04:00:29", "2026-01-03 04:00:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("30772", "10276", "action created", "2026-01-03 04:00:29", "2026-01-03 04:00:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("30779", "10249", "action started via WP Cron", "2026-01-03 04:00:30", "2026-01-03 04:00:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("30780", "10249", "action complete via WP Cron", "2026-01-03 04:00:30", "2026-01-03 04:00:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("30781", "10279", "action created", "2026-01-03 04:00:30", "2026-01-03 04:00:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("30857", "10267", "action started via WP Cron", "2026-01-04 04:00:54", "2026-01-04 04:00:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("30858", "10267", "action complete via WP Cron", "2026-01-04 04:00:54", "2026-01-04 04:00:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("30859", "10305", "action created", "2026-01-04 04:00:54", "2026-01-04 04:00:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("30860", "10268", "action started via WP Cron", "2026-01-04 04:00:54", "2026-01-04 04:00:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("30861", "10268", "action complete via WP Cron", "2026-01-04 04:00:54", "2026-01-04 04:00:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("30862", "10306", "action created", "2026-01-04 04:00:54", "2026-01-04 04:00:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("30863", "10269", "action started via WP Cron", "2026-01-04 04:00:54", "2026-01-04 04:00:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("30864", "10269", "action complete via WP Cron", "2026-01-04 04:00:54", "2026-01-04 04:00:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("30865", "10307", "action created", "2026-01-04 04:00:54", "2026-01-04 04:00:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("30869", "10271", "action started via WP Cron", "2026-01-04 04:00:54", "2026-01-04 04:00:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("30870", "10271", "action complete via WP Cron", "2026-01-04 04:00:54", "2026-01-04 04:00:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("30871", "10309", "action created", "2026-01-04 04:00:54", "2026-01-04 04:00:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("30872", "10272", "action started via WP Cron", "2026-01-04 04:00:54", "2026-01-04 04:00:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("30873", "10272", "action complete via WP Cron", "2026-01-04 04:00:54", "2026-01-04 04:00:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("30874", "10310", "action created", "2026-01-04 04:00:54", "2026-01-04 04:00:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("30875", "10273", "action started via WP Cron", "2026-01-04 04:00:54", "2026-01-04 04:00:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("30876", "10273", "action complete via WP Cron", "2026-01-04 04:00:54", "2026-01-04 04:00:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("30877", "10311", "action created", "2026-01-04 04:00:54", "2026-01-04 04:00:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("30878", "10274", "action started via WP Cron", "2026-01-04 04:00:54", "2026-01-04 04:00:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("30879", "10274", "action complete via WP Cron", "2026-01-04 04:00:54", "2026-01-04 04:00:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("30880", "10312", "action created", "2026-01-04 04:00:54", "2026-01-04 04:00:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("30881", "10275", "action started via WP Cron", "2026-01-04 04:00:54", "2026-01-04 04:00:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("30882", "10275", "action complete via WP Cron", "2026-01-04 04:00:54", "2026-01-04 04:00:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("30883", "10313", "action created", "2026-01-04 04:00:54", "2026-01-04 04:00:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("30884", "10276", "action started via WP Cron", "2026-01-04 04:00:54", "2026-01-04 04:00:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("30885", "10276", "action complete via WP Cron", "2026-01-04 04:00:54", "2026-01-04 04:00:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("30886", "10314", "action created", "2026-01-04 04:00:54", "2026-01-04 04:00:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("30893", "10279", "action started via WP Cron", "2026-01-04 04:00:54", "2026-01-04 04:00:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("30894", "10279", "action complete via WP Cron", "2026-01-04 04:00:54", "2026-01-04 04:00:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("30895", "10317", "action created", "2026-01-04 04:00:54", "2026-01-04 04:00:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("30965", "10305", "action started via WP Cron", "2026-01-05 04:48:45", "2026-01-05 04:48:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("30966", "10305", "action complete via WP Cron", "2026-01-05 04:48:45", "2026-01-05 04:48:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("30967", "10341", "action created", "2026-01-05 04:48:45", "2026-01-05 04:48:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("30968", "10306", "action started via WP Cron", "2026-01-05 04:48:45", "2026-01-05 04:48:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("30969", "10306", "action complete via WP Cron", "2026-01-05 04:48:45", "2026-01-05 04:48:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("30970", "10342", "action created", "2026-01-05 04:48:45", "2026-01-05 04:48:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("30971", "10307", "action started via WP Cron", "2026-01-05 04:48:45", "2026-01-05 04:48:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("30972", "10307", "action complete via WP Cron", "2026-01-05 04:48:45", "2026-01-05 04:48:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("30973", "10343", "action created", "2026-01-05 04:48:45", "2026-01-05 04:48:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("30977", "10309", "action started via WP Cron", "2026-01-05 04:48:45", "2026-01-05 04:48:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("30978", "10309", "action complete via WP Cron", "2026-01-05 04:48:45", "2026-01-05 04:48:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("30979", "10345", "action created", "2026-01-05 04:48:45", "2026-01-05 04:48:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("30980", "10310", "action started via WP Cron", "2026-01-05 04:48:45", "2026-01-05 04:48:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("30981", "10310", "action complete via WP Cron", "2026-01-05 04:48:45", "2026-01-05 04:48:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("30982", "10346", "action created", "2026-01-05 04:48:45", "2026-01-05 04:48:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("30983", "10311", "action started via WP Cron", "2026-01-05 04:48:45", "2026-01-05 04:48:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("30984", "10311", "action complete via WP Cron", "2026-01-05 04:48:45", "2026-01-05 04:48:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("30985", "10347", "action created", "2026-01-05 04:48:45", "2026-01-05 04:48:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("30986", "10312", "action started via WP Cron", "2026-01-05 04:48:45", "2026-01-05 04:48:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("30987", "10312", "action complete via WP Cron", "2026-01-05 04:48:45", "2026-01-05 04:48:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("30988", "10348", "action created", "2026-01-05 04:48:45", "2026-01-05 04:48:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("30989", "10313", "action started via WP Cron", "2026-01-05 04:48:45", "2026-01-05 04:48:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("30990", "10313", "action complete via WP Cron", "2026-01-05 04:48:45", "2026-01-05 04:48:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("30991", "10349", "action created", "2026-01-05 04:48:45", "2026-01-05 04:48:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("30992", "10314", "action started via WP Cron", "2026-01-05 04:48:45", "2026-01-05 04:48:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("30993", "10314", "action complete via WP Cron", "2026-01-05 04:48:45", "2026-01-05 04:48:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("30994", "10350", "action created", "2026-01-05 04:48:45", "2026-01-05 04:48:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("31001", "10317", "action started via WP Cron", "2026-01-05 04:48:46", "2026-01-05 04:48:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("31002", "10317", "action complete via WP Cron", "2026-01-05 04:48:46", "2026-01-05 04:48:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("31003", "10353", "action created", "2026-01-05 04:48:46", "2026-01-05 04:48:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("31070", "10341", "action started via WP Cron", "2026-01-06 05:13:39", "2026-01-06 05:13:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("31071", "10341", "action complete via WP Cron", "2026-01-06 05:13:39", "2026-01-06 05:13:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("31072", "10376", "action created", "2026-01-06 05:13:39", "2026-01-06 05:13:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("31073", "10342", "action started via WP Cron", "2026-01-06 05:13:39", "2026-01-06 05:13:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("31074", "10342", "action complete via WP Cron", "2026-01-06 05:13:39", "2026-01-06 05:13:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("31075", "10377", "action created", "2026-01-06 05:13:39", "2026-01-06 05:13:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("31076", "10343", "action started via WP Cron", "2026-01-06 05:13:39", "2026-01-06 05:13:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("31077", "10343", "action complete via WP Cron", "2026-01-06 05:13:39", "2026-01-06 05:13:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("31078", "10378", "action created", "2026-01-06 05:13:39", "2026-01-06 05:13:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("31082", "10345", "action started via WP Cron", "2026-01-06 05:13:39", "2026-01-06 05:13:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("31083", "10345", "action complete via WP Cron", "2026-01-06 05:13:39", "2026-01-06 05:13:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("31084", "10380", "action created", "2026-01-06 05:13:39", "2026-01-06 05:13:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("31085", "10346", "action started via WP Cron", "2026-01-06 05:13:39", "2026-01-06 05:13:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("31086", "10346", "action complete via WP Cron", "2026-01-06 05:13:39", "2026-01-06 05:13:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("31087", "10381", "action created", "2026-01-06 05:13:39", "2026-01-06 05:13:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("31088", "10347", "action started via WP Cron", "2026-01-06 05:13:39", "2026-01-06 05:13:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("31089", "10347", "action complete via WP Cron", "2026-01-06 05:13:39", "2026-01-06 05:13:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("31090", "10382", "action created", "2026-01-06 05:13:39", "2026-01-06 05:13:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("31091", "10348", "action started via WP Cron", "2026-01-06 05:13:39", "2026-01-06 05:13:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("31092", "10348", "action complete via WP Cron", "2026-01-06 05:13:39", "2026-01-06 05:13:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("31093", "10383", "action created", "2026-01-06 05:13:39", "2026-01-06 05:13:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("31094", "10349", "action started via WP Cron", "2026-01-06 05:13:39", "2026-01-06 05:13:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("31095", "10349", "action complete via WP Cron", "2026-01-06 05:13:39", "2026-01-06 05:13:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("31096", "10384", "action created", "2026-01-06 05:13:39", "2026-01-06 05:13:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("31097", "10350", "action started via WP Cron", "2026-01-06 05:13:39", "2026-01-06 05:13:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("31098", "10350", "action complete via WP Cron", "2026-01-06 05:13:39", "2026-01-06 05:13:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("31099", "10385", "action created", "2026-01-06 05:13:39", "2026-01-06 05:13:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("31109", "10353", "action started via WP Cron", "2026-01-06 05:13:39", "2026-01-06 05:13:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("31110", "10353", "action complete via WP Cron", "2026-01-06 05:13:39", "2026-01-06 05:13:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("31111", "10389", "action created", "2026-01-06 05:13:39", "2026-01-06 05:13:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("31184", "10376", "action started via WP Cron", "2026-01-07 05:35:35", "2026-01-07 05:35:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("31185", "10376", "action complete via WP Cron", "2026-01-07 05:35:35", "2026-01-07 05:35:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("31186", "10414", "action created", "2026-01-07 05:35:35", "2026-01-07 05:35:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("31187", "10377", "action started via WP Cron", "2026-01-07 05:35:35", "2026-01-07 05:35:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("31188", "10377", "action complete via WP Cron", "2026-01-07 05:35:35", "2026-01-07 05:35:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("31189", "10415", "action created", "2026-01-07 05:35:35", "2026-01-07 05:35:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("31190", "10378", "action started via WP Cron", "2026-01-07 05:35:35", "2026-01-07 05:35:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("31191", "10378", "action complete via WP Cron", "2026-01-07 05:35:35", "2026-01-07 05:35:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("31192", "10416", "action created", "2026-01-07 05:35:35", "2026-01-07 05:35:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("31196", "10380", "action started via WP Cron", "2026-01-07 05:35:35", "2026-01-07 05:35:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("31197", "10380", "action complete via WP Cron", "2026-01-07 05:35:35", "2026-01-07 05:35:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("31198", "10418", "action created", "2026-01-07 05:35:35", "2026-01-07 05:35:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("31199", "10381", "action started via WP Cron", "2026-01-07 05:35:35", "2026-01-07 05:35:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("31200", "10381", "action complete via WP Cron", "2026-01-07 05:35:35", "2026-01-07 05:35:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("31201", "10419", "action created", "2026-01-07 05:35:35", "2026-01-07 05:35:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("31202", "10382", "action started via WP Cron", "2026-01-07 05:35:35", "2026-01-07 05:35:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("31203", "10382", "action complete via WP Cron", "2026-01-07 05:35:35", "2026-01-07 05:35:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("31204", "10420", "action created", "2026-01-07 05:35:35", "2026-01-07 05:35:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("31205", "10383", "action started via WP Cron", "2026-01-07 05:35:35", "2026-01-07 05:35:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("31206", "10383", "action complete via WP Cron", "2026-01-07 05:35:35", "2026-01-07 05:35:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("31207", "10421", "action created", "2026-01-07 05:35:35", "2026-01-07 05:35:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("31208", "10384", "action started via WP Cron", "2026-01-07 05:35:35", "2026-01-07 05:35:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("31209", "10384", "action complete via WP Cron", "2026-01-07 05:35:35", "2026-01-07 05:35:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("31210", "10422", "action created", "2026-01-07 05:35:35", "2026-01-07 05:35:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("31211", "10385", "action started via WP Cron", "2026-01-07 05:35:35", "2026-01-07 05:35:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("31212", "10385", "action complete via WP Cron", "2026-01-07 05:35:35", "2026-01-07 05:35:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("31213", "10423", "action created", "2026-01-07 05:35:35", "2026-01-07 05:35:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("31220", "10389", "action started via WP Cron", "2026-01-07 05:35:35", "2026-01-07 05:35:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("31221", "10389", "action complete via WP Cron", "2026-01-07 05:35:35", "2026-01-07 05:35:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("31222", "10426", "action created", "2026-01-07 05:35:35", "2026-01-07 05:35:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("31286", "10414", "action started via WP Cron", "2026-01-08 05:43:16", "2026-01-08 05:43:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("31287", "10414", "action complete via WP Cron", "2026-01-08 05:43:16", "2026-01-08 05:43:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("31288", "10448", "action created", "2026-01-08 05:43:16", "2026-01-08 05:43:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("31289", "10415", "action started via WP Cron", "2026-01-08 05:43:16", "2026-01-08 05:43:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("31290", "10415", "action complete via WP Cron", "2026-01-08 05:43:16", "2026-01-08 05:43:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("31291", "10449", "action created", "2026-01-08 05:43:16", "2026-01-08 05:43:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("31292", "10416", "action started via WP Cron", "2026-01-08 05:43:16", "2026-01-08 05:43:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("31293", "10416", "action complete via WP Cron", "2026-01-08 05:43:16", "2026-01-08 05:43:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("31294", "10450", "action created", "2026-01-08 05:43:16", "2026-01-08 05:43:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("31298", "10418", "action started via WP Cron", "2026-01-08 05:43:16", "2026-01-08 05:43:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("31299", "10418", "action complete via WP Cron", "2026-01-08 05:43:16", "2026-01-08 05:43:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("31300", "10452", "action created", "2026-01-08 05:43:16", "2026-01-08 05:43:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("31301", "10419", "action started via WP Cron", "2026-01-08 05:43:16", "2026-01-08 05:43:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("31302", "10419", "action complete via WP Cron", "2026-01-08 05:43:16", "2026-01-08 05:43:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("31303", "10453", "action created", "2026-01-08 05:43:16", "2026-01-08 05:43:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("31304", "10420", "action started via WP Cron", "2026-01-08 05:43:16", "2026-01-08 05:43:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("31305", "10420", "action complete via WP Cron", "2026-01-08 05:43:16", "2026-01-08 05:43:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("31306", "10454", "action created", "2026-01-08 05:43:16", "2026-01-08 05:43:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("31307", "10421", "action started via WP Cron", "2026-01-08 05:43:16", "2026-01-08 05:43:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("31308", "10421", "action complete via WP Cron", "2026-01-08 05:43:16", "2026-01-08 05:43:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("31309", "10455", "action created", "2026-01-08 05:43:16", "2026-01-08 05:43:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("31310", "10422", "action started via WP Cron", "2026-01-08 05:43:16", "2026-01-08 05:43:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("31311", "10422", "action complete via WP Cron", "2026-01-08 05:43:16", "2026-01-08 05:43:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("31312", "10456", "action created", "2026-01-08 05:43:16", "2026-01-08 05:43:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("31313", "10423", "action started via WP Cron", "2026-01-08 05:43:16", "2026-01-08 05:43:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("31314", "10423", "action complete via WP Cron", "2026-01-08 05:43:16", "2026-01-08 05:43:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("31315", "10457", "action created", "2026-01-08 05:43:16", "2026-01-08 05:43:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("31322", "10426", "action started via WP Cron", "2026-01-08 05:43:16", "2026-01-08 05:43:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("31323", "10426", "action complete via WP Cron", "2026-01-08 05:43:16", "2026-01-08 05:43:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("31324", "10460", "action created", "2026-01-08 05:43:16", "2026-01-08 05:43:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("31364", "10231", "action started via WP Cron", "2026-01-08 19:43:42", "2026-01-08 19:43:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("31365", "10231", "action complete via WP Cron", "2026-01-08 19:43:42", "2026-01-08 19:43:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("31366", "10474", "action created", "2026-01-08 19:43:42", "2026-01-08 19:43:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("31406", "10448", "action started via WP Cron", "2026-01-09 07:47:59", "2026-01-09 07:47:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("31407", "10448", "action complete via WP Cron", "2026-01-09 07:47:59", "2026-01-09 07:47:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("31408", "10488", "action created", "2026-01-09 07:47:59", "2026-01-09 07:47:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("31409", "10449", "action started via WP Cron", "2026-01-09 07:47:59", "2026-01-09 07:47:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("31410", "10449", "action complete via WP Cron", "2026-01-09 07:47:59", "2026-01-09 07:47:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("31411", "10489", "action created", "2026-01-09 07:47:59", "2026-01-09 07:47:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("31412", "10450", "action started via WP Cron", "2026-01-09 07:47:59", "2026-01-09 07:47:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("31413", "10450", "action complete via WP Cron", "2026-01-09 07:47:59", "2026-01-09 07:47:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("31414", "10490", "action created", "2026-01-09 07:47:59", "2026-01-09 07:47:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("31418", "10452", "action started via WP Cron", "2026-01-09 07:47:59", "2026-01-09 07:47:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("31419", "10452", "action complete via WP Cron", "2026-01-09 07:47:59", "2026-01-09 07:47:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("31420", "10492", "action created", "2026-01-09 07:47:59", "2026-01-09 07:47:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("31421", "10453", "action started via WP Cron", "2026-01-09 07:47:59", "2026-01-09 07:47:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("31422", "10453", "action complete via WP Cron", "2026-01-09 07:47:59", "2026-01-09 07:47:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("31423", "10493", "action created", "2026-01-09 07:47:59", "2026-01-09 07:47:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("31424", "10454", "action started via WP Cron", "2026-01-09 07:47:59", "2026-01-09 07:47:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("31425", "10454", "action complete via WP Cron", "2026-01-09 07:47:59", "2026-01-09 07:47:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("31426", "10494", "action created", "2026-01-09 07:47:59", "2026-01-09 07:47:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("31427", "10455", "action started via WP Cron", "2026-01-09 07:47:59", "2026-01-09 07:47:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("31428", "10455", "action complete via WP Cron", "2026-01-09 07:47:59", "2026-01-09 07:47:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("31429", "10495", "action created", "2026-01-09 07:47:59", "2026-01-09 07:47:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("31430", "10456", "action started via WP Cron", "2026-01-09 07:47:59", "2026-01-09 07:47:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("31431", "10456", "action complete via WP Cron", "2026-01-09 07:47:59", "2026-01-09 07:47:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("31432", "10496", "action created", "2026-01-09 07:47:59", "2026-01-09 07:47:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("31433", "10457", "action started via WP Cron", "2026-01-09 07:47:59", "2026-01-09 07:47:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("31434", "10457", "action complete via WP Cron", "2026-01-09 07:47:59", "2026-01-09 07:47:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("31435", "10497", "action created", "2026-01-09 07:47:59", "2026-01-09 07:47:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("31442", "10460", "action started via WP Cron", "2026-01-09 07:48:00", "2026-01-09 07:48:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("31443", "10460", "action complete via WP Cron", "2026-01-09 07:48:00", "2026-01-09 07:48:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("31444", "10500", "action created", "2026-01-09 07:48:00", "2026-01-09 07:48:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("31502", "10264", "action started via WP Cron", "2026-01-10 04:20:50", "2026-01-10 04:20:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("31503", "10264", "action complete via WP Cron", "2026-01-10 04:20:50", "2026-01-10 04:20:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("31504", "10520", "action created", "2026-01-10 04:20:50", "2026-01-10 04:20:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("31517", "10488", "action started via WP Cron", "2026-01-10 08:24:28", "2026-01-10 08:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("31518", "10488", "action complete via WP Cron", "2026-01-10 08:24:28", "2026-01-10 08:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("31519", "10525", "action created", "2026-01-10 08:24:28", "2026-01-10 08:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("31520", "10489", "action started via WP Cron", "2026-01-10 08:24:28", "2026-01-10 08:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("31521", "10489", "action complete via WP Cron", "2026-01-10 08:24:28", "2026-01-10 08:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("31522", "10526", "action created", "2026-01-10 08:24:28", "2026-01-10 08:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("31523", "10490", "action started via WP Cron", "2026-01-10 08:24:28", "2026-01-10 08:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("31524", "10490", "action complete via WP Cron", "2026-01-10 08:24:28", "2026-01-10 08:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("31525", "10527", "action created", "2026-01-10 08:24:28", "2026-01-10 08:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("31529", "10492", "action started via WP Cron", "2026-01-10 08:24:28", "2026-01-10 08:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("31530", "10492", "action complete via WP Cron", "2026-01-10 08:24:28", "2026-01-10 08:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("31531", "10529", "action created", "2026-01-10 08:24:28", "2026-01-10 08:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("31532", "10493", "action started via WP Cron", "2026-01-10 08:24:28", "2026-01-10 08:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("31533", "10493", "action complete via WP Cron", "2026-01-10 08:24:28", "2026-01-10 08:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("31534", "10530", "action created", "2026-01-10 08:24:28", "2026-01-10 08:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("31535", "10494", "action started via WP Cron", "2026-01-10 08:24:28", "2026-01-10 08:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("31536", "10494", "action complete via WP Cron", "2026-01-10 08:24:28", "2026-01-10 08:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("31537", "10531", "action created", "2026-01-10 08:24:28", "2026-01-10 08:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("31538", "10495", "action started via WP Cron", "2026-01-10 08:24:28", "2026-01-10 08:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("31539", "10495", "action complete via WP Cron", "2026-01-10 08:24:28", "2026-01-10 08:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("31540", "10532", "action created", "2026-01-10 08:24:28", "2026-01-10 08:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("31541", "10496", "action started via WP Cron", "2026-01-10 08:24:28", "2026-01-10 08:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("31542", "10496", "action complete via WP Cron", "2026-01-10 08:24:28", "2026-01-10 08:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("31543", "10533", "action created", "2026-01-10 08:24:28", "2026-01-10 08:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("31544", "10497", "action started via WP Cron", "2026-01-10 08:24:28", "2026-01-10 08:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("31545", "10497", "action complete via WP Cron", "2026-01-10 08:24:28", "2026-01-10 08:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("31546", "10534", "action created", "2026-01-10 08:24:28", "2026-01-10 08:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("31553", "10500", "action started via WP Cron", "2026-01-10 08:24:29", "2026-01-10 08:24:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31554", "10500", "action complete via WP Cron", "2026-01-10 08:24:29", "2026-01-10 08:24:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31555", "10537", "action created", "2026-01-10 08:24:29", "2026-01-10 08:24:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31619", "10525", "action started via WP Cron", "2026-01-11 09:58:19", "2026-01-11 09:58:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31620", "10525", "action complete via WP Cron", "2026-01-11 09:58:19", "2026-01-11 09:58:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31621", "10559", "action created", "2026-01-11 09:58:19", "2026-01-11 09:58:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31622", "10526", "action started via WP Cron", "2026-01-11 09:58:19", "2026-01-11 09:58:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31623", "10526", "action complete via WP Cron", "2026-01-11 09:58:19", "2026-01-11 09:58:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31624", "10560", "action created", "2026-01-11 09:58:19", "2026-01-11 09:58:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31625", "10527", "action started via WP Cron", "2026-01-11 09:58:19", "2026-01-11 09:58:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31626", "10527", "action complete via WP Cron", "2026-01-11 09:58:19", "2026-01-11 09:58:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31627", "10561", "action created", "2026-01-11 09:58:19", "2026-01-11 09:58:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31631", "10529", "action started via WP Cron", "2026-01-11 09:58:19", "2026-01-11 09:58:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31632", "10529", "action complete via WP Cron", "2026-01-11 09:58:19", "2026-01-11 09:58:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31633", "10563", "action created", "2026-01-11 09:58:19", "2026-01-11 09:58:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31634", "10530", "action started via WP Cron", "2026-01-11 09:58:19", "2026-01-11 09:58:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31635", "10530", "action complete via WP Cron", "2026-01-11 09:58:19", "2026-01-11 09:58:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31636", "10564", "action created", "2026-01-11 09:58:19", "2026-01-11 09:58:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31637", "10531", "action started via WP Cron", "2026-01-11 09:58:19", "2026-01-11 09:58:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31638", "10531", "action complete via WP Cron", "2026-01-11 09:58:19", "2026-01-11 09:58:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31639", "10565", "action created", "2026-01-11 09:58:19", "2026-01-11 09:58:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31640", "10532", "action started via WP Cron", "2026-01-11 09:58:19", "2026-01-11 09:58:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31641", "10532", "action complete via WP Cron", "2026-01-11 09:58:19", "2026-01-11 09:58:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31642", "10566", "action created", "2026-01-11 09:58:19", "2026-01-11 09:58:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31643", "10533", "action started via WP Cron", "2026-01-11 09:58:19", "2026-01-11 09:58:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31644", "10533", "action complete via WP Cron", "2026-01-11 09:58:19", "2026-01-11 09:58:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31645", "10567", "action created", "2026-01-11 09:58:19", "2026-01-11 09:58:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31646", "10534", "action started via WP Cron", "2026-01-11 09:58:19", "2026-01-11 09:58:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31647", "10534", "action complete via WP Cron", "2026-01-11 09:58:19", "2026-01-11 09:58:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31648", "10568", "action created", "2026-01-11 09:58:19", "2026-01-11 09:58:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31655", "10537", "action started via WP Cron", "2026-01-11 09:58:19", "2026-01-11 09:58:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31656", "10537", "action complete via WP Cron", "2026-01-11 09:58:19", "2026-01-11 09:58:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31657", "10571", "action created", "2026-01-11 09:58:19", "2026-01-11 09:58:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31721", "10559", "action started via WP Cron", "2026-01-12 10:28:49", "2026-01-12 10:28:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("31722", "10559", "action complete via WP Cron", "2026-01-12 10:28:49", "2026-01-12 10:28:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("31723", "10593", "action created", "2026-01-12 10:28:49", "2026-01-12 10:28:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("31724", "10560", "action started via WP Cron", "2026-01-12 10:28:49", "2026-01-12 10:28:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("31725", "10560", "action complete via WP Cron", "2026-01-12 10:28:49", "2026-01-12 10:28:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("31726", "10594", "action created", "2026-01-12 10:28:49", "2026-01-12 10:28:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("31727", "10561", "action started via WP Cron", "2026-01-12 10:28:49", "2026-01-12 10:28:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("31728", "10561", "action complete via WP Cron", "2026-01-12 10:28:49", "2026-01-12 10:28:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("31729", "10595", "action created", "2026-01-12 10:28:49", "2026-01-12 10:28:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("31733", "10563", "action started via WP Cron", "2026-01-12 10:28:49", "2026-01-12 10:28:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("31734", "10563", "action complete via WP Cron", "2026-01-12 10:28:49", "2026-01-12 10:28:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("31735", "10597", "action created", "2026-01-12 10:28:49", "2026-01-12 10:28:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("31736", "10564", "action started via WP Cron", "2026-01-12 10:28:49", "2026-01-12 10:28:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("31737", "10564", "action complete via WP Cron", "2026-01-12 10:28:49", "2026-01-12 10:28:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("31738", "10598", "action created", "2026-01-12 10:28:49", "2026-01-12 10:28:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("31739", "10565", "action started via WP Cron", "2026-01-12 10:28:49", "2026-01-12 10:28:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("31740", "10565", "action complete via WP Cron", "2026-01-12 10:28:49", "2026-01-12 10:28:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("31741", "10599", "action created", "2026-01-12 10:28:49", "2026-01-12 10:28:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("31742", "10566", "action started via WP Cron", "2026-01-12 10:28:49", "2026-01-12 10:28:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("31743", "10566", "action complete via WP Cron", "2026-01-12 10:28:49", "2026-01-12 10:28:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("31744", "10600", "action created", "2026-01-12 10:28:49", "2026-01-12 10:28:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("31745", "10567", "action started via WP Cron", "2026-01-12 10:28:49", "2026-01-12 10:28:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("31746", "10567", "action complete via WP Cron", "2026-01-12 10:28:49", "2026-01-12 10:28:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("31747", "10601", "action created", "2026-01-12 10:28:49", "2026-01-12 10:28:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("31748", "10568", "action started via WP Cron", "2026-01-12 10:28:49", "2026-01-12 10:28:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("31749", "10568", "action complete via WP Cron", "2026-01-12 10:28:49", "2026-01-12 10:28:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("31750", "10602", "action created", "2026-01-12 10:28:49", "2026-01-12 10:28:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("31757", "10571", "action started via WP Cron", "2026-01-12 10:28:50", "2026-01-12 10:28:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("31758", "10571", "action complete via WP Cron", "2026-01-12 10:28:50", "2026-01-12 10:28:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("31759", "10605", "action created", "2026-01-12 10:28:50", "2026-01-12 10:28:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("31817", "10593", "action started via WP Cron", "2026-01-13 11:57:51", "2026-01-13 11:57:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("31818", "10593", "action complete via WP Cron", "2026-01-13 11:57:51", "2026-01-13 11:57:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("31819", "10625", "action created", "2026-01-13 11:57:51", "2026-01-13 11:57:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("31820", "10594", "action started via WP Cron", "2026-01-13 11:57:51", "2026-01-13 11:57:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("31821", "10594", "action complete via WP Cron", "2026-01-13 11:57:51", "2026-01-13 11:57:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("31822", "10626", "action created", "2026-01-13 11:57:51", "2026-01-13 11:57:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("31823", "10595", "action started via WP Cron", "2026-01-13 11:57:51", "2026-01-13 11:57:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("31824", "10595", "action complete via WP Cron", "2026-01-13 11:57:51", "2026-01-13 11:57:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("31825", "10627", "action created", "2026-01-13 11:57:51", "2026-01-13 11:57:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("31829", "10597", "action started via WP Cron", "2026-01-13 11:57:51", "2026-01-13 11:57:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("31830", "10597", "action complete via WP Cron", "2026-01-13 11:57:51", "2026-01-13 11:57:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("31831", "10629", "action created", "2026-01-13 11:57:51", "2026-01-13 11:57:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("31832", "10598", "action started via WP Cron", "2026-01-13 11:57:51", "2026-01-13 11:57:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("31833", "10598", "action complete via WP Cron", "2026-01-13 11:57:51", "2026-01-13 11:57:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("31834", "10630", "action created", "2026-01-13 11:57:51", "2026-01-13 11:57:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("31835", "10599", "action started via WP Cron", "2026-01-13 11:57:51", "2026-01-13 11:57:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("31836", "10599", "action complete via WP Cron", "2026-01-13 11:57:51", "2026-01-13 11:57:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("31837", "10631", "action created", "2026-01-13 11:57:51", "2026-01-13 11:57:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("31838", "10600", "action started via WP Cron", "2026-01-13 11:57:51", "2026-01-13 11:57:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("31839", "10600", "action complete via WP Cron", "2026-01-13 11:57:51", "2026-01-13 11:57:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("31840", "10632", "action created", "2026-01-13 11:57:51", "2026-01-13 11:57:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("31841", "10601", "action started via WP Cron", "2026-01-13 11:57:51", "2026-01-13 11:57:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("31842", "10601", "action complete via WP Cron", "2026-01-13 11:57:51", "2026-01-13 11:57:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("31843", "10633", "action created", "2026-01-13 11:57:51", "2026-01-13 11:57:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("31844", "10602", "action started via WP Cron", "2026-01-13 11:57:51", "2026-01-13 11:57:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("31845", "10602", "action complete via WP Cron", "2026-01-13 11:57:51", "2026-01-13 11:57:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("31846", "10634", "action created", "2026-01-13 11:57:51", "2026-01-13 11:57:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("31853", "10605", "action started via WP Cron", "2026-01-13 11:57:52", "2026-01-13 11:57:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("31854", "10605", "action complete via WP Cron", "2026-01-13 11:57:52", "2026-01-13 11:57:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("31855", "10637", "action created", "2026-01-13 11:57:52", "2026-01-13 11:57:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("31931", "10625", "action started via WP Cron", "2026-01-14 14:04:29", "2026-01-14 14:04:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31932", "10625", "action complete via WP Cron", "2026-01-14 14:04:29", "2026-01-14 14:04:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31933", "10663", "action created", "2026-01-14 14:04:29", "2026-01-14 14:04:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31934", "10626", "action started via WP Cron", "2026-01-14 14:04:29", "2026-01-14 14:04:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31935", "10626", "action complete via WP Cron", "2026-01-14 14:04:29", "2026-01-14 14:04:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31936", "10664", "action created", "2026-01-14 14:04:29", "2026-01-14 14:04:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31937", "10627", "action started via WP Cron", "2026-01-14 14:04:29", "2026-01-14 14:04:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31938", "10627", "action complete via WP Cron", "2026-01-14 14:04:29", "2026-01-14 14:04:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31939", "10665", "action created", "2026-01-14 14:04:29", "2026-01-14 14:04:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31943", "10629", "action started via WP Cron", "2026-01-14 14:04:29", "2026-01-14 14:04:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31944", "10629", "action complete via WP Cron", "2026-01-14 14:04:29", "2026-01-14 14:04:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31945", "10667", "action created", "2026-01-14 14:04:29", "2026-01-14 14:04:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31946", "10630", "action started via WP Cron", "2026-01-14 14:04:29", "2026-01-14 14:04:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31947", "10630", "action complete via WP Cron", "2026-01-14 14:04:29", "2026-01-14 14:04:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31948", "10668", "action created", "2026-01-14 14:04:29", "2026-01-14 14:04:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31949", "10631", "action started via WP Cron", "2026-01-14 14:04:29", "2026-01-14 14:04:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31950", "10631", "action complete via WP Cron", "2026-01-14 14:04:29", "2026-01-14 14:04:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31951", "10669", "action created", "2026-01-14 14:04:29", "2026-01-14 14:04:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31952", "10632", "action started via WP Cron", "2026-01-14 14:04:29", "2026-01-14 14:04:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31953", "10632", "action complete via WP Cron", "2026-01-14 14:04:29", "2026-01-14 14:04:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31954", "10670", "action created", "2026-01-14 14:04:29", "2026-01-14 14:04:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31955", "10633", "action started via WP Cron", "2026-01-14 14:04:29", "2026-01-14 14:04:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31956", "10633", "action complete via WP Cron", "2026-01-14 14:04:29", "2026-01-14 14:04:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31957", "10671", "action created", "2026-01-14 14:04:29", "2026-01-14 14:04:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31958", "10634", "action started via WP Cron", "2026-01-14 14:04:29", "2026-01-14 14:04:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31959", "10634", "action complete via WP Cron", "2026-01-14 14:04:29", "2026-01-14 14:04:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31960", "10672", "action created", "2026-01-14 14:04:29", "2026-01-14 14:04:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31967", "10637", "action started via WP Cron", "2026-01-14 14:04:29", "2026-01-14 14:04:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31968", "10637", "action complete via WP Cron", "2026-01-14 14:04:29", "2026-01-14 14:04:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31969", "10675", "action created", "2026-01-14 14:04:29", "2026-01-14 14:04:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("32039", "10663", "action started via WP Cron", "2026-01-15 14:38:49", "2026-01-15 14:38:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("32040", "10663", "action complete via WP Cron", "2026-01-15 14:38:49", "2026-01-15 14:38:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("32041", "10699", "action created", "2026-01-15 14:38:49", "2026-01-15 14:38:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("32042", "10664", "action started via WP Cron", "2026-01-15 14:38:49", "2026-01-15 14:38:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("32043", "10664", "action complete via WP Cron", "2026-01-15 14:38:49", "2026-01-15 14:38:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("32044", "10700", "action created", "2026-01-15 14:38:49", "2026-01-15 14:38:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("32045", "10665", "action started via WP Cron", "2026-01-15 14:38:49", "2026-01-15 14:38:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("32046", "10665", "action complete via WP Cron", "2026-01-15 14:38:49", "2026-01-15 14:38:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("32047", "10701", "action created", "2026-01-15 14:38:49", "2026-01-15 14:38:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("32051", "10667", "action started via WP Cron", "2026-01-15 14:38:49", "2026-01-15 14:38:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("32052", "10667", "action complete via WP Cron", "2026-01-15 14:38:49", "2026-01-15 14:38:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("32053", "10703", "action created", "2026-01-15 14:38:49", "2026-01-15 14:38:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("32054", "10668", "action started via WP Cron", "2026-01-15 14:38:49", "2026-01-15 14:38:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("32055", "10668", "action complete via WP Cron", "2026-01-15 14:38:49", "2026-01-15 14:38:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("32056", "10704", "action created", "2026-01-15 14:38:49", "2026-01-15 14:38:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("32057", "10669", "action started via WP Cron", "2026-01-15 14:38:49", "2026-01-15 14:38:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("32058", "10669", "action complete via WP Cron", "2026-01-15 14:38:49", "2026-01-15 14:38:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("32059", "10705", "action created", "2026-01-15 14:38:49", "2026-01-15 14:38:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("32060", "10670", "action started via WP Cron", "2026-01-15 14:38:49", "2026-01-15 14:38:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("32061", "10670", "action complete via WP Cron", "2026-01-15 14:38:49", "2026-01-15 14:38:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("32062", "10706", "action created", "2026-01-15 14:38:49", "2026-01-15 14:38:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("32063", "10671", "action started via WP Cron", "2026-01-15 14:38:49", "2026-01-15 14:38:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("32064", "10671", "action complete via WP Cron", "2026-01-15 14:38:49", "2026-01-15 14:38:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("32065", "10707", "action created", "2026-01-15 14:38:49", "2026-01-15 14:38:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("32066", "10672", "action started via WP Cron", "2026-01-15 14:38:49", "2026-01-15 14:38:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("32067", "10672", "action complete via WP Cron", "2026-01-15 14:38:49", "2026-01-15 14:38:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("32068", "10708", "action created", "2026-01-15 14:38:49", "2026-01-15 14:38:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("32075", "10675", "action started via WP Cron", "2026-01-15 14:38:50", "2026-01-15 14:38:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("32076", "10675", "action complete via WP Cron", "2026-01-15 14:38:50", "2026-01-15 14:38:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("32077", "10711", "action created", "2026-01-15 14:38:50", "2026-01-15 14:38:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("32096", "10474", "action started via WP Cron", "2026-01-15 19:52:02", "2026-01-15 19:52:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("32097", "10474", "action complete via WP Cron", "2026-01-15 19:52:02", "2026-01-15 19:52:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("32098", "10718", "action created", "2026-01-15 19:52:02", "2026-01-15 19:52:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("32129", "10699", "action started via WP Cron", "2026-01-16 14:42:33", "2026-01-16 14:42:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32130", "10699", "action complete via WP Cron", "2026-01-16 14:42:33", "2026-01-16 14:42:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32131", "10729", "action created", "2026-01-16 14:42:33", "2026-01-16 14:42:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32132", "10700", "action started via WP Cron", "2026-01-16 14:42:33", "2026-01-16 14:42:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32133", "10700", "action complete via WP Cron", "2026-01-16 14:42:33", "2026-01-16 14:42:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32134", "10730", "action created", "2026-01-16 14:42:33", "2026-01-16 14:42:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32135", "10701", "action started via WP Cron", "2026-01-16 14:42:33", "2026-01-16 14:42:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32136", "10701", "action complete via WP Cron", "2026-01-16 14:42:33", "2026-01-16 14:42:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32137", "10731", "action created", "2026-01-16 14:42:33", "2026-01-16 14:42:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32141", "10703", "action started via WP Cron", "2026-01-16 14:42:33", "2026-01-16 14:42:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32142", "10703", "action complete via WP Cron", "2026-01-16 14:42:33", "2026-01-16 14:42:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32143", "10733", "action created", "2026-01-16 14:42:33", "2026-01-16 14:42:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32144", "10704", "action started via WP Cron", "2026-01-16 14:42:33", "2026-01-16 14:42:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32145", "10704", "action complete via WP Cron", "2026-01-16 14:42:33", "2026-01-16 14:42:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32146", "10734", "action created", "2026-01-16 14:42:33", "2026-01-16 14:42:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32147", "10705", "action started via WP Cron", "2026-01-16 14:42:33", "2026-01-16 14:42:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32148", "10705", "action complete via WP Cron", "2026-01-16 14:42:33", "2026-01-16 14:42:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32149", "10735", "action created", "2026-01-16 14:42:33", "2026-01-16 14:42:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32150", "10706", "action started via WP Cron", "2026-01-16 14:42:33", "2026-01-16 14:42:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32151", "10706", "action complete via WP Cron", "2026-01-16 14:42:33", "2026-01-16 14:42:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32152", "10736", "action created", "2026-01-16 14:42:33", "2026-01-16 14:42:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32153", "10707", "action started via WP Cron", "2026-01-16 14:42:33", "2026-01-16 14:42:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32154", "10707", "action complete via WP Cron", "2026-01-16 14:42:33", "2026-01-16 14:42:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32155", "10737", "action created", "2026-01-16 14:42:33", "2026-01-16 14:42:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32156", "10708", "action started via WP Cron", "2026-01-16 14:42:33", "2026-01-16 14:42:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32157", "10708", "action complete via WP Cron", "2026-01-16 14:42:33", "2026-01-16 14:42:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32158", "10738", "action created", "2026-01-16 14:42:33", "2026-01-16 14:42:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32165", "10711", "action started via WP Cron", "2026-01-16 14:42:34", "2026-01-16 14:42:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("32166", "10711", "action complete via WP Cron", "2026-01-16 14:42:34", "2026-01-16 14:42:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("32167", "10741", "action created", "2026-01-16 14:42:34", "2026-01-16 14:42:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("32195", "10520", "action started via WP Cron", "2026-01-17 05:32:19", "2026-01-17 05:32:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("32196", "10520", "action complete via WP Cron", "2026-01-17 05:32:19", "2026-01-17 05:32:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("32197", "10751", "action created", "2026-01-17 05:32:19", "2026-01-17 05:32:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("32219", "10729", "action started via WP Cron", "2026-01-17 15:10:06", "2026-01-17 15:10:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("32220", "10729", "action complete via WP Cron", "2026-01-17 15:10:06", "2026-01-17 15:10:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("32221", "10759", "action created", "2026-01-17 15:10:06", "2026-01-17 15:10:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("32222", "10730", "action started via WP Cron", "2026-01-17 15:10:06", "2026-01-17 15:10:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("32223", "10730", "action complete via WP Cron", "2026-01-17 15:10:06", "2026-01-17 15:10:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("32224", "10760", "action created", "2026-01-17 15:10:06", "2026-01-17 15:10:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("32225", "10731", "action started via WP Cron", "2026-01-17 15:10:06", "2026-01-17 15:10:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("32226", "10731", "action complete via WP Cron", "2026-01-17 15:10:06", "2026-01-17 15:10:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("32227", "10761", "action created", "2026-01-17 15:10:06", "2026-01-17 15:10:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("32231", "10733", "action started via WP Cron", "2026-01-17 15:10:06", "2026-01-17 15:10:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("32232", "10733", "action complete via WP Cron", "2026-01-17 15:10:06", "2026-01-17 15:10:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("32233", "10763", "action created", "2026-01-17 15:10:06", "2026-01-17 15:10:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("32234", "10734", "action started via WP Cron", "2026-01-17 15:10:06", "2026-01-17 15:10:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("32235", "10734", "action complete via WP Cron", "2026-01-17 15:10:06", "2026-01-17 15:10:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("32236", "10764", "action created", "2026-01-17 15:10:06", "2026-01-17 15:10:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("32237", "10735", "action started via WP Cron", "2026-01-17 15:10:06", "2026-01-17 15:10:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("32238", "10735", "action complete via WP Cron", "2026-01-17 15:10:06", "2026-01-17 15:10:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("32239", "10765", "action created", "2026-01-17 15:10:06", "2026-01-17 15:10:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("32240", "10736", "action started via WP Cron", "2026-01-17 15:10:06", "2026-01-17 15:10:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("32241", "10736", "action complete via WP Cron", "2026-01-17 15:10:06", "2026-01-17 15:10:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("32242", "10766", "action created", "2026-01-17 15:10:06", "2026-01-17 15:10:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("32243", "10737", "action started via WP Cron", "2026-01-17 15:10:06", "2026-01-17 15:10:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("32244", "10737", "action complete via WP Cron", "2026-01-17 15:10:06", "2026-01-17 15:10:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("32245", "10767", "action created", "2026-01-17 15:10:06", "2026-01-17 15:10:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("32246", "10738", "action started via WP Cron", "2026-01-17 15:10:06", "2026-01-17 15:10:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("32247", "10738", "action complete via WP Cron", "2026-01-17 15:10:06", "2026-01-17 15:10:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("32248", "10768", "action created", "2026-01-17 15:10:06", "2026-01-17 15:10:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("32255", "10741", "action started via WP Cron", "2026-01-17 15:10:07", "2026-01-17 15:10:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("32256", "10741", "action complete via WP Cron", "2026-01-17 15:10:07", "2026-01-17 15:10:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("32257", "10771", "action created", "2026-01-17 15:10:07", "2026-01-17 15:10:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("32303", "10759", "action started via WP Cron", "2026-01-18 20:57:04", "2026-01-18 20:57:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("32304", "10759", "action complete via WP Cron", "2026-01-18 20:57:04", "2026-01-18 20:57:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("32305", "10787", "action created", "2026-01-18 20:57:04", "2026-01-18 20:57:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("32306", "10760", "action started via WP Cron", "2026-01-18 20:57:04", "2026-01-18 20:57:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("32307", "10760", "action complete via WP Cron", "2026-01-18 20:57:04", "2026-01-18 20:57:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("32308", "10788", "action created", "2026-01-18 20:57:04", "2026-01-18 20:57:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("32309", "10761", "action started via WP Cron", "2026-01-18 20:57:04", "2026-01-18 20:57:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("32310", "10761", "action complete via WP Cron", "2026-01-18 20:57:04", "2026-01-18 20:57:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("32311", "10789", "action created", "2026-01-18 20:57:04", "2026-01-18 20:57:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("32315", "10763", "action started via WP Cron", "2026-01-18 20:57:04", "2026-01-18 20:57:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("32316", "10763", "action complete via WP Cron", "2026-01-18 20:57:04", "2026-01-18 20:57:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("32317", "10791", "action created", "2026-01-18 20:57:04", "2026-01-18 20:57:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("32318", "10764", "action started via WP Cron", "2026-01-18 20:57:04", "2026-01-18 20:57:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("32319", "10764", "action complete via WP Cron", "2026-01-18 20:57:04", "2026-01-18 20:57:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("32320", "10792", "action created", "2026-01-18 20:57:04", "2026-01-18 20:57:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("32321", "10765", "action started via WP Cron", "2026-01-18 20:57:04", "2026-01-18 20:57:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("32322", "10765", "action complete via WP Cron", "2026-01-18 20:57:04", "2026-01-18 20:57:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("32323", "10793", "action created", "2026-01-18 20:57:04", "2026-01-18 20:57:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("32324", "10766", "action started via WP Cron", "2026-01-18 20:57:04", "2026-01-18 20:57:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("32325", "10766", "action complete via WP Cron", "2026-01-18 20:57:04", "2026-01-18 20:57:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("32326", "10794", "action created", "2026-01-18 20:57:04", "2026-01-18 20:57:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("32327", "10767", "action started via WP Cron", "2026-01-18 20:57:04", "2026-01-18 20:57:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("32328", "10767", "action complete via WP Cron", "2026-01-18 20:57:04", "2026-01-18 20:57:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("32329", "10795", "action created", "2026-01-18 20:57:04", "2026-01-18 20:57:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("32330", "10768", "action started via WP Cron", "2026-01-18 20:57:04", "2026-01-18 20:57:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("32331", "10768", "action complete via WP Cron", "2026-01-18 20:57:04", "2026-01-18 20:57:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("32332", "10796", "action created", "2026-01-18 20:57:04", "2026-01-18 20:57:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("32339", "10771", "action started via WP Cron", "2026-01-18 20:57:05", "2026-01-18 20:57:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("32340", "10771", "action complete via WP Cron", "2026-01-18 20:57:05", "2026-01-18 20:57:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("32341", "10799", "action created", "2026-01-18 20:57:05", "2026-01-18 20:57:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("32378", "10787", "action started via WP Cron", "2026-01-19 20:59:21", "2026-01-19 20:59:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("32379", "10787", "action complete via WP Cron", "2026-01-19 20:59:21", "2026-01-19 20:59:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("32380", "10812", "action created", "2026-01-19 20:59:21", "2026-01-19 20:59:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("32381", "10788", "action started via WP Cron", "2026-01-19 20:59:21", "2026-01-19 20:59:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("32382", "10788", "action complete via WP Cron", "2026-01-19 20:59:21", "2026-01-19 20:59:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("32383", "10813", "action created", "2026-01-19 20:59:21", "2026-01-19 20:59:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("32384", "10789", "action started via WP Cron", "2026-01-19 20:59:21", "2026-01-19 20:59:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("32385", "10789", "action complete via WP Cron", "2026-01-19 20:59:21", "2026-01-19 20:59:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("32386", "10814", "action created", "2026-01-19 20:59:21", "2026-01-19 20:59:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("32390", "10791", "action started via WP Cron", "2026-01-19 20:59:21", "2026-01-19 20:59:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("32391", "10791", "action complete via WP Cron", "2026-01-19 20:59:21", "2026-01-19 20:59:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("32392", "10816", "action created", "2026-01-19 20:59:21", "2026-01-19 20:59:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("32393", "10792", "action started via WP Cron", "2026-01-19 20:59:21", "2026-01-19 20:59:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("32394", "10792", "action complete via WP Cron", "2026-01-19 20:59:21", "2026-01-19 20:59:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("32395", "10817", "action created", "2026-01-19 20:59:21", "2026-01-19 20:59:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("32396", "10793", "action started via WP Cron", "2026-01-19 20:59:21", "2026-01-19 20:59:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("32397", "10793", "action complete via WP Cron", "2026-01-19 20:59:21", "2026-01-19 20:59:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("32398", "10818", "action created", "2026-01-19 20:59:21", "2026-01-19 20:59:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("32399", "10794", "action started via WP Cron", "2026-01-19 20:59:21", "2026-01-19 20:59:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("32400", "10794", "action complete via WP Cron", "2026-01-19 20:59:21", "2026-01-19 20:59:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("32401", "10819", "action created", "2026-01-19 20:59:21", "2026-01-19 20:59:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("32402", "10795", "action started via WP Cron", "2026-01-19 20:59:21", "2026-01-19 20:59:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("32403", "10795", "action complete via WP Cron", "2026-01-19 20:59:21", "2026-01-19 20:59:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("32404", "10820", "action created", "2026-01-19 20:59:21", "2026-01-19 20:59:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("32405", "10796", "action started via WP Cron", "2026-01-19 20:59:21", "2026-01-19 20:59:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("32406", "10796", "action complete via WP Cron", "2026-01-19 20:59:21", "2026-01-19 20:59:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("32407", "10821", "action created", "2026-01-19 20:59:21", "2026-01-19 20:59:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("32414", "10799", "action started via WP Cron", "2026-01-19 20:59:21", "2026-01-19 20:59:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("32415", "10799", "action complete via WP Cron", "2026-01-19 20:59:21", "2026-01-19 20:59:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("32416", "10824", "action created", "2026-01-19 20:59:21", "2026-01-19 20:59:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("32474", "10812", "action started via WP Cron", "2026-01-20 21:55:33", "2026-01-20 21:55:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32475", "10812", "action complete via WP Cron", "2026-01-20 21:55:33", "2026-01-20 21:55:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32476", "10844", "action created", "2026-01-20 21:55:33", "2026-01-20 21:55:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32477", "10813", "action started via WP Cron", "2026-01-20 21:55:33", "2026-01-20 21:55:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32478", "10813", "action complete via WP Cron", "2026-01-20 21:55:33", "2026-01-20 21:55:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32479", "10845", "action created", "2026-01-20 21:55:33", "2026-01-20 21:55:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32480", "10814", "action started via WP Cron", "2026-01-20 21:55:33", "2026-01-20 21:55:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32481", "10814", "action complete via WP Cron", "2026-01-20 21:55:33", "2026-01-20 21:55:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32482", "10846", "action created", "2026-01-20 21:55:33", "2026-01-20 21:55:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32486", "10816", "action started via WP Cron", "2026-01-20 21:55:33", "2026-01-20 21:55:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32487", "10816", "action complete via WP Cron", "2026-01-20 21:55:33", "2026-01-20 21:55:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32488", "10848", "action created", "2026-01-20 21:55:33", "2026-01-20 21:55:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32489", "10817", "action started via WP Cron", "2026-01-20 21:55:33", "2026-01-20 21:55:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32490", "10817", "action complete via WP Cron", "2026-01-20 21:55:33", "2026-01-20 21:55:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32491", "10849", "action created", "2026-01-20 21:55:33", "2026-01-20 21:55:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32492", "10818", "action started via WP Cron", "2026-01-20 21:55:33", "2026-01-20 21:55:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32493", "10818", "action complete via WP Cron", "2026-01-20 21:55:33", "2026-01-20 21:55:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32494", "10850", "action created", "2026-01-20 21:55:33", "2026-01-20 21:55:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32495", "10819", "action started via WP Cron", "2026-01-20 21:55:33", "2026-01-20 21:55:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32496", "10819", "action complete via WP Cron", "2026-01-20 21:55:33", "2026-01-20 21:55:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32497", "10851", "action created", "2026-01-20 21:55:33", "2026-01-20 21:55:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32498", "10820", "action started via WP Cron", "2026-01-20 21:55:33", "2026-01-20 21:55:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32499", "10820", "action complete via WP Cron", "2026-01-20 21:55:33", "2026-01-20 21:55:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32500", "10852", "action created", "2026-01-20 21:55:33", "2026-01-20 21:55:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32501", "10821", "action started via WP Cron", "2026-01-20 21:55:33", "2026-01-20 21:55:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32502", "10821", "action complete via WP Cron", "2026-01-20 21:55:33", "2026-01-20 21:55:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32503", "10853", "action created", "2026-01-20 21:55:33", "2026-01-20 21:55:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32510", "10824", "action started via WP Cron", "2026-01-20 21:55:33", "2026-01-20 21:55:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32511", "10824", "action complete via WP Cron", "2026-01-20 21:55:33", "2026-01-20 21:55:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32512", "10856", "action created", "2026-01-20 21:55:33", "2026-01-20 21:55:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("32576", "10844", "action started via WP Cron", "2026-01-21 22:42:13", "2026-01-21 22:42:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("32577", "10844", "action complete via WP Cron", "2026-01-21 22:42:13", "2026-01-21 22:42:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("32578", "10878", "action created", "2026-01-21 22:42:13", "2026-01-21 22:42:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("32579", "10845", "action started via WP Cron", "2026-01-21 22:42:13", "2026-01-21 22:42:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("32580", "10845", "action complete via WP Cron", "2026-01-21 22:42:13", "2026-01-21 22:42:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("32581", "10879", "action created", "2026-01-21 22:42:13", "2026-01-21 22:42:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("32582", "10846", "action started via WP Cron", "2026-01-21 22:42:13", "2026-01-21 22:42:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("32583", "10846", "action complete via WP Cron", "2026-01-21 22:42:13", "2026-01-21 22:42:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("32584", "10880", "action created", "2026-01-21 22:42:13", "2026-01-21 22:42:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("32588", "10848", "action started via WP Cron", "2026-01-21 22:42:13", "2026-01-21 22:42:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("32589", "10848", "action complete via WP Cron", "2026-01-21 22:42:13", "2026-01-21 22:42:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("32590", "10882", "action created", "2026-01-21 22:42:13", "2026-01-21 22:42:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("32591", "10849", "action started via WP Cron", "2026-01-21 22:42:13", "2026-01-21 22:42:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("32592", "10849", "action complete via WP Cron", "2026-01-21 22:42:13", "2026-01-21 22:42:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("32593", "10883", "action created", "2026-01-21 22:42:13", "2026-01-21 22:42:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("32594", "10850", "action started via WP Cron", "2026-01-21 22:42:13", "2026-01-21 22:42:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("32595", "10850", "action complete via WP Cron", "2026-01-21 22:42:13", "2026-01-21 22:42:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("32596", "10884", "action created", "2026-01-21 22:42:13", "2026-01-21 22:42:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("32597", "10851", "action started via WP Cron", "2026-01-21 22:42:13", "2026-01-21 22:42:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("32598", "10851", "action complete via WP Cron", "2026-01-21 22:42:13", "2026-01-21 22:42:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("32599", "10885", "action created", "2026-01-21 22:42:13", "2026-01-21 22:42:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("32600", "10852", "action started via WP Cron", "2026-01-21 22:42:13", "2026-01-21 22:42:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("32601", "10852", "action complete via WP Cron", "2026-01-21 22:42:13", "2026-01-21 22:42:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("32602", "10886", "action created", "2026-01-21 22:42:13", "2026-01-21 22:42:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("32603", "10853", "action started via WP Cron", "2026-01-21 22:42:13", "2026-01-21 22:42:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("32604", "10853", "action complete via WP Cron", "2026-01-21 22:42:13", "2026-01-21 22:42:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("32605", "10887", "action created", "2026-01-21 22:42:13", "2026-01-21 22:42:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("32612", "10856", "action started via WP Cron", "2026-01-21 22:42:14", "2026-01-21 22:42:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("32613", "10856", "action complete via WP Cron", "2026-01-21 22:42:14", "2026-01-21 22:42:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("32614", "10890", "action created", "2026-01-21 22:42:14", "2026-01-21 22:42:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("32681", "10718", "action started via WP Cron", "2026-01-22 19:53:22", "2026-01-22 19:53:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("32682", "10718", "action complete via WP Cron", "2026-01-22 19:53:22", "2026-01-22 19:53:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("32683", "10913", "action created", "2026-01-22 19:53:22", "2026-01-22 19:53:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("32693", "10878", "action started via WP Cron", "2026-01-22 23:39:47", "2026-01-22 23:39:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32694", "10878", "action complete via WP Cron", "2026-01-22 23:39:47", "2026-01-22 23:39:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32695", "10917", "action created", "2026-01-22 23:39:47", "2026-01-22 23:39:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32696", "10879", "action started via WP Cron", "2026-01-22 23:39:47", "2026-01-22 23:39:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32697", "10879", "action complete via WP Cron", "2026-01-22 23:39:47", "2026-01-22 23:39:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32698", "10918", "action created", "2026-01-22 23:39:47", "2026-01-22 23:39:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32699", "10880", "action started via WP Cron", "2026-01-22 23:39:47", "2026-01-22 23:39:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32700", "10880", "action complete via WP Cron", "2026-01-22 23:39:47", "2026-01-22 23:39:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32701", "10919", "action created", "2026-01-22 23:39:47", "2026-01-22 23:39:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32705", "10882", "action started via WP Cron", "2026-01-22 23:39:47", "2026-01-22 23:39:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32706", "10882", "action complete via WP Cron", "2026-01-22 23:39:47", "2026-01-22 23:39:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32707", "10921", "action created", "2026-01-22 23:39:47", "2026-01-22 23:39:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32708", "10883", "action started via WP Cron", "2026-01-22 23:39:47", "2026-01-22 23:39:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32709", "10883", "action complete via WP Cron", "2026-01-22 23:39:47", "2026-01-22 23:39:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32710", "10922", "action created", "2026-01-22 23:39:47", "2026-01-22 23:39:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32711", "10884", "action started via WP Cron", "2026-01-22 23:39:47", "2026-01-22 23:39:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32712", "10884", "action complete via WP Cron", "2026-01-22 23:39:47", "2026-01-22 23:39:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32713", "10923", "action created", "2026-01-22 23:39:47", "2026-01-22 23:39:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32714", "10885", "action started via WP Cron", "2026-01-22 23:39:47", "2026-01-22 23:39:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32715", "10885", "action complete via WP Cron", "2026-01-22 23:39:47", "2026-01-22 23:39:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32716", "10924", "action created", "2026-01-22 23:39:47", "2026-01-22 23:39:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32717", "10886", "action started via WP Cron", "2026-01-22 23:39:47", "2026-01-22 23:39:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32718", "10886", "action complete via WP Cron", "2026-01-22 23:39:47", "2026-01-22 23:39:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32719", "10925", "action created", "2026-01-22 23:39:47", "2026-01-22 23:39:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32720", "10887", "action started via WP Cron", "2026-01-22 23:39:47", "2026-01-22 23:39:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32721", "10887", "action complete via WP Cron", "2026-01-22 23:39:47", "2026-01-22 23:39:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32722", "10926", "action created", "2026-01-22 23:39:47", "2026-01-22 23:39:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32729", "10890", "action started via WP Cron", "2026-01-22 23:39:48", "2026-01-22 23:39:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("32730", "10890", "action complete via WP Cron", "2026-01-22 23:39:48", "2026-01-22 23:39:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("32731", "10929", "action created", "2026-01-22 23:39:48", "2026-01-22 23:39:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("32804", "10917", "action started via WP Cron", "2026-01-24 01:31:47", "2026-01-24 01:31:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32805", "10917", "action complete via WP Cron", "2026-01-24 01:31:47", "2026-01-24 01:31:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32806", "10954", "action created", "2026-01-24 01:31:47", "2026-01-24 01:31:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32807", "10918", "action started via WP Cron", "2026-01-24 01:31:47", "2026-01-24 01:31:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32808", "10918", "action complete via WP Cron", "2026-01-24 01:31:47", "2026-01-24 01:31:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32809", "10955", "action created", "2026-01-24 01:31:47", "2026-01-24 01:31:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32810", "10919", "action started via WP Cron", "2026-01-24 01:31:47", "2026-01-24 01:31:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32811", "10919", "action complete via WP Cron", "2026-01-24 01:31:47", "2026-01-24 01:31:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32812", "10956", "action created", "2026-01-24 01:31:47", "2026-01-24 01:31:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32816", "10921", "action started via WP Cron", "2026-01-24 01:31:47", "2026-01-24 01:31:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32817", "10921", "action complete via WP Cron", "2026-01-24 01:31:47", "2026-01-24 01:31:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32818", "10958", "action created", "2026-01-24 01:31:47", "2026-01-24 01:31:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32819", "10922", "action started via WP Cron", "2026-01-24 01:31:47", "2026-01-24 01:31:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32820", "10922", "action complete via WP Cron", "2026-01-24 01:31:47", "2026-01-24 01:31:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32821", "10959", "action created", "2026-01-24 01:31:47", "2026-01-24 01:31:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32822", "10923", "action started via WP Cron", "2026-01-24 01:31:47", "2026-01-24 01:31:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32823", "10923", "action complete via WP Cron", "2026-01-24 01:31:47", "2026-01-24 01:31:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32824", "10960", "action created", "2026-01-24 01:31:47", "2026-01-24 01:31:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32825", "10924", "action started via WP Cron", "2026-01-24 01:31:47", "2026-01-24 01:31:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32826", "10924", "action complete via WP Cron", "2026-01-24 01:31:47", "2026-01-24 01:31:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32827", "10961", "action created", "2026-01-24 01:31:47", "2026-01-24 01:31:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32828", "10925", "action started via WP Cron", "2026-01-24 01:31:47", "2026-01-24 01:31:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32829", "10925", "action complete via WP Cron", "2026-01-24 01:31:47", "2026-01-24 01:31:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32830", "10962", "action created", "2026-01-24 01:31:47", "2026-01-24 01:31:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32831", "10926", "action started via WP Cron", "2026-01-24 01:31:47", "2026-01-24 01:31:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32832", "10926", "action complete via WP Cron", "2026-01-24 01:31:47", "2026-01-24 01:31:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32833", "10963", "action created", "2026-01-24 01:31:47", "2026-01-24 01:31:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32843", "10929", "action started via WP Cron", "2026-01-24 01:31:47", "2026-01-24 01:31:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32844", "10929", "action complete via WP Cron", "2026-01-24 01:31:47", "2026-01-24 01:31:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32845", "10967", "action created", "2026-01-24 01:31:47", "2026-01-24 01:31:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("32855", "10751", "action started via WP Cron", "2026-01-24 06:12:31", "2026-01-24 06:12:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("32856", "10751", "action complete via WP Cron", "2026-01-24 06:12:31", "2026-01-24 06:12:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("32857", "10971", "action created", "2026-01-24 06:12:31", "2026-01-24 06:12:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("32909", "10954", "action started via WP Cron", "2026-01-25 02:46:24", "2026-01-25 02:46:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("32910", "10954", "action complete via WP Cron", "2026-01-25 02:46:24", "2026-01-25 02:46:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("32911", "10989", "action created", "2026-01-25 02:46:24", "2026-01-25 02:46:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("32912", "10955", "action started via WP Cron", "2026-01-25 02:46:24", "2026-01-25 02:46:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("32913", "10955", "action complete via WP Cron", "2026-01-25 02:46:24", "2026-01-25 02:46:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("32914", "10990", "action created", "2026-01-25 02:46:24", "2026-01-25 02:46:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("32915", "10956", "action started via WP Cron", "2026-01-25 02:46:24", "2026-01-25 02:46:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("32916", "10956", "action complete via WP Cron", "2026-01-25 02:46:24", "2026-01-25 02:46:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("32917", "10991", "action created", "2026-01-25 02:46:24", "2026-01-25 02:46:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("32921", "10958", "action started via WP Cron", "2026-01-25 02:46:24", "2026-01-25 02:46:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("32922", "10958", "action complete via WP Cron", "2026-01-25 02:46:24", "2026-01-25 02:46:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("32923", "10993", "action created", "2026-01-25 02:46:24", "2026-01-25 02:46:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("32924", "10959", "action started via WP Cron", "2026-01-25 02:46:24", "2026-01-25 02:46:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("32925", "10959", "action complete via WP Cron", "2026-01-25 02:46:24", "2026-01-25 02:46:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("32926", "10994", "action created", "2026-01-25 02:46:24", "2026-01-25 02:46:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("32927", "10960", "action started via WP Cron", "2026-01-25 02:46:24", "2026-01-25 02:46:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("32928", "10960", "action complete via WP Cron", "2026-01-25 02:46:24", "2026-01-25 02:46:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("32929", "10995", "action created", "2026-01-25 02:46:24", "2026-01-25 02:46:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("32930", "10961", "action started via WP Cron", "2026-01-25 02:46:24", "2026-01-25 02:46:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("32931", "10961", "action complete via WP Cron", "2026-01-25 02:46:24", "2026-01-25 02:46:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("32932", "10996", "action created", "2026-01-25 02:46:24", "2026-01-25 02:46:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("32933", "10962", "action started via WP Cron", "2026-01-25 02:46:24", "2026-01-25 02:46:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("32934", "10962", "action complete via WP Cron", "2026-01-25 02:46:24", "2026-01-25 02:46:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("32935", "10997", "action created", "2026-01-25 02:46:24", "2026-01-25 02:46:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("32936", "10963", "action started via WP Cron", "2026-01-25 02:46:24", "2026-01-25 02:46:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("32937", "10963", "action complete via WP Cron", "2026-01-25 02:46:24", "2026-01-25 02:46:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("32938", "10998", "action created", "2026-01-25 02:46:24", "2026-01-25 02:46:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("32945", "10967", "action started via WP Cron", "2026-01-25 02:46:25", "2026-01-25 02:46:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("32946", "10967", "action complete via WP Cron", "2026-01-25 02:46:25", "2026-01-25 02:46:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("32947", "11001", "action created", "2026-01-25 02:46:25", "2026-01-25 02:46:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("33002", "10989", "action started via WP Cron", "2026-01-26 05:02:19", "2026-01-26 05:02:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("33003", "10989", "action complete via WP Cron", "2026-01-26 05:02:19", "2026-01-26 05:02:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("33004", "11020", "action created", "2026-01-26 05:02:19", "2026-01-26 05:02:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("33005", "10990", "action started via WP Cron", "2026-01-26 05:02:19", "2026-01-26 05:02:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("33006", "10990", "action complete via WP Cron", "2026-01-26 05:02:19", "2026-01-26 05:02:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("33007", "11021", "action created", "2026-01-26 05:02:19", "2026-01-26 05:02:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("33008", "10991", "action started via WP Cron", "2026-01-26 05:02:19", "2026-01-26 05:02:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("33009", "10991", "action complete via WP Cron", "2026-01-26 05:02:19", "2026-01-26 05:02:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("33010", "11022", "action created", "2026-01-26 05:02:19", "2026-01-26 05:02:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("33014", "10993", "action started via WP Cron", "2026-01-26 05:02:19", "2026-01-26 05:02:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("33015", "10993", "action complete via WP Cron", "2026-01-26 05:02:19", "2026-01-26 05:02:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("33016", "11024", "action created", "2026-01-26 05:02:19", "2026-01-26 05:02:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("33017", "10994", "action started via WP Cron", "2026-01-26 05:02:19", "2026-01-26 05:02:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("33018", "10994", "action complete via WP Cron", "2026-01-26 05:02:19", "2026-01-26 05:02:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("33019", "11025", "action created", "2026-01-26 05:02:19", "2026-01-26 05:02:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("33020", "10995", "action started via WP Cron", "2026-01-26 05:02:19", "2026-01-26 05:02:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("33021", "10995", "action complete via WP Cron", "2026-01-26 05:02:19", "2026-01-26 05:02:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("33022", "11026", "action created", "2026-01-26 05:02:19", "2026-01-26 05:02:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("33023", "10996", "action started via WP Cron", "2026-01-26 05:02:19", "2026-01-26 05:02:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("33024", "10996", "action complete via WP Cron", "2026-01-26 05:02:19", "2026-01-26 05:02:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("33025", "11027", "action created", "2026-01-26 05:02:19", "2026-01-26 05:02:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("33026", "10997", "action started via WP Cron", "2026-01-26 05:02:19", "2026-01-26 05:02:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("33027", "10997", "action complete via WP Cron", "2026-01-26 05:02:19", "2026-01-26 05:02:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("33028", "11028", "action created", "2026-01-26 05:02:19", "2026-01-26 05:02:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("33029", "10998", "action started via WP Cron", "2026-01-26 05:02:19", "2026-01-26 05:02:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("33030", "10998", "action complete via WP Cron", "2026-01-26 05:02:19", "2026-01-26 05:02:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("33031", "11029", "action created", "2026-01-26 05:02:19", "2026-01-26 05:02:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("33038", "11001", "action started via WP Cron", "2026-01-26 05:02:20", "2026-01-26 05:02:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("33039", "11001", "action complete via WP Cron", "2026-01-26 05:02:20", "2026-01-26 05:02:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("33040", "11032", "action created", "2026-01-26 05:02:20", "2026-01-26 05:02:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("33104", "11020", "action started via WP Cron", "2026-01-27 05:45:18", "2026-01-27 05:45:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("33105", "11020", "action complete via WP Cron", "2026-01-27 05:45:18", "2026-01-27 05:45:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("33106", "11054", "action created", "2026-01-27 05:45:18", "2026-01-27 05:45:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("33107", "11021", "action started via WP Cron", "2026-01-27 05:45:18", "2026-01-27 05:45:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("33108", "11021", "action complete via WP Cron", "2026-01-27 05:45:18", "2026-01-27 05:45:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("33109", "11055", "action created", "2026-01-27 05:45:18", "2026-01-27 05:45:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("33110", "11022", "action started via WP Cron", "2026-01-27 05:45:18", "2026-01-27 05:45:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("33111", "11022", "action complete via WP Cron", "2026-01-27 05:45:18", "2026-01-27 05:45:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("33112", "11056", "action created", "2026-01-27 05:45:18", "2026-01-27 05:45:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("33116", "11024", "action started via WP Cron", "2026-01-27 05:45:18", "2026-01-27 05:45:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("33117", "11024", "action complete via WP Cron", "2026-01-27 05:45:18", "2026-01-27 05:45:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("33118", "11058", "action created", "2026-01-27 05:45:18", "2026-01-27 05:45:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("33119", "11025", "action started via WP Cron", "2026-01-27 05:45:18", "2026-01-27 05:45:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("33120", "11025", "action complete via WP Cron", "2026-01-27 05:45:18", "2026-01-27 05:45:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("33121", "11059", "action created", "2026-01-27 05:45:18", "2026-01-27 05:45:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("33122", "11026", "action started via WP Cron", "2026-01-27 05:45:18", "2026-01-27 05:45:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("33123", "11026", "action complete via WP Cron", "2026-01-27 05:45:18", "2026-01-27 05:45:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("33124", "11060", "action created", "2026-01-27 05:45:18", "2026-01-27 05:45:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("33125", "11027", "action started via WP Cron", "2026-01-27 05:45:18", "2026-01-27 05:45:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("33126", "11027", "action complete via WP Cron", "2026-01-27 05:45:18", "2026-01-27 05:45:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("33127", "11061", "action created", "2026-01-27 05:45:18", "2026-01-27 05:45:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("33128", "11028", "action started via WP Cron", "2026-01-27 05:45:18", "2026-01-27 05:45:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("33129", "11028", "action complete via WP Cron", "2026-01-27 05:45:18", "2026-01-27 05:45:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("33130", "11062", "action created", "2026-01-27 05:45:18", "2026-01-27 05:45:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("33131", "11029", "action started via WP Cron", "2026-01-27 05:45:18", "2026-01-27 05:45:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("33132", "11029", "action complete via WP Cron", "2026-01-27 05:45:18", "2026-01-27 05:45:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("33133", "11063", "action created", "2026-01-27 05:45:18", "2026-01-27 05:45:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("33140", "11032", "action started via WP Cron", "2026-01-27 05:45:18", "2026-01-27 05:45:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("33141", "11032", "action complete via WP Cron", "2026-01-27 05:45:18", "2026-01-27 05:45:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("33142", "11066", "action created", "2026-01-27 05:45:18", "2026-01-27 05:45:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("33169", "11075", "action created", "2026-01-27 21:05:12", "2026-01-27 21:05:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("33206", "11054", "action started via WP Cron", "2026-01-28 06:06:42", "2026-01-28 06:06:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("33207", "11054", "action complete via WP Cron", "2026-01-28 06:06:42", "2026-01-28 06:06:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("33208", "11088", "action created", "2026-01-28 06:06:42", "2026-01-28 06:06:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("33209", "11055", "action started via WP Cron", "2026-01-28 06:06:42", "2026-01-28 06:06:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("33210", "11055", "action complete via WP Cron", "2026-01-28 06:06:42", "2026-01-28 06:06:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("33211", "11089", "action created", "2026-01-28 06:06:42", "2026-01-28 06:06:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("33212", "11056", "action started via WP Cron", "2026-01-28 06:06:42", "2026-01-28 06:06:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("33213", "11056", "action complete via WP Cron", "2026-01-28 06:06:42", "2026-01-28 06:06:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("33214", "11090", "action created", "2026-01-28 06:06:42", "2026-01-28 06:06:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("33218", "11058", "action started via WP Cron", "2026-01-28 06:06:42", "2026-01-28 06:06:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("33219", "11058", "action complete via WP Cron", "2026-01-28 06:06:42", "2026-01-28 06:06:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("33220", "11092", "action created", "2026-01-28 06:06:42", "2026-01-28 06:06:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("33221", "11059", "action started via WP Cron", "2026-01-28 06:06:42", "2026-01-28 06:06:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("33222", "11059", "action complete via WP Cron", "2026-01-28 06:06:42", "2026-01-28 06:06:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("33223", "11093", "action created", "2026-01-28 06:06:42", "2026-01-28 06:06:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("33224", "11060", "action started via WP Cron", "2026-01-28 06:06:42", "2026-01-28 06:06:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("33225", "11060", "action complete via WP Cron", "2026-01-28 06:06:42", "2026-01-28 06:06:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("33226", "11094", "action created", "2026-01-28 06:06:42", "2026-01-28 06:06:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("33227", "11061", "action started via WP Cron", "2026-01-28 06:06:42", "2026-01-28 06:06:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("33228", "11061", "action complete via WP Cron", "2026-01-28 06:06:42", "2026-01-28 06:06:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("33229", "11095", "action created", "2026-01-28 06:06:42", "2026-01-28 06:06:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("33230", "11062", "action started via WP Cron", "2026-01-28 06:06:42", "2026-01-28 06:06:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("33231", "11062", "action complete via WP Cron", "2026-01-28 06:06:42", "2026-01-28 06:06:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("33232", "11096", "action created", "2026-01-28 06:06:42", "2026-01-28 06:06:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("33233", "11063", "action started via WP Cron", "2026-01-28 06:06:42", "2026-01-28 06:06:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("33234", "11063", "action complete via WP Cron", "2026-01-28 06:06:42", "2026-01-28 06:06:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("33235", "11097", "action created", "2026-01-28 06:06:42", "2026-01-28 06:06:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("33242", "11066", "action started via WP Cron", "2026-01-28 06:06:43", "2026-01-28 06:06:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("33243", "11066", "action complete via WP Cron", "2026-01-28 06:06:43", "2026-01-28 06:06:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("33244", "11100", "action created", "2026-01-28 06:06:43", "2026-01-28 06:06:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("33286", "11114", "action created", "2026-01-28 20:17:44", "2026-01-28 20:17:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("33314", "11088", "action started via WP Cron", "2026-01-29 06:26:32", "2026-01-29 06:26:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("33315", "11088", "action complete via WP Cron", "2026-01-29 06:26:32", "2026-01-29 06:26:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("33316", "11124", "action created", "2026-01-29 06:26:32", "2026-01-29 06:26:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("33317", "11089", "action started via WP Cron", "2026-01-29 06:26:32", "2026-01-29 06:26:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("33318", "11089", "action complete via WP Cron", "2026-01-29 06:26:32", "2026-01-29 06:26:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("33319", "11125", "action created", "2026-01-29 06:26:32", "2026-01-29 06:26:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("33320", "11090", "action started via WP Cron", "2026-01-29 06:26:32", "2026-01-29 06:26:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("33321", "11090", "action complete via WP Cron", "2026-01-29 06:26:32", "2026-01-29 06:26:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("33322", "11126", "action created", "2026-01-29 06:26:32", "2026-01-29 06:26:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("33326", "11092", "action started via WP Cron", "2026-01-29 06:26:32", "2026-01-29 06:26:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("33327", "11092", "action complete via WP Cron", "2026-01-29 06:26:32", "2026-01-29 06:26:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("33328", "11128", "action created", "2026-01-29 06:26:32", "2026-01-29 06:26:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("33329", "11093", "action started via WP Cron", "2026-01-29 06:26:32", "2026-01-29 06:26:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("33330", "11093", "action complete via WP Cron", "2026-01-29 06:26:32", "2026-01-29 06:26:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("33331", "11129", "action created", "2026-01-29 06:26:32", "2026-01-29 06:26:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("33332", "11094", "action started via WP Cron", "2026-01-29 06:26:32", "2026-01-29 06:26:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("33333", "11094", "action complete via WP Cron", "2026-01-29 06:26:32", "2026-01-29 06:26:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("33334", "11130", "action created", "2026-01-29 06:26:32", "2026-01-29 06:26:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("33335", "11095", "action started via WP Cron", "2026-01-29 06:26:32", "2026-01-29 06:26:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("33336", "11095", "action complete via WP Cron", "2026-01-29 06:26:32", "2026-01-29 06:26:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("33337", "11131", "action created", "2026-01-29 06:26:32", "2026-01-29 06:26:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("33338", "11096", "action started via WP Cron", "2026-01-29 06:26:32", "2026-01-29 06:26:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("33339", "11096", "action complete via WP Cron", "2026-01-29 06:26:32", "2026-01-29 06:26:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("33340", "11132", "action created", "2026-01-29 06:26:32", "2026-01-29 06:26:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("33341", "11097", "action started via WP Cron", "2026-01-29 06:26:32", "2026-01-29 06:26:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("33342", "11097", "action complete via WP Cron", "2026-01-29 06:26:32", "2026-01-29 06:26:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("33343", "11133", "action created", "2026-01-29 06:26:32", "2026-01-29 06:26:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("33350", "11100", "action started via WP Cron", "2026-01-29 06:26:33", "2026-01-29 06:26:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("33351", "11100", "action complete via WP Cron", "2026-01-29 06:26:33", "2026-01-29 06:26:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("33352", "11136", "action created", "2026-01-29 06:26:33", "2026-01-29 06:26:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("33401", "10913", "action started via WP Cron", "2026-01-29 20:04:37", "2026-01-29 20:04:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("33402", "10913", "action complete via WP Cron", "2026-01-29 20:04:37", "2026-01-29 20:04:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("33403", "11153", "action created", "2026-01-29 20:04:37", "2026-01-29 20:04:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("33424", "11160", "action created", "2026-01-30 06:34:20", "2026-01-30 06:34:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("33425", "11124", "action started via WP Cron", "2026-01-30 06:34:20", "2026-01-30 06:34:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("33426", "11124", "action complete via WP Cron", "2026-01-30 06:34:20", "2026-01-30 06:34:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("33427", "11161", "action created", "2026-01-30 06:34:20", "2026-01-30 06:34:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("33428", "11125", "action started via WP Cron", "2026-01-30 06:34:20", "2026-01-30 06:34:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("33429", "11125", "action complete via WP Cron", "2026-01-30 06:34:20", "2026-01-30 06:34:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("33430", "11162", "action created", "2026-01-30 06:34:20", "2026-01-30 06:34:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("33431", "11126", "action started via WP Cron", "2026-01-30 06:34:20", "2026-01-30 06:34:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("33432", "11126", "action complete via WP Cron", "2026-01-30 06:34:20", "2026-01-30 06:34:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("33433", "11163", "action created", "2026-01-30 06:34:20", "2026-01-30 06:34:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("33436", "11164", "action created", "2026-01-30 06:34:20", "2026-01-30 06:34:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("33437", "11128", "action started via WP Cron", "2026-01-30 06:34:20", "2026-01-30 06:34:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("33438", "11128", "action complete via WP Cron", "2026-01-30 06:34:20", "2026-01-30 06:34:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("33439", "11165", "action created", "2026-01-30 06:34:20", "2026-01-30 06:34:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("33440", "11129", "action started via WP Cron", "2026-01-30 06:34:20", "2026-01-30 06:34:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("33441", "11129", "action complete via WP Cron", "2026-01-30 06:34:20", "2026-01-30 06:34:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("33442", "11166", "action created", "2026-01-30 06:34:20", "2026-01-30 06:34:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("33443", "11130", "action started via WP Cron", "2026-01-30 06:34:20", "2026-01-30 06:34:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("33444", "11130", "action complete via WP Cron", "2026-01-30 06:34:20", "2026-01-30 06:34:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("33445", "11167", "action created", "2026-01-30 06:34:20", "2026-01-30 06:34:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("33446", "11131", "action started via WP Cron", "2026-01-30 06:34:20", "2026-01-30 06:34:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("33447", "11131", "action complete via WP Cron", "2026-01-30 06:34:20", "2026-01-30 06:34:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("33448", "11168", "action created", "2026-01-30 06:34:20", "2026-01-30 06:34:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("33449", "11132", "action started via WP Cron", "2026-01-30 06:34:20", "2026-01-30 06:34:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("33450", "11132", "action complete via WP Cron", "2026-01-30 06:34:20", "2026-01-30 06:34:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("33451", "11169", "action created", "2026-01-30 06:34:20", "2026-01-30 06:34:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("33452", "11133", "action started via WP Cron", "2026-01-30 06:34:20", "2026-01-30 06:34:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("33453", "11133", "action complete via WP Cron", "2026-01-30 06:34:20", "2026-01-30 06:34:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("33454", "11170", "action created", "2026-01-30 06:34:20", "2026-01-30 06:34:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("33457", "11171", "action created", "2026-01-30 06:34:20", "2026-01-30 06:34:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("33460", "11172", "action created", "2026-01-30 06:34:20", "2026-01-30 06:34:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("33461", "11136", "action started via WP Cron", "2026-01-30 06:34:20", "2026-01-30 06:34:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("33462", "11136", "action complete via WP Cron", "2026-01-30 06:34:20", "2026-01-30 06:34:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("33463", "11173", "action created", "2026-01-30 06:34:20", "2026-01-30 06:34:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("33482", "11180", "action created", "2026-01-30 10:57:42", "2026-01-30 10:57:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("33484", "11180", "action started via WP Cron", "2026-01-30 10:58:34", "2026-01-30 10:58:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("33485", "11180", "action complete via WP Cron", "2026-01-30 10:58:35", "2026-01-30 10:58:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("33519", "11192", "action created", "2026-01-30 18:26:43", "2026-01-30 18:26:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("33521", "11192", "action started via WP Cron", "2026-01-30 19:08:49", "2026-01-30 19:08:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("33522", "11193", "action created", "2026-01-30 19:08:49", "2026-01-30 19:08:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("33523", "11192", "action complete via WP Cron", "2026-01-30 19:08:49", "2026-01-30 19:08:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("33524", "11193", "action started via WP Cron", "2026-01-30 19:43:45", "2026-01-30 19:43:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("33525", "11194", "action created", "2026-01-30 19:43:45", "2026-01-30 19:43:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("33526", "11193", "action complete via WP Cron", "2026-01-30 19:43:45", "2026-01-30 19:43:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("33527", "11194", "action started via WP Cron", "2026-01-30 20:31:13", "2026-01-30 20:31:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("33528", "11195", "action created", "2026-01-30 20:31:13", "2026-01-30 20:31:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("33529", "11194", "action complete via WP Cron", "2026-01-30 20:31:13", "2026-01-30 20:31:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("33530", "11195", "action started via WP Cron", "2026-01-30 20:46:57", "2026-01-30 20:46:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("33531", "11196", "action created", "2026-01-30 20:46:57", "2026-01-30 20:46:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("33532", "11195", "action complete via WP Cron", "2026-01-30 20:46:57", "2026-01-30 20:46:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("33533", "11196", "action started via WP Cron", "2026-01-30 21:02:04", "2026-01-30 21:02:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("33534", "11197", "action created", "2026-01-30 21:02:04", "2026-01-30 21:02:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("33535", "11196", "action complete via WP Cron", "2026-01-30 21:02:04", "2026-01-30 21:02:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("33536", "11197", "action started via WP Cron", "2026-01-30 23:23:49", "2026-01-30 23:23:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("33537", "11198", "action created", "2026-01-30 23:23:49", "2026-01-30 23:23:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("33538", "11197", "action complete via WP Cron", "2026-01-30 23:23:49", "2026-01-30 23:23:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("33539", "11198", "action started via WP Cron", "2026-01-31 01:01:02", "2026-01-31 01:01:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("33540", "11199", "action created", "2026-01-31 01:01:02", "2026-01-31 01:01:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("33541", "11198", "action complete via WP Cron", "2026-01-31 01:01:02", "2026-01-31 01:01:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("33542", "11199", "action started via WP Cron", "2026-01-31 02:41:34", "2026-01-31 02:41:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("33543", "11200", "action created", "2026-01-31 02:41:34", "2026-01-31 02:41:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("33544", "11199", "action complete via WP Cron", "2026-01-31 02:41:34", "2026-01-31 02:41:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("33545", "11200", "action started via WP Cron", "2026-01-31 03:47:07", "2026-01-31 03:47:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("33546", "11201", "action created", "2026-01-31 03:47:07", "2026-01-31 03:47:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("33547", "11200", "action complete via WP Cron", "2026-01-31 03:47:07", "2026-01-31 03:47:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("33548", "11201", "action started via WP Cron", "2026-01-31 05:18:39", "2026-01-31 05:18:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("33549", "11202", "action created", "2026-01-31 05:18:39", "2026-01-31 05:18:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("33550", "11201", "action complete via WP Cron", "2026-01-31 05:18:39", "2026-01-31 05:18:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("33551", "11202", "action started via WP Cron", "2026-01-31 05:49:38", "2026-01-31 05:49:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("33552", "11203", "action created", "2026-01-31 05:49:38", "2026-01-31 05:49:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("33553", "11202", "action complete via WP Cron", "2026-01-31 05:49:38", "2026-01-31 05:49:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("33554", "11204", "action created", "2026-01-31 05:51:18", "2026-01-31 05:51:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("33555", "11204", "action started via WP Cron", "2026-01-31 05:51:18", "2026-01-31 05:51:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("33556", "11204", "action complete via WP Cron", "2026-01-31 05:51:18", "2026-01-31 05:51:18");

/* INSERT TABLE DATA: wp_aioseo_cache */
INSERT INTO `wp_aioseo_cache` VALUES("2", "db_schema", "{\"wp_actionscheduler_logs\":[\"log_id\",\"action_id\",\"message\",\"log_date_gmt\",\"log_date_local\"],\"wp_wpforms_logs\":[\"id\",\"title\",\"message\",\"types\",\"create_at\",\"form_id\",\"entry_id\",\"user_id\"],\"wp_litespeed_url\":[\"id\",\"url\",\"cache_tags\"],\"wp_posts\":[\"ID\",\"post_author\",\"post_date\",\"post_date_gmt\",\"post_content\",\"post_title\",\"post_excerpt\",\"post_status\",\"comment_status\",\"ping_status\",\"post_password\",\"post_name\",\"to_ping\",\"pinged\",\"post_modified\",\"post_modified_gmt\",\"post_content_filtered\",\"post_parent\",\"guid\",\"menu_order\",\"post_type\",\"post_mime_type\",\"comment_count\"],\"wp_aioseo_posts\":[\"id\",\"post_id\",\"title\",\"description\",\"keywords\",\"keyphrases\",\"page_analysis\",\"primary_term\",\"canonical_url\",\"og_title\",\"og_description\",\"og_object_type\",\"og_image_type\",\"og_image_url\",\"og_image_width\",\"og_image_height\",\"og_image_custom_url\",\"og_image_custom_fields\",\"og_video\",\"og_custom_url\",\"og_article_section\",\"og_article_tags\",\"twitter_use_og\",\"twitter_card\",\"twitter_image_type\",\"twitter_image_url\",\"twitter_image_custom_url\",\"twitter_image_custom_fields\",\"twitter_title\",\"twitter_description\",\"seo_score\",\"schema\",\"schema_type\",\"schema_type_options\",\"pillar_content\",\"robots_default\",\"robots_noindex\",\"robots_noarchive\",\"robots_nosnippet\",\"robots_nofollow\",\"robots_noimageindex\",\"robots_noodp\",\"robots_notranslate\",\"robots_max_snippet\",\"robots_max_videopreview\",\"robots_max_imagepreview\",\"images\",\"image_scan_date\",\"priority\",\"frequency\",\"videos\",\"video_thumbnail\",\"video_scan_date\",\"local_seo\",\"breadcrumb_settings\",\"limit_modified_date\",\"options\",\"ai\",\"created\",\"updated\"],\"wp_aioseo_crawl_cleanup_logs\":[\"id\",\"slug\",\"key\",\"value\",\"hash\",\"hits\",\"created\",\"updated\"],\"wp_actionscheduler_groups\":[\"group_id\",\"slug\"],\"wp_comments\":[\"comment_ID\",\"comment_post_ID\",\"comment_author\",\"comment_author_email\",\"comment_author_url\",\"comment_author_IP\",\"comment_date\",\"comment_date_gmt\",\"comment_content\",\"comment_karma\",\"comment_approved\",\"comment_agent\",\"comment_type\",\"comment_parent\",\"user_id\"],\"wp_commentmeta\":[\"meta_id\",\"comment_id\",\"meta_key\",\"meta_value\"],\"wp_wpforms_tasks_meta\":[\"id\",\"action\",\"data\",\"date\"],\"wp_actionscheduler_claims\":[\"claim_id\",\"date_created_gmt\"],\"wp_aioseo_writing_assistant_keywords\":[\"id\",\"uuid\",\"keyword\",\"country\",\"language\",\"progress\",\"keywords\",\"competitors\",\"created\",\"updated\"],\"wp_actionscheduler_actions\":[\"action_id\",\"hook\",\"status\",\"scheduled_date_gmt\",\"scheduled_date_local\",\"priority\",\"args\",\"schedule\",\"group_id\",\"attempts\",\"last_attempt_gmt\",\"last_attempt_local\",\"claim_id\",\"extended_args\"],\"wp_termmeta\":[\"meta_id\",\"term_id\",\"meta_key\",\"meta_value\"],\"wp_wpforms_payments\":[\"id\",\"form_id\",\"status\",\"subtotal_amount\",\"discount_amount\",\"total_amount\",\"currency\",\"entry_id\",\"gateway\",\"type\",\"mode\",\"transaction_id\",\"customer_id\",\"subscription_id\",\"subscription_status\",\"title\",\"date_created_gmt\",\"date_updated_gmt\",\"is_published\"],\"wp_litespeed_url_file\":[\"id\",\"url_id\",\"vary\",\"filename\",\"type\",\"mobile\",\"webp\",\"expired\"],\"wp_term_relationships\":[\"object_id\",\"term_taxonomy_id\",\"term_order\"],\"wp_aioseo_writing_assistant_posts\":[\"id\",\"post_id\",\"keyword_id\",\"content_analysis_hash\",\"content_analysis\",\"created\",\"updated\"],\"wp_aioseo_ai_insights_keyword_reports\":[\"id\",\"uuid\",\"keyword\",\"status\",\"brands\",\"brands_mentioned\",\"results\",\"created\",\"updated\"],\"wp_aioseo_cache\":[\"id\",\"key\",\"value\",\"is_object\",\"expiration\",\"created\",\"updated\"],\"wp_aioseo_notifications\":[\"id\",\"slug\",\"addon\",\"title\",\"content\",\"type\",\"level\",\"notification_id\",\"notification_name\",\"start\",\"end\",\"button1_label\",\"button1_action\",\"button2_label\",\"button2_action\",\"dismissed\",\"new\",\"created\",\"updated\"],\"wp_aioseo_crawl_cleanup_blocked_args\":[\"id\",\"key\",\"value\",\"key_value_hash\",\"regex\",\"hits\",\"created\",\"updated\"],\"wp_aioseo_seo_analyzer_results\":[\"id\",\"data\",\"score\",\"competitor_url\",\"created\",\"updated\"],\"wp_users\":[\"ID\",\"user_login\",\"user_pass\",\"user_nicename\",\"user_email\",\"user_url\",\"user_registered\",\"user_activation_key\",\"user_status\",\"display_name\"],\"wp_usermeta\":[\"umeta_id\",\"user_id\",\"meta_key\",\"meta_value\"],\"wp_postmeta\":[\"meta_id\",\"post_id\",\"meta_key\",\"meta_value\"],\"wp_srfm_entries\":[\"ID\",\"form_id\",\"user_id\",\"form_data\",\"logs\",\"notes\",\"submission_info\",\"status\",\"type\",\"extras\",\"created_at\",\"updated_at\"],\"wp_term_taxonomy\":[\"term_taxonomy_id\",\"term_id\",\"taxonomy\",\"description\",\"parent\",\"count\"],\"wp_terms\":[\"term_id\",\"name\",\"slug\",\"term_group\"],\"wp_wpforms_payment_meta\":[\"id\",\"payment_id\",\"meta_key\",\"meta_value\"],\"wp_links\":[\"link_id\",\"link_url\",\"link_name\",\"link_image\",\"link_target\",\"link_description\",\"link_visible\",\"link_owner\",\"link_rating\",\"link_updated\",\"link_rel\",\"link_notes\",\"link_rss\"],\"wp_options\":[\"option_id\",\"option_name\",\"option_value\",\"autoload\"]}", "0", "2026-01-31 19:08:48", "2026-01-23 11:47:24", "2026-01-30 19:08:48");
INSERT INTO `wp_aioseo_cache` VALUES("3", "addons", "[{\"sku\":\"aioseo-redirects\",\"name\":\"Redirection Manager\",\"version\":\"1.4.15\",\"image\":null,\"icon\":\"PHN2ZyB2aWV3Qm94PSIwIDAgMjQgMjQiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgY2xhc3M9ImFpb3Nlby1yZWRpcmVjdCI+PHBhdGggZmlsbC1ydWxlPSJldmVub2RkIiBjbGlwLXJ1bGU9ImV2ZW5vZGQiIGQ9Ik0xMC41OSA5LjE3TDUuNDEgNEw0IDUuNDFMOS4xNyAxMC41OEwxMC41OSA5LjE3Wk0xNC41IDRMMTYuNTQgNi4wNEw0IDE4LjU5TDUuNDEgMjBMMTcuOTYgNy40NkwyMCA5LjVWNEgxNC41Wk0xMy40MiAxNC44MkwxNC44MyAxMy40MUwxNy45NiAxNi41NEwyMCAxNC41VjIwSDE0LjVMMTYuNTUgMTcuOTVMMTMuNDIgMTQuODJaIiBmaWxsPSJjdXJyZW50Q29sb3IiIC8+PC9zdmc+\",\"levels\":[\"business\",\"agency\",\"pro\",\"elite\"],\"currentLevels\":[\"pro\",\"elite\"],\"requiresUpgrade\":true,\"description\":\"<p>Our Redirection Manager allows you to create and manage redirects for 404s or modified posts.<\\/p>\\n\",\"descriptionVersion\":0,\"downloadUrl\":\"\",\"productUrl\":\"https:\\/\\/aioseo.com\\/features\\/redirection-manager\\/\",\"learnMoreUrl\":\"https:\\/\\/aioseo.com\\/features\\/redirection-manager\\/\",\"manageUrl\":\"https:\\/\\/route#aioseo-redirects:redirects\",\"features\":[{\"license_level\":\"elite\",\"feature\":\"404-parent-redirect\"}]},{\"sku\":\"aioseo-link-assistant\",\"name\":\"Link Assistant\",\"version\":\"1.1.11\",\"image\":null,\"icon\":\"PHN2ZyB2aWV3Qm94PSIwIDAgMjQgMjQiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHBhdGggZmlsbC1ydWxlPSJldmVub2RkIiBjbGlwLXJ1bGU9ImV2ZW5vZGQiIGQ9Ik0xMSAxNUg3QzUuMzUgMTUgNCAxMy42NSA0IDEyQzQgMTAuMzUgNS4zNSA5IDcgOUgxMVY3SDdDNC4yNCA3IDIgOS4yNCAyIDEyQzIgMTQuNzYgNC4yNCAxNyA3IDE3SDExVjE1Wk0xNyA3SDEzVjlIMTdDMTguNjUgOSAyMCAxMC4zNSAyMCAxMkMyMCAxMy42NSAxOC42NSAxNSAxNyAxNUgxM1YxN0gxN0MxOS43NiAxNyAyMiAxNC43NiAyMiAxMkMyMiA5LjI0IDE5Ljc2IDcgMTcgN1pNMTYgMTFIOFYxM0gxNlYxMVoiIGZpbGw9ImN1cnJlbnRDb2xvciIvPjwvc3ZnPgo=\",\"levels\":[\"agency\",\"pro\",\"elite\"],\"currentLevels\":[\"pro\",\"elite\"],\"requiresUpgrade\":true,\"description\":\"<p>Super-charge your SEO with Link Assistant! Get relevant suggestions for adding internal links to older content as well as finding any orphaned posts that have no internal links. Use our reporting feature to see all link suggestions or add them directly from any page or post.<\\/p>\\n\",\"descriptionVersion\":0,\"downloadUrl\":\"\",\"productUrl\":\"https:\\/\\/aioseo.com\\/docs\\/link-assistant\\/\",\"learnMoreUrl\":\"https:\\/\\/aioseo.com\\/docs\\/link-assistant\\/\",\"manageUrl\":\"https:\\/\\/route#aioseo-link-assistant:overview\",\"features\":[]},{\"sku\":\"aioseo-video-sitemap\",\"name\":\"Video Sitemap\",\"version\":\"1.1.24\",\"image\":null,\"icon\":\"PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyMCAyMCI+PHBhdGggZmlsbC1ydWxlPSJldmVub2RkIiBkPSJNMy4zMzMgNWgxMGMuNDU5IDAgLjgzNC4zNzUuODM0LjgzM1Y4Ljc1TDE3LjUgNS40MTd2OS4xNjZsLTMuMzMzLTMuMzMzdjIuOTE3YS44MzYuODM2IDAgMCAxLS44MzQuODMzaC0xMGEuODM2LjgzNiAwIDAgMS0uODMzLS44MzNWNS44MzNjMC0uNDU4LjM3NS0uODMzLjgzMy0uODMzWm05LjE2NyA4LjMzM1Y2LjY2N0g0LjE2N3Y2LjY2NkgxMi41WiIgY2xpcC1ydWxlPSJldmVub2RkIi8+PC9zdmc+\",\"levels\":[\"individual\",\"business\",\"agency\",\"pro\",\"elite\"],\"currentLevels\":[\"pro\",\"elite\"],\"requiresUpgrade\":true,\"description\":\"<p>The Video Sitemap works in much the same way as the XML Sitemap module, it generates an XML Sitemap specifically for video content on your site. Search engines use this information to display rich snippet information in search results.<\\/p>\\n\",\"descriptionVersion\":0,\"downloadUrl\":\"\",\"productUrl\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-create-a-video-sitemap\\/\",\"learnMoreUrl\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-create-a-video-sitemap\\/\",\"manageUrl\":\"https:\\/\\/route#aioseo-sitemaps:video-sitemap\",\"features\":[]},{\"sku\":\"aioseo-local-business\",\"name\":\"Local Business SEO\",\"version\":\"1.3.12\",\"image\":null,\"icon\":\"svg-local-business\",\"levels\":[\"business\",\"agency\",\"plus\",\"pro\",\"elite\"],\"currentLevels\":[\"plus\",\"pro\",\"elite\"],\"requiresUpgrade\":true,\"description\":\"<p>Local Business schema markup enables you to tell Google about your business, including your business name, address and phone number, opening hours and price range. This information may be displayed as a Knowledge Graph card or business carousel.<\\/p>\\n\",\"descriptionVersion\":0,\"downloadUrl\":\"\",\"productUrl\":\"https:\\/\\/aioseo.com\\/docs\\/local-business-seo\\/\",\"learnMoreUrl\":\"https:\\/\\/aioseo.com\\/docs\\/local-business-seo\\/\",\"manageUrl\":\"https:\\/\\/route#aioseo-local-seo:locations\",\"features\":[]},{\"sku\":\"aioseo-news-sitemap\",\"name\":\"News Sitemap\",\"version\":\"1.0.20\",\"image\":null,\"icon\":\"svg-sitemaps-pro\",\"levels\":[\"business\",\"agency\",\"pro\",\"elite\"],\"currentLevels\":[\"pro\",\"elite\"],\"requiresUpgrade\":true,\"description\":\"<p>Our Google News Sitemap lets you control which content you submit to Google News and only contains articles that were published in the last 48 hours. In order to submit a News Sitemap to Google, you must have added your site to Google\\u2019s Publisher Center and had it approved.<\\/p>\\n\",\"descriptionVersion\":0,\"downloadUrl\":\"\",\"productUrl\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-create-a-google-news-sitemap\\/\",\"learnMoreUrl\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-create-a-google-news-sitemap\\/\",\"manageUrl\":\"https:\\/\\/route#aioseo-sitemaps:news-sitemap\",\"features\":[]},{\"sku\":\"aioseo-index-now\",\"name\":\"IndexNow\",\"version\":\"1.0.13\",\"image\":null,\"icon\":\"PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyMCAyMCI+PHBhdGggZD0iTTE3LjY0NCAxMS42NTVjLS4zMjEtLjIyOS0uNjU0LS40NDYtLjk2NC0uNjk3LS42NDMtLjUzNC0uNjMxLTEuMzcyLjAyMy0xLjg4NC4zMS0uMjQuNjQyLS40NTguOTY0LS42OTcuMTg0LS4xMy4zMjEtLjI5NC4zMzMtLjUzNCAwLS4wMzIgMC0uMDc2LS4wMTItLjEyYTcuNDQyIDcuNDQyIDAgMCAwLTEuODkzLTMuMTQ3Yy0uMjA3LS4yMDctLjQ2LS4yNC0uNzQ2LS4xMmEyMi4wNSAyMi4wNSAwIDAgMS0xLjA2OC40MzZjLS45MTguMzQ4LTEuNjg3LS4wODctMS44MTMtMS4wMjQtLjA0Ni0uMzM4LS4wOC0uNjc1LS4xMTUtMS4wMTMtLjAzNC0uMzctLjI0LS41OTktLjYzLS42NzVhOC40NDYgOC40NDYgMCAwIDAtMy40NjcgMGMtLjM2Ny4wNzYtLjU3NC4yNzItLjYwOC42MzJhMTMuNzggMTMuNzggMCAwIDEtLjE2IDEuMTc2Yy0uMTYxLjgyOC0uOTE5IDEuMjMtMS43NDUuOTE1LS4zNTYtLjEzLS43MTItLjI5NC0xLjA2Ny0uNDQ3LS4zMzMtLjE0MS0uNjA5LS4wODctLjg1LjE2NGE3Ljc3OSA3Ljc3OSAwIDAgMC0xLjc3OSAyLjkxOGMtLjExNC4zMzgtLjAyMy42MS4yODcuODI4LjI5OS4yMDcuNjA5LjQxNC44OTUuNjMyLjc3LjU4OC43NTggMS40NDgtLjAyMiAyLjAxNC0uMjg3LjIwNy0uNTc0LjQxNC0uODYxLjYxLS4zMjIuMjE4LS40MTMuNTEyLS4yOTkuODZhNy44NyA3Ljg3IDAgMCAwIDEuNzQ1IDIuODg3Yy4yNC4yNS41MTYuMzE2Ljg1LjE4NS4zOS0uMTUzLjc2OC0uMzI3IDEuMTU4LS40NjguNzU4LS4yNzMgMS41MTUuMTIgMS42NzYuODcuMDguNDA0LjEyNi44MTguMTYgMS4yMi4wMzUuMzcuMjQxLjU2Ny41OTcuNjQzIDEuMTYuMjQgMi4zMDcuMjQgMy40NjYuMDExLjQxMy0uMDg3LjYwOC0uMzE2LjY0My0uNzA4LjAyMy0uMzI3LjA2OS0uNjUzLjEwMy0uOTcuMTE1LS45MjUuODk1LTEuMzgyIDEuODE0LTEuMDQ1LjM0NC4xMzEuNjg4LjI3MyAxLjAzMi40MjUuMzY4LjE1My42NjYuMDc2LjkxOC0uMjA3YTguNDk0IDguNDk0IDAgMCAwIDEuNzEtMi44MmMuMTUtLjMzOC4wNTgtLjYyMS0uMjc1LS44NXptLTkuNDguNjk3Yy0uMTAzLjEzLS4zMS4xMi0uNDEzLS4wMUw2LjAzIDEwLjE3M2EuMjIuMjIgMCAwIDEgMC0uMjgzbDEuOTI4LTIuNDI5IDEuNDY5IDEuNzItLjYzMS44NS41MjcuNzA4YS4yMDUuMjA1IDAgMCAxLS4wMTEuMjYyem01LjgzLTIuMTc4LTIuNDc5IDMuMDE3YS4yNi4yNiAwIDAgMS0uMjA2LjEwOUg5LjEwNWEuMjUuMjUgMCAwIDEtLjIwNi0uNDAzbDIuMzUzLTIuODY1LTIuNjc0LTMuMjY3aDIuODY5bDIuNTU5IDMuMTI2YS4yMzYuMjM2IDAgMCAxLS4wMTEuMjgzeiIvPjwvc3ZnPg==\",\"levels\":[\"business\",\"agency\",\"basic\",\"plus\",\"pro\",\"elite\"],\"currentLevels\":[\"basic\",\"plus\",\"pro\",\"elite\"],\"requiresUpgrade\":true,\"description\":\"<p>Add IndexNow support to instantly notify search engines when your content has changed. This helps the search engines to prioritize the changes on your website and helps you rank faster.<\\/p>\\n\",\"descriptionVersion\":0,\"downloadUrl\":\"\",\"productUrl\":\"https:\\/\\/aioseo.com\\/index-now\",\"learnMoreUrl\":\"https:\\/\\/aioseo.com\\/index-now\",\"manageUrl\":\"https:\\/\\/route#aioseo-settings:webmaster-tools\",\"features\":[]},{\"sku\":\"aioseo-rest-api\",\"name\":\"REST API\",\"version\":\"1.0.9\",\"image\":null,\"icon\":\"PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCIgY2xhc3M9ImFpb3Nlby1jb2RlIj48cGF0aCBkPSJNOS40IDE2LjZMNC44IDEybDQuNi00LjZMOCA2bC02IDYgNiA2IDEuNC0xLjR6bTUuMiAwbDQuNi00LjYtNC42LTQuNkwxNiA2bDYgNi02IDYtMS40LTEuNHoiIGZpbGw9ImN1cnJlbnRDb2xvciIvPjwvc3ZnPg==\",\"levels\":[\"plus\",\"pro\",\"elite\"],\"currentLevels\":[\"plus\",\"pro\",\"elite\"],\"requiresUpgrade\":true,\"description\":\"<p>Manage your post and term SEO meta via the WordPress REST API. This addon also works seamlessly with headless WordPress installs.<\\/p>\\n\",\"descriptionVersion\":0,\"downloadUrl\":\"\",\"productUrl\":\"https:\\/\\/aioseo.com\\/feature\\/rest-api\\/\",\"learnMoreUrl\":\"https:\\/\\/aioseo.com\\/feature\\/rest-api\\/\",\"manageUrl\":\"\",\"features\":[]},{\"sku\":\"aioseo-image-seo\",\"name\":\"Image SEO\",\"version\":\"1.2.2\",\"image\":null,\"icon\":\"PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyMCAyMCI+PHBhdGggZD0iTTE1LjgzMyA0LjE2N3YxMS42NjZINC4xNjdWNC4xNjdoMTEuNjY2Wm0wLTEuNjY3SDQuMTY3QzMuMjUgMi41IDIuNSAzLjI1IDIuNSA0LjE2N3YxMS42NjZjMCAuOTE3Ljc1IDEuNjY3IDEuNjY3IDEuNjY3aDExLjY2NmMuOTE3IDAgMS42NjctLjc1IDEuNjY3LTEuNjY3VjQuMTY3YzAtLjkxNy0uNzUtMS42NjctMS42NjctMS42NjdabS00LjA1IDcuMzgzLTIuNSAzLjIyNUw3LjUgMTAuOTUgNSAxNC4xNjdoMTBsLTMuMjE3LTQuMjg0WiIvPjwvc3ZnPg==\",\"levels\":[\"business\",\"agency\",\"plus\",\"pro\",\"elite\"],\"currentLevels\":[\"plus\",\"pro\",\"elite\"],\"requiresUpgrade\":true,\"description\":\"<p>Globally control the Title, Alt Text, Caption and Descriptions for images in your content. These attributes are essential for both accessibility and SEO.<\\/p>\\n\",\"descriptionVersion\":0,\"downloadUrl\":\"\",\"productUrl\":\"https:\\/\\/aioseo.com\\/docs\\/using-the-image-seo-features-in-all-in-one-seo\\/\",\"learnMoreUrl\":\"https:\\/\\/aioseo.com\\/docs\\/using-the-image-seo-features-in-all-in-one-seo\\/\",\"manageUrl\":\"https:\\/\\/route#aioseo-search-appearance:media\",\"features\":[]},{\"sku\":\"aioseo-eeat\",\"name\":\"Author SEO (E-E-A-T)\",\"version\":\"1.2.9\",\"image\":null,\"icon\":\"PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgLTk2MCA5NjAgOTYwIiB3aWR0aD0iMjQiPjxwYXRoIGQ9Ik00NDAuMTE4LTU2MHEzMy44MzkgMCA1Ny44MTctMjQuMDk3dDIzLjk3OC01Ny45MzVxMC0zMy44MzgtMjMuOTc4LTU3LjY5Ni0yMy45NzgtMjMuODU5LTU3LjgxNy0yMy44NTktMzMuODM4IDAtNTcuOTM0IDIzLjg1OS0yNC4wOTcgMjMuODU4LTI0LjA5NyA1Ny42OTYgMCAzMy44MzggMjQuMDk3IDU3LjkzNVE0MDYuMjgtNTYwIDQ0MC4xMTgtNTYwWk00NDAtMzk2LjQxM3E0NS43MTcgMCA4NS41NzYtMTkuNDc4IDM5Ljg1OS0xOS40NzkgNjkuNTc2LTU2LjE1Mi0zNS45NTYtMjMuNzE4LTc0LjkzNS0zNS44MzdRNDgxLjIzOS01MjAgNDQwLTUyMHQtODAuMjE3IDEyLjEycS0zOC45NzkgMTIuMTE5LTc0LjkzNSAzNS44MzcgMjkuNzE3IDM2LjY3MyA2OS41NzYgNTYuMTUyIDM5Ljg1OSAxOS40NzggODUuNTc2IDE5LjQ3OFptMzg2LjM5MSAyODYuOTM1TDYzNy45MTMtMjk3Ljk1NnEtNDEuNzE3IDMxLjc2MS05MS42OTYgNDkuNDAyUTQ5Ni4yMzktMjMwLjkxMyA0NDAtMjMwLjkxM3EtMTM3LjU4NyAwLTIzMy4zMzctOTUuNzVUMTEwLjkxMy01NjBxMC0xMzcuNTg3IDk1Ljc1LTIzMy4zMzdUNDQwLTg4OS4wODdxMTM3LjU4NyAwIDIzMy4zMzcgOTUuNzVUNzY5LjA4Ny01NjBxMCA1NS43NjEtMTcuNzYxIDEwNS45NzgtMTcuNzYxIDUwLjIxOC00OS41MjEgOTIuMTc0TDg5MC4yODMtMTczLjM3bC02My44OTIgNjMuODkyWk00NDAuMTEzLTMyMS45MTNxOTkuMTU2IDAgMTY4LjU2NS02OS41MjIgNjkuNDA5LTY5LjUyMiA2OS40MDktMTY4LjY3OCAwLTk5LjE1Ni02OS40MDktMTY4LjU2NS02OS40MDktNjkuNDA5LTE2OC41NjUtNjkuNDA5LTk5LjE1NiAwLTE2OC42NzggNjkuNDA5LTY5LjUyMiA2OS40MDktNjkuNTIyIDE2OC41NjUgMCA5OS4xNTYgNjkuNTIyIDE2OC42NzggNjkuNTIyIDY5LjUyMiAxNjguNjc4IDY5LjUyMlpNNDQwLTU2MFoiLz48L3N2Zz4=\",\"levels\":[\"plus\",\"pro\",\"elite\"],\"currentLevels\":[\"plus\",\"pro\",\"elite\"],\"requiresUpgrade\":true,\"description\":\"<p>Optimize your site for Google\'s E-E-A-T ranking factor by proving your writer\'s expertise through author schema markup and new UI elements.<\\/p>\\n\",\"descriptionVersion\":0,\"downloadUrl\":\"\",\"productUrl\":\"https:\\/\\/aioseo.com\\/features\\/eeat\\/\",\"learnMoreUrl\":\"https:\\/\\/aioseo.com\\/features\\/eeat\\/\",\"manageUrl\":\"https:\\/\\/route#aioseo-search-appearance:author-seo\",\"features\":[]}]", "0", "2026-01-31 19:08:48", "2026-01-23 11:47:25", "2026-01-30 19:08:48");
INSERT INTO `wp_aioseo_cache` VALUES("4", "action_scheduler_log_cleanup", "true", "0", "2026-01-31 19:08:49", "2026-01-23 11:47:25", "2026-01-30 19:08:49");
INSERT INTO `wp_aioseo_cache` VALUES("5", "aioseo_sitemap_sitemap.rss", "{\"counts\":[],\"datetime\":{\"https:\\/\\/katerinasamanatebi.com\\/tracking-ge-de\\/\":{\"date\":\"October 29, 2025\",\"time\":\"3:50 pm\"},\"https:\\/\\/katerinasamanatebi.com\\/tracking-de-ge\\/\":{\"date\":\"January 21, 2026\",\"time\":\"10:49 pm\"},\"https:\\/\\/katerinasamanatebi.com\\/\\u10e1\\u10d0\\u10d8\\u10e2\\u10d8\\u10e1-\\u10da\\u10dd\\u10d2\\u10d8\\u10dc\\u10d8-\\u10d3\\u10d0-\\u10de\\u10d0\\u10e0\\u10dd\\u10da\\u10d8\\/\":{\"date\":\"March 12, 2025\",\"time\":\"7:16 am\"},\"https:\\/\\/katerinasamanatebi.com\\/\\u10e1\\u10d0\\u10e1\\u10d0\\u10e0\\u10d2\\u10d4\\u10d1\\u10da\\u10dd-\\u10d8\\u10dc\\u10e4\\u10dd\\u10e0\\u10db\\u10d0\\u10ea\\u10d8\\u10d0\\/\":{\"date\":\"April 9, 2025\",\"time\":\"9:52 am\"},\"https:\\/\\/katerinasamanatebi.com\\/tracking\\/\":{\"date\":\"April 29, 2025\",\"time\":\"9:07 am\"},\"https:\\/\\/katerinasamanatebi.com\\/29-04-2025-\\u10e8\\u10d8-\\u10d2\\u10d0\\u10d2\\u10d6\\u10d0\\u10d5\\u10dc\\u10d8\\u10da\\u10d8-\\u10e2\\u10d5\\u10d8\\u10e0\\u10d7\\u10d8\\u10e1-\\u10e1\\/\":{\"date\":\"October 21, 2025\",\"time\":\"11:01 pm\"},\"https:\\/\\/katerinasamanatebi.com\\/\\u10d7\\u10d0\\u10dc\\u10d0\\u10db\\u10e8\\u10e0\\u10dd\\u10db\\u10da\\u10d4\\u10d1\\u10d8\\/\":{\"date\":\"August 19, 2025\",\"time\":\"8:21 pm\"},\"https:\\/\\/katerinasamanatebi.com\\/05-03-2025-\\u10d2\\u10d0\\u10d2\\u10d6\\u10d0\\u10d5\\u10dc\\u10d8\\u10da\\u10d8-\\u10e2\\u10d5\\u10d8\\u10e0\\u10d7\\u10d8\\u10e1-\\u10e1\\u10d8\\u10d0\\/\":{\"date\":\"December 9, 2025\",\"time\":\"8:40 am\"},\"https:\\/\\/katerinasamanatebi.com\\/12-03-2025-\\u10d2\\u10d0\\u10d2\\u10d6\\u10d0\\u10d5\\u10dc\\u10d8\\u10da\\u10d8-\\u10e2\\u10d5\\u10d8\\u10e0\\u10d7\\u10d8\\u10e1-\\u10e1\\u10d8\\u10d0\\/\":{\"date\":\"January 29, 2026\",\"time\":\"4:30 pm\"},\"https:\\/\\/katerinasamanatebi.com\\/27-04-2025\\/\":{\"date\":\"October 16, 2025\",\"time\":\"8:26 pm\"},\"https:\\/\\/katerinasamanatebi.com\\/\\u10d9\\u10dd\\u10dc\\u10e2\\u10d0\\u10e5\\u10e2\\u10d8\\/\":{\"date\":\"March 22, 2025\",\"time\":\"6:00 pm\"},\"https:\\/\\/katerinasamanatebi.com\\/\\u10e2\\u10d0\\u10e0\\u10d8\\u10e4\\u10d4\\u10d1\\u10d8\\/\":{\"date\":\"March 22, 2025\",\"time\":\"5:55 pm\"},\"https:\\/\\/katerinasamanatebi.com\\/\\u10e1\\u10d4\\u10e0\\u10d5\\u10d8\\u10e1-\\u10ea\\u10d4\\u10dc\\u10e2\\u10e0\\u10d4\\u10d1\\u10d8\\u10e1-\\u10e5\\u10e1\\u10d4\\u10da\\u10d8\\/\":{\"date\":\"March 22, 2025\",\"time\":\"5:09 pm\"}},\"pagination\":{\"showing\":13,\"total\":13}}", "0", "2026-03-02 05:18:39", "2026-01-23 12:49:52", "2026-01-31 05:18:39");
INSERT INTO `wp_aioseo_cache` VALUES("9", "aioseo_sitemap_sitemap.xml", "{\"counts\":{\"https:\\/\\/katerinasamanatebi.com\\/addl-sitemap.xml\":1,\"https:\\/\\/katerinasamanatebi.com\\/post-sitemap.xml\":1,\"https:\\/\\/katerinasamanatebi.com\\/page-sitemap.xml\":12,\"https:\\/\\/katerinasamanatebi.com\\/category-sitemap.xml\":1},\"datetime\":{\"https:\\/\\/katerinasamanatebi.com\\/addl-sitemap.xml\":{\"date\":\"January 29, 2026\",\"time\":\"4:30 pm\"},\"https:\\/\\/katerinasamanatebi.com\\/post-sitemap.xml\":{\"date\":\"March 12, 2025\",\"time\":\"7:16 am\"},\"https:\\/\\/katerinasamanatebi.com\\/page-sitemap.xml\":{\"date\":\"January 29, 2026\",\"time\":\"4:30 pm\"},\"https:\\/\\/katerinasamanatebi.com\\/category-sitemap.xml\":{\"date\":\"March 12, 2025\",\"time\":\"7:16 am\"}},\"pagination\":{\"showing\":4,\"total\":4}}", "0", "2026-03-01 19:08:49", "2026-01-24 06:12:30", "2026-01-30 19:08:49");
INSERT INTO `wp_aioseo_cache` VALUES("27", "aioseo_sitemap_addl-sitemap.xml", "{\"counts\":[],\"datetime\":{\"https:\\/\\/katerinasamanatebi.com\\/\":{\"date\":\"January 29, 2026\",\"time\":\"4:30 pm\"}},\"pagination\":{\"showing\":1,\"total\":1}}", "0", "2026-03-01 19:08:52", "2026-01-25 15:28:32", "2026-01-30 19:08:52");
INSERT INTO `wp_aioseo_cache` VALUES("28", "aioseo_sitemap_post-sitemap.xml", "{\"counts\":[],\"datetime\":{\"https:\\/\\/katerinasamanatebi.com\\/\\u10e1\\u10d0\\u10d8\\u10e2\\u10d8\\u10e1-\\u10da\\u10dd\\u10d2\\u10d8\\u10dc\\u10d8-\\u10d3\\u10d0-\\u10de\\u10d0\\u10e0\\u10dd\\u10da\\u10d8\\/\":{\"date\":\"March 12, 2025\",\"time\":\"7:16 am\"}},\"pagination\":{\"showing\":1,\"total\":1}}", "0", "2026-03-01 19:08:55", "2026-01-25 15:28:36", "2026-01-30 19:08:55");
INSERT INTO `wp_aioseo_cache` VALUES("29", "aioseo_sitemap_page-sitemap.xml", "{\"counts\":[],\"datetime\":{\"https:\\/\\/katerinasamanatebi.com\\/12-03-2025-\\u10d2\\u10d0\\u10d2\\u10d6\\u10d0\\u10d5\\u10dc\\u10d8\\u10da\\u10d8-\\u10e2\\u10d5\\u10d8\\u10e0\\u10d7\\u10d8\\u10e1-\\u10e1\\u10d8\\u10d0\\/\":{\"date\":\"January 29, 2026\",\"time\":\"4:30 pm\"},\"https:\\/\\/katerinasamanatebi.com\\/tracking-de-ge\\/\":{\"date\":\"January 21, 2026\",\"time\":\"10:49 pm\"},\"https:\\/\\/katerinasamanatebi.com\\/05-03-2025-\\u10d2\\u10d0\\u10d2\\u10d6\\u10d0\\u10d5\\u10dc\\u10d8\\u10da\\u10d8-\\u10e2\\u10d5\\u10d8\\u10e0\\u10d7\\u10d8\\u10e1-\\u10e1\\u10d8\\u10d0\\/\":{\"date\":\"December 9, 2025\",\"time\":\"8:40 am\"},\"https:\\/\\/katerinasamanatebi.com\\/tracking-ge-de\\/\":{\"date\":\"October 29, 2025\",\"time\":\"3:50 pm\"},\"https:\\/\\/katerinasamanatebi.com\\/29-04-2025-\\u10e8\\u10d8-\\u10d2\\u10d0\\u10d2\\u10d6\\u10d0\\u10d5\\u10dc\\u10d8\\u10da\\u10d8-\\u10e2\\u10d5\\u10d8\\u10e0\\u10d7\\u10d8\\u10e1-\\u10e1\\/\":{\"date\":\"October 21, 2025\",\"time\":\"11:01 pm\"},\"https:\\/\\/katerinasamanatebi.com\\/27-04-2025\\/\":{\"date\":\"October 16, 2025\",\"time\":\"8:26 pm\"},\"https:\\/\\/katerinasamanatebi.com\\/\\u10d7\\u10d0\\u10dc\\u10d0\\u10db\\u10e8\\u10e0\\u10dd\\u10db\\u10da\\u10d4\\u10d1\\u10d8\\/\":{\"date\":\"August 19, 2025\",\"time\":\"8:21 pm\"},\"https:\\/\\/katerinasamanatebi.com\\/tracking\\/\":{\"date\":\"April 29, 2025\",\"time\":\"9:07 am\"},\"https:\\/\\/katerinasamanatebi.com\\/\\u10e1\\u10d0\\u10e1\\u10d0\\u10e0\\u10d2\\u10d4\\u10d1\\u10da\\u10dd-\\u10d8\\u10dc\\u10e4\\u10dd\\u10e0\\u10db\\u10d0\\u10ea\\u10d8\\u10d0\\/\":{\"date\":\"April 9, 2025\",\"time\":\"9:52 am\"},\"https:\\/\\/katerinasamanatebi.com\\/\\u10d9\\u10dd\\u10dc\\u10e2\\u10d0\\u10e5\\u10e2\\u10d8\\/\":{\"date\":\"March 22, 2025\",\"time\":\"6:00 pm\"},\"https:\\/\\/katerinasamanatebi.com\\/\\u10e2\\u10d0\\u10e0\\u10d8\\u10e4\\u10d4\\u10d1\\u10d8\\/\":{\"date\":\"March 22, 2025\",\"time\":\"5:55 pm\"},\"https:\\/\\/katerinasamanatebi.com\\/\\u10e1\\u10d4\\u10e0\\u10d5\\u10d8\\u10e1-\\u10ea\\u10d4\\u10dc\\u10e2\\u10e0\\u10d4\\u10d1\\u10d8\\u10e1-\\u10e5\\u10e1\\u10d4\\u10da\\u10d8\\/\":{\"date\":\"March 22, 2025\",\"time\":\"5:09 pm\"}},\"pagination\":{\"showing\":12,\"total\":12}}", "0", "2026-03-01 19:08:59", "2026-01-25 15:28:40", "2026-01-30 19:08:59");
INSERT INTO `wp_aioseo_cache` VALUES("30", "aioseo_sitemap_category-sitemap.xml", "{\"counts\":[],\"datetime\":{\"https:\\/\\/katerinasamanatebi.com\\/category\\/uncategorized\\/\":{\"date\":\"January 1, 1970\",\"time\":\"12:00 am\"}},\"pagination\":{\"showing\":1,\"total\":1}}", "0", "2026-03-01 19:09:03", "2026-01-25 15:28:43", "2026-01-30 19:09:03");
INSERT INTO `wp_aioseo_cache` VALUES("37", "aioseo_sitemap_sitemap.xml.gz", "{\"counts\":{\"https:\\/\\/katerinasamanatebi.com\\/addl-sitemap.xml\":1,\"https:\\/\\/katerinasamanatebi.com\\/post-sitemap.xml\":1,\"https:\\/\\/katerinasamanatebi.com\\/page-sitemap.xml\":12,\"https:\\/\\/katerinasamanatebi.com\\/category-sitemap.xml\":1},\"datetime\":{\"https:\\/\\/katerinasamanatebi.com\\/addl-sitemap.xml\":{\"date\":\"January 29, 2026\",\"time\":\"4:30 pm\"},\"https:\\/\\/katerinasamanatebi.com\\/post-sitemap.xml\":{\"date\":\"March 12, 2025\",\"time\":\"7:16 am\"},\"https:\\/\\/katerinasamanatebi.com\\/page-sitemap.xml\":{\"date\":\"January 29, 2026\",\"time\":\"4:30 pm\"},\"https:\\/\\/katerinasamanatebi.com\\/category-sitemap.xml\":{\"date\":\"March 12, 2025\",\"time\":\"7:16 am\"}},\"pagination\":{\"showing\":4,\"total\":4}}", "0", "2026-02-28 18:59:59", "2026-01-25 23:19:36", "2026-01-29 18:59:59");
INSERT INTO `wp_aioseo_cache` VALUES("72", "attachment_url_to_post_id_d99ed2ddbeefba28910cca4100f73b401b38bc49", "\"none\"", "0", "2026-01-31 18:26:42", "2026-01-28 07:12:59", "2026-01-30 18:26:42");
INSERT INTO `wp_aioseo_cache` VALUES("75", "admin_notifications_update", "1769925078", "0", "2026-02-01 05:51:18", "2026-01-28 12:41:46", "2026-01-31 05:51:18");
INSERT INTO `wp_aioseo_cache` VALUES("88", "wp_notices", "[]", "0", "2026-02-01 05:52:40", "2026-01-29 16:28:40", "2026-01-31 05:52:40");
INSERT INTO `wp_aioseo_cache` VALUES("89", "license_features", "[{\"license_level\":\"pro\",\"section\":\"schema\",\"feature\":\"event\"},{\"license_level\":\"elite\",\"section\":\"schema\",\"feature\":\"event\"},{\"license_level\":\"elite\",\"section\":\"schema\",\"feature\":\"job-posting\"},{\"license_level\":\"elite\",\"section\":\"tools\",\"feature\":\"network-tools-site-activation\"},{\"license_level\":\"elite\",\"section\":\"tools\",\"feature\":\"network-tools-database\"},{\"license_level\":\"elite\",\"section\":\"tools\",\"feature\":\"network-tools-import-export\"},{\"license_level\":\"elite\",\"section\":\"tools\",\"feature\":\"network-tools-robots\"},{\"license_level\":\"elite\",\"section\":\"search-statistics\",\"feature\":\"seo-statistics\"},{\"license_level\":\"elite\",\"section\":\"search-statistics\",\"feature\":\"keyword-rankings\"},{\"license_level\":\"elite\",\"section\":\"search-statistics\",\"feature\":\"keyword-rankings-pages\"},{\"license_level\":\"elite\",\"section\":\"search-statistics\",\"feature\":\"post-detail\"},{\"license_level\":\"elite\",\"section\":\"search-statistics\",\"feature\":\"post-detail-page-speed\"},{\"license_level\":\"elite\",\"section\":\"search-statistics\",\"feature\":\"post-detail-seo-statistics\"},{\"license_level\":\"elite\",\"section\":\"search-statistics\",\"feature\":\"post-detail-keywords\"},{\"license_level\":\"elite\",\"section\":\"search-statistics\",\"feature\":\"post-detail-focus-keyword-trend\"},{\"license_level\":\"elite\",\"section\":\"search-statistics\",\"feature\":\"keyword-tracking\"},{\"license_level\":\"elite\",\"section\":\"search-statistics\",\"feature\":\"post-detail-keyword-tracking\"},{\"license_level\":\"elite\",\"section\":\"search-statistics\",\"feature\":\"content-rankings\"},{\"license_level\":\"elite\",\"section\":\"seo-revisions\",\"feature\":\"revisions:-1\"},{\"license_level\":\"pro\",\"section\":\"seo-revisions\",\"feature\":\"revisions:30\"},{\"license_level\":\"plus\",\"section\":\"seo-revisions\",\"feature\":\"revisions:15\"},{\"license_level\":\"pro\",\"section\":\"general\",\"feature\":\"cornerstone-content\"},{\"license_level\":\"elite\",\"section\":\"general\",\"feature\":\"cornerstone-content\"},{\"license_level\":\"elite\",\"section\":\"search-statistics\",\"feature\":\"index-status\"},{\"license_level\":\"plus\",\"section\":\"aioseo-eeat\",\"feature\":\"author-info\"},{\"license_level\":\"pro\",\"section\":\"aioseo-eeat\",\"feature\":\"author-info\"},{\"license_level\":\"elite\",\"section\":\"aioseo-eeat\",\"feature\":\"author-info\"},{\"license_level\":\"pro\",\"section\":\"aioseo-eeat\",\"feature\":\"author-archive-bio\"},{\"license_level\":\"elite\",\"section\":\"aioseo-eeat\",\"feature\":\"author-archive-bio\"},{\"license_level\":\"pro\",\"section\":\"aioseo-eeat\",\"feature\":\"post-reviewer\"},{\"license_level\":\"elite\",\"section\":\"aioseo-eeat\",\"feature\":\"post-reviewer\"},{\"license_level\":\"elite\",\"section\":\"search-statistics\",\"feature\":\"keyword-rank-tracker:100\"},{\"license_level\":\"plus\",\"section\":\"redirects\",\"feature\":\"http-headers\"},{\"license_level\":\"pro\",\"section\":\"redirects\",\"feature\":\"http-headers\"},{\"license_level\":\"elite\",\"section\":\"redirects\",\"feature\":\"http-headers\"},{\"license_level\":\"pro\",\"section\":\"redirects\",\"feature\":\"logs\"},{\"license_level\":\"elite\",\"section\":\"redirects\",\"feature\":\"logs\"},{\"license_level\":\"pro\",\"section\":\"redirects\",\"feature\":\"advanced-404-settings\"},{\"license_level\":\"pro\",\"section\":\"redirects\",\"feature\":\"full-site-redirect\"},{\"license_level\":\"elite\",\"section\":\"redirects\",\"feature\":\"full-site-redirect\"},{\"license_level\":\"elite\",\"section\":\"redirects\",\"feature\":\"advanced-404-settings\"},{\"license_level\":\"agency\",\"section\":\"redirects\",\"feature\":\"http-headers\"},{\"license_level\":\"agency\",\"section\":\"redirects\",\"feature\":\"logs\"},{\"license_level\":\"agency\",\"section\":\"redirects\",\"feature\":\"full-site-redirect\"},{\"license_level\":\"business\",\"section\":\"redirects\",\"feature\":\"http-headers\"},{\"license_level\":\"business\",\"section\":\"redirects\",\"feature\":\"logs\"},{\"license_level\":\"business\",\"section\":\"redirects\",\"feature\":\"full-site-redirect\"},{\"license_level\":\"agency\",\"section\":\"redirects\",\"feature\":\"advanced-404-settings\"},{\"license_level\":\"business\",\"section\":\"redirects\",\"feature\":\"advanced-404-settings\"}]", "0", "2026-02-01 05:51:18", "2026-01-29 16:28:40", "2026-01-31 05:51:18");
INSERT INTO `wp_aioseo_cache` VALUES("90", "admin_help_docs", "\"{\\\"categories\\\":{\\\"getting-started\\\":\\\"Getting Started\\\",\\\"advanced-settings\\\":\\\"Advanced Settings\\\",\\\"display-settings\\\":\\\"Display Settings\\\",\\\"general-seo-topics\\\":\\\"General SEO Topics\\\",\\\"feature-manager\\\":\\\"Feature Manager\\\",\\\"installation\\\":\\\"Installation\\\"},\\\"docs\\\":{\\\"401534\\\":{\\\"title\\\":\\\"How to Generate Your SEO Email Reports\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-generate-your-seo-email-reports\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\",\\\"general-settings\\\",\\\"search-statistics\\\"]},\\\"389367\\\":{\\\"title\\\":\\\"Using the Keyword Rank Tracker feature in Search Statistics\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-the-keyword-rank-tracker-feature-in-search-statistics\\\\\\/\\\",\\\"categories\\\":[\\\"keyword-settings\\\",\\\"search-statistics\\\"]},\\\"379863\\\":{\\\"title\\\":\\\"Setting Vehicle (Car) Schema Markup in Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-vehicle-car-schema-markup-in-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"379713\\\":{\\\"title\\\":\\\"Setting Product Review Schema Markup in Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-product-review-schema-markup-in-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"332691\\\":{\\\"title\\\":\\\"Google Permissions for oAuth\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/google-permissions-for-the-aioseo-google-search-console-integration\\\\\\/\\\",\\\"categories\\\":[]},\\\"326862\\\":{\\\"title\\\":\\\"aioseo_user_profile_tab_allowed_user_ids\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_user_profile_tab_allowed_user_ids\\\\\\/\\\",\\\"categories\\\":[\\\"developer-documentation\\\",\\\"filter-hooks\\\"]},\\\"326858\\\":{\\\"title\\\":\\\"aioseo_import_yoast_seo_posts_per_action\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_import_yoast_seo_posts_per_action\\\\\\/\\\",\\\"categories\\\":[\\\"developer-documentation\\\",\\\"filter-hooks\\\"]},\\\"326856\\\":{\\\"title\\\":\\\"aioseo_import_seopress_posts_per_action\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_import_seopress_posts_per_action\\\\\\/\\\",\\\"categories\\\":[\\\"developer-documentation\\\",\\\"filter-hooks\\\"]},\\\"326850\\\":{\\\"title\\\":\\\"aioseo_import_rank_math_posts_per_action\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_import_rank_math_posts_per_action\\\\\\/\\\",\\\"categories\\\":[\\\"developer-documentation\\\",\\\"filter-hooks\\\"]},\\\"298356\\\":{\\\"title\\\":\\\"aioseo_redirects_log_skip\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_redirects_log_skip\\\\\\/\\\",\\\"categories\\\":[\\\"developer-documentation\\\",\\\"filter-hooks\\\"]},\\\"294047\\\":{\\\"title\\\":\\\"Using the Query Arg Monitoring in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-the-query-arg-monitoring-in-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\"]},\\\"279241\\\":{\\\"title\\\":\\\"How to Schedule a Redirect in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-schedule-a-redirect-in-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"269732\\\":{\\\"title\\\":\\\"Displaying Detailed Author Information on Your Site\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/displaying-detailed-author-information-on-your-site\\\\\\/\\\",\\\"categories\\\":[\\\"author-seo\\\",\\\"content-blocks\\\"]},\\\"267254\\\":{\\\"title\\\":\\\"Adding Author SEO (E-E-A-T) to Your Site\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/adding-author-seo-e-e-a-t-to-your-site\\\\\\/\\\",\\\"categories\\\":[\\\"author-seo\\\"]},\\\"262344\\\":{\\\"title\\\":\\\"How to Get Your Images to Appear in Search Results\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-get-your-images-to-appear-in-search-results\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\",\\\"general-seo-topics\\\",\\\"image-seo\\\"]},\\\"261932\\\":{\\\"title\\\":\\\"Sharing Content on Slack\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/sharing-content-on-slack\\\\\\/\\\",\\\"categories\\\":[\\\"social-networks\\\"]},\\\"261923\\\":{\\\"title\\\":\\\"Sharing Content on WhatsApp\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/sharing-content-on-whatsapp\\\\\\/\\\",\\\"categories\\\":[\\\"social-networks\\\"]},\\\"261517\\\":{\\\"title\\\":\\\"Importing Locations From Other Plugins\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/importing-locations-from-other-plugins\\\\\\/\\\",\\\"categories\\\":[\\\"importer-exporter\\\",\\\"local-business-seo\\\"]},\\\"244975\\\":{\\\"title\\\":\\\"Checking the Index Status of Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/checking-the-index-status-of-content\\\\\\/\\\",\\\"categories\\\":[\\\"post-page-settings\\\",\\\"search-statistics\\\"]},\\\"242346\\\":{\\\"title\\\":\\\"Using AIOSEO Details on the Posts Screen\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-aioseo-details-on-the-posts-screen\\\\\\/\\\",\\\"categories\\\":[\\\"category-tag-settings\\\",\\\"post-page-settings\\\"]},\\\"240583\\\":{\\\"title\\\":\\\"Setting WP_HOME and WP_SITEURL in the wp-config.php File\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-wp_home-and-wp_siteurl-in-the-wp-config-php-file\\\\\\/\\\",\\\"categories\\\":[\\\"troubleshooting\\\"]},\\\"240452\\\":{\\\"title\\\":\\\"Should I Use Meta Keywords?\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/should-i-use-meta-keywords\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\",\\\"general-seo-topics\\\"]},\\\"235044\\\":{\\\"title\\\":\\\"Setting Cornerstone Content in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/cornerstone-content\\\\\\/\\\",\\\"categories\\\":[\\\"link-assistant\\\",\\\"post-page-settings\\\"]},\\\"222363\\\":{\\\"title\\\":\\\"aioseo_get_post_id\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_get_post_id\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"200603\\\":{\\\"title\\\":\\\"Viewing Detailed Search Statistics For Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/viewing-detailed-search-statistics-for-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"search-statistics\\\"]},\\\"200304\\\":{\\\"title\\\":\\\"Tracking Changes to Your SEO Using SEO Revisions\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/tracking-changes-to-your-seo-using-seo-revisions\\\\\\/\\\",\\\"categories\\\":[\\\"seo-revisions\\\"]},\\\"188167\\\":{\\\"title\\\":\\\"WPCode Snippet Library\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/wpcode-snippet-library\\\\\\/\\\",\\\"categories\\\":[\\\"tools\\\"]},\\\"186946\\\":{\\\"title\\\":\\\"aioseo_hide_version_number\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_hide_version_number\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"178887\\\":{\\\"title\\\":\\\"Setting the Primary Term for Breadcrumbs\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-primary-term-for-breadcrumbs\\\\\\/\\\",\\\"categories\\\":[\\\"breadcrumbs\\\"]},\\\"178727\\\":{\\\"title\\\":\\\"Using Broken Link Checker to Find and Fix Broken Links and Images\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-broken-link-checker-to-find-and-fix-broken-links-and-images\\\\\\/\\\",\\\"categories\\\":[\\\"broken-link-checker\\\"]},\\\"163922\\\":{\\\"title\\\":\\\"aioseo_schema_json_flags\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_schema_json_flags\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"163519\\\":{\\\"title\\\":\\\"Using OpenAI to Generate SEO Titles and Meta Descriptions\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-openai-to-generate-seo-titles-and-meta-descriptions\\\\\\/\\\",\\\"categories\\\":[]},\\\"145363\\\":{\\\"title\\\":\\\"Using the Search Statistics in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-the-search-statistics-in-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"google-search-console\\\",\\\"search-statistics\\\"]},\\\"145281\\\":{\\\"title\\\":\\\"Connecting Search Statistics to Google Search Console\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/connecting-search-statistics-to-google-search-console\\\\\\/\\\",\\\"categories\\\":[\\\"google-search-console\\\",\\\"search-statistics\\\"]},\\\"139798\\\":{\\\"title\\\":\\\"Checking Your SEO Using the SEO Preview\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/checking-your-seo-using-the-seo-preview\\\\\\/\\\",\\\"categories\\\":[\\\"facebook-settings\\\",\\\"post-page-settings\\\",\\\"seo-preview\\\",\\\"truseo\\\",\\\"twitter-settings\\\"]},\\\"136509\\\":{\\\"title\\\":\\\"aioseo_sitemap_lastmod_disable\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_sitemap_lastmod_disable\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"135249\\\":{\\\"title\\\":\\\"aioseo_sitemap_rss\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_sitemap_rss\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"133251\\\":{\\\"title\\\":\\\"aioseo_user_profile_tab_disable\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_user_profile_tab_disable\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"131885\\\":{\\\"title\\\":\\\"Setting Web Page Schema Markup in Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-web-page-schema-markup-in-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"129515\\\":{\\\"title\\\":\\\"Editing the .htaccess file Using All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/editing-the-htaccess-file-using-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"file-editor\\\",\\\"tools\\\"]},\\\"124292\\\":{\\\"title\\\":\\\"Using the Emojis in Titles and Descriptions\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-the-emojis-in-titles-and-descriptions\\\\\\/\\\",\\\"categories\\\":[\\\"facebook-settings\\\",\\\"post-page-settings\\\",\\\"search-appearance\\\",\\\"social-networks\\\",\\\"twitter-settings\\\"]},\\\"123164\\\":{\\\"title\\\":\\\"Google Permissions for the AIOSEO Google Search Console Integration\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/google-permissions-for-oauth\\\\\\/\\\",\\\"categories\\\":[\\\"google-search-console\\\",\\\"search-statistics\\\"]},\\\"112137\\\":{\\\"title\\\":\\\"Setting the Schema Type for Individual Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-schema-type-for-individual-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112145\\\":{\\\"title\\\":\\\"Configuring the Schema Settings in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/configuring-the-schema-settings-in-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112153\\\":{\\\"title\\\":\\\"A Guide to Schema.org Markup for Rich Snippets\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/a-guide-to-schema-org-markup-for-rich-snippets\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112438\\\":{\\\"title\\\":\\\"Creating Reusable Schema Templates in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/creating-reusable-schema-templates-in-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112428\\\":{\\\"title\\\":\\\"Creating Custom Schema Markup with All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/creating-custom-schema-markup-with-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112889\\\":{\\\"title\\\":\\\"Setting Event Schema Markup in Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-event-schema-markup-in-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112735\\\":{\\\"title\\\":\\\"Setting Dataset Schema Markup in Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-dataset-schema-markup-in-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112711\\\":{\\\"title\\\":\\\"Setting Article Schema Markup in Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-article-schema-markup-in-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112164\\\":{\\\"title\\\":\\\"Setting Course Schema Markup in Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-course-schema-markup-in-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112933\\\":{\\\"title\\\":\\\"Setting Job Posting Schema Markup in Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-job-posting-schema-markup-in-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112926\\\":{\\\"title\\\":\\\"Setting How-To Schema Markup in Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-how-to-schema-markup-in-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112916\\\":{\\\"title\\\":\\\"Setting Fact Check Schema Markup in Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-fact-check-schema-markup-in-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112727\\\":{\\\"title\\\":\\\"Setting Book Schema Markup in Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-book-schema-markup-in-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112243\\\":{\\\"title\\\":\\\"Setting FAQ Schema Markup in Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-faq-page-schema-markup-in-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112958\\\":{\\\"title\\\":\\\"Setting Service Schema Markup in Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-service-schema-markup-in-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112949\\\":{\\\"title\\\":\\\"Setting Person Schema Markup in Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-person-schema-markup-in-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112944\\\":{\\\"title\\\":\\\"Setting Music Schema Markup in Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-music-schema-markup-in-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112941\\\":{\\\"title\\\":\\\"Setting Movie Schema Markup in Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-movie-schema-markup-in-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112212\\\":{\\\"title\\\":\\\"Setting Recipe Schema Markup in Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-recipe-schema-markup-in-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112962\\\":{\\\"title\\\":\\\"Setting Video Schema Markup in Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-video-schema-markup-in-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112403\\\":{\\\"title\\\":\\\"Testing Your Schema in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/testing-your-schema-in-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112226\\\":{\\\"title\\\":\\\"Setting Software Application Schema Markup in Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-software-application-schema-markup-in-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112197\\\":{\\\"title\\\":\\\"Setting Product Schema Markup in Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-product-schema-markup-in-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"119555\\\":{\\\"title\\\":\\\"How to Use the AIOSEO Feature Manager on a Multisite Network\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-use-the-aioseo-feature-manager-on-a-multisite-network\\\\\\/\\\",\\\"categories\\\":[\\\"feature-manager\\\",\\\"multisite-networks\\\"]},\\\"119550\\\":{\\\"title\\\":\\\"How to Reset the AIOSEO Site Settings on a Multisite Network\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-reset-the-aioseo-site-settings-on-a-multisite-network\\\\\\/\\\",\\\"categories\\\":[\\\"multisite-networks\\\",\\\"network-tools\\\"]},\\\"119543\\\":{\\\"title\\\":\\\"How to Backup and Restore AIOSEO Site Settings on a Multisite Network\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-backup-and-restore-aioseo-site-settings-on-a-multisite-network\\\\\\/\\\",\\\"categories\\\":[\\\"multisite-networks\\\",\\\"network-tools\\\"]},\\\"119531\\\":{\\\"title\\\":\\\"How to Import Settings from Other Plugins on a Multisite Network\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-import-settings-from-other-plugins-on-a-multisite-network\\\\\\/\\\",\\\"categories\\\":[\\\"multisite-networks\\\",\\\"network-tools\\\"]},\\\"119519\\\":{\\\"title\\\":\\\"How to Import and Export AIOSEO Settings and Meta Data on a Multisite Network\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-import-and-export-aioseo-settings-and-meta-data-on-a-multisite-network\\\\\\/\\\",\\\"categories\\\":[\\\"multisite-networks\\\",\\\"network-tools\\\"]},\\\"119497\\\":{\\\"title\\\":\\\"How to Add Your AIOSEO License Key on a WordPress Multisite Network\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-add-your-aioseo-license-key-on-a-wordpress-multisite-network\\\\\\/\\\",\\\"categories\\\":[\\\"multisite-networks\\\",\\\"network-settings\\\"]},\\\"111476\\\":{\\\"title\\\":\\\"Displaying a List of Locations on Your Site\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/displaying-a-list-of-locations-on-your-site\\\\\\/\\\",\\\"categories\\\":[\\\"content-blocks\\\",\\\"local-business-seo\\\"]},\\\"111473\\\":{\\\"title\\\":\\\"Displaying Your Business Location Information on Your Site\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/displaying-your-business-location-information-on-your-site\\\\\\/\\\",\\\"categories\\\":[\\\"content-blocks\\\",\\\"local-business-seo\\\"]},\\\"111459\\\":{\\\"title\\\":\\\"Displaying Opening Hours on Your Site\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/displaying-opening-hours-on-your-site\\\\\\/\\\",\\\"categories\\\":[\\\"content-blocks\\\",\\\"local-business-seo\\\"]},\\\"111455\\\":{\\\"title\\\":\\\"Adding a Map of Your Location to Your Site\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/adding-a-map-of-your-location-to-your-site\\\\\\/\\\",\\\"categories\\\":[\\\"content-blocks\\\",\\\"local-business-seo\\\"]},\\\"111450\\\":{\\\"title\\\":\\\"Adding Breadcrumbs to Your Site Using the AIOSEO Breadcrumbs Block\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/adding-breadcrumbs-to-your-site-using-the-aioseo-breadcrumbs-block\\\\\\/\\\",\\\"categories\\\":[\\\"breadcrumbs\\\",\\\"content-blocks\\\"]},\\\"109878\\\":{\\\"title\\\":\\\"Adding a Redirect When You Delete Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/adding-a-redirect-when-you-delete-content\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"109829\\\":{\\\"title\\\":\\\"Redirecting 404 Content Not Found Using All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/redirecting-404-content-not-found-using-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"109916\\\":{\\\"title\\\":\\\"Using the Image SEO Features in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-the-image-seo-features-in-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"image-seo\\\"]},\\\"104857\\\":{\\\"title\\\":\\\"Adding a Table of Contents to Your Site Using All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/adding-a-table-of-contents-to-your-site-using-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"content-blocks\\\"]},\\\"104616\\\":{\\\"title\\\":\\\"Adding FAQs to Your Site Using All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/adding-faqs-to-your-site-using-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"content-blocks\\\"]},\\\"104595\\\":{\\\"title\\\":\\\"Automatic Redirects When Changing the Post Slug\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/automatic-redirects-when-changing-the-post-slug\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"103415\\\":{\\\"title\\\":\\\"Removing Published Date from Article Schema\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/removing-published-date-from-article-schema\\\\\\/\\\",\\\"categories\\\":[\\\"developer-documentation\\\"]},\\\"101250\\\":{\\\"title\\\":\\\"Outputting AIOSEO\'s data in the HEAD without using wp_head()\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/outputting-aioseos-data-in-the-head-without-using-wp_head\\\\\\/\\\",\\\"categories\\\":[\\\"developer-documentation\\\"]},\\\"100154\\\":{\\\"title\\\":\\\"Automatic Redirects When You Delete Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/automatic-redirects-when-you-delete-content\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"98532\\\":{\\\"title\\\":\\\"Localizing AIOSEO Data via the Translations API\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/localizing-aioseo-data-via-the-translations-api\\\\\\/\\\",\\\"categories\\\":[\\\"developer-documentation\\\"]},\\\"98576\\\":{\\\"title\\\":\\\"aioseo_sitemap_term\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_sitemap_term\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"98575\\\":{\\\"title\\\":\\\"aioseo_sitemap_post\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_sitemap_post\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"98566\\\":{\\\"title\\\":\\\"aioseo_save_term\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_save_term\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"98565\\\":{\\\"title\\\":\\\"aioseo_save_post\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_save_post\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"98557\\\":{\\\"title\\\":\\\"aioseo_get_term\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_get_term\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"98554\\\":{\\\"title\\\":\\\"aioseo_get_post\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_get_post\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"93967\\\":{\\\"title\\\":\\\"Importing URLs into the XML Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/importing-urls-into-the-xml-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"xml-sitemap\\\"]},\\\"93822\\\":{\\\"title\\\":\\\"How to Use Crawl Cleanup to Increase Search Engine Crawl Quota\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/crawl-cleanup-best-practices\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\"]},\\\"90584\\\":{\\\"title\\\":\\\"How to Add a Temporary Administrator Login to Your Site\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-add-a-temporary-administrator-login-to-your-site\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\",\\\"troubleshooting\\\"]},\\\"88927\\\":{\\\"title\\\":\\\"Dashboard Widgets in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/dashboard-widgets-in-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"dashboard\\\"]},\\\"86198\\\":{\\\"title\\\":\\\"How to Strip the Category Base in WordPress\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-strip-the-category-base-in-wordpress\\\\\\/\\\",\\\"categories\\\":[\\\"category-tag-settings\\\"]},\\\"84322\\\":{\\\"title\\\":\\\"Running shortcodes in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/running-shortcodes\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\"]},\\\"84156\\\":{\\\"title\\\":\\\"Translating Your SEO with WPML\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/translating-your-seo-with-wpml\\\\\\/\\\",\\\"categories\\\":[\\\"post-page-settings\\\"]},\\\"80219\\\":{\\\"title\\\":\\\"How to Verify Your Site with Microsoft Clarity\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-verify-your-site-with-microsoft-clarity\\\\\\/\\\",\\\"categories\\\":[\\\"webmaster-tools\\\"]},\\\"79928\\\":{\\\"title\\\":\\\"How to Handle Issues With Installing All in One SEO Pro\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-handle-issues-with-installing-all-in-one-seo-pro\\\\\\/\\\",\\\"categories\\\":[\\\"installation\\\"]},\\\"79149\\\":{\\\"title\\\":\\\"Fetching &amp; Updating AIOSEO Data via the WordPress REST API\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/fetching-updating-aioseo-data-via-the-wordpress-rest-api\\\\\\/\\\",\\\"categories\\\":[\\\"developer-documentation\\\",\\\"rest-api\\\"]},\\\"77593\\\":{\\\"title\\\":\\\"How To Fix JavaScript Errors\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-fix-javascript-errors\\\\\\/\\\",\\\"categories\\\":[\\\"troubleshooting\\\"]},\\\"77589\\\":{\\\"title\\\":\\\"Browser Support Policy\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/browser-support-policy\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\"]},\\\"75143\\\":{\\\"title\\\":\\\"How to Redirect a Post from the Edit Post Screen\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-redirect-a-post-from-the-edit-post-screen\\\\\\/\\\",\\\"categories\\\":[\\\"post-page-settings\\\",\\\"redirection-manager\\\"]},\\\"75686\\\":{\\\"title\\\":\\\"Preventing the Modified Date for Content from Changing\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/preventing-the-modified-date-for-content-from-changing\\\\\\/\\\",\\\"categories\\\":[\\\"post-page-settings\\\"]},\\\"73002\\\":{\\\"title\\\":\\\"Page Builder Integrations\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/page-builder-integrations\\\\\\/\\\",\\\"categories\\\":[\\\"home-page-settings\\\",\\\"post-page-settings\\\",\\\"third-party-integrations\\\",\\\"truseo\\\"]},\\\"73003\\\":{\\\"title\\\":\\\"Integrating with IndexNow to Instantly Re-index Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/integrating-with-indexnow-to-instantly-re-index-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"indexnow\\\",\\\"webmaster-tools\\\"]},\\\"72711\\\":{\\\"title\\\":\\\"aioseo_page_builder_integration_disable\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_page_builder_integration_disable\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"68444\\\":{\\\"title\\\":\\\"An Introduction to Link Assistant \\\\u2014 The Easy Way to Manage Onsite Links\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/introduction-to-link-assistant\\\\\\/\\\",\\\"categories\\\":[\\\"link-assistant\\\"]},\\\"69559\\\":{\\\"title\\\":\\\"Using the Link Assistant in All in One SEO Pro\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/link-assistant\\\\\\/\\\",\\\"categories\\\":[\\\"link-assistant\\\"]},\\\"69594\\\":{\\\"title\\\":\\\"Internal Links in the Links Report in Link Assistant\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/internal-links-in-the-links-report-in-link-assistant\\\\\\/\\\",\\\"categories\\\":[\\\"link-assistant\\\"]},\\\"69596\\\":{\\\"title\\\":\\\"External Links in the Links Report in Link Assistant\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/external-links-in-the-links-report-in-link-assistant\\\\\\/\\\",\\\"categories\\\":[\\\"link-assistant\\\"]},\\\"69921\\\":{\\\"title\\\":\\\"Link Suggestions in the Links Report in Link Assistant\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/link-suggestions-in-the-links-report-in-link-assistant\\\\\\/\\\",\\\"categories\\\":[\\\"link-assistant\\\"]},\\\"69602\\\":{\\\"title\\\":\\\"Affiliate Links in the Links Report in Link Assistant\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/affiliate-links-in-the-links-report-in-link-assistant\\\\\\/\\\",\\\"categories\\\":[\\\"link-assistant\\\"]},\\\"69761\\\":{\\\"title\\\":\\\"Using the Domains Report in Link Assistant\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-the-domains-report-in-link-assistant\\\\\\/\\\",\\\"categories\\\":[\\\"link-assistant\\\"]},\\\"69770\\\":{\\\"title\\\":\\\"Link Assistant Settings\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/link-assistant-settings\\\\\\/\\\",\\\"categories\\\":[\\\"link-assistant\\\"]},\\\"68431\\\":{\\\"title\\\":\\\"aioseo_sitemap_images\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_sitemap_images\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"66833\\\":{\\\"title\\\":\\\"Why Is N\\\\\\/A Displayed Instead of a Score For My Content?\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/why-is-na-displayed-instead-of-a-score-for-my-content\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\",\\\"truseo\\\"]},\\\"18824\\\":{\\\"title\\\":\\\"Local Business SEO for a Single Location\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/local-business-seo-for-a-single-location\\\\\\/\\\",\\\"categories\\\":[\\\"local-business-seo\\\",\\\"schema-settings\\\"]},\\\"35828\\\":{\\\"title\\\":\\\"Local Business SEO for Multiple Locations\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/local-business-seo-for-multiple-locations\\\\\\/\\\",\\\"categories\\\":[\\\"local-business-seo\\\"]},\\\"58476\\\":{\\\"title\\\":\\\"aioseo_public_taxonomies\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_public_taxonomies\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"58475\\\":{\\\"title\\\":\\\"aioseo_public_post_types\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_public_post_types\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"64776\\\":{\\\"title\\\":\\\"How Long Does it Take For My Content to Appear on Google?\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-long-does-it-take-for-my-content-to-appear-on-google\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\"]},\\\"35926\\\":{\\\"title\\\":\\\"Adding a Location in Local SEO Addon\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/adding-a-location-in-local-seo-addon\\\\\\/\\\",\\\"categories\\\":[\\\"local-business-seo\\\"]},\\\"61020\\\":{\\\"title\\\":\\\"How to Display a Favicon in Search Results\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-display-a-favicon-in-search-results\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\",\\\"general-seo-topics\\\"]},\\\"35956\\\":{\\\"title\\\":\\\"Displaying Locations on Your Site\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/displaying-locations-on-your-site\\\\\\/\\\",\\\"categories\\\":[\\\"local-business-seo\\\"]},\\\"56330\\\":{\\\"title\\\":\\\"aioseo_sitemap_indexes\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_sitemap_indexes\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"56011\\\":{\\\"title\\\":\\\"Redirect Manager - Configuration Reload\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/redirect-manager-configuration-reload\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"52689\\\":{\\\"title\\\":\\\"aioseo_flyout_menu_enable\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_flyout_menu_disable\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"45698\\\":{\\\"title\\\":\\\"Displaying your Business Information and Star Ratings on a Map\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-places-on-your-maps\\\\\\/\\\",\\\"categories\\\":[\\\"local-business-seo\\\"]},\\\"49268\\\":{\\\"title\\\":\\\"aioseo_access_control_excluded_roles\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_access_control_excluded_roles\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"44555\\\":{\\\"title\\\":\\\"Setting up Google Maps for Local SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-up-google-maps\\\\\\/\\\",\\\"categories\\\":[\\\"local-business-seo\\\"]},\\\"48189\\\":{\\\"title\\\":\\\"How to Create an HTML Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/html-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"html-sitemap\\\"]},\\\"48365\\\":{\\\"title\\\":\\\"Using a Widget to Display Your HTML Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-a-widget-to-display-your-html-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"html-sitemap\\\"]},\\\"48361\\\":{\\\"title\\\":\\\"Using PHP Code to Display Your HTML Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/function-html-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"html-sitemap\\\"]},\\\"48260\\\":{\\\"title\\\":\\\"Using a Block to Display Your HTML Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-a-block-to-display-your-html-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"content-blocks\\\",\\\"html-sitemap\\\"]},\\\"48222\\\":{\\\"title\\\":\\\"aioseo_breadcrumbs_separator_symbol\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_breadcrumbs_separator_symbol\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"48227\\\":{\\\"title\\\":\\\"aioseo_breadcrumbs_template\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_breadcrumbs_template\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"48231\\\":{\\\"title\\\":\\\"aioseo_breadcrumbs_trail\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_breadcrumbs_trail\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"48232\\\":{\\\"title\\\":\\\"aioseo_breadcrumbs_link_current_item\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_breadcrumbs_link_current_item\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"48233\\\":{\\\"title\\\":\\\"aioseo_breadcrumbs_show_current_item\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_breadcrumbs_show_current_item\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"48219\\\":{\\\"title\\\":\\\"aioseo_breadcrumbs_output\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_breadcrumbs_output\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"48223\\\":{\\\"title\\\":\\\"aioseo_breadcrumbs_separator\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_breadcrumbs_separator\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"48238\\\":{\\\"title\\\":\\\"Using a Shortcode to Display Your HTML Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/shortcode-html-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"html-sitemap\\\"]},\\\"45805\\\":{\\\"title\\\":\\\"aioseo_sitemap_exclude_terms\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_sitemap_exclude_terms\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"45804\\\":{\\\"title\\\":\\\"aioseo_sitemap_exclude_posts\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_sitemap_exclude_posts\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"61002\\\":{\\\"title\\\":\\\"How to Create a Google Maps API Key\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-create-a-google-maps-api-key\\\\\\/\\\",\\\"categories\\\":[\\\"local-business-seo\\\"]},\\\"45528\\\":{\\\"title\\\":\\\"aioseo_schema_output\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_schema_output\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"42995\\\":{\\\"title\\\":\\\"Using the Headline Analyzer in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-the-headline-analyzer-in-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"headline-analyzer\\\"]},\\\"42683\\\":{\\\"title\\\":\\\"How to Perform a Full Site Redirect\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/full-site-redirects\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"50988\\\":{\\\"title\\\":\\\"Displaying Maps on Your Site\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/displaying-maps-on-your-site\\\\\\/\\\",\\\"categories\\\":[\\\"local-business-seo\\\"]},\\\"42999\\\":{\\\"title\\\":\\\"How to Disable the Headline Analyzer\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-disable-the-headline-analyzer\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\",\\\"headline-analyzer\\\"]},\\\"42975\\\":{\\\"title\\\":\\\"Installing Addons for All in One SEO Pro\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/installing-addons-for-all-in-one-seo-pro\\\\\\/\\\",\\\"categories\\\":[\\\"installation\\\"]},\\\"42854\\\":{\\\"title\\\":\\\"Creating a Pass Through Redirect\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/creating-a-pass-through-redirect\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"41800\\\":{\\\"title\\\":\\\"Using Custom Rules in the Redirection Manager\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/redirection-manager-custom-rules\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"42224\\\":{\\\"title\\\":\\\"Resetting the Settings in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/resetting-the-settings-in-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"database-tools\\\",\\\"tools\\\"]},\\\"41884\\\":{\\\"title\\\":\\\"Setting the Site Name for Facebook\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-site-name-for-facebook\\\\\\/\\\",\\\"categories\\\":[\\\"facebook-settings\\\",\\\"social-networks\\\"]},\\\"41862\\\":{\\\"title\\\":\\\"How to Get Google to Display the Sitelinks Search Box\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-get-google-to-display-the-sitelinks-search-box\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"41851\\\":{\\\"title\\\":\\\"Setting the SEO Title and Description Format for the Search Results Page\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-seo-title-and-description-format-for-the-search-results-page\\\\\\/\\\",\\\"categories\\\":[\\\"content-type-settings\\\",\\\"search-appearance\\\"]},\\\"41811\\\":{\\\"title\\\":\\\"SEO Analysis Unable to Connect to Your Site\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/seo-analysis-unable-to-connect-to-your-site\\\\\\/\\\",\\\"categories\\\":[\\\"seo-analysis\\\",\\\"troubleshooting\\\"]},\\\"41280\\\":{\\\"title\\\":\\\"How to Renew Your AIOSEO License\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-renew-your-aioseo-license\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\",\\\"getting-started\\\"]},\\\"41077\\\":{\\\"title\\\":\\\"Update WordPress: WordPress Versions Supported by AIOSEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/update-wordpress\\\\\\/\\\",\\\"categories\\\":[\\\"troubleshooting\\\"]},\\\"40587\\\":{\\\"title\\\":\\\"How to Open the Browser Error Console\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-open-the-browser-error-console\\\\\\/\\\",\\\"categories\\\":[\\\"troubleshooting\\\"]},\\\"40582\\\":{\\\"title\\\":\\\"How to Enable Debugging in WordPress\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-enable-debugging-in-wordpress\\\\\\/\\\",\\\"categories\\\":[\\\"troubleshooting\\\"]},\\\"40148\\\":{\\\"title\\\":\\\"What is TruSEO?\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/what-is-truseo\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\",\\\"truseo\\\"]},\\\"39494\\\":{\\\"title\\\":\\\"Redirecting Attachment Pages\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/redirecting-attachment-pages\\\\\\/\\\",\\\"categories\\\":[\\\"media-settings\\\",\\\"search-appearance\\\"]},\\\"66310\\\":{\\\"title\\\":\\\"Selecting the Google Maps APIs to use with All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/selecting-the-google-maps-apis-to-use-with-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"local-business-seo\\\"]},\\\"38915\\\":{\\\"title\\\":\\\"Setting Up and Using Breadcrumbs Templates\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-up-and-using-breadcrumbs-templates\\\\\\/\\\",\\\"categories\\\":[\\\"breadcrumbs\\\"]},\\\"38610\\\":{\\\"title\\\":\\\"Displaying Breadcrumbs On Your Site\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/displaying-breadcrumbs-on-your-site\\\\\\/\\\",\\\"categories\\\":[\\\"breadcrumbs\\\"]},\\\"36048\\\":{\\\"title\\\":\\\"Function: aioseo_breadcrumbs()\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/function-aioseo_breadcrumbs\\\\\\/\\\",\\\"categories\\\":[\\\"breadcrumbs\\\"]},\\\"36047\\\":{\\\"title\\\":\\\"Shortcode: [aioseo_breadcrumbs]\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/shortcode-aioseo_breadcrumbs\\\\\\/\\\",\\\"categories\\\":[\\\"breadcrumbs\\\"]},\\\"38240\\\":{\\\"title\\\":\\\"aioseo_social_image_ignore_cover_block\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_social_image_ignore_cover_block\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"34923\\\":{\\\"title\\\":\\\"How to Redirect a Post or Page in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-redirect-a-post-or-page-in-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"34977\\\":{\\\"title\\\":\\\"How to Redirect Multiple URLs to the Same Destination\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-redirect-multiple-urls-to-the-same-destination\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"35604\\\":{\\\"title\\\":\\\"Automatic Redirects When URLs Change in Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/automatic-redirects-when-urls-change-in-content\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"31460\\\":{\\\"title\\\":\\\"Enhanced Search Query Conflict\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/enhanced-search-query-conflict\\\\\\/\\\",\\\"categories\\\":[\\\"local-business-seo\\\"]},\\\"30850\\\":{\\\"title\\\":\\\"aioseo_local_business_info_email_icon\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_local_business_info_email_icon\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"30839\\\":{\\\"title\\\":\\\"aioseo_local_business_info_location_icon\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_local_business_info_location_icon\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"30759\\\":{\\\"title\\\":\\\"aioseo_local_business_output_business_info_instance\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_local_business_output_business_info_instance\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"30760\\\":{\\\"title\\\":\\\"aioseo_local_business_output_business_info_location_data\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_local_business_output_business_info_location_data\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"30765\\\":{\\\"title\\\":\\\"aioseo_local_business_output_opening_hours_instance\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_local_business_output_opening_hours_instance\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"30766\\\":{\\\"title\\\":\\\"aioseo_local_business_output_opening_hours_data\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_local_business_output_opening_hours_data\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"30849\\\":{\\\"title\\\":\\\"aioseo_local_business_info_phone_icon\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_local_business_info_phone_icon\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"30851\\\":{\\\"title\\\":\\\"aioseo_local_business_opening_hours_icon\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_local_business_opening_hours_icon\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"30398\\\":{\\\"title\\\":\\\"aioseo_local_business_post_type_name\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_local_business_post_type_name\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"30551\\\":{\\\"title\\\":\\\"aioseo_local_business_post_type_slug\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_local_business_post_type_slug\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"30556\\\":{\\\"title\\\":\\\"aioseo_local_business_post_type_single_label\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_local_business_post_type_single_label\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"30559\\\":{\\\"title\\\":\\\"aioseo_local_business_post_type_plural_label\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_local_business_post_type_plural_label\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"30560\\\":{\\\"title\\\":\\\"aioseo_local_business_post_type\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_local_business_post_type\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"30563\\\":{\\\"title\\\":\\\"aioseo_local_business_taxonomy_name\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_local_business_taxonomy_name\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"30564\\\":{\\\"title\\\":\\\"aioseo_local_business_taxonomy_slug\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_local_business_taxonomy_slug\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"35609\\\":{\\\"title\\\":\\\"Choosing Which Redirect Type to Use\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/choosing-which-redirect-type-to-use\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"35599\\\":{\\\"title\\\":\\\"Importing Redirects From Other Plugins\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/importing-redirects-from-other-plugins\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"35588\\\":{\\\"title\\\":\\\"Exporting and Importing Redirects\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/exporting-and-importing-redirects\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"35579\\\":{\\\"title\\\":\\\"Logging 404 Errors in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/logging-404-errors-in-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"35552\\\":{\\\"title\\\":\\\"Logging Redirects in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/logging-redirects-in-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"35570\\\":{\\\"title\\\":\\\"Redirect GDPR Privacy Information\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/redirect-gdpr-privacy-information\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"30863\\\":{\\\"title\\\":\\\"Local Business SEO - Template overrides\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/local-business-seo-template-overrides\\\\\\/\\\",\\\"categories\\\":[\\\"local-business-seo\\\"]},\\\"35133\\\":{\\\"title\\\":\\\"aioseo_twitter_tags\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_twitter_tags\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"35132\\\":{\\\"title\\\":\\\"aioseo_facebook_tags\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_facebook_tags\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"34993\\\":{\\\"title\\\":\\\"Ignoring Case Sensitivity in Redirects\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/ignoring-case-sensitivity-in-redirects\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"34983\\\":{\\\"title\\\":\\\"Ignoring the Trailing Slash in Redirects\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/ignoring-the-trailing-slash-in-redirects\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"36104\\\":{\\\"title\\\":\\\"Using Query Parameters With Redirects\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-query-parameters-with-redirects\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"30565\\\":{\\\"title\\\":\\\"aioseo_local_business_taxonomy\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_local_business_taxonomy\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"36115\\\":{\\\"title\\\":\\\"Caching of Redirects in the Browser\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/caching-of-redirects-in-the-browser\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"34701\\\":{\\\"title\\\":\\\"Adding WooCommerce Product Attributes to SEO Title or Description\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/adding-woocommerce-product-attributes-to-seo-title-or-description\\\\\\/\\\",\\\"categories\\\":[\\\"post-page-settings\\\",\\\"search-appearance\\\",\\\"woocommerce\\\"]},\\\"36111\\\":{\\\"title\\\":\\\"Selecting the Redirect Method in Redirects\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/selecting-the-redirect-method-in-redirects\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"40115\\\":{\\\"title\\\":\\\"Redirect Manager Cannot Detect Your Server\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/redirect-manager-unknown-web-server\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"36369\\\":{\\\"title\\\":\\\"Using Regex in the Redirection Manager\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/redirect-manager-regex\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"31442\\\":{\\\"title\\\":\\\"Shortcode: [aioseo_local_opening_hours]\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/shortcode-aioseo_local_opening_hours\\\\\\/\\\",\\\"categories\\\":[\\\"local-business-seo\\\"]},\\\"31443\\\":{\\\"title\\\":\\\"Shortcode: [aioseo_local_locations]\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/shortcode-aioseo_local_locations\\\\\\/\\\",\\\"categories\\\":[\\\"local-business-seo\\\"]},\\\"34179\\\":{\\\"title\\\":\\\"Using the Smart Tags in Titles and Descriptions\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-the-smart-tags-in-titles-and-descriptions\\\\\\/\\\",\\\"categories\\\":[\\\"post-page-settings\\\",\\\"search-appearance\\\"]},\\\"31441\\\":{\\\"title\\\":\\\"Shortcode: [aioseo_local_business_info]\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/shortcode-aioseo_local_business_info\\\\\\/\\\",\\\"categories\\\":[\\\"local-business-seo\\\"]},\\\"46122\\\":{\\\"title\\\":\\\"Shortcode: [aioseo_local_map]\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/shortcode-aioseo_local_map\\\\\\/\\\",\\\"categories\\\":[\\\"local-business-seo\\\"]},\\\"33507\\\":{\\\"title\\\":\\\"What\'s The Difference Between TruSEO and Page Analysis?\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/whats-the-difference-between-truseo-and-page-analysis\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\",\\\"post-page-settings\\\",\\\"truseo\\\"]},\\\"33310\\\":{\\\"title\\\":\\\"Setting Noindex for RSS Feeds\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-noindex-for-rss-feeds\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\",\\\"search-appearance\\\"]},\\\"33130\\\":{\\\"title\\\":\\\"aioseo_disable_shortcode_parsing\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_disable_shortcode_parsing\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"32085\\\":{\\\"title\\\":\\\"aioseo_conflicting_shortcodes\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_conflicting_shortcodes\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"31992\\\":{\\\"title\\\":\\\"aioseo_schema_graphs\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_schema_graphs\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"31589\\\":{\\\"title\\\":\\\"Understanding the TruSEO Page Analysis Recommendations\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/understanding-the-truseo-page-analysis-recommendations\\\\\\/\\\",\\\"categories\\\":[\\\"post-page-settings\\\",\\\"truseo\\\"]},\\\"31456\\\":{\\\"title\\\":\\\"Function: aioseo_local_locations()\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/function-aioseo_local_locations\\\\\\/\\\",\\\"categories\\\":[\\\"local-business-seo\\\"]},\\\"31455\\\":{\\\"title\\\":\\\"Function: aioseo_local_opening_hours()\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/function-aioseo_local_opening_hours\\\\\\/\\\",\\\"categories\\\":[\\\"local-business-seo\\\"]},\\\"31451\\\":{\\\"title\\\":\\\"Function: aioseo_local_business_info()\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/function-aioseo_local_business_info\\\\\\/\\\",\\\"categories\\\":[\\\"local-business-seo\\\"]},\\\"46123\\\":{\\\"title\\\":\\\"Function: aioseo_local_map()\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/function-aioseo_local_map\\\\\\/\\\",\\\"categories\\\":[\\\"local-business-seo\\\"]},\\\"31042\\\":{\\\"title\\\":\\\"Getting Keyphrase Suggestions From Semrush\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/getting-keyphrase-suggestions-from-semrush\\\\\\/\\\",\\\"categories\\\":[\\\"post-page-settings\\\",\\\"truseo\\\"]},\\\"30773\\\":{\\\"title\\\":\\\"aioseo_local_business_address_tag_value\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_local_business_address_tag_value\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"30770\\\":{\\\"title\\\":\\\"aioseo_local_business_address_tags\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_local_business_address_tags\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"30752\\\":{\\\"title\\\":\\\"aioseo_local_business_get_location\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_local_business_get_location\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"30728\\\":{\\\"title\\\":\\\"Unable to Save Settings Due to Cloudflare Firewall Rules\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/unable-to-save-settings-due-to-cloudflare-firewall-rules\\\\\\/\\\",\\\"categories\\\":[\\\"troubleshooting\\\"]},\\\"30318\\\":{\\\"title\\\":\\\"aioseo_flush_output_buffer\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_flush_output_buffer\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"18813\\\":{\\\"title\\\":\\\"Installing All in One SEO Pro\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/installing-all-in-one-seo-pro\\\\\\/\\\",\\\"categories\\\":[\\\"getting-started\\\",\\\"installation\\\"]},\\\"18973\\\":{\\\"title\\\":\\\"Beginners Guide for All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/quick-start-guide\\\\\\/\\\",\\\"categories\\\":[\\\"getting-started\\\"]},\\\"18820\\\":{\\\"title\\\":\\\"Setting the SEO Title and Description for Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-seo-title-and-description-for-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"getting-started\\\",\\\"post-page-settings\\\"]},\\\"18902\\\":{\\\"title\\\":\\\"How to Create an XML Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-create-an-xml-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"getting-started\\\",\\\"xml-sitemap\\\"]},\\\"18859\\\":{\\\"title\\\":\\\"Beginners Guide to Social Networks Settings for Facebook\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/beginners-guide-to-social-networks-settings-for-facebook\\\\\\/\\\",\\\"categories\\\":[\\\"facebook-settings\\\",\\\"getting-started\\\",\\\"social-networks\\\"]},\\\"18857\\\":{\\\"title\\\":\\\"Beginners Guide to Social Networks Settings for Twitter\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/beginners-guide-to-social-networks-settings-for-twitter\\\\\\/\\\",\\\"categories\\\":[\\\"getting-started\\\",\\\"social-networks\\\",\\\"twitter-settings\\\"]},\\\"29991\\\":{\\\"title\\\":\\\"aioseo_disable_link_format\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_disable_link_format\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"27841\\\":{\\\"title\\\":\\\"aioseo_thumbnail_size\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_thumbnail_size\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"27844\\\":{\\\"title\\\":\\\"Displaying Additional Data for Written By and Reading Time\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/displaying-additional-data-for-written-by-and-reading-time\\\\\\/\\\",\\\"categories\\\":[\\\"social-networks\\\"]},\\\"27494\\\":{\\\"title\\\":\\\"aioseo_meta_views\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_meta_views\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"27363\\\":{\\\"title\\\":\\\"Using the SEO Analysis Tool\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-the-seo-analysis-tool\\\\\\/\\\",\\\"categories\\\":[\\\"seo-analysis\\\"]},\\\"27272\\\":{\\\"title\\\":\\\"Importing Settings From Other Plugins\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/importing-settings-from-other-plugins\\\\\\/\\\",\\\"categories\\\":[\\\"importer-exporter\\\",\\\"seo-data-importer\\\",\\\"tools\\\"]},\\\"27268\\\":{\\\"title\\\":\\\"Backing Up and Restoring AIOSEO Settings\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/backing-up-and-restoring-aioseo-settings\\\\\\/\\\",\\\"categories\\\":[\\\"importer-exporter\\\",\\\"tools\\\"]},\\\"27259\\\":{\\\"title\\\":\\\"Importing and Exporting AIOSEO Settings and Meta Data\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/importing-and-exporting-aioseo-settings-and-meta-data\\\\\\/\\\",\\\"categories\\\":[\\\"importer-exporter\\\",\\\"tools\\\"]},\\\"26450\\\":{\\\"title\\\":\\\"Blank Title Formats Have Been Detected\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/blank-title-formats-detected\\\\\\/\\\",\\\"categories\\\":[\\\"troubleshooting\\\"]},\\\"25802\\\":{\\\"title\\\":\\\"aioseo_sitemap_additional_pages\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_sitemap_additional_pages\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"24928\\\":{\\\"title\\\":\\\"Including Custom Fields in the TruSEO Page Analysis\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/including-custom-fields-in-the-seo-page-analysis\\\\\\/\\\",\\\"categories\\\":[\\\"content-type-settings\\\",\\\"search-appearance\\\",\\\"truseo\\\"]},\\\"24285\\\":{\\\"title\\\":\\\"aioseo_prev_link\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_prev_link\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"24284\\\":{\\\"title\\\":\\\"aioseo_next_link\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_next_link\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"23717\\\":{\\\"title\\\":\\\"aioseo_canonical_url\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_canonical_url\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"23604\\\":{\\\"title\\\":\\\"aioseo_schema_breadcrumbs_home\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_schema_breadcrumbs_home\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"23448\\\":{\\\"title\\\":\\\"aioseo_schema_disable\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_schema_disable\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"23447\\\":{\\\"title\\\":\\\"aioseo_robots_meta\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_robots_meta\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"23446\\\":{\\\"title\\\":\\\"aioseo_disable\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_disable\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"23438\\\":{\\\"title\\\":\\\"aioseo_disable_title_rewrites\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_disable_title_rewrites\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"23437\\\":{\\\"title\\\":\\\"aioseo_post_metabox_priority\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_post_metabox_priority\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"23436\\\":{\\\"title\\\":\\\"aioseo_show_seo_news\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_show_seo_news\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"23433\\\":{\\\"title\\\":\\\"aioseo_show_in_admin_bar\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_show_in_admin_bar\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"23423\\\":{\\\"title\\\":\\\"aioseo_keywords\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_keywords\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"23350\\\":{\\\"title\\\":\\\"aioseo_title\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_title\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"23351\\\":{\\\"title\\\":\\\"aioseo_description\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_description\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"23415\\\":{\\\"title\\\":\\\"Troubleshooting Action Scheduler issues with AIOSEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/troubleshooting-action-scheduler-issues\\\\\\/\\\",\\\"categories\\\":[\\\"troubleshooting\\\"]},\\\"20504\\\":{\\\"title\\\":\\\"Where Did my SEO Keywords go in All in One SEO v4.0?\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/where-did-my-seo-keywords-go-in-all-in-one-seo-v4-0\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\",\\\"frequently-asked-questions\\\",\\\"post-page-settings\\\",\\\"search-appearance\\\"]},\\\"18792\\\":{\\\"title\\\":\\\"Sitemap rewrite rules for NGINX\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/xml-sitemap-rewrite-rules-for-nginx\\\\\\/\\\",\\\"categories\\\":[\\\"rss-sitemap\\\",\\\"video-sitemap\\\",\\\"xml-sitemap\\\"]},\\\"18793\\\":{\\\"title\\\":\\\"Unfiltered HTML Capability is Required\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/unfiltered-html-capability\\\\\\/\\\",\\\"categories\\\":[\\\"troubleshooting\\\"]},\\\"18794\\\":{\\\"title\\\":\\\"Deprecated Open Graph Settings in All in One SEO version 4.0\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/deprecated-opengraph-settings\\\\\\/\\\",\\\"categories\\\":[\\\"social-networks\\\"]},\\\"18795\\\":{\\\"title\\\":\\\"Why does the character counter for SEO titles show a different count?\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/why-does-the-character-counter-for-seo-titles-show-a-different-count\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\",\\\"post-page-settings\\\"]},\\\"18796\\\":{\\\"title\\\":\\\"Adding nofollow, sponsored, UGC and title attributes to links\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/adding-nofollow-sponsored-and-title-attributes-to-links\\\\\\/\\\",\\\"categories\\\":[\\\"post-page-settings\\\"]},\\\"18797\\\":{\\\"title\\\":\\\"Setting the SEO for WooCommerce Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-seo-for-woocommerce-content\\\\\\/\\\",\\\"categories\\\":[\\\"search-appearance\\\",\\\"woocommerce\\\"]},\\\"18798\\\":{\\\"title\\\":\\\"All in One SEO uses the WordPress REST API\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo-uses-rest-api\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\"]},\\\"18799\\\":{\\\"title\\\":\\\"How to Remove All Settings and Data When you Uninstall All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-remove-all-settings-and-data-when-you-uninstall-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\",\\\"general-settings\\\"]},\\\"18800\\\":{\\\"title\\\":\\\"How to Disable TruSEO Content Analysis\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-disable-truseo-content-analysis\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\",\\\"general-settings\\\",\\\"truseo\\\"]},\\\"18801\\\":{\\\"title\\\":\\\"Enabling Automatic Updates for All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/enabling-automatic-updates-for-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\",\\\"general-settings\\\"]},\\\"18802\\\":{\\\"title\\\":\\\"Hiding Plugin Notifications in the Notifications Center\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/hiding-plugin-notifications-in-the-notifications-center\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\",\\\"general-settings\\\"]},\\\"18803\\\":{\\\"title\\\":\\\"How to Hide the AIOSEO Settings on the Edit Content Screens in WordPress\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-hide-the-aioseo-settings-on-the-edit-content-screens-in-wordpress\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\",\\\"content-type-settings\\\",\\\"post-page-settings\\\",\\\"search-appearance\\\"]},\\\"18804\\\":{\\\"title\\\":\\\"Setting Noindex and Nofollow on Paginated Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-noindex-and-nofollow-on-paginated-content\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\",\\\"search-appearance\\\"]},\\\"18805\\\":{\\\"title\\\":\\\"Setting Unique SEO Titles and Descriptions for Paginated Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-unique-seo-titles-and-descriptions-for-paginated-content\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\",\\\"search-appearance\\\"]},\\\"18806\\\":{\\\"title\\\":\\\"Setting the SEO Title and Description Format for Custom Post Type Archives\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-seo-title-and-description-format-for-custom-post-type-archives\\\\\\/\\\",\\\"categories\\\":[\\\"archive-settings\\\",\\\"search-appearance\\\"]},\\\"18807\\\":{\\\"title\\\":\\\"Meta Keyword Settings in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/keyword-settings\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\",\\\"search-appearance\\\"]},\\\"18808\\\":{\\\"title\\\":\\\"Using the Quick Edit Feature in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-the-quick-edit-feature-in-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"post-page-settings\\\"]},\\\"18809\\\":{\\\"title\\\":\\\"How to FTP to your web server\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-ftp-to-your-web-server\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\"]},\\\"18810\\\":{\\\"title\\\":\\\"How to manually install All in One SEO Pro when the file is too big\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-manually-install-all-in-one-seo-pro-when-the-file-is-too-big\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\",\\\"installation\\\"]},\\\"18811\\\":{\\\"title\\\":\\\"How to Upgrade From All in One SEO Lite to Pro\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-upgrade-from-all-in-one-seo-lite-to-pro\\\\\\/\\\",\\\"categories\\\":[\\\"getting-started\\\",\\\"installation\\\"]},\\\"18812\\\":{\\\"title\\\":\\\"Installation instructions for WordPress.com Users\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/installation-instructions-for-wordpress-com-users\\\\\\/\\\",\\\"categories\\\":[\\\"installation\\\"]},\\\"18814\\\":{\\\"title\\\":\\\"Configuring the Twitter Settings for Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/configuring-the-twitter-settings-for-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"post-page-settings\\\",\\\"social-networks\\\",\\\"twitter-settings\\\"]},\\\"18815\\\":{\\\"title\\\":\\\"Configuring the Facebook Settings for Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/configuring-the-facebook-settings-for-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"facebook-settings\\\",\\\"post-page-settings\\\",\\\"social-networks\\\"]},\\\"18816\\\":{\\\"title\\\":\\\"Hiding the AIOSEO Column on Taxonomy Screens\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/hiding-the-aioseo-column-on-taxonomy-screens\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\",\\\"category-tag-settings\\\",\\\"general-settings\\\"]},\\\"18818\\\":{\\\"title\\\":\\\"Setting the Sitemap Priority and Frequency for Individual Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-sitemap-priority-and-frequency-for-individual-content\\\\\\/\\\",\\\"categories\\\":[\\\"post-page-settings\\\",\\\"xml-sitemap\\\"]},\\\"18819\\\":{\\\"title\\\":\\\"Setting the Robots Meta for Individual Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-robots-meta-for-individual-content\\\\\\/\\\",\\\"categories\\\":[\\\"post-page-settings\\\"]},\\\"18821\\\":{\\\"title\\\":\\\"Individual Post\\\\\\/Page Settings\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/post-settings\\\\\\/\\\",\\\"categories\\\":[\\\"post-page-settings\\\"]},\\\"18822\\\":{\\\"title\\\":\\\"Bad Bot Blocker\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/bad-bot-blocker\\\\\\/\\\",\\\"categories\\\":[\\\"bad-bot-blocker\\\"]},\\\"18823\\\":{\\\"title\\\":\\\"How to Fix a 404 Error When Viewing Your Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-fix-a-404-error-when-viewing-your-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\",\\\"google-news-sitemap\\\",\\\"rss-sitemap\\\",\\\"troubleshooting\\\",\\\"video-sitemap\\\",\\\"xml-sitemap\\\"]},\\\"18825\\\":{\\\"title\\\":\\\"When to use NOINDEX or the robots.txt?\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/when-to-use-noindex-or-the-robots-txt\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\",\\\"robots-txt\\\",\\\"search-appearance\\\",\\\"tools\\\"]},\\\"18826\\\":{\\\"title\\\":\\\"Support for Videos Embedded Using the Media Library\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/support-for-videos-embedded-using-the-media-library\\\\\\/\\\",\\\"categories\\\":[\\\"video-sitemap\\\"]},\\\"18827\\\":{\\\"title\\\":\\\"Supported Videos\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/supported-videos\\\\\\/\\\",\\\"categories\\\":[\\\"video-sitemap\\\"]},\\\"18828\\\":{\\\"title\\\":\\\"Performance Settings\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/performance-settings\\\\\\/\\\",\\\"categories\\\":[\\\"performance\\\"]},\\\"18830\\\":{\\\"title\\\":\\\"Setting the SEO Title and Description Format for Author and Date Archives\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-seo-title-and-description-format-for-author-and-date-archives\\\\\\/\\\",\\\"categories\\\":[\\\"archive-settings\\\",\\\"search-appearance\\\"]},\\\"18831\\\":{\\\"title\\\":\\\"Using Custom Fields in Titles and Descriptions\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/custom-fields-in-titles-and-descriptions\\\\\\/\\\",\\\"categories\\\":[\\\"content-type-settings\\\",\\\"post-page-settings\\\",\\\"search-appearance\\\"]},\\\"18832\\\":{\\\"title\\\":\\\"Using the Focus Keyphrase to Analyze Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-the-focus-keyphrase-to-analyze-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\",\\\"post-page-settings\\\",\\\"truseo\\\"]},\\\"18833\\\":{\\\"title\\\":\\\"Using the Robots.txt Tool in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-the-robots-txt-tool-in-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"robots-txt\\\",\\\"tools\\\"]},\\\"18834\\\":{\\\"title\\\":\\\"Using the Robots Meta Settings in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-the-robots-meta-settings-in-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\",\\\"archive-settings\\\",\\\"category-tag-settings\\\",\\\"content-type-settings\\\",\\\"media-settings\\\",\\\"post-page-settings\\\",\\\"search-appearance\\\",\\\"taxonomy-settings\\\"]},\\\"18835\\\":{\\\"title\\\":\\\"Noindex Settings\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/noindex-settings\\\\\\/\\\",\\\"categories\\\":[\\\"search-appearance\\\"]},\\\"18838\\\":{\\\"title\\\":\\\"Hiding the AIOSEO Admin Bar Menu\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/hiding-the-aioseo-admin-bar-menu\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\",\\\"general-settings\\\"]},\\\"18839\\\":{\\\"title\\\":\\\"Hiding the AIOSEO Dashboard Widgets\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/hiding-the-aioseo-dashboard-widget\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\",\\\"general-settings\\\"]},\\\"18840\\\":{\\\"title\\\":\\\"Hiding the AIOSEO Column on All Posts Screens\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/hiding-the-aioseo-column-on-all-posts-screens\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\",\\\"general-settings\\\"]},\\\"18841\\\":{\\\"title\\\":\\\"Display Settings\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/display-settings\\\\\\/\\\",\\\"categories\\\":[\\\"display-settings\\\"]},\\\"18842\\\":{\\\"title\\\":\\\"Setting the SEO Title and Description Format for Media Attachments\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-seo-title-and-description-format-for-media-attachments\\\\\\/\\\",\\\"categories\\\":[\\\"media-settings\\\",\\\"search-appearance\\\"]},\\\"18843\\\":{\\\"title\\\":\\\"Showing or Hiding Your Content in Search Results\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/showing-or-hiding-your-content-in-search-results\\\\\\/\\\",\\\"categories\\\":[\\\"archive-settings\\\",\\\"category-tag-settings\\\",\\\"content-type-settings\\\",\\\"media-settings\\\",\\\"post-page-settings\\\",\\\"search-appearance\\\",\\\"taxonomy-settings\\\"]},\\\"18844\\\":{\\\"title\\\":\\\"Content Type Settings\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/custom-post-type-settings\\\\\\/\\\",\\\"categories\\\":[\\\"content-type-settings\\\",\\\"search-appearance\\\"]},\\\"18845\\\":{\\\"title\\\":\\\"What Are Media Attachments and Should I Submit Them to Search Engines?\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/what-are-media-attachments-and-should-i-submit-them-to-search-engines\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\",\\\"media-settings\\\"]},\\\"18846\\\":{\\\"title\\\":\\\"Setting the SEO Title and Description Format for Custom Taxonomies\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-seo-title-and-description-format-for-custom-taxonomies\\\\\\/\\\",\\\"categories\\\":[\\\"category-tag-settings\\\",\\\"search-appearance\\\",\\\"taxonomy-settings\\\"]},\\\"18847\\\":{\\\"title\\\":\\\"Setting the SEO Title and Description Format for Custom Post Types\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-seo-title-and-description-format-for-custom-post-types\\\\\\/\\\",\\\"categories\\\":[\\\"content-type-settings\\\",\\\"search-appearance\\\"]},\\\"18848\\\":{\\\"title\\\":\\\"Setting the SEO Title and Description Format for Tags\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-seo-title-and-description-format-for-tags\\\\\\/\\\",\\\"categories\\\":[\\\"category-tag-settings\\\",\\\"search-appearance\\\",\\\"taxonomy-settings\\\"]},\\\"18849\\\":{\\\"title\\\":\\\"Setting the SEO Title and Description Format for Categories\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-seo-title-and-description-format-for-categories\\\\\\/\\\",\\\"categories\\\":[\\\"category-tag-settings\\\",\\\"search-appearance\\\",\\\"taxonomy-settings\\\"]},\\\"18850\\\":{\\\"title\\\":\\\"Setting the SEO Title and Description Format for Pages\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-seo-title-and-description-format-for-pages\\\\\\/\\\",\\\"categories\\\":[\\\"content-type-settings\\\",\\\"post-page-settings\\\",\\\"search-appearance\\\"]},\\\"18851\\\":{\\\"title\\\":\\\"Setting the SEO Title and Description Format for Posts\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-seo-title-and-description-format-for-posts\\\\\\/\\\",\\\"categories\\\":[\\\"content-type-settings\\\",\\\"post-page-settings\\\",\\\"search-appearance\\\"]},\\\"18852\\\":{\\\"title\\\":\\\"Title Settings\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/title-settings\\\\\\/\\\",\\\"categories\\\":[\\\"search-appearance\\\"]},\\\"18853\\\":{\\\"title\\\":\\\"Setting the SEO for Your Home Page\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-seo-for-your-home-page\\\\\\/\\\",\\\"categories\\\":[\\\"home-page-settings\\\",\\\"search-appearance\\\"]},\\\"18854\\\":{\\\"title\\\":\\\"General Settings\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/general-settings\\\\\\/\\\",\\\"categories\\\":[\\\"general-settings\\\"]},\\\"18855\\\":{\\\"title\\\":\\\"How to Add Your License Key for All in One SEO Pro\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-add-your-license-key-in-all-in-one-seo-pro\\\\\\/\\\",\\\"categories\\\":[\\\"general-settings\\\",\\\"getting-started\\\"]},\\\"18856\\\":{\\\"title\\\":\\\"Canonical URLs in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/canonical-urls-in-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\",\\\"search-appearance\\\"]},\\\"18858\\\":{\\\"title\\\":\\\"Adding non-WordPress Content to the Video Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/adding-non-wordpress-content-to-the-video-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"video-sitemap\\\"]},\\\"18860\\\":{\\\"title\\\":\\\"Troubleshooting Problems With Sharing Content on Twitter\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/troubleshooting-problems-with-sharing-content-on-twitter\\\\\\/\\\",\\\"categories\\\":[\\\"social-networks\\\",\\\"troubleshooting\\\",\\\"twitter-settings\\\"]},\\\"18861\\\":{\\\"title\\\":\\\"Troubleshooting Problems With Sharing Content on Facebook\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/troubleshooting-problems-with-sharing-content-on-facebook\\\\\\/\\\",\\\"categories\\\":[\\\"facebook-settings\\\",\\\"social-networks\\\",\\\"troubleshooting\\\"]},\\\"18862\\\":{\\\"title\\\":\\\"Getting Started With Pinterest Rich Pins\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-social-meta-for-pinterest-rich-pins\\\\\\/\\\",\\\"categories\\\":[\\\"pinterest-settings\\\",\\\"social-networks\\\"]},\\\"18863\\\":{\\\"title\\\":\\\"Setting the Content Publisher for Twitter\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-content-publisher-for-twitter\\\\\\/\\\",\\\"categories\\\":[\\\"social-networks\\\",\\\"twitter-settings\\\"]},\\\"18865\\\":{\\\"title\\\":\\\"Submitting a Sitemap to Yandex\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/submitting-a-sitemap-to-yandex\\\\\\/\\\",\\\"categories\\\":[\\\"rss-sitemap\\\",\\\"video-sitemap\\\",\\\"xml-sitemap\\\"]},\\\"18866\\\":{\\\"title\\\":\\\"Submitting a Sitemap to Bing\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/submitting-a-sitemap-to-bing\\\\\\/\\\",\\\"categories\\\":[\\\"bing-webmaster-tools\\\",\\\"rss-sitemap\\\",\\\"video-sitemap\\\",\\\"xml-sitemap\\\"]},\\\"18867\\\":{\\\"title\\\":\\\"Submitting a Sitemap to Google\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/submitting-a-sitemap-to-google\\\\\\/\\\",\\\"categories\\\":[\\\"google-news-sitemap\\\",\\\"google-search-console\\\",\\\"rss-sitemap\\\",\\\"video-sitemap\\\",\\\"xml-sitemap\\\"]},\\\"18868\\\":{\\\"title\\\":\\\"Including Date and Author Archives in Your XML Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/including-date-and-author-archives-in-your-xml-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"xml-sitemap\\\"]},\\\"18869\\\":{\\\"title\\\":\\\"Choosing Which Content to Include in Your Video Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/choosing-which-content-to-include-in-your-video-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"video-sitemap\\\"]},\\\"18870\\\":{\\\"title\\\":\\\"Choosing Which Content to Include in Your XML Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/choosing-which-content-to-include-in-your-xml-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"xml-sitemap\\\"]},\\\"18871\\\":{\\\"title\\\":\\\"Using Sitemap Indexes and Pagination\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-sitemap-indexes-and-pagination\\\\\\/\\\",\\\"categories\\\":[\\\"video-sitemap\\\",\\\"xml-sitemap\\\"]},\\\"18872\\\":{\\\"title\\\":\\\"How to Disable Sitemaps in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-disable-sitemaps-in-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"google-news-sitemap\\\",\\\"rss-sitemap\\\",\\\"video-sitemap\\\",\\\"xml-sitemap\\\"]},\\\"18873\\\":{\\\"title\\\":\\\"Baidu Webmaster Tools Verification\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/baidu-webmaster-tools-verification\\\\\\/\\\",\\\"categories\\\":[\\\"webmaster-tools\\\",\\\"webmaster-verification\\\"]},\\\"18874\\\":{\\\"title\\\":\\\"Setting Twitter Social Meta for Your Homepage\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-twitter-social-meta-for-your-homepage\\\\\\/\\\",\\\"categories\\\":[\\\"home-page-settings\\\",\\\"social-networks\\\",\\\"twitter-settings\\\"]},\\\"18875\\\":{\\\"title\\\":\\\"Setting Facebook Social Meta for Your Homepage\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-facebook-social-meta-for-your-homepage\\\\\\/\\\",\\\"categories\\\":[\\\"facebook-settings\\\",\\\"home-page-settings\\\",\\\"social-networks\\\"]},\\\"18876\\\":{\\\"title\\\":\\\"Setting the Card Type for Twitter\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-card-type-for-twitter\\\\\\/\\\",\\\"categories\\\":[\\\"social-networks\\\",\\\"twitter-settings\\\"]},\\\"18877\\\":{\\\"title\\\":\\\"Setting the Object Types for Facebook\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-object-types-for-facebook\\\\\\/\\\",\\\"categories\\\":[\\\"facebook-settings\\\",\\\"social-networks\\\"]},\\\"18879\\\":{\\\"title\\\":\\\"Setting the Priority and Frequency for Content in the Video Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-priority-and-frequency-for-content-in-the-video-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"video-sitemap\\\"]},\\\"18880\\\":{\\\"title\\\":\\\"Setting the Priority and Frequency for Content in the XML Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-priority-and-frequency-for-content-in-the-xml-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"xml-sitemap\\\"]},\\\"18881\\\":{\\\"title\\\":\\\"How to Exclude Content from Your RSS Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-exclude-content-from-your-rss-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"rss-sitemap\\\"]},\\\"18882\\\":{\\\"title\\\":\\\"How to Exclude Content from Your Google News Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-exclude-content-from-your-google-news-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"google-news-sitemap\\\"]},\\\"18883\\\":{\\\"title\\\":\\\"How to Exclude Content from Your Video Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-exclude-content-from-your-video-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"video-sitemap\\\"]},\\\"18884\\\":{\\\"title\\\":\\\"How to Exclude Content from Your XML Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-exclude-content-from-your-xml-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"xml-sitemap\\\"]},\\\"18885\\\":{\\\"title\\\":\\\"Setting Article Tags for Facebook\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-article-tags-for-facebook\\\\\\/\\\",\\\"categories\\\":[\\\"facebook-settings\\\",\\\"social-networks\\\"]},\\\"18886\\\":{\\\"title\\\":\\\"Setting the Content Author for Twitter\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-content-author-for-twitter\\\\\\/\\\",\\\"categories\\\":[\\\"social-networks\\\",\\\"twitter-settings\\\"]},\\\"18887\\\":{\\\"title\\\":\\\"Setting the Content Author for Facebook\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-content-author-for-facebook\\\\\\/\\\",\\\"categories\\\":[\\\"facebook-settings\\\",\\\"social-networks\\\"]},\\\"18888\\\":{\\\"title\\\":\\\"Setting the Content Publisher for Facebook\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-content-publisher-for-facebook\\\\\\/\\\",\\\"categories\\\":[\\\"facebook-settings\\\",\\\"social-networks\\\"]},\\\"18889\\\":{\\\"title\\\":\\\"How to Create a Google News Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-create-a-google-news-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"google-news-sitemap\\\"]},\\\"18890\\\":{\\\"title\\\":\\\"Including Videos in Custom Fields in Your Video Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/including-videos-in-custom-fields-in-your-video-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"video-sitemap\\\"]},\\\"18891\\\":{\\\"title\\\":\\\"What is a Dynamically Generated Sitemap and Why is it Better to Use?\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/what-is-a-dynamically-generated-sitemap-and-why-is-it-better-to-use\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\",\\\"video-sitemap\\\",\\\"xml-sitemap\\\"]},\\\"18892\\\":{\\\"title\\\":\\\"How to Create a Video Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-create-a-video-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"video-sitemap\\\"]},\\\"18893\\\":{\\\"title\\\":\\\"Adding Your Facebook Admin ID\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/adding-your-facebook-admin-id\\\\\\/\\\",\\\"categories\\\":[\\\"facebook-settings\\\",\\\"social-networks\\\"]},\\\"18894\\\":{\\\"title\\\":\\\"Adding Your Facebook App ID\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/adding-your-facebook-app-id\\\\\\/\\\",\\\"categories\\\":[\\\"facebook-settings\\\",\\\"social-networks\\\"]},\\\"18895\\\":{\\\"title\\\":\\\"Access Control Settings\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/access-control-settings\\\\\\/\\\",\\\"categories\\\":[\\\"access-control-settings\\\"]},\\\"18896\\\":{\\\"title\\\":\\\"Advanced Settings for Google Analytics\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/advanced-settings-for-google-analytics\\\\\\/\\\",\\\"categories\\\":[\\\"google-analytics\\\"]},\\\"18897\\\":{\\\"title\\\":\\\"Miscellaneous Site Verification\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/miscellaneous-site-verification\\\\\\/\\\",\\\"categories\\\":[\\\"webmaster-tools\\\",\\\"webmaster-verification\\\"]},\\\"18898\\\":{\\\"title\\\":\\\"Displaying Your Social Media Profiles in Knowledge Panel\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/displaying-your-social-media-profiles-in-knowledge-panel\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\",\\\"social-networks\\\"]},\\\"18899\\\":{\\\"title\\\":\\\"How to Create an RSS Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-create-an-rss-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"rss-sitemap\\\"]},\\\"18900\\\":{\\\"title\\\":\\\"Excluding Images from the XML Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/excluding-images-from-the-xml-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"xml-sitemap\\\"]},\\\"18901\\\":{\\\"title\\\":\\\"Adding non-WordPress Content to the XML Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/adding-non-wordpress-content-to-the-xml-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"xml-sitemap\\\"]},\\\"18903\\\":{\\\"title\\\":\\\"Setting a Default Image for Twitter\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-a-default-image-for-twitter\\\\\\/\\\",\\\"categories\\\":[\\\"social-networks\\\",\\\"twitter-settings\\\"]},\\\"18904\\\":{\\\"title\\\":\\\"Setting a Default Image for Facebook\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-a-default-image-for-facebook\\\\\\/\\\",\\\"categories\\\":[\\\"facebook-settings\\\",\\\"social-networks\\\"]},\\\"18905\\\":{\\\"title\\\":\\\"Setting a Title Separator\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-a-title-separator\\\\\\/\\\",\\\"categories\\\":[\\\"search-appearance\\\"]},\\\"18906\\\":{\\\"title\\\":\\\"How to Protect Your Content With RSS Content Settings\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-protect-your-content-with-rss-content-settings\\\\\\/\\\",\\\"categories\\\":[\\\"rss-content-settings\\\"]},\\\"18907\\\":{\\\"title\\\":\\\"How to Connect Your Site with Google Tag Manager\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-connect-your-site-with-google-tag-manager\\\\\\/\\\",\\\"categories\\\":[\\\"google-analytics\\\"]},\\\"18908\\\":{\\\"title\\\":\\\"How to Connect Your Site with Google Analytics\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-connect-your-site-with-google-analytics\\\\\\/\\\",\\\"categories\\\":[\\\"google-analytics\\\"]},\\\"18909\\\":{\\\"title\\\":\\\"How to Verify Your Site with Pinterest\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-verify-your-site-with-pinterest\\\\\\/\\\",\\\"categories\\\":[\\\"pinterest-settings\\\",\\\"social-networks\\\",\\\"webmaster-tools\\\",\\\"webmaster-verification\\\"]},\\\"18910\\\":{\\\"title\\\":\\\"How to Verify Your Site with Yandex Webmaster Tools\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-verify-your-site-with-yandex-webmaster-tools\\\\\\/\\\",\\\"categories\\\":[\\\"webmaster-tools\\\",\\\"webmaster-verification\\\"]},\\\"18911\\\":{\\\"title\\\":\\\"How to Verify Your Site with Bing Webmaster Tools\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-verify-your-site-with-bing-webmaster-tools\\\\\\/\\\",\\\"categories\\\":[\\\"bing-webmaster-tools\\\",\\\"webmaster-tools\\\",\\\"webmaster-verification\\\"]},\\\"18912\\\":{\\\"title\\\":\\\"How to Verify Your Site with Google Search Console\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-verify-your-site-with-google-search-console\\\\\\/\\\",\\\"categories\\\":[\\\"google-search-console\\\",\\\"webmaster-tools\\\",\\\"webmaster-verification\\\"]},\\\"18913\\\":{\\\"title\\\":\\\"Usage Tracking\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/usage-tracking\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\"]},\\\"18915\\\":{\\\"title\\\":\\\"How do I use All in One SEO in my language?\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-do-i-use-all-in-one-seo-in-my-language\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\"]},\\\"18920\\\":{\\\"title\\\":\\\"NGINX rewrite rules for Robots.txt\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/nginx-rewrite-rules-for-robots-txt\\\\\\/\\\",\\\"categories\\\":[\\\"robots-txt\\\",\\\"tools\\\"]},\\\"18927\\\":{\\\"title\\\":\\\"Supported PHP Versions for All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/supported-php-version\\\\\\/\\\",\\\"categories\\\":[\\\"troubleshooting\\\"]},\\\"18929\\\":{\\\"title\\\":\\\"Using a different CDN for script enqueuing\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-a-different-cdn-for-script-enqueuing\\\\\\/\\\",\\\"categories\\\":[\\\"troubleshooting\\\"]},\\\"18930\\\":{\\\"title\\\":\\\"How do I get Google to show sitelinks for my site?\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-do-i-get-google-to-show-sitelinks-for-my-site\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\"]},\\\"18954\\\":{\\\"title\\\":\\\"How does the import process for SEO data work?\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-does-the-import-process-for-seo-data-work\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\",\\\"importer-exporter\\\",\\\"tools\\\"]},\\\"18960\\\":{\\\"title\\\":\\\"Robots.txt Editor for Multisite Networks\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/robots-txt-editor-for-multisite-networks\\\\\\/\\\",\\\"categories\\\":[\\\"multisite-networks\\\",\\\"robots-txt\\\"]},\\\"18961\\\":{\\\"title\\\":\\\"What are the minimum requirements for All in One SEO?\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/what-are-the-minimum-requirements-for-all-in-one-seo-pack\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\"]},\\\"18964\\\":{\\\"title\\\":\\\"How do I use your API code examples?\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-do-i-use-your-api-code-examples\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\"]},\\\"18969\\\":{\\\"title\\\":\\\"XML Parsing Error - This page contains the following errors\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/this-page-contains-the-following-errors\\\\\\/\\\",\\\"categories\\\":[\\\"google-news-sitemap\\\",\\\"troubleshooting\\\",\\\"video-sitemap\\\",\\\"xml-sitemap\\\"]},\\\"18972\\\":{\\\"title\\\":\\\"The File Editor or Robots.txt modules are missing\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/the-file-editor-or-robots-txt-modules-are-missing\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\"]},\\\"18977\\\":{\\\"title\\\":\\\"Excluding the XML Sitemap from caching\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/excluding-the-xml-sitemap-from-caching\\\\\\/\\\",\\\"categories\\\":[\\\"xml-sitemap\\\"]},\\\"18982\\\":{\\\"title\\\":\\\"Why doesn\'t the title and description I set appear in search results?\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/why-doesnt-the-title-and-description-i-set-appear-in-search-results\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\",\\\"post-page-settings\\\"]},\\\"18983\\\":{\\\"title\\\":\\\"Can I remove the date from Google search results?\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/can-i-remove-the-date-from-google-search-results\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\"]},\\\"18985\\\":{\\\"title\\\":\\\"Setting up HTTPS SSL\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-up-https-ssl\\\\\\/\\\",\\\"categories\\\":[\\\"general-seo-topics\\\"]},\\\"18995\\\":{\\\"title\\\":\\\"How to Increase the WordPress PHP Memory Limit\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/increase-wordpress-php-memory-limit\\\\\\/\\\",\\\"categories\\\":[\\\"troubleshooting\\\"]},\\\"19002\\\":{\\\"title\\\":\\\"Checking Index Status in Google Search Results\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/checking-index-status-in-google-search-results\\\\\\/\\\",\\\"categories\\\":[\\\"general-seo-topics\\\"]},\\\"19006\\\":{\\\"title\\\":\\\"SEO Data Importer\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/seo-data-importer\\\\\\/\\\",\\\"categories\\\":[\\\"seo-data-importer\\\"]},\\\"19008\\\":{\\\"title\\\":\\\"How to troubleshoot issues with All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-troubleshoot-issues-with-all-in-one-seo-pack\\\\\\/\\\",\\\"categories\\\":[\\\"troubleshooting\\\"]},\\\"19010\\\":{\\\"title\\\":\\\"Quality Guidelines for SEO Titles and Descriptions\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/quality-guidelines-for-seo-titles-and-descriptions\\\\\\/\\\",\\\"categories\\\":[\\\"general-seo-topics\\\"]},\\\"19016\\\":{\\\"title\\\":\\\"Top Tips for Good On-Page SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/top-tips-for-good-on-page-seo\\\\\\/\\\",\\\"categories\\\":[\\\"general-seo-topics\\\"]},\\\"19017\\\":{\\\"title\\\":\\\"Meta Descriptions\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/meta-descriptions\\\\\\/\\\",\\\"categories\\\":[\\\"general-seo-topics\\\"]},\\\"19028\\\":{\\\"title\\\":\\\"What is SEO meta?\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/what-is-seo-meta\\\\\\/\\\",\\\"categories\\\":[\\\"getting-started\\\"]},\\\"19029\\\":{\\\"title\\\":\\\"Social Meta Settings - Individual Page\\\\\\/Post Settings\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/social-meta-settings-individual-pagepost-settings\\\\\\/\\\",\\\"categories\\\":[\\\"post-page-settings\\\",\\\"social-networks\\\"]},\\\"19030\\\":{\\\"title\\\":\\\"File Editor Module\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/file-editor-module\\\\\\/\\\",\\\"categories\\\":[\\\"file-editor\\\"]},\\\"19031\\\":{\\\"title\\\":\\\"Social Meta Settings\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/social-meta-module\\\\\\/\\\",\\\"categories\\\":[\\\"social-networks\\\"]},\\\"19032\\\":{\\\"title\\\":\\\"Importer &amp; Exporter Module\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/importer-exporter-module\\\\\\/\\\",\\\"categories\\\":[\\\"importer-exporter\\\",\\\"tools\\\"]},\\\"19034\\\":{\\\"title\\\":\\\"Feature Manager\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/feature-manager\\\\\\/\\\",\\\"categories\\\":[\\\"feature-manager\\\"]},\\\"19035\\\":{\\\"title\\\":\\\"Advanced Settings for All in One SEO Pack\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/all-in-one-seo-pack-advanced-settings\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\"]}}}\"", "0", "2026-02-05 16:28:40", "2026-01-29 16:28:40", "2026-01-29 16:28:40");
INSERT INTO `wp_aioseo_cache` VALUES("123", "attachment_url_to_post_id_386af2a08e75156923fe01b07fc0b0b0f40a6f2c", "\"2568\"", "0", "2026-01-30 16:34:26", "2026-01-29 16:34:26", "2026-01-29 16:34:26");
INSERT INTO `wp_aioseo_cache` VALUES("134", "page_overview_data", "{\"total\":12,\"withoutFocusKeyword\":12,\"withoutTruSeoScore\":0,\"needsImprovement\":0,\"okay\":10,\"good\":2}", "0", "2026-01-31 06:51:18", "2026-01-30 10:57:42", "2026-01-31 05:51:18");
INSERT INTO `wp_aioseo_cache` VALUES("135", "rss_feed", "[{\"url\":\"https:\\/\\/aioseo.com\\/best-ai-blog-post-generators\\/\",\"title\":\"7 Best AI Blog Post Generators for 2026 (Tested &amp; Ranked)\",\"date\":\"January 22, 2026\",\"content\":\"We\\u2019ve all stared at a blank screen, waiting for inspiration to strike. Writer\\u2019s block is a real drain on productivity, especiall&hellip;\"},{\"url\":\"https:\\/\\/aioseo.com\\/multiple-table-of-contents-wordpress\\/\",\"title\":\"How to Add Multiple Table of Contents in WordPress (3 Steps)\",\"date\":\"January 13, 2026\",\"content\":\"Have you ever written a massive, comprehensive guide\\u2014maybe 3,000 or 5,000 words long? Long-form content is great for SEO, but it&hellip;\"},{\"url\":\"https:\\/\\/aioseo.com\\/how-to-add-products-to-wordpress\\/\",\"title\":\"How to Add Products to WordPress Without an Ecommerce Plugin\",\"date\":\"January 6, 2026\",\"content\":\"Do you want to add products to WordPress, but don\'t need a full-blown eCommerce platform? Many WordPress users need to display p&hellip;\"},{\"url\":\"https:\\/\\/aioseo.com\\/best-ai-image-generator-plugins\\/\",\"title\":\"7 Best AI Image Generator Plugins for WordPress [2026]\",\"date\":\"December 30, 2025\",\"content\":\"The search for the perfect blog post image is over. A new wave of AI image generator plugins lets you create exactly what you ne&hellip;\"}]", "0", "2026-01-31 10:57:43", "2026-01-30 10:57:43", "2026-01-30 10:57:43");
INSERT INTO `wp_aioseo_cache` VALUES("157", "post_overview_data", "{\"total\":1,\"withoutFocusKeyword\":1,\"withoutTruSeoScore\":0,\"needsImprovement\":0,\"okay\":1,\"good\":0}", "0", "2026-01-31 06:51:18", "2026-01-31 05:51:18", "2026-01-31 05:51:18");

/* INSERT TABLE DATA: wp_aioseo_notifications */
INSERT INTO `wp_aioseo_notifications` VALUES("1", "67c0433a4912e", NULL, "Have you connected your site to Google Search Console?", "All in One SEO can now verify whether your site is correctly verified with Google Search Console and that your sitemaps have been submitted correctly. Connect with Google Search Console now to ensure your content is being added to Google as soon as possible for increased rankings.", "warning", "[\"all\"]", NULL, "search-console-site-not-connected", "2025-02-27 10:49:30", NULL, "Connect to Google Search Console", "https://route#aioseo-settings&aioseo-scroll=google-search-console-settings&aioseo-highlight=google-search-console-settings:webmaster-tools?activetool=googleSearchConsole", NULL, NULL, "0", "0", "2025-02-27 10:49:30", "2025-02-27 10:49:30");
INSERT INTO `wp_aioseo_notifications` VALUES("2", "67d2a60ce4089", NULL, "[New] Supercharged Crawl Cleanup and Query Arg Monitoring! 🚀", "<p>Is your WordPress site slowing down? Or are AI bots scraping your content? 🧐</p>\n\n<p><strong>AIOSEO 4.8.0 puts you in control with</strong>:<br>🧹 <strong>Supercharged Crawl Cleanup</strong> – Stop search engines from indexing unnecessary URLs.<br>📊 <strong>Advanced Query Monitoring</strong> – Optimize UTM parameters automatically.<br>🛡️ <strong>Bot Control</strong> – Block unauthorized AI crawlers.<br>🔍 <strong>Internal Search Optimization</strong> – Prevent spam &amp; boost performance.<br><br>🔥 Keep your site fast, secure, and SEO-friendly. Update now! 🚀</p>", "success", "[\"4-x\",\"lite\"]", "1222", NULL, "2025-03-11 00:00:00", NULL, "Learn More", "https://aioseo.com/introducing-aioseo-4-8-0-advanced-crawl-features/?utm_source=WordPress&utm_medium=plugin-notification&utm_campaign=480-v4-x-lite", "Get AIOSEO Pro", "https://aioseo.com/lite-upgrade/?utm_source=WordPress&utm_medium=plugin-notification&utm_campaign=480-v4-x-lite", "0", "0", "2025-03-13 09:31:56", "2026-01-31 05:51:18");
INSERT INTO `wp_aioseo_notifications` VALUES("3", "67d2b94f8bac8", NULL, "Email Reports", "Stay ahead in SEO with our new email digest! Get the latest tips, trends, and tools delivered right to your inbox, helping you optimize smarter and faster. Enable it today and never miss an update that can take your rankings to the next level.", "info", "[\"all\"]", NULL, "email-reports-enable-reminder", "2025-03-13 10:54:07", NULL, "Enable Email Reports", "https://route#aioseo-settings&aioseo-scroll=aioseo-email-summary-row&aioseo-highlight=aioseo-email-summary-row:advanced", "All Good, I\'m already getting it", "http://action#notification/email-reports-enable", "0", "0", "2025-03-13 10:54:07", "2025-03-13 10:54:07");
INSERT INTO `wp_aioseo_notifications` VALUES("4", "68181292024cd", NULL, "Spring Sale 2025! Get Up to 70% Off AIOSEO", "<img src=\"data:image/webp;base64,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\" alt=\"\" class=\"wp-image-1240\"/>\n\n<p>Save up to 70% OFF on AIOSEO &amp; give your website a vibrant boost this spring!&nbsp;</p>\n\n<p>Ready for new growth? Whether you need a fresh plan or a powerful upgrade...</p>\n\n<p>🔓 Unlock pro-level features and cultivate top search rankings! Don\'t let this season of savings pass you by!</p>", "success", "[\"4-x\",\"lite\"]", "1239", NULL, "2025-05-01 00:00:00", "2025-05-08 00:00:00", "Get AIOSEO Pro", "https://aioseo.com/lite-upgrade/?utm_source=WordPress&utm_medium=plugin-notification&utm_campaign=spring-sale-2025-v4-x-lite", NULL, NULL, "0", "0", "2025-05-05 01:21:22", "2025-05-07 04:03:01");
INSERT INTO `wp_aioseo_notifications` VALUES("5", "6831e1b32c378", NULL, "[New] Get Indexing Data Right Inside WordPress!", "<p>Worried Google\'s not seeing your amazing WordPress content? 🤔&nbsp;</p>\n\n<p>AIOSEO 4.8.2 introduces the <strong>Index Status Report</strong>, giving you crystal-clear visibility into what <strong>Google\'s indexing</strong> (and what it\'s missing!). <strong>Uncover hidden indexing issues</strong>, see post-level details, and track your rich results—all within your familiar WordPress dashboard.&nbsp;</p>\n\n<p>Stop losing traffic and ensure your hard work gets seen.&nbsp;</p>\n\n<p>Update to AIOSEO 4.8.2 today and take control of your website’s visibility! 🚀</p>", "success", "[\"4-x\",\"lite\"]", "1249", NULL, "2025-05-22 15:19:11", NULL, "Learn More", "https://aioseo.com/introducing-index-status-report/?utm_source=WordPress&utm_medium=plugin-notification&utm_campaign=aioseo-482-v4-x-lite", "Get AIOSEO Pro", "https://aioseo.com/lite-upgrade/?utm_source=WordPress&utm_medium=plugin-notification&utm_campaign=aioseo-482-v4-x-lite", "0", "0", "2025-05-24 15:11:47", "2026-01-31 05:51:18");
INSERT INTO `wp_aioseo_notifications` VALUES("6", "6870e47a93932", NULL, "[New] AI Content Generator: Supercharge Your Content Creation!", "<img src=\"data:image/webp;base64,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\" alt=\"\" class=\"wp-image-1276\" style=\"object-fit:cover\"/>\n\n<p>Tired of the endless grind of crafting content, SEO titles, meta descriptions, social media posts, and FAQs?&nbsp;</p>\n\n<p>We get it! Creating high-quality, optimized content can be challenging and time-consuming. That\'s why we\'re thrilled to introduce AIOSEO\'s new <strong>AI Content Generator</strong>!</p>\n\n<p>Automatically generate content snippets like:</p>\n\n<p>✅ FAQs<br>✅ Key points<br>✅ Social media posts<br>✅ Email copy<br>✅ SEO titles and meta descriptions&nbsp;</p>\n\n<p>... and much more to come!</p>\n\n<p>Update to AIOSEO 4.8.4 now to unlock these powerful AI features and transform your content creation process! 🚀</p>", "success", "[\"4-x\",\"lite\"]", "1270", NULL, "2025-07-09 13:36:07", NULL, "Learn More", "https://aioseo.com/new-ai-content-generator/?utm_source=WordPress&utm_medium=plugin-notification&utm_campaign=aioseo-484-v4-x-lite", "Get AIOSEO Pro", "https://aioseo.com/lite-upgrade/?utm_source=WordPress&utm_medium=plugin-notification&utm_campaign=aioseo-484-v4-x-lite", "0", "0", "2025-07-11 10:16:26", "2026-01-31 05:51:18");
INSERT INTO `wp_aioseo_notifications` VALUES("7", "688a92bd249ef", NULL, "☀️ Summer Sale - Up to 70% Off AIOSEO Plans!", "<img src=\"data:image/webp;base64,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\" alt=\"Summer sale\" class=\"wp-image-1288\"/>\n\n<p>🔥 It’s the Hottest Sale of the Summer! 🔥</p>\n\n<p>Get up to <strong>70% off</strong> AIOSEO, whether you\'re grabbing a new plan or upgrading your current one.</p>\n\n<p>This summer special is only here for a short time, so don’t miss your chance to SAVE BIG!</p>\n\n<p>☀️ Grab your discount before it’s gone!</p>", "success", "[\"4-x\",\"lite\"]", "1286", NULL, "2025-08-01 00:00:00", "2025-08-08 00:00:00", "Get AIOSEO Pro", "https://aioseo.com/lite-upgrade/?utm_source=WordPress&utm_medium=plugin-notification&utm_campaign=summer-sale-2025-v4-x-lite", NULL, NULL, "0", "0", "2025-07-30 21:46:37", "2025-08-07 02:12:28");
INSERT INTO `wp_aioseo_notifications` VALUES("8", "68b7d989e86e8", NULL, "Introducing Site Audit in AIOSEO 4.8.6", "<p>Tired of guessing why your website isn’t ranking higher? Or frustrated by SEO tools that give you too much data but no clear answers?</p>\n\n<p>We’ve supercharged our SEO Analyzer to give you crystal-clear insights and action steps—right inside your WordPress dashboard!</p>\n\n<p>Now you can:</p>\n\n<p>✅ Scan your <strong>entire site</strong> for common SEO issues.</p>\n\n<p>✅ View issues <strong>page-by-page</strong> or <strong>by issue type</strong>.</p>\n\n<p>✅ <strong>Get instant tooltips</strong>, 1-click fixes, and quick keyword additions.</p>\n\n<p>✅ <strong>Track progress</strong> with satisfying visual checkmarks.</p>\n\n<p>Update to AIOSEO 4.8.6 today and take the guesswork out of SEO!</p>", "success", "[\"4-x\",\"lite\"]", "1298", NULL, "2025-08-27 00:00:00", NULL, "Learn More", "https://aioseo.com/site-audit-announcement/?utm_source=WordPress&utm_medium=plugin-notification&utm_campaign=486-v4-x-lite", "Get AIOSEO Pro", "https://aioseo.com/lite-upgrade/?utm_source=WordPress&utm_medium=plugin-notification&utm_campaign=486-v4-x-lite", "0", "0", "2025-09-03 06:00:41", "2026-01-31 05:51:18");
INSERT INTO `wp_aioseo_notifications` VALUES("9", "68fb1d0d19a03", NULL, "🤖 4.8.8 is Here — Unleash the Power of AI on Your Website!", "<img src=\"data:image/webp;base64,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\" alt=\"\" class=\"wp-image-1311\" style=\"object-fit:cover\"/>\n\n<p>Ready to create content, images, and boost your visibility faster than ever? With AIOSEO 4.8.8, you get cutting-edge AI features right inside WordPress:</p>\n\n<p>✅ Instantly generate blog posts, product copy, FAQs, and more with our new AI Assistant.</p>\n\n<p>✅ Create stunning, one-of-a-kind images with the Image Generator — no designer needed.</p>\n\n<p>✅ Take charge of how AI engines see your site using the new LLMS.txt Generator.</p>\n\n<p>Update to AIOSEO 4.8.8 now and supercharge your site with the future of SEO — powered by AI. 🚀</p>", "success", "[\"4-x\",\"lite\"]", "1310", NULL, "2025-10-22 16:06:34", NULL, "Learn More", "https://aioseo.com/aioseo-4-8-8-release/?utm_source=WordPress&utm_medium=plugin-notification&utm_campaign=4.8.8-v4-x-lite", "Get AIOSEO Pro", "https://aioseo.com/lite-upgrade/?utm_source=WordPress&utm_medium=plugin-notification&utm_campaign=4.8.8-v4-x-lite", "0", "0", "2025-10-24 06:30:37", "2026-01-31 05:51:18");
INSERT INTO `wp_aioseo_notifications` VALUES("10", "68fb1d0d1b094", NULL, "🍁 Fall Sale: Up to 60% Off AIOSEO Plans + Upgrades", "<img src=\"data:image/webp;base64,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\" alt=\"\" class=\"wp-image-1317\"/>\n\n<p>Fall is here, and so is your chance to rake in the savings. 🍂</p>\n\n<p>We’re celebrating the season with <strong>up to 60% off t</strong>he best WordPress SEO plugin. Whether you’re starting fresh or ready to upgrade, now’s the perfect time.</p>\n\n<p>Think falling leaves, rising traffic, and incredible savings.&nbsp;</p>\n\n<p>But hurry, this sale is only here for a limited time. ⏳</p>", "success", "[\"4-x\",\"lite\"]", "1316", NULL, "2025-10-24 00:00:00", "2025-10-31 00:00:00", "Get AIOSEO Pro", "https://aioseo.com/lite-upgrade/?utm_source=WordPress&utm_medium=plugin-notification&utm_campaign=fall-sale-2025-v4-x-lite", NULL, NULL, "0", "0", "2025-10-24 06:30:37", "2025-10-30 11:48:36");
INSERT INTO `wp_aioseo_notifications` VALUES("11", "69276e419d036", NULL, "🌳 Final Days: Your Purchase Makes an Impact!", "<img src=\"data:image/webp;base64,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\" alt=\"\" class=\"wp-image-1374\"/>\n\n<p>This is it—the final days of our sale! This is your last chance to get the powerful SEO tools you need to grow, and do some good for the planet at the same time. 🌎</p>\n\n<p>Upgrade to AIOSEO Pro now for<strong> up to 65% OFF</strong> and you\'ll get:</p>\n\n<p>✅ Access to more AIOSEO features to boost your rankings and traffic.</p>\n\n<p>💚 A portion of your purchase donated to the <strong>International Tree Foundation</strong>, an incredible organization that empowers communities to restore forests and fight climate change.</p>\n\n<p><strong>It’s a win-win.&nbsp;</strong></p>\n\n<p>You get to grow your site with powerful tools like the AI Image Generator, and we all help support global reforestation. 🤝</p>", "success", "[\"4-x\",\"lite\"]", "1338", NULL, "2025-12-05 00:00:00", "2025-12-10 00:00:00", "Upgrade & Make an Impact", "https://aioseo.com/pricing/?utm_source=WordPress&utm_medium=plugin-notification&utm_campaign=green-monday-2025-v4-x-lite", NULL, NULL, "0", "0", "2025-11-26 21:16:49", "2025-12-09 08:37:16");
INSERT INTO `wp_aioseo_notifications` VALUES("12", "69276e419e6d4", NULL, "Cyber Monday Deal Just for You 🤖", "<img src=\"data:image/webp;base64,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\" alt=\"\" class=\"wp-image-1363\"/>\n\n<p>Frustrated watching your competitors outrank you? Cyber Monday is your chance to fight back with the complete AIOSEO Pro toolkit.</p>\n\n<p>Our sale is extended! For <strong>up to 65% OFF</strong>, you can:</p>\n\n<p>✍️<strong> Write Faster:</strong> Use the AI Assistant to create perfect, SEO-friendly content.</p>\n\n<p><strong>🚀 Rank Higher:</strong> Unlock our complete SEO toolkit to optimize every part of your site.</p>\n\n<p>⏰<strong> Save Time:</strong> Automate tedious tasks like image SEO and internal linking.</p>\n\n<p><strong>📈 Get More Traffic:</strong> Use all the tools the pros use to dominate search results.</p>\n\n<p>This is your chance to get AIOSEO Pro at a price that only comes once a year. Don\'t miss it!</p>", "success", "[\"4-x\",\"lite\"]", "1330", NULL, "2025-12-01 00:00:00", "2025-12-05 00:00:00", "Get My Cyber Monday Deal", "https://aioseo.com/pricing/?utm_source=WordPress&utm_medium=plugin-notification&utm_campaign=cyber-monday-2025-v4-x-lite", NULL, NULL, "0", "0", "2025-11-26 21:16:49", "2025-12-01 14:26:48");
INSERT INTO `wp_aioseo_notifications` VALUES("13", "69276e419f07f", NULL, "Black Friday Sale: Unlock Your SEO Potential!", "<img src=\"data:image/webp;base64,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\" alt=\"\" class=\"wp-image-1357\"/>\n\n<p>Tired of waiting for your website to rank higher? Our biggest sale of the year is your chance to take control of your website’s SEO and start winning with AIOSEO Pro. 🌟</p>\n\n<p>Get <strong>up to 65% off </strong>and unlock our most powerful features:</p>\n\n<p>✅<strong> AI Content: </strong>Use AI to generate blog posts, images, summaries, and FAQs in seconds.</p>\n\n<p>✅ <strong>Search Statistics: </strong>View Google Search Console data right in WordPress.</p>\n\n<p><strong>✅ Link Assistant:</strong> Get smart internal linking suggestions to boost your authority.</p>\n\n<p>✅<strong> Redirection Manager: </strong>Safely delete content without losing traffic to 404 errors.</p>\n\n<p>You’re ready for the next stage of growth. Let us help you get there at the lowest price of the year.</p>", "success", "[\"4-x\",\"lite\"]", "1322", NULL, "2025-11-24 00:00:00", "2025-12-01 00:00:00", "Upgrade Now & Save", "https://aioseo.com/pricing/?utm_source=WordPress&utm_medium=plugin-notification&utm_campaign=black-friday-2025-v4-x-lite", NULL, NULL, "0", "0", "2025-11-26 21:16:49", "2025-11-26 21:16:49");

/* INSERT TABLE DATA: wp_aioseo_posts */
INSERT INTO `wp_aioseo_posts` VALUES("1", "1146", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-02-27 10:49:18", "2025-02-27 10:49:18");
INSERT INTO `wp_aioseo_posts` VALUES("2", "1315", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-02-27 10:49:18", "2025-02-27 10:49:18");
INSERT INTO `wp_aioseo_posts` VALUES("3", "1272", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-02-27 10:49:18", "2025-02-27 10:49:18");
INSERT INTO `wp_aioseo_posts` VALUES("32", "2284", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/02\\/katerinas-logo.jpg\"}]", "2025-09-26 11:22:37", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-02-27 10:53:50", "2025-09-26 11:22:37");
INSERT INTO `wp_aioseo_posts` VALUES("38", "2285", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/02\\/cropped-katerinas-logo.jpg\"}]", "2025-09-26 11:22:37", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-02-27 11:27:51", "2025-09-26 11:22:37");
INSERT INTO `wp_aioseo_posts` VALUES("39", "2296", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/02\\/katerinasfoto.jpg\"}]", "2025-09-26 11:22:37", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-02-27 11:44:00", "2025-09-26 11:22:37");
INSERT INTO `wp_aioseo_posts` VALUES("40", "2298", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/02\\/katerinassawkobi.jpg\"}]", "2025-09-26 11:22:37", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-02-27 11:44:00", "2025-09-26 11:22:37");
INSERT INTO `wp_aioseo_posts` VALUES("41", "2312", NULL, NULL, NULL, "{\"focus\":{\"keyphrase\":\"\",\"score\":0,\"analysis\":{\"keyphraseInTitle\":{\"score\":0,\"maxScore\":9,\"error\":1}}},\"additional\":[]}", "{\"analysis\":{\"basic\":{\"metadescriptionLength\":{\"score\":6,\"maxScore\":9,\"error\":1},\"lengthContent\":{\"score\":-20,\"maxScore\":9,\"error\":1},\"isInternalLink\":{\"score\":9,\"maxScore\":9,\"error\":0},\"isExternalLink\":{\"score\":3,\"maxScore\":9,\"error\":1},\"errors\":3},\"title\":{\"titleLength\":{\"score\":6,\"maxScore\":9,\"error\":1},\"errors\":1},\"readability\":{\"contentHasAssets\":{\"error\":1,\"score\":1,\"maxScore\":5},\"paragraphLength\":{\"score\":5,\"maxScore\":5,\"error\":0},\"sentenceLength\":{\"score\":9,\"maxScore\":9,\"error\":0},\"passiveVoice\":{\"score\":9,\"maxScore\":9,\"error\":0},\"transitionWords\":[],\"consecutiveSentences\":{\"score\":9,\"maxScore\":9,\"error\":0},\"subheadingsDistribution\":{\"score\":9,\"maxScore\":9,\"error\":0},\"calculateFleschReading\":{\"score\":9,\"maxScore\":9,\"error\":0},\"errors\":1}}}", NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, "", NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "75", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"WebPage\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", "-1", "-1", "large", NULL, "2026-01-21 22:58:13", NULL, "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "{\"faqs\":[],\"keyPoints\":[],\"titles\":[],\"descriptions\":[],\"socialPosts\":{\"email\":[],\"linkedin\":[],\"twitter\":[],\"facebook\":[],\"instagram\":[]}}", "2025-02-27 11:58:00", "2026-01-21 22:58:13");
INSERT INTO `wp_aioseo_posts` VALUES("42", "2309", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/02\\/4564420.png\"}]", "2025-09-26 11:22:37", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-02-27 11:59:53", "2025-09-26 11:22:37");
INSERT INTO `wp_aioseo_posts` VALUES("43", "2310", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/02\\/1559790.png\"}]", "2025-09-26 11:22:37", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-02-27 11:59:53", "2025-09-26 11:22:37");
INSERT INTO `wp_aioseo_posts` VALUES("44", "2317", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/02\\/logosite.jpg\"}]", "2025-09-26 11:22:37", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-02-27 12:15:53", "2025-09-26 11:22:37");
INSERT INTO `wp_aioseo_posts` VALUES("45", "2326", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/02\\/katerinasitelogo.png\"}]", "2025-09-26 11:22:37", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-03-01 06:51:39", "2025-09-26 11:22:37");
INSERT INTO `wp_aioseo_posts` VALUES("46", "2331", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/03\\/tracking2-scaled.jpg\"}]", "2025-09-26 11:22:37", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-03-07 08:09:34", "2025-09-26 11:22:37");
INSERT INTO `wp_aioseo_posts` VALUES("47", "2336", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/02\\/tracking1-scaled.jpg\"}]", "2025-09-26 11:22:37", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-03-07 08:09:34", "2025-09-26 11:22:37");
INSERT INTO `wp_aioseo_posts` VALUES("48", "2337", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/02\\/tracking1-1-scaled.jpg\"}]", "2025-09-26 12:13:41", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-03-07 08:09:34", "2025-09-26 12:13:41");
INSERT INTO `wp_aioseo_posts` VALUES("49", "2344", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/03\\/sakartvelo.png\"}]", "2025-09-26 12:13:41", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-03-07 08:09:34", "2025-09-26 12:13:41");
INSERT INTO `wp_aioseo_posts` VALUES("50", "2345", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/03\\/turketi.png\"}]", "2025-09-26 12:13:41", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-03-07 08:09:34", "2025-09-26 12:13:41");
INSERT INTO `wp_aioseo_posts` VALUES("51", "2347", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/03\\/Italia.png\"}]", "2025-09-26 12:13:41", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-03-07 08:09:34", "2025-09-26 12:13:41");
INSERT INTO `wp_aioseo_posts` VALUES("52", "2362", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/02\\/katerina.jpg\"}]", "2025-09-26 12:13:41", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-03-07 13:59:54", "2025-09-26 12:13:41");
INSERT INTO `wp_aioseo_posts` VALUES("53", "2363", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/02\\/katerina-1.jpg\"}]", "2025-09-26 12:13:41", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-03-07 13:59:54", "2025-09-26 12:13:41");
INSERT INTO `wp_aioseo_posts` VALUES("54", "2365", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/02\\/anano.jpg\"}]", "2025-09-26 12:13:41", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-03-07 13:59:54", "2025-09-26 12:13:41");
INSERT INTO `wp_aioseo_posts` VALUES("55", "2366", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/02\\/natia.jpg\"}]", "2025-09-26 12:13:41", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-03-07 13:59:54", "2025-09-26 12:13:41");
INSERT INTO `wp_aioseo_posts` VALUES("56", "2368", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/02\\/nona.jpg\"}]", "2025-09-26 12:13:41", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-03-07 13:59:54", "2025-09-26 12:13:41");
INSERT INTO `wp_aioseo_posts` VALUES("57", "2370", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/02\\/badri.jpg\"}]", "2025-09-26 12:13:41", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-03-07 14:15:58", "2025-09-26 12:13:41");
INSERT INTO `wp_aioseo_posts` VALUES("58", "2371", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/02\\/david.jpg\"}]", "2025-09-26 13:26:56", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-03-07 14:15:58", "2025-09-26 13:26:56");
INSERT INTO `wp_aioseo_posts` VALUES("59", "2372", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/02\\/temo.jpg\"}]", "2025-09-26 13:26:56", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-03-07 14:15:58", "2025-09-26 13:26:56");
INSERT INTO `wp_aioseo_posts` VALUES("60", "2373", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/02\\/IMG-20250221-WA0240.jpg\"}]", "2025-09-26 13:26:56", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-03-07 14:15:58", "2025-09-26 13:26:56");
INSERT INTO `wp_aioseo_posts` VALUES("61", "2408", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/02\\/aleqsandre.jpg\"}]", "2025-09-26 13:26:56", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-03-07 15:17:00", "2025-09-26 13:26:56");
INSERT INTO `wp_aioseo_posts` VALUES("62", "2321", NULL, NULL, NULL, "{\"focus\":{\"keyphrase\":\"\",\"score\":0,\"analysis\":{\"keyphraseInTitle\":{\"score\":0,\"maxScore\":9,\"error\":1}}},\"additional\":[]}", "{\"analysis\":{\"basic\":{\"metadescriptionLength\":{\"score\":6,\"maxScore\":9,\"error\":1},\"lengthContent\":{\"score\":-20,\"maxScore\":9,\"error\":1},\"isInternalLink\":{\"score\":3,\"maxScore\":9,\"error\":1},\"isExternalLink\":{\"score\":3,\"maxScore\":9,\"error\":1},\"errors\":4},\"title\":{\"titleLength\":{\"score\":9,\"maxScore\":9,\"error\":0},\"errors\":0},\"readability\":{\"contentHasAssets\":{\"error\":1,\"score\":1,\"maxScore\":5},\"paragraphLength\":{\"score\":5,\"maxScore\":5,\"error\":0},\"sentenceLength\":{\"score\":9,\"maxScore\":9,\"error\":0},\"passiveVoice\":{\"score\":9,\"maxScore\":9,\"error\":0},\"transitionWords\":[],\"consecutiveSentences\":{\"score\":9,\"maxScore\":9,\"error\":0},\"subheadingsDistribution\":{\"score\":9,\"maxScore\":9,\"error\":0},\"calculateFleschReading\":{\"score\":3,\"maxScore\":9,\"error\":1},\"errors\":2}}}", NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, "", NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "75", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"BlogPosting\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", "-1", "-1", "large", NULL, "2025-09-26 14:34:26", NULL, "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-03-09 06:46:24", "2025-09-26 14:34:26");
INSERT INTO `wp_aioseo_posts` VALUES("63", "2446", NULL, NULL, NULL, "{\"focus\":{\"keyphrase\":\"\",\"score\":0,\"analysis\":{\"keyphraseInTitle\":{\"score\":0,\"maxScore\":9,\"error\":1}}},\"additional\":[]}", "{\"analysis\":{\"basic\":{\"metadescriptionLength\":{\"score\":6,\"maxScore\":9,\"error\":1},\"lengthContent\":{\"score\":-20,\"maxScore\":9,\"error\":1},\"isInternalLink\":{\"score\":3,\"maxScore\":9,\"error\":1},\"isExternalLink\":{\"score\":3,\"maxScore\":9,\"error\":1},\"errors\":4},\"title\":{\"titleLength\":{\"score\":9,\"maxScore\":9,\"error\":0},\"errors\":0},\"readability\":{\"contentHasAssets\":{\"error\":0,\"score\":5,\"maxScore\":5},\"paragraphLength\":{\"score\":5,\"maxScore\":5,\"error\":0},\"sentenceLength\":{\"score\":9,\"maxScore\":9,\"error\":0},\"passiveVoice\":{\"score\":9,\"maxScore\":9,\"error\":0},\"transitionWords\":[],\"consecutiveSentences\":{\"score\":9,\"maxScore\":9,\"error\":0},\"subheadingsDistribution\":{\"score\":9,\"maxScore\":9,\"error\":0},\"calculateFleschReading\":{\"score\":9,\"maxScore\":9,\"error\":0},\"errors\":0}}}", NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, "", NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "81", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"WebPage\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", "-1", "-1", "large", "[{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/04\\/WhatsApp-Image-2025-03-22-at-23.27.05_f13c3640.jpg\"}]", "2026-01-29 16:34:26", NULL, "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "{\"faqs\":[],\"keyPoints\":[],\"titles\":[],\"descriptions\":[],\"socialPosts\":{\"email\":[],\"linkedin\":[],\"twitter\":[],\"facebook\":[],\"instagram\":[]}}", "2025-03-12 07:17:05", "2026-01-29 16:34:26");
INSERT INTO `wp_aioseo_posts` VALUES("64", "2448", NULL, NULL, NULL, "{\"focus\":{\"keyphrase\":\"\",\"score\":0,\"analysis\":{\"keyphraseInTitle\":{\"score\":0,\"maxScore\":9,\"error\":1}}},\"additional\":[]}", "{\"analysis\":{\"basic\":{\"metadescriptionLength\":{\"score\":6,\"maxScore\":9,\"error\":1},\"lengthContent\":{\"score\":-20,\"maxScore\":9,\"error\":1},\"isInternalLink\":{\"score\":3,\"maxScore\":9,\"error\":1},\"isExternalLink\":{\"score\":3,\"maxScore\":9,\"error\":1},\"errors\":4},\"title\":{\"titleLength\":{\"score\":9,\"maxScore\":9,\"error\":0},\"errors\":0},\"readability\":{\"contentHasAssets\":{\"error\":0,\"score\":5,\"maxScore\":5},\"paragraphLength\":{\"score\":5,\"maxScore\":5,\"error\":0},\"sentenceLength\":{\"score\":9,\"maxScore\":9,\"error\":0},\"passiveVoice\":{\"score\":9,\"maxScore\":9,\"error\":0},\"transitionWords\":[],\"consecutiveSentences\":{\"score\":9,\"maxScore\":9,\"error\":0},\"subheadingsDistribution\":{\"score\":9,\"maxScore\":9,\"error\":0},\"calculateFleschReading\":{\"score\":9,\"maxScore\":9,\"error\":0},\"errors\":0}}}", NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, "", NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "81", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"WebPage\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", "-1", "-1", "large", "[{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/04\\/WhatsApp-Image-2025-03-22-at-23.27.06_a90cf613.jpg\"}]", "2025-12-09 09:03:42", NULL, "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "{\"faqs\":[],\"keyPoints\":[],\"titles\":[],\"descriptions\":[],\"socialPosts\":{\"email\":[],\"linkedin\":[],\"twitter\":[],\"facebook\":[],\"instagram\":[]}}", "2025-03-12 07:18:02", "2025-12-09 09:03:42");
INSERT INTO `wp_aioseo_posts` VALUES("65", "2477", NULL, NULL, NULL, "{\"focus\":{\"keyphrase\":\"\",\"score\":0,\"analysis\":{\"keyphraseInTitle\":{\"score\":0,\"maxScore\":9,\"error\":1}}},\"additional\":[]}", "{\"analysis\":{\"basic\":{\"metadescriptionLength\":{\"score\":6,\"maxScore\":9,\"error\":1},\"lengthContent\":{\"score\":-20,\"maxScore\":9,\"error\":1},\"isInternalLink\":{\"score\":3,\"maxScore\":9,\"error\":1},\"isExternalLink\":{\"score\":3,\"maxScore\":9,\"error\":1},\"errors\":4},\"title\":{\"titleLength\":{\"score\":6,\"maxScore\":9,\"error\":1},\"errors\":1},\"readability\":{\"contentHasAssets\":{\"error\":1,\"score\":1,\"maxScore\":5},\"paragraphLength\":{\"score\":5,\"maxScore\":5,\"error\":0},\"sentenceLength\":{\"score\":9,\"maxScore\":9,\"error\":0},\"passiveVoice\":{\"score\":9,\"maxScore\":9,\"error\":0},\"transitionWords\":[],\"consecutiveSentences\":{\"score\":9,\"maxScore\":9,\"error\":0},\"subheadingsDistribution\":{\"score\":9,\"maxScore\":9,\"error\":0},\"calculateFleschReading\":{\"score\":9,\"maxScore\":9,\"error\":0},\"errors\":1}}}", NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, "", NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "68", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"WebPage\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", "-1", "-1", "large", NULL, "2025-09-26 13:34:34", NULL, "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-03-17 13:59:25", "2025-09-26 13:34:34");
INSERT INTO `wp_aioseo_posts` VALUES("66", "2480", NULL, NULL, NULL, "{\"focus\":{\"keyphrase\":\"\",\"score\":0,\"analysis\":{\"keyphraseInTitle\":{\"score\":0,\"maxScore\":9,\"error\":1}}},\"additional\":[]}", "{\"analysis\":{\"basic\":{\"metadescriptionLength\":{\"score\":6,\"maxScore\":9,\"error\":1},\"lengthContent\":{\"score\":-20,\"maxScore\":9,\"error\":1},\"isInternalLink\":{\"score\":3,\"maxScore\":9,\"error\":1},\"isExternalLink\":{\"score\":3,\"maxScore\":9,\"error\":1},\"errors\":4},\"title\":{\"titleLength\":{\"score\":6,\"maxScore\":9,\"error\":1},\"errors\":1},\"readability\":{\"contentHasAssets\":{\"error\":1,\"score\":1,\"maxScore\":5},\"paragraphLength\":{\"score\":5,\"maxScore\":5,\"error\":0},\"sentenceLength\":{\"score\":9,\"maxScore\":9,\"error\":0},\"passiveVoice\":{\"score\":9,\"maxScore\":9,\"error\":0},\"transitionWords\":[],\"consecutiveSentences\":{\"score\":9,\"maxScore\":9,\"error\":0},\"subheadingsDistribution\":{\"score\":9,\"maxScore\":9,\"error\":0},\"calculateFleschReading\":{\"score\":9,\"maxScore\":9,\"error\":0},\"errors\":1}}}", NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, "", NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "68", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"WebPage\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", "-1", "-1", "large", NULL, "2025-09-26 13:34:34", NULL, "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-03-17 14:01:01", "2025-09-26 13:34:34");
INSERT INTO `wp_aioseo_posts` VALUES("67", "2483", NULL, NULL, NULL, "{\"focus\":{\"keyphrase\":\"\",\"score\":0,\"analysis\":{\"keyphraseInTitle\":{\"score\":0,\"maxScore\":9,\"error\":1}}},\"additional\":[]}", "{\"analysis\":{\"basic\":{\"metadescriptionLength\":{\"score\":6,\"maxScore\":9,\"error\":1},\"lengthContent\":{\"score\":-20,\"maxScore\":9,\"error\":1},\"isInternalLink\":{\"score\":3,\"maxScore\":9,\"error\":1},\"isExternalLink\":{\"score\":3,\"maxScore\":9,\"error\":1},\"errors\":4},\"title\":{\"titleLength\":{\"score\":6,\"maxScore\":9,\"error\":1},\"errors\":1},\"readability\":{\"contentHasAssets\":{\"error\":1,\"score\":1,\"maxScore\":5},\"paragraphLength\":{\"score\":5,\"maxScore\":5,\"error\":0},\"sentenceLength\":{\"score\":9,\"maxScore\":9,\"error\":0},\"passiveVoice\":{\"score\":9,\"maxScore\":9,\"error\":0},\"transitionWords\":[],\"consecutiveSentences\":{\"score\":3,\"maxScore\":9,\"error\":1},\"subheadingsDistribution\":{\"score\":9,\"maxScore\":9,\"error\":0},\"calculateFleschReading\":{\"score\":9,\"maxScore\":9,\"error\":0},\"errors\":2}}}", NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, "", NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "64", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"WebPage\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", "-1", "-1", "large", NULL, "2025-09-26 14:34:26", NULL, "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-03-17 14:02:19", "2025-09-26 14:34:26");
INSERT INTO `wp_aioseo_posts` VALUES("68", "2503", NULL, NULL, NULL, "{\"focus\":{\"keyphrase\":\"\",\"score\":0,\"analysis\":{\"keyphraseInTitle\":{\"score\":0,\"maxScore\":9,\"error\":1}}},\"additional\":[]}", "{\"analysis\":{\"basic\":{\"metadescriptionLength\":{\"score\":6,\"maxScore\":9,\"error\":1},\"lengthContent\":{\"score\":-20,\"maxScore\":9,\"error\":1},\"isInternalLink\":{\"score\":3,\"maxScore\":9,\"error\":1},\"isExternalLink\":{\"score\":3,\"maxScore\":9,\"error\":1},\"errors\":4},\"title\":{\"titleLength\":{\"score\":6,\"maxScore\":9,\"error\":1},\"errors\":1},\"readability\":{\"contentHasAssets\":{\"error\":0,\"score\":5,\"maxScore\":5},\"paragraphLength\":{\"score\":5,\"maxScore\":5,\"error\":0},\"sentenceLength\":{\"score\":9,\"maxScore\":9,\"error\":0},\"passiveVoice\":{\"score\":9,\"maxScore\":9,\"error\":0},\"transitionWords\":{\"score\":3,\"maxScore\":9,\"error\":1},\"consecutiveSentences\":{\"score\":9,\"maxScore\":9,\"error\":0},\"subheadingsDistribution\":{\"score\":9,\"maxScore\":9,\"error\":0},\"calculateFleschReading\":{\"score\":9,\"maxScore\":9,\"error\":0},\"errors\":1}}}", NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, "", NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "67", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"WebPage\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", "-1", "-1", "large", "[{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/02\\/katerina-1.jpg\"},{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/02\\/natia.jpg\"},{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/02\\/anano.jpg\"},{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/02\\/nona.jpg\"},{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/02\\/badri.jpg\"},{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/08\\/WhatsApp-Image-2025-08-19-at-23.55.57_331d2a0e.jpg\"},{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/02\\/temo.jpg\"},{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/02\\/IMG-20250221-WA0240.jpg\"},{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/02\\/aleqsandre.jpg\"}]", "2025-09-26 14:34:26", NULL, "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-03-22 17:01:17", "2025-09-26 14:34:26");
INSERT INTO `wp_aioseo_posts` VALUES("69", "2522", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/03\\/WhatsApp-Image-2025-03-22-at-23.27.06_64ef96ea.jpg\"}]", "2025-09-26 13:26:56", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-03-22 19:38:32", "2025-09-26 13:26:56");
INSERT INTO `wp_aioseo_posts` VALUES("70", "2531", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/03\\/WhatsApp-Image-2025-03-22-at-23.27.06_538a3a96.jpg\"}]", "2025-09-26 13:26:56", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-03-22 20:49:24", "2025-09-26 13:26:56");
INSERT INTO `wp_aioseo_posts` VALUES("71", "2534", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/03\\/WhatsApp-Image-2025-03-22-at-23.27.06_538a3a96-1.jpg\"}]", "2025-09-26 13:26:56", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-03-22 20:49:24", "2025-09-26 13:26:56");
INSERT INTO `wp_aioseo_posts` VALUES("72", "2536", NULL, NULL, NULL, "{\"focus\":{\"keyphrase\":\"\",\"score\":0,\"analysis\":{\"keyphraseInTitle\":{\"score\":0,\"maxScore\":9,\"error\":1}}},\"additional\":[]}", "{\"analysis\":{\"basic\":{\"metadescriptionLength\":{\"score\":6,\"maxScore\":9,\"error\":1},\"lengthContent\":{\"score\":-20,\"maxScore\":9,\"error\":1},\"isInternalLink\":{\"score\":3,\"maxScore\":9,\"error\":1},\"isExternalLink\":{\"score\":3,\"maxScore\":9,\"error\":1},\"errors\":4},\"title\":{\"titleLength\":{\"score\":9,\"maxScore\":9,\"error\":0},\"errors\":0},\"readability\":{\"contentHasAssets\":{\"error\":1,\"score\":1,\"maxScore\":5},\"paragraphLength\":{\"score\":5,\"maxScore\":5,\"error\":0},\"sentenceLength\":{\"score\":9,\"maxScore\":9,\"error\":0},\"passiveVoice\":{\"score\":9,\"maxScore\":9,\"error\":0},\"transitionWords\":{\"score\":3,\"maxScore\":9,\"error\":1},\"consecutiveSentences\":{\"score\":9,\"maxScore\":9,\"error\":0},\"subheadingsDistribution\":{\"score\":2,\"maxScore\":9,\"error\":1},\"calculateFleschReading\":{\"score\":9,\"maxScore\":9,\"error\":0},\"errors\":3}}}", NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, "", NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "72", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"WebPage\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", "-1", "-1", "large", NULL, "2025-09-26 14:34:26", NULL, "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-03-23 08:07:31", "2025-09-26 14:34:26");
INSERT INTO `wp_aioseo_posts` VALUES("73", "2568", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/04\\/WhatsApp-Image-2025-03-22-at-23.27.05_f13c3640.jpg\"}]", "2025-09-26 13:26:56", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-04-07 06:45:21", "2025-09-26 13:26:56");
INSERT INTO `wp_aioseo_posts` VALUES("74", "2571", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/04\\/WhatsApp-Image-2025-03-22-at-23.27.05_f13c3640-1.jpg\"}]", "2025-09-26 13:26:56", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-04-07 06:45:21", "2025-09-26 13:26:56");
INSERT INTO `wp_aioseo_posts` VALUES("75", "2579", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/04\\/WhatsApp-Image-2025-03-22-at-23.27.06_a90cf613.jpg\"}]", "2025-09-26 13:26:56", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-04-09 10:02:00", "2025-09-26 13:26:56");
INSERT INTO `wp_aioseo_posts` VALUES("76", "2607", NULL, NULL, NULL, "{\"focus\":{\"keyphrase\":\"\",\"score\":0,\"analysis\":{\"keyphraseInTitle\":{\"score\":0,\"maxScore\":9,\"error\":1}}},\"additional\":[]}", "{\"analysis\":{\"basic\":{\"metadescriptionLength\":{\"score\":6,\"maxScore\":9,\"error\":1},\"lengthContent\":{\"score\":-20,\"maxScore\":9,\"error\":1},\"isInternalLink\":{\"score\":9,\"maxScore\":9,\"error\":0},\"isExternalLink\":{\"score\":3,\"maxScore\":9,\"error\":1},\"errors\":3},\"title\":{\"titleLength\":{\"score\":6,\"maxScore\":9,\"error\":1},\"errors\":1},\"readability\":{\"contentHasAssets\":{\"error\":1,\"score\":1,\"maxScore\":5},\"paragraphLength\":{\"score\":5,\"maxScore\":5,\"error\":0},\"sentenceLength\":{\"score\":9,\"maxScore\":9,\"error\":0},\"passiveVoice\":{\"score\":9,\"maxScore\":9,\"error\":0},\"transitionWords\":[],\"consecutiveSentences\":{\"score\":9,\"maxScore\":9,\"error\":0},\"subheadingsDistribution\":{\"score\":9,\"maxScore\":9,\"error\":0},\"calculateFleschReading\":{\"score\":9,\"maxScore\":9,\"error\":0},\"errors\":1}}}", NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, "", NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "75", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"WebPage\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", "-1", "-1", "large", NULL, "2025-09-26 14:34:26", NULL, "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-04-29 08:58:48", "2025-09-26 14:34:26");
INSERT INTO `wp_aioseo_posts` VALUES("77", "2610", NULL, NULL, NULL, "{\"focus\":{\"keyphrase\":\"\",\"score\":0,\"analysis\":{\"keyphraseInTitle\":{\"score\":0,\"maxScore\":9,\"error\":1}}},\"additional\":[]}", "{\"analysis\":{\"basic\":{\"metadescriptionLength\":{\"score\":6,\"maxScore\":9,\"error\":1},\"lengthContent\":{\"score\":-20,\"maxScore\":9,\"error\":1},\"isInternalLink\":{\"score\":9,\"maxScore\":9,\"error\":0},\"isExternalLink\":{\"score\":3,\"maxScore\":9,\"error\":1},\"errors\":3},\"title\":{\"titleLength\":{\"score\":6,\"maxScore\":9,\"error\":1},\"errors\":1},\"readability\":{\"contentHasAssets\":{\"error\":1,\"score\":1,\"maxScore\":5},\"paragraphLength\":{\"score\":5,\"maxScore\":5,\"error\":0},\"sentenceLength\":{\"score\":9,\"maxScore\":9,\"error\":0},\"passiveVoice\":{\"score\":9,\"maxScore\":9,\"error\":0},\"transitionWords\":[],\"consecutiveSentences\":{\"score\":9,\"maxScore\":9,\"error\":0},\"subheadingsDistribution\":{\"score\":9,\"maxScore\":9,\"error\":0},\"calculateFleschReading\":{\"score\":9,\"maxScore\":9,\"error\":0},\"errors\":1}}}", NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, "", NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "75", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"WebPage\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", "-1", "-1", "large", NULL, "2025-10-29 15:53:12", NULL, "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "{\"faqs\":[],\"keyPoints\":[],\"titles\":[],\"descriptions\":[],\"socialPosts\":{\"email\":[],\"linkedin\":[],\"twitter\":[],\"facebook\":[],\"instagram\":[]}}", "2025-04-29 09:01:55", "2025-10-29 15:53:12");
INSERT INTO `wp_aioseo_posts` VALUES("78", "2618", NULL, NULL, NULL, "{\"focus\":{\"keyphrase\":\"\",\"score\":0,\"analysis\":{\"keyphraseInTitle\":{\"score\":0,\"maxScore\":9,\"error\":1}}},\"additional\":[]}", "{\"analysis\":{\"basic\":{\"metadescriptionLength\":{\"score\":6,\"maxScore\":9,\"error\":1},\"lengthContent\":{\"score\":-20,\"maxScore\":9,\"error\":1},\"isInternalLink\":{\"score\":3,\"maxScore\":9,\"error\":1},\"isExternalLink\":{\"score\":3,\"maxScore\":9,\"error\":1},\"errors\":4},\"title\":{\"titleLength\":{\"score\":6,\"maxScore\":9,\"error\":1},\"errors\":1},\"readability\":{\"contentHasAssets\":{\"error\":0,\"score\":5,\"maxScore\":5},\"paragraphLength\":{\"score\":5,\"maxScore\":5,\"error\":0},\"sentenceLength\":{\"score\":9,\"maxScore\":9,\"error\":0},\"passiveVoice\":{\"score\":9,\"maxScore\":9,\"error\":0},\"transitionWords\":[],\"consecutiveSentences\":{\"score\":9,\"maxScore\":9,\"error\":0},\"subheadingsDistribution\":{\"score\":9,\"maxScore\":9,\"error\":0},\"calculateFleschReading\":{\"score\":9,\"maxScore\":9,\"error\":0},\"errors\":0}}}", NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, "", NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "70", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"WebPage\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", "-1", "-1", "large", "[{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/05\\/WhatsApp-Image-2025-05-29-at-12.11.59_3da7f987.jpg\"}]", "2025-10-21 23:36:52", NULL, "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "{\"faqs\":[],\"keyPoints\":[],\"titles\":[],\"descriptions\":[],\"socialPosts\":{\"email\":[],\"linkedin\":[],\"twitter\":[],\"facebook\":[],\"instagram\":[]}}", "2025-04-29 09:10:53", "2025-10-21 23:36:52");
INSERT INTO `wp_aioseo_posts` VALUES("79", "2659", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/05\\/WhatsApp-Image-2025-05-29-at-12.12.00_3aaa9c23.jpg\"}]", "2025-09-26 13:34:34", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-05-29 08:24:48", "2025-09-26 13:34:34");
INSERT INTO `wp_aioseo_posts` VALUES("80", "2667", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/05\\/WhatsApp-Image-2025-05-29-at-12.11.59_3da7f987.jpg\"}]", "2025-09-26 13:34:34", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-05-31 12:25:27", "2025-09-26 13:34:34");
INSERT INTO `wp_aioseo_posts` VALUES("81", "2674", NULL, NULL, NULL, "{\"focus\":{\"keyphrase\":\"\",\"score\":0,\"analysis\":{\"keyphraseInTitle\":{\"score\":0,\"maxScore\":9,\"error\":1}}},\"additional\":[]}", "{\"analysis\":{\"basic\":{\"metadescriptionLength\":{\"score\":6,\"maxScore\":9,\"error\":1},\"lengthContent\":{\"score\":-20,\"maxScore\":9,\"error\":1},\"isInternalLink\":{\"score\":3,\"maxScore\":9,\"error\":1},\"isExternalLink\":{\"score\":3,\"maxScore\":9,\"error\":1},\"errors\":4},\"title\":{\"titleLength\":{\"score\":6,\"maxScore\":9,\"error\":1},\"errors\":1},\"readability\":{\"contentHasAssets\":{\"error\":0,\"score\":5,\"maxScore\":5},\"paragraphLength\":{\"score\":5,\"maxScore\":5,\"error\":0},\"sentenceLength\":{\"score\":9,\"maxScore\":9,\"error\":0},\"passiveVoice\":{\"score\":9,\"maxScore\":9,\"error\":0},\"transitionWords\":[],\"consecutiveSentences\":{\"score\":9,\"maxScore\":9,\"error\":0},\"subheadingsDistribution\":{\"score\":9,\"maxScore\":9,\"error\":0},\"calculateFleschReading\":{\"score\":9,\"maxScore\":9,\"error\":0},\"errors\":0}}}", NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, "", NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "70", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"WebPage\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", "-1", "-1", "large", "[{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/05\\/WhatsApp-Image-2025-05-29-at-12.11.59_3da7f987.jpg\"}]", "2025-10-16 20:39:56", NULL, "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "{\"faqs\":[],\"keyPoints\":[],\"titles\":[],\"descriptions\":[],\"socialPosts\":{\"email\":[],\"linkedin\":[],\"twitter\":[],\"facebook\":[],\"instagram\":[]}}", "2025-06-03 17:50:58", "2025-10-16 20:39:56");
INSERT INTO `wp_aioseo_posts` VALUES("82", "2692", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/02\\/ChatGPT-Image-Jun-4-2025-06_24_07-PM.png\"}]", "2025-09-26 13:34:34", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-06-04 15:31:18", "2025-09-26 13:34:34");
INSERT INTO `wp_aioseo_posts` VALUES("83", "2693", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/02\\/ChatGPT-Image-Jun-4-2025-06_24_07-PM-1.png\"}]", "2025-09-26 13:34:34", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-06-04 15:31:18", "2025-09-26 13:34:34");
INSERT INTO `wp_aioseo_posts` VALUES("84", "2795", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/wp-content\\/uploads\\/2025\\/08\\/WhatsApp-Image-2025-08-19-at-23.55.57_331d2a0e.jpg\"}]", "2025-09-26 13:34:34", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2025-08-19 20:33:22", "2025-09-26 13:34:34");

/* INSERT TABLE DATA: wp_commentmeta */
INSERT INTO `wp_commentmeta` VALUES("1", "3", "_wp_trash_meta_status", "0");
INSERT INTO `wp_commentmeta` VALUES("2", "3", "_wp_trash_meta_time", "1769035636");
INSERT INTO `wp_commentmeta` VALUES("3", "2", "_wp_trash_meta_status", "0");
INSERT INTO `wp_commentmeta` VALUES("4", "2", "_wp_trash_meta_time", "1769035640");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("2", "2321", "cannabis jobs spokane", "mirthglisten239@gmail.com", "https://www.obtainhigh.com/product/breez-berry-daytime-cannabis-infused-tin-of-mints/", "2a09:bac5:636c:1173::1bd:118", "2025-12-19 03:38:18", "2025-12-19 03:38:18", "thc gummies no prescription required online", "0", "spam", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("3", "2321", "medusagamevn", "admin@medusagamevn.com", "https://medusagamevn.com", "156.245.246.112", "2025-12-22 08:09:10", "2025-12-22 08:09:10", "What\'s up guys? Trying out medusagamevn. The themes are interesting. Could be a fun time killer. See what you think at <a href=\'https://medusagamevn.com\' rel=\"nofollow ugc\">medusagamevn</a>", "0", "spam", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/17.6 Safari/605.1.15", "comment", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "katerina", "a652d2aead2dee1e3637_20260131055350", "24", "2026-01-31 05:54:00", "kvarasamanatebi@gmail.com", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2026-01-31 05:53:50\";s:7:\"Version\";s:6:\"1.5.15\";s:9:\"VersionWP\";s:5:\"6.7.4\";s:9:\"VersionDB\";s:6:\"11.8.3\";s:10:\"VersionPHP\";s:6:\"8.2.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:8:\"katerina\";s:4:\"Hash\";s:35:\"a652d2aead2dee1e3637_20260131055350\";s:8:\"NameHash\";s:44:\"katerina_a652d2aead2dee1e3637_20260131055350\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:54:\"katerina_a652d2aead2dee1e3637_20260131055350_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"24.8\";s:6:\"WPUser\";s:25:\"kvarasamanatebi@gmail.com\";s:7:\"Archive\";O:11:\"DUP_Archive\":27:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:56:\"katerina_a652d2aead2dee1e3637_20260131055350_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:59:\"/home/u940523010/domains/katerinasamanatebi.com/public_html\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2733;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:17305;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2026-01-31 05:53:50\";s:7:\"Version\";s:6:\"1.5.15\";s:9:\"VersionWP\";s:5:\"6.7.4\";s:9:\"VersionDB\";s:6:\"11.8.3\";s:10:\"VersionPHP\";s:6:\"8.2.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:8:\"katerina\";s:4:\"Hash\";s:35:\"a652d2aead2dee1e3637_20260131055350\";s:8:\"NameHash\";s:44:\"katerina_a652d2aead2dee1e3637_20260131055350\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:62:\"katerina_a652d2aead2dee1e3637_20260131055350_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:66;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:73:\"/home/u940523010/domains/katerinasamanatebi.com/public_html/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:57:\"katerina_a652d2aead2dee1e3637_20260131055350_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:149:\"/home/u940523010/domains/katerinasamanatebi.com/public_html/wp-content/backups-dup-lite/tmp/katerina_a652d2aead2dee1e3637_20260131055350_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:66;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:68:\"/home/u940523010/domains/katerinasamanatebi.com/public_html/wp-admin\";i:1;s:71:\"/home/u940523010/domains/katerinasamanatebi.com/public_html/wp-includes\";i:2;s:80:\"/home/u940523010/domains/katerinasamanatebi.com/public_html/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:59:\"/home/u940523010/domains/katerinasamanatebi.com/public_html\";i:1;s:59:\"/home/u940523010/domains/katerinasamanatebi.com/public_html\";i:2;s:70:\"/home/u940523010/domains/katerinasamanatebi.com/public_html/wp-content\";i:3;s:78:\"/home/u940523010/domains/katerinasamanatebi.com/public_html/wp-content/uploads\";i:4;s:78:\"/home/u940523010/domains/katerinasamanatebi.com/public_html/wp-content/plugins\";i:5;s:81:\"/home/u940523010/domains/katerinasamanatebi.com/public_html/wp-content/mu-plugins\";i:6;s:77:\"/home/u940523010/domains/katerinasamanatebi.com/public_html/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:3:{i:0;s:91:\"/home/u940523010/domains/katerinasamanatebi.com/public_html/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";i:2;s:18:\"duplicator-backups\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;s:38:\"\0DUP_Archive\0wpContentDirNormalizePath\";N;}s:9:\"Installer\";r:87;s:8:\"Database\";r:106;s:13:\"BuildProgress\";r:145;}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "cron", "a:18:{i:1769838851;a:1:{s:19:\"litespeed_task_lqip\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:16:\"litespeed_filter\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}}i:1769838874;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1769839362;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1769856513;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1769856579;a:4:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:41:\"googlesitekit_cron_update_remote_features\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1769856655;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1769861912;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1769870358;a:1:{s:23:\"fs_data_sync_tablepress\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1769871189;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1769871800;a:1:{s:48:\"puc_cron_check_updates-hostinger-easy-onboarding\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1769874312;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1769990400;a:2:{s:28:\"wpforms_email_summaries_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}s:33:\"wpforms_weekly_entries_count_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1770040800;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1770288516;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1770288576;a:1:{s:24:\"run_weekly_partner_astra\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1770359173;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1770374913;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_options` VALUES("2", "siteurl", "https://katerinasamanatebi.com", "on");
INSERT INTO `wp_options` VALUES("3", "home", "https://katerinasamanatebi.com", "on");
INSERT INTO `wp_options` VALUES("4", "blogname", "კატერინას ამანათები", "on");
INSERT INTO `wp_options` VALUES("5", "blogdescription", "", "on");
INSERT INTO `wp_options` VALUES("6", "users_can_register", "0", "on");
INSERT INTO `wp_options` VALUES("7", "admin_email", "kvarasamanatebi@gmail.com", "on");
INSERT INTO `wp_options` VALUES("8", "start_of_week", "1", "on");
INSERT INTO `wp_options` VALUES("9", "use_balanceTags", "0", "on");
INSERT INTO `wp_options` VALUES("10", "use_smilies", "1", "on");
INSERT INTO `wp_options` VALUES("11", "require_name_email", "1", "on");
INSERT INTO `wp_options` VALUES("12", "comments_notify", "1", "on");
INSERT INTO `wp_options` VALUES("13", "posts_per_rss", "10", "on");
INSERT INTO `wp_options` VALUES("14", "rss_use_excerpt", "0", "on");
INSERT INTO `wp_options` VALUES("15", "mailserver_url", "mail.example.com", "on");
INSERT INTO `wp_options` VALUES("16", "mailserver_login", "login@example.com", "on");
INSERT INTO `wp_options` VALUES("17", "mailserver_pass", "", "on");
INSERT INTO `wp_options` VALUES("18", "mailserver_port", "110", "on");
INSERT INTO `wp_options` VALUES("19", "default_category", "1", "on");
INSERT INTO `wp_options` VALUES("20", "default_comment_status", "open", "on");
INSERT INTO `wp_options` VALUES("21", "default_ping_status", "open", "on");
INSERT INTO `wp_options` VALUES("22", "default_pingback_flag", "1", "on");
INSERT INTO `wp_options` VALUES("23", "posts_per_page", "10", "on");
INSERT INTO `wp_options` VALUES("24", "date_format", "F j, Y", "on");
INSERT INTO `wp_options` VALUES("25", "time_format", "g:i a", "on");
INSERT INTO `wp_options` VALUES("26", "links_updated_date_format", "F j, Y g:i a", "on");
INSERT INTO `wp_options` VALUES("27", "comment_moderation", "0", "on");
INSERT INTO `wp_options` VALUES("28", "moderation_notify", "1", "on");
INSERT INTO `wp_options` VALUES("29", "permalink_structure", "/%postname%/", "on");
INSERT INTO `wp_options` VALUES("31", "hack_file", "0", "on");
INSERT INTO `wp_options` VALUES("32", "blog_charset", "UTF-8", "on");
INSERT INTO `wp_options` VALUES("33", "moderation_keys", "", "off");
INSERT INTO `wp_options` VALUES("34", "active_plugins", "a:14:{i:0;s:43:\"all-in-one-seo-pack/all_in_one_seo_pack.php\";i:1;s:27:\"astra-sites/astra-sites.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:39:\"easy-google-fonts/easy-google-fonts.php\";i:4;s:35:\"google-site-kit/google-site-kit.php\";i:5;s:55:\"hostinger-easy-onboarding/hostinger-easy-onboarding.php\";i:6;s:23:\"hostinger/hostinger.php\";i:7;s:35:\"litespeed-cache/litespeed-cache.php\";i:8;s:42:\"omnisend/class-omnisend-core-bootstrap.php\";i:9;s:29:\"site-offline/site-offline.php\";i:10;s:23:\"sureforms/sureforms.php\";i:11;s:25:\"tablepress/tablepress.php\";i:12;s:63:\"ultimate-addons-for-gutenberg/ultimate-addons-for-gutenberg.php\";i:13;s:24:\"wpforms-lite/wpforms.php\";}", "on");
INSERT INTO `wp_options` VALUES("35", "category_base", "", "on");
INSERT INTO `wp_options` VALUES("36", "ping_sites", "http://rpc.pingomatic.com/", "on");
INSERT INTO `wp_options` VALUES("37", "comment_max_links", "2", "on");
INSERT INTO `wp_options` VALUES("38", "gmt_offset", "0", "on");
INSERT INTO `wp_options` VALUES("39", "default_email_category", "1", "on");
INSERT INTO `wp_options` VALUES("40", "recently_edited", "", "off");
INSERT INTO `wp_options` VALUES("41", "template", "moving", "on");
INSERT INTO `wp_options` VALUES("42", "stylesheet", "moving", "on");
INSERT INTO `wp_options` VALUES("43", "comment_registration", "0", "on");
INSERT INTO `wp_options` VALUES("44", "html_type", "text/html", "on");
INSERT INTO `wp_options` VALUES("45", "use_trackback", "0", "on");
INSERT INTO `wp_options` VALUES("46", "default_role", "subscriber", "on");
INSERT INTO `wp_options` VALUES("47", "db_version", "58975", "on");
INSERT INTO `wp_options` VALUES("48", "uploads_use_yearmonth_folders", "1", "on");
INSERT INTO `wp_options` VALUES("49", "upload_path", "", "on");
INSERT INTO `wp_options` VALUES("50", "blog_public", "1", "on");
INSERT INTO `wp_options` VALUES("51", "default_link_category", "2", "on");
INSERT INTO `wp_options` VALUES("52", "show_on_front", "posts", "on");
INSERT INTO `wp_options` VALUES("53", "tag_base", "", "on");
INSERT INTO `wp_options` VALUES("54", "show_avatars", "1", "on");
INSERT INTO `wp_options` VALUES("55", "avatar_rating", "G", "on");
INSERT INTO `wp_options` VALUES("56", "upload_url_path", "", "on");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_w", "150", "on");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_h", "150", "on");
INSERT INTO `wp_options` VALUES("59", "thumbnail_crop", "1", "on");
INSERT INTO `wp_options` VALUES("60", "medium_size_w", "300", "on");
INSERT INTO `wp_options` VALUES("61", "medium_size_h", "300", "on");
INSERT INTO `wp_options` VALUES("62", "avatar_default", "mystery", "on");
INSERT INTO `wp_options` VALUES("63", "large_size_w", "1024", "on");
INSERT INTO `wp_options` VALUES("64", "large_size_h", "1024", "on");
INSERT INTO `wp_options` VALUES("65", "image_default_link_type", "none", "on");
INSERT INTO `wp_options` VALUES("66", "image_default_size", "", "on");
INSERT INTO `wp_options` VALUES("67", "image_default_align", "", "on");
INSERT INTO `wp_options` VALUES("68", "close_comments_for_old_posts", "0", "on");
INSERT INTO `wp_options` VALUES("69", "close_comments_days_old", "14", "on");
INSERT INTO `wp_options` VALUES("70", "thread_comments", "1", "on");
INSERT INTO `wp_options` VALUES("71", "thread_comments_depth", "5", "on");
INSERT INTO `wp_options` VALUES("72", "page_comments", "0", "on");
INSERT INTO `wp_options` VALUES("73", "comments_per_page", "50", "on");
INSERT INTO `wp_options` VALUES("74", "default_comments_page", "newest", "on");
INSERT INTO `wp_options` VALUES("75", "comment_order", "asc", "on");
INSERT INTO `wp_options` VALUES("76", "sticky_posts", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("77", "widget_categories", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("78", "widget_text", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("79", "widget_rss", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("80", "uninstall_plugins", "a:2:{s:42:\"omnisend/class-omnisend-core-bootstrap.php\";s:34:\"Omnisend_Core_Bootstrap::uninstall\";s:35:\"litespeed-cache/litespeed-cache.php\";s:47:\"LiteSpeed\\Activation::uninstall_litespeed_cache\";}", "off");
INSERT INTO `wp_options` VALUES("81", "timezone_string", "", "on");
INSERT INTO `wp_options` VALUES("82", "page_for_posts", "0", "on");
INSERT INTO `wp_options` VALUES("83", "page_on_front", "0", "on");
INSERT INTO `wp_options` VALUES("84", "default_post_format", "0", "on");
INSERT INTO `wp_options` VALUES("85", "link_manager_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("86", "finished_splitting_shared_terms", "1", "on");
INSERT INTO `wp_options` VALUES("87", "site_icon", "2285", "on");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_w", "768", "on");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_h", "0", "on");
INSERT INTO `wp_options` VALUES("90", "wp_page_for_privacy_policy", "3", "on");
INSERT INTO `wp_options` VALUES("91", "show_comments_cookies_opt_in", "1", "on");
INSERT INTO `wp_options` VALUES("92", "admin_email_lifespan", "1770029861", "on");
INSERT INTO `wp_options` VALUES("93", "disallowed_keys", "", "off");
INSERT INTO `wp_options` VALUES("94", "comment_previously_approved", "1", "on");
INSERT INTO `wp_options` VALUES("95", "auto_plugin_theme_update_emails", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_dev", "enabled", "on");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_minor", "enabled", "on");
INSERT INTO `wp_options` VALUES("98", "auto_update_core_major", "enabled", "on");
INSERT INTO `wp_options` VALUES("99", "wp_force_deactivated_plugins", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("100", "wp_attachment_pages_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("101", "initial_db_version", "58975", "on");
INSERT INTO `wp_options` VALUES("102", "wp_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:81:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:17:\"aioseo_manage_seo\";b:1;s:20:\"aioseo_page_analysis\";b:1;s:28:\"aioseo_page_general_settings\";b:1;s:29:\"aioseo_page_advanced_settings\";b:1;s:27:\"aioseo_page_schema_settings\";b:1;s:27:\"aioseo_page_social_settings\";b:1;s:23:\"manage_zip_ai_assistant\";b:1;s:26:\"manage_ast_block_templates\";b:1;s:22:\"tablepress_edit_tables\";b:1;s:24:\"tablepress_delete_tables\";b:1;s:22:\"tablepress_list_tables\";b:1;s:21:\"tablepress_add_tables\";b:1;s:22:\"tablepress_copy_tables\";b:1;s:24:\"tablepress_import_tables\";b:1;s:24:\"tablepress_export_tables\";b:1;s:32:\"tablepress_access_options_screen\";b:1;s:30:\"tablepress_access_about_screen\";b:1;s:23:\"tablepress_edit_options\";b:1;s:28:\"tablepress_import_tables_url\";b:1;s:31:\"aioseo_page_ai_content_settings\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:51:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:20:\"aioseo_page_analysis\";b:1;s:28:\"aioseo_page_general_settings\";b:1;s:29:\"aioseo_page_advanced_settings\";b:1;s:27:\"aioseo_page_schema_settings\";b:1;s:27:\"aioseo_page_social_settings\";b:1;s:22:\"tablepress_edit_tables\";b:1;s:24:\"tablepress_delete_tables\";b:1;s:22:\"tablepress_list_tables\";b:1;s:21:\"tablepress_add_tables\";b:1;s:22:\"tablepress_copy_tables\";b:1;s:24:\"tablepress_import_tables\";b:1;s:24:\"tablepress_export_tables\";b:1;s:32:\"tablepress_access_options_screen\";b:1;s:30:\"tablepress_access_about_screen\";b:1;s:28:\"tablepress_import_tables_url\";b:1;s:31:\"aioseo_page_ai_content_settings\";b:1;s:23:\"manage_zip_ai_assistant\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:25:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"aioseo_page_analysis\";b:1;s:28:\"aioseo_page_general_settings\";b:1;s:29:\"aioseo_page_advanced_settings\";b:1;s:27:\"aioseo_page_schema_settings\";b:1;s:27:\"aioseo_page_social_settings\";b:1;s:22:\"tablepress_edit_tables\";b:1;s:24:\"tablepress_delete_tables\";b:1;s:22:\"tablepress_list_tables\";b:1;s:21:\"tablepress_add_tables\";b:1;s:22:\"tablepress_copy_tables\";b:1;s:24:\"tablepress_import_tables\";b:1;s:24:\"tablepress_export_tables\";b:1;s:32:\"tablepress_access_options_screen\";b:1;s:30:\"tablepress_access_about_screen\";b:1;s:31:\"aioseo_page_ai_content_settings\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:11:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:20:\"aioseo_page_analysis\";b:1;s:28:\"aioseo_page_general_settings\";b:1;s:29:\"aioseo_page_advanced_settings\";b:1;s:27:\"aioseo_page_schema_settings\";b:1;s:27:\"aioseo_page_social_settings\";b:1;s:31:\"aioseo_page_ai_content_settings\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "on");
INSERT INTO `wp_options` VALUES("103", "fresh_site", "0", "off");
INSERT INTO `wp_options` VALUES("104", "user_count", "3", "off");
INSERT INTO `wp_options` VALUES("105", "widget_block", "a:13:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}i:7;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:8;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:9;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:10;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:11;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}i:12;a:1:{s:7:\"content\";s:385:\"<!-- wp:image {\"align\":\"center\",\"id\":965,\"width\":116,\"height\":47,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<div class=\"wp-block-image\"><figure class=\"aligncenter size-large is-resized\"><img src=\"https://websitedemos.net/family-lawyer-08/wp-content/uploads/sites/932/2021/04/site-logo-1.svg\" alt=\"\" class=\"wp-image-965\" width=\"116\" height=\"47\"/></figure></div>\n<!-- /wp:image -->\";}i:13;a:1:{s:7:\"content\";s:339:\"<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"color\":{\"text\":\"#ffffff\"}}} -->\n<p class=\"has-text-align-center has-text-color\" style=\"color:#ffffff\">Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae, Donec velit neque, auctor sit amet aliquam vel, ullamcorper sit amet ligula.</p>\n<!-- /wp:paragraph -->\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("106", "sidebars_widgets", "a:6:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:9:\"sidebar-1\";a:5:{i:0;s:7:\"block-7\";i:1;s:7:\"block-8\";i:2;s:7:\"block-9\";i:3;s:8:\"block-10\";i:4;s:8:\"block-11\";}s:13:\"header-widget\";a:0:{}s:15:\"footer-widget-1\";a:2:{i:0;s:8:\"block-12\";i:1;s:8:\"block-13\";}s:15:\"footer-widget-2\";a:0:{}s:13:\"array_version\";i:3;}", "auto");
INSERT INTO `wp_options` VALUES("107", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("108", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("109", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("110", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("111", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("112", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("113", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("114", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("115", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("116", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("117", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("118", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("119", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("120", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("121", "_transient_wp_core_block_css_files", "a:2:{s:7:\"version\";s:5:\"6.7.4\";s:5:\"files\";a:540:{i:0;s:23:\"archives/editor-rtl.css\";i:1;s:27:\"archives/editor-rtl.min.css\";i:2;s:19:\"archives/editor.css\";i:3;s:23:\"archives/editor.min.css\";i:4;s:22:\"archives/style-rtl.css\";i:5;s:26:\"archives/style-rtl.min.css\";i:6;s:18:\"archives/style.css\";i:7;s:22:\"archives/style.min.css\";i:8;s:20:\"audio/editor-rtl.css\";i:9;s:24:\"audio/editor-rtl.min.css\";i:10;s:16:\"audio/editor.css\";i:11;s:20:\"audio/editor.min.css\";i:12;s:19:\"audio/style-rtl.css\";i:13;s:23:\"audio/style-rtl.min.css\";i:14;s:15:\"audio/style.css\";i:15;s:19:\"audio/style.min.css\";i:16;s:19:\"audio/theme-rtl.css\";i:17;s:23:\"audio/theme-rtl.min.css\";i:18;s:15:\"audio/theme.css\";i:19;s:19:\"audio/theme.min.css\";i:20;s:21:\"avatar/editor-rtl.css\";i:21;s:25:\"avatar/editor-rtl.min.css\";i:22;s:17:\"avatar/editor.css\";i:23;s:21:\"avatar/editor.min.css\";i:24;s:20:\"avatar/style-rtl.css\";i:25;s:24:\"avatar/style-rtl.min.css\";i:26;s:16:\"avatar/style.css\";i:27;s:20:\"avatar/style.min.css\";i:28;s:21:\"button/editor-rtl.css\";i:29;s:25:\"button/editor-rtl.min.css\";i:30;s:17:\"button/editor.css\";i:31;s:21:\"button/editor.min.css\";i:32;s:20:\"button/style-rtl.css\";i:33;s:24:\"button/style-rtl.min.css\";i:34;s:16:\"button/style.css\";i:35;s:20:\"button/style.min.css\";i:36;s:22:\"buttons/editor-rtl.css\";i:37;s:26:\"buttons/editor-rtl.min.css\";i:38;s:18:\"buttons/editor.css\";i:39;s:22:\"buttons/editor.min.css\";i:40;s:21:\"buttons/style-rtl.css\";i:41;s:25:\"buttons/style-rtl.min.css\";i:42;s:17:\"buttons/style.css\";i:43;s:21:\"buttons/style.min.css\";i:44;s:22:\"calendar/style-rtl.css\";i:45;s:26:\"calendar/style-rtl.min.css\";i:46;s:18:\"calendar/style.css\";i:47;s:22:\"calendar/style.min.css\";i:48;s:25:\"categories/editor-rtl.css\";i:49;s:29:\"categories/editor-rtl.min.css\";i:50;s:21:\"categories/editor.css\";i:51;s:25:\"categories/editor.min.css\";i:52;s:24:\"categories/style-rtl.css\";i:53;s:28:\"categories/style-rtl.min.css\";i:54;s:20:\"categories/style.css\";i:55;s:24:\"categories/style.min.css\";i:56;s:19:\"code/editor-rtl.css\";i:57;s:23:\"code/editor-rtl.min.css\";i:58;s:15:\"code/editor.css\";i:59;s:19:\"code/editor.min.css\";i:60;s:18:\"code/style-rtl.css\";i:61;s:22:\"code/style-rtl.min.css\";i:62;s:14:\"code/style.css\";i:63;s:18:\"code/style.min.css\";i:64;s:18:\"code/theme-rtl.css\";i:65;s:22:\"code/theme-rtl.min.css\";i:66;s:14:\"code/theme.css\";i:67;s:18:\"code/theme.min.css\";i:68;s:22:\"columns/editor-rtl.css\";i:69;s:26:\"columns/editor-rtl.min.css\";i:70;s:18:\"columns/editor.css\";i:71;s:22:\"columns/editor.min.css\";i:72;s:21:\"columns/style-rtl.css\";i:73;s:25:\"columns/style-rtl.min.css\";i:74;s:17:\"columns/style.css\";i:75;s:21:\"columns/style.min.css\";i:76;s:33:\"comment-author-name/style-rtl.css\";i:77;s:37:\"comment-author-name/style-rtl.min.css\";i:78;s:29:\"comment-author-name/style.css\";i:79;s:33:\"comment-author-name/style.min.css\";i:80;s:29:\"comment-content/style-rtl.css\";i:81;s:33:\"comment-content/style-rtl.min.css\";i:82;s:25:\"comment-content/style.css\";i:83;s:29:\"comment-content/style.min.css\";i:84;s:26:\"comment-date/style-rtl.css\";i:85;s:30:\"comment-date/style-rtl.min.css\";i:86;s:22:\"comment-date/style.css\";i:87;s:26:\"comment-date/style.min.css\";i:88;s:31:\"comment-edit-link/style-rtl.css\";i:89;s:35:\"comment-edit-link/style-rtl.min.css\";i:90;s:27:\"comment-edit-link/style.css\";i:91;s:31:\"comment-edit-link/style.min.css\";i:92;s:32:\"comment-reply-link/style-rtl.css\";i:93;s:36:\"comment-reply-link/style-rtl.min.css\";i:94;s:28:\"comment-reply-link/style.css\";i:95;s:32:\"comment-reply-link/style.min.css\";i:96;s:30:\"comment-template/style-rtl.css\";i:97;s:34:\"comment-template/style-rtl.min.css\";i:98;s:26:\"comment-template/style.css\";i:99;s:30:\"comment-template/style.min.css\";i:100;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:101;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:102;s:38:\"comments-pagination-numbers/editor.css\";i:103;s:42:\"comments-pagination-numbers/editor.min.css\";i:104;s:34:\"comments-pagination/editor-rtl.css\";i:105;s:38:\"comments-pagination/editor-rtl.min.css\";i:106;s:30:\"comments-pagination/editor.css\";i:107;s:34:\"comments-pagination/editor.min.css\";i:108;s:33:\"comments-pagination/style-rtl.css\";i:109;s:37:\"comments-pagination/style-rtl.min.css\";i:110;s:29:\"comments-pagination/style.css\";i:111;s:33:\"comments-pagination/style.min.css\";i:112;s:29:\"comments-title/editor-rtl.css\";i:113;s:33:\"comments-title/editor-rtl.min.css\";i:114;s:25:\"comments-title/editor.css\";i:115;s:29:\"comments-title/editor.min.css\";i:116;s:23:\"comments/editor-rtl.css\";i:117;s:27:\"comments/editor-rtl.min.css\";i:118;s:19:\"comments/editor.css\";i:119;s:23:\"comments/editor.min.css\";i:120;s:22:\"comments/style-rtl.css\";i:121;s:26:\"comments/style-rtl.min.css\";i:122;s:18:\"comments/style.css\";i:123;s:22:\"comments/style.min.css\";i:124;s:20:\"cover/editor-rtl.css\";i:125;s:24:\"cover/editor-rtl.min.css\";i:126;s:16:\"cover/editor.css\";i:127;s:20:\"cover/editor.min.css\";i:128;s:19:\"cover/style-rtl.css\";i:129;s:23:\"cover/style-rtl.min.css\";i:130;s:15:\"cover/style.css\";i:131;s:19:\"cover/style.min.css\";i:132;s:22:\"details/editor-rtl.css\";i:133;s:26:\"details/editor-rtl.min.css\";i:134;s:18:\"details/editor.css\";i:135;s:22:\"details/editor.min.css\";i:136;s:21:\"details/style-rtl.css\";i:137;s:25:\"details/style-rtl.min.css\";i:138;s:17:\"details/style.css\";i:139;s:21:\"details/style.min.css\";i:140;s:20:\"embed/editor-rtl.css\";i:141;s:24:\"embed/editor-rtl.min.css\";i:142;s:16:\"embed/editor.css\";i:143;s:20:\"embed/editor.min.css\";i:144;s:19:\"embed/style-rtl.css\";i:145;s:23:\"embed/style-rtl.min.css\";i:146;s:15:\"embed/style.css\";i:147;s:19:\"embed/style.min.css\";i:148;s:19:\"embed/theme-rtl.css\";i:149;s:23:\"embed/theme-rtl.min.css\";i:150;s:15:\"embed/theme.css\";i:151;s:19:\"embed/theme.min.css\";i:152;s:19:\"file/editor-rtl.css\";i:153;s:23:\"file/editor-rtl.min.css\";i:154;s:15:\"file/editor.css\";i:155;s:19:\"file/editor.min.css\";i:156;s:18:\"file/style-rtl.css\";i:157;s:22:\"file/style-rtl.min.css\";i:158;s:14:\"file/style.css\";i:159;s:18:\"file/style.min.css\";i:160;s:23:\"footnotes/style-rtl.css\";i:161;s:27:\"footnotes/style-rtl.min.css\";i:162;s:19:\"footnotes/style.css\";i:163;s:23:\"footnotes/style.min.css\";i:164;s:23:\"freeform/editor-rtl.css\";i:165;s:27:\"freeform/editor-rtl.min.css\";i:166;s:19:\"freeform/editor.css\";i:167;s:23:\"freeform/editor.min.css\";i:168;s:22:\"gallery/editor-rtl.css\";i:169;s:26:\"gallery/editor-rtl.min.css\";i:170;s:18:\"gallery/editor.css\";i:171;s:22:\"gallery/editor.min.css\";i:172;s:21:\"gallery/style-rtl.css\";i:173;s:25:\"gallery/style-rtl.min.css\";i:174;s:17:\"gallery/style.css\";i:175;s:21:\"gallery/style.min.css\";i:176;s:21:\"gallery/theme-rtl.css\";i:177;s:25:\"gallery/theme-rtl.min.css\";i:178;s:17:\"gallery/theme.css\";i:179;s:21:\"gallery/theme.min.css\";i:180;s:20:\"group/editor-rtl.css\";i:181;s:24:\"group/editor-rtl.min.css\";i:182;s:16:\"group/editor.css\";i:183;s:20:\"group/editor.min.css\";i:184;s:19:\"group/style-rtl.css\";i:185;s:23:\"group/style-rtl.min.css\";i:186;s:15:\"group/style.css\";i:187;s:19:\"group/style.min.css\";i:188;s:19:\"group/theme-rtl.css\";i:189;s:23:\"group/theme-rtl.min.css\";i:190;s:15:\"group/theme.css\";i:191;s:19:\"group/theme.min.css\";i:192;s:21:\"heading/style-rtl.css\";i:193;s:25:\"heading/style-rtl.min.css\";i:194;s:17:\"heading/style.css\";i:195;s:21:\"heading/style.min.css\";i:196;s:19:\"html/editor-rtl.css\";i:197;s:23:\"html/editor-rtl.min.css\";i:198;s:15:\"html/editor.css\";i:199;s:19:\"html/editor.min.css\";i:200;s:20:\"image/editor-rtl.css\";i:201;s:24:\"image/editor-rtl.min.css\";i:202;s:16:\"image/editor.css\";i:203;s:20:\"image/editor.min.css\";i:204;s:19:\"image/style-rtl.css\";i:205;s:23:\"image/style-rtl.min.css\";i:206;s:15:\"image/style.css\";i:207;s:19:\"image/style.min.css\";i:208;s:19:\"image/theme-rtl.css\";i:209;s:23:\"image/theme-rtl.min.css\";i:210;s:15:\"image/theme.css\";i:211;s:19:\"image/theme.min.css\";i:212;s:29:\"latest-comments/style-rtl.css\";i:213;s:33:\"latest-comments/style-rtl.min.css\";i:214;s:25:\"latest-comments/style.css\";i:215;s:29:\"latest-comments/style.min.css\";i:216;s:27:\"latest-posts/editor-rtl.css\";i:217;s:31:\"latest-posts/editor-rtl.min.css\";i:218;s:23:\"latest-posts/editor.css\";i:219;s:27:\"latest-posts/editor.min.css\";i:220;s:26:\"latest-posts/style-rtl.css\";i:221;s:30:\"latest-posts/style-rtl.min.css\";i:222;s:22:\"latest-posts/style.css\";i:223;s:26:\"latest-posts/style.min.css\";i:224;s:18:\"list/style-rtl.css\";i:225;s:22:\"list/style-rtl.min.css\";i:226;s:14:\"list/style.css\";i:227;s:18:\"list/style.min.css\";i:228;s:22:\"loginout/style-rtl.css\";i:229;s:26:\"loginout/style-rtl.min.css\";i:230;s:18:\"loginout/style.css\";i:231;s:22:\"loginout/style.min.css\";i:232;s:25:\"media-text/editor-rtl.css\";i:233;s:29:\"media-text/editor-rtl.min.css\";i:234;s:21:\"media-text/editor.css\";i:235;s:25:\"media-text/editor.min.css\";i:236;s:24:\"media-text/style-rtl.css\";i:237;s:28:\"media-text/style-rtl.min.css\";i:238;s:20:\"media-text/style.css\";i:239;s:24:\"media-text/style.min.css\";i:240;s:19:\"more/editor-rtl.css\";i:241;s:23:\"more/editor-rtl.min.css\";i:242;s:15:\"more/editor.css\";i:243;s:19:\"more/editor.min.css\";i:244;s:30:\"navigation-link/editor-rtl.css\";i:245;s:34:\"navigation-link/editor-rtl.min.css\";i:246;s:26:\"navigation-link/editor.css\";i:247;s:30:\"navigation-link/editor.min.css\";i:248;s:29:\"navigation-link/style-rtl.css\";i:249;s:33:\"navigation-link/style-rtl.min.css\";i:250;s:25:\"navigation-link/style.css\";i:251;s:29:\"navigation-link/style.min.css\";i:252;s:33:\"navigation-submenu/editor-rtl.css\";i:253;s:37:\"navigation-submenu/editor-rtl.min.css\";i:254;s:29:\"navigation-submenu/editor.css\";i:255;s:33:\"navigation-submenu/editor.min.css\";i:256;s:25:\"navigation/editor-rtl.css\";i:257;s:29:\"navigation/editor-rtl.min.css\";i:258;s:21:\"navigation/editor.css\";i:259;s:25:\"navigation/editor.min.css\";i:260;s:24:\"navigation/style-rtl.css\";i:261;s:28:\"navigation/style-rtl.min.css\";i:262;s:20:\"navigation/style.css\";i:263;s:24:\"navigation/style.min.css\";i:264;s:23:\"nextpage/editor-rtl.css\";i:265;s:27:\"nextpage/editor-rtl.min.css\";i:266;s:19:\"nextpage/editor.css\";i:267;s:23:\"nextpage/editor.min.css\";i:268;s:24:\"page-list/editor-rtl.css\";i:269;s:28:\"page-list/editor-rtl.min.css\";i:270;s:20:\"page-list/editor.css\";i:271;s:24:\"page-list/editor.min.css\";i:272;s:23:\"page-list/style-rtl.css\";i:273;s:27:\"page-list/style-rtl.min.css\";i:274;s:19:\"page-list/style.css\";i:275;s:23:\"page-list/style.min.css\";i:276;s:24:\"paragraph/editor-rtl.css\";i:277;s:28:\"paragraph/editor-rtl.min.css\";i:278;s:20:\"paragraph/editor.css\";i:279;s:24:\"paragraph/editor.min.css\";i:280;s:23:\"paragraph/style-rtl.css\";i:281;s:27:\"paragraph/style-rtl.min.css\";i:282;s:19:\"paragraph/style.css\";i:283;s:23:\"paragraph/style.min.css\";i:284;s:35:\"post-author-biography/style-rtl.css\";i:285;s:39:\"post-author-biography/style-rtl.min.css\";i:286;s:31:\"post-author-biography/style.css\";i:287;s:35:\"post-author-biography/style.min.css\";i:288;s:30:\"post-author-name/style-rtl.css\";i:289;s:34:\"post-author-name/style-rtl.min.css\";i:290;s:26:\"post-author-name/style.css\";i:291;s:30:\"post-author-name/style.min.css\";i:292;s:26:\"post-author/editor-rtl.css\";i:293;s:30:\"post-author/editor-rtl.min.css\";i:294;s:22:\"post-author/editor.css\";i:295;s:26:\"post-author/editor.min.css\";i:296;s:25:\"post-author/style-rtl.css\";i:297;s:29:\"post-author/style-rtl.min.css\";i:298;s:21:\"post-author/style.css\";i:299;s:25:\"post-author/style.min.css\";i:300;s:33:\"post-comments-form/editor-rtl.css\";i:301;s:37:\"post-comments-form/editor-rtl.min.css\";i:302;s:29:\"post-comments-form/editor.css\";i:303;s:33:\"post-comments-form/editor.min.css\";i:304;s:32:\"post-comments-form/style-rtl.css\";i:305;s:36:\"post-comments-form/style-rtl.min.css\";i:306;s:28:\"post-comments-form/style.css\";i:307;s:32:\"post-comments-form/style.min.css\";i:308;s:27:\"post-content/editor-rtl.css\";i:309;s:31:\"post-content/editor-rtl.min.css\";i:310;s:23:\"post-content/editor.css\";i:311;s:27:\"post-content/editor.min.css\";i:312;s:26:\"post-content/style-rtl.css\";i:313;s:30:\"post-content/style-rtl.min.css\";i:314;s:22:\"post-content/style.css\";i:315;s:26:\"post-content/style.min.css\";i:316;s:23:\"post-date/style-rtl.css\";i:317;s:27:\"post-date/style-rtl.min.css\";i:318;s:19:\"post-date/style.css\";i:319;s:23:\"post-date/style.min.css\";i:320;s:27:\"post-excerpt/editor-rtl.css\";i:321;s:31:\"post-excerpt/editor-rtl.min.css\";i:322;s:23:\"post-excerpt/editor.css\";i:323;s:27:\"post-excerpt/editor.min.css\";i:324;s:26:\"post-excerpt/style-rtl.css\";i:325;s:30:\"post-excerpt/style-rtl.min.css\";i:326;s:22:\"post-excerpt/style.css\";i:327;s:26:\"post-excerpt/style.min.css\";i:328;s:34:\"post-featured-image/editor-rtl.css\";i:329;s:38:\"post-featured-image/editor-rtl.min.css\";i:330;s:30:\"post-featured-image/editor.css\";i:331;s:34:\"post-featured-image/editor.min.css\";i:332;s:33:\"post-featured-image/style-rtl.css\";i:333;s:37:\"post-featured-image/style-rtl.min.css\";i:334;s:29:\"post-featured-image/style.css\";i:335;s:33:\"post-featured-image/style.min.css\";i:336;s:34:\"post-navigation-link/style-rtl.css\";i:337;s:38:\"post-navigation-link/style-rtl.min.css\";i:338;s:30:\"post-navigation-link/style.css\";i:339;s:34:\"post-navigation-link/style.min.css\";i:340;s:28:\"post-template/editor-rtl.css\";i:341;s:32:\"post-template/editor-rtl.min.css\";i:342;s:24:\"post-template/editor.css\";i:343;s:28:\"post-template/editor.min.css\";i:344;s:27:\"post-template/style-rtl.css\";i:345;s:31:\"post-template/style-rtl.min.css\";i:346;s:23:\"post-template/style.css\";i:347;s:27:\"post-template/style.min.css\";i:348;s:24:\"post-terms/style-rtl.css\";i:349;s:28:\"post-terms/style-rtl.min.css\";i:350;s:20:\"post-terms/style.css\";i:351;s:24:\"post-terms/style.min.css\";i:352;s:24:\"post-title/style-rtl.css\";i:353;s:28:\"post-title/style-rtl.min.css\";i:354;s:20:\"post-title/style.css\";i:355;s:24:\"post-title/style.min.css\";i:356;s:26:\"preformatted/style-rtl.css\";i:357;s:30:\"preformatted/style-rtl.min.css\";i:358;s:22:\"preformatted/style.css\";i:359;s:26:\"preformatted/style.min.css\";i:360;s:24:\"pullquote/editor-rtl.css\";i:361;s:28:\"pullquote/editor-rtl.min.css\";i:362;s:20:\"pullquote/editor.css\";i:363;s:24:\"pullquote/editor.min.css\";i:364;s:23:\"pullquote/style-rtl.css\";i:365;s:27:\"pullquote/style-rtl.min.css\";i:366;s:19:\"pullquote/style.css\";i:367;s:23:\"pullquote/style.min.css\";i:368;s:23:\"pullquote/theme-rtl.css\";i:369;s:27:\"pullquote/theme-rtl.min.css\";i:370;s:19:\"pullquote/theme.css\";i:371;s:23:\"pullquote/theme.min.css\";i:372;s:39:\"query-pagination-numbers/editor-rtl.css\";i:373;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:374;s:35:\"query-pagination-numbers/editor.css\";i:375;s:39:\"query-pagination-numbers/editor.min.css\";i:376;s:31:\"query-pagination/editor-rtl.css\";i:377;s:35:\"query-pagination/editor-rtl.min.css\";i:378;s:27:\"query-pagination/editor.css\";i:379;s:31:\"query-pagination/editor.min.css\";i:380;s:30:\"query-pagination/style-rtl.css\";i:381;s:34:\"query-pagination/style-rtl.min.css\";i:382;s:26:\"query-pagination/style.css\";i:383;s:30:\"query-pagination/style.min.css\";i:384;s:25:\"query-title/style-rtl.css\";i:385;s:29:\"query-title/style-rtl.min.css\";i:386;s:21:\"query-title/style.css\";i:387;s:25:\"query-title/style.min.css\";i:388;s:20:\"query/editor-rtl.css\";i:389;s:24:\"query/editor-rtl.min.css\";i:390;s:16:\"query/editor.css\";i:391;s:20:\"query/editor.min.css\";i:392;s:19:\"quote/style-rtl.css\";i:393;s:23:\"quote/style-rtl.min.css\";i:394;s:15:\"quote/style.css\";i:395;s:19:\"quote/style.min.css\";i:396;s:19:\"quote/theme-rtl.css\";i:397;s:23:\"quote/theme-rtl.min.css\";i:398;s:15:\"quote/theme.css\";i:399;s:19:\"quote/theme.min.css\";i:400;s:23:\"read-more/style-rtl.css\";i:401;s:27:\"read-more/style-rtl.min.css\";i:402;s:19:\"read-more/style.css\";i:403;s:23:\"read-more/style.min.css\";i:404;s:18:\"rss/editor-rtl.css\";i:405;s:22:\"rss/editor-rtl.min.css\";i:406;s:14:\"rss/editor.css\";i:407;s:18:\"rss/editor.min.css\";i:408;s:17:\"rss/style-rtl.css\";i:409;s:21:\"rss/style-rtl.min.css\";i:410;s:13:\"rss/style.css\";i:411;s:17:\"rss/style.min.css\";i:412;s:21:\"search/editor-rtl.css\";i:413;s:25:\"search/editor-rtl.min.css\";i:414;s:17:\"search/editor.css\";i:415;s:21:\"search/editor.min.css\";i:416;s:20:\"search/style-rtl.css\";i:417;s:24:\"search/style-rtl.min.css\";i:418;s:16:\"search/style.css\";i:419;s:20:\"search/style.min.css\";i:420;s:20:\"search/theme-rtl.css\";i:421;s:24:\"search/theme-rtl.min.css\";i:422;s:16:\"search/theme.css\";i:423;s:20:\"search/theme.min.css\";i:424;s:24:\"separator/editor-rtl.css\";i:425;s:28:\"separator/editor-rtl.min.css\";i:426;s:20:\"separator/editor.css\";i:427;s:24:\"separator/editor.min.css\";i:428;s:23:\"separator/style-rtl.css\";i:429;s:27:\"separator/style-rtl.min.css\";i:430;s:19:\"separator/style.css\";i:431;s:23:\"separator/style.min.css\";i:432;s:23:\"separator/theme-rtl.css\";i:433;s:27:\"separator/theme-rtl.min.css\";i:434;s:19:\"separator/theme.css\";i:435;s:23:\"separator/theme.min.css\";i:436;s:24:\"shortcode/editor-rtl.css\";i:437;s:28:\"shortcode/editor-rtl.min.css\";i:438;s:20:\"shortcode/editor.css\";i:439;s:24:\"shortcode/editor.min.css\";i:440;s:24:\"site-logo/editor-rtl.css\";i:441;s:28:\"site-logo/editor-rtl.min.css\";i:442;s:20:\"site-logo/editor.css\";i:443;s:24:\"site-logo/editor.min.css\";i:444;s:23:\"site-logo/style-rtl.css\";i:445;s:27:\"site-logo/style-rtl.min.css\";i:446;s:19:\"site-logo/style.css\";i:447;s:23:\"site-logo/style.min.css\";i:448;s:27:\"site-tagline/editor-rtl.css\";i:449;s:31:\"site-tagline/editor-rtl.min.css\";i:450;s:23:\"site-tagline/editor.css\";i:451;s:27:\"site-tagline/editor.min.css\";i:452;s:26:\"site-tagline/style-rtl.css\";i:453;s:30:\"site-tagline/style-rtl.min.css\";i:454;s:22:\"site-tagline/style.css\";i:455;s:26:\"site-tagline/style.min.css\";i:456;s:25:\"site-title/editor-rtl.css\";i:457;s:29:\"site-title/editor-rtl.min.css\";i:458;s:21:\"site-title/editor.css\";i:459;s:25:\"site-title/editor.min.css\";i:460;s:24:\"site-title/style-rtl.css\";i:461;s:28:\"site-title/style-rtl.min.css\";i:462;s:20:\"site-title/style.css\";i:463;s:24:\"site-title/style.min.css\";i:464;s:26:\"social-link/editor-rtl.css\";i:465;s:30:\"social-link/editor-rtl.min.css\";i:466;s:22:\"social-link/editor.css\";i:467;s:26:\"social-link/editor.min.css\";i:468;s:27:\"social-links/editor-rtl.css\";i:469;s:31:\"social-links/editor-rtl.min.css\";i:470;s:23:\"social-links/editor.css\";i:471;s:27:\"social-links/editor.min.css\";i:472;s:26:\"social-links/style-rtl.css\";i:473;s:30:\"social-links/style-rtl.min.css\";i:474;s:22:\"social-links/style.css\";i:475;s:26:\"social-links/style.min.css\";i:476;s:21:\"spacer/editor-rtl.css\";i:477;s:25:\"spacer/editor-rtl.min.css\";i:478;s:17:\"spacer/editor.css\";i:479;s:21:\"spacer/editor.min.css\";i:480;s:20:\"spacer/style-rtl.css\";i:481;s:24:\"spacer/style-rtl.min.css\";i:482;s:16:\"spacer/style.css\";i:483;s:20:\"spacer/style.min.css\";i:484;s:20:\"table/editor-rtl.css\";i:485;s:24:\"table/editor-rtl.min.css\";i:486;s:16:\"table/editor.css\";i:487;s:20:\"table/editor.min.css\";i:488;s:19:\"table/style-rtl.css\";i:489;s:23:\"table/style-rtl.min.css\";i:490;s:15:\"table/style.css\";i:491;s:19:\"table/style.min.css\";i:492;s:19:\"table/theme-rtl.css\";i:493;s:23:\"table/theme-rtl.min.css\";i:494;s:15:\"table/theme.css\";i:495;s:19:\"table/theme.min.css\";i:496;s:24:\"tag-cloud/editor-rtl.css\";i:497;s:28:\"tag-cloud/editor-rtl.min.css\";i:498;s:20:\"tag-cloud/editor.css\";i:499;s:24:\"tag-cloud/editor.min.css\";i:500;s:23:\"tag-cloud/style-rtl.css\";i:501;s:27:\"tag-cloud/style-rtl.min.css\";i:502;s:19:\"tag-cloud/style.css\";i:503;s:23:\"tag-cloud/style.min.css\";i:504;s:28:\"template-part/editor-rtl.css\";i:505;s:32:\"template-part/editor-rtl.min.css\";i:506;s:24:\"template-part/editor.css\";i:507;s:28:\"template-part/editor.min.css\";i:508;s:27:\"template-part/theme-rtl.css\";i:509;s:31:\"template-part/theme-rtl.min.css\";i:510;s:23:\"template-part/theme.css\";i:511;s:27:\"template-part/theme.min.css\";i:512;s:30:\"term-description/style-rtl.css\";i:513;s:34:\"term-description/style-rtl.min.css\";i:514;s:26:\"term-description/style.css\";i:515;s:30:\"term-description/style.min.css\";i:516;s:27:\"text-columns/editor-rtl.css\";i:517;s:31:\"text-columns/editor-rtl.min.css\";i:518;s:23:\"text-columns/editor.css\";i:519;s:27:\"text-columns/editor.min.css\";i:520;s:26:\"text-columns/style-rtl.css\";i:521;s:30:\"text-columns/style-rtl.min.css\";i:522;s:22:\"text-columns/style.css\";i:523;s:26:\"text-columns/style.min.css\";i:524;s:19:\"verse/style-rtl.css\";i:525;s:23:\"verse/style-rtl.min.css\";i:526;s:15:\"verse/style.css\";i:527;s:19:\"verse/style.min.css\";i:528;s:20:\"video/editor-rtl.css\";i:529;s:24:\"video/editor-rtl.min.css\";i:530;s:16:\"video/editor.css\";i:531;s:20:\"video/editor.min.css\";i:532;s:19:\"video/style-rtl.css\";i:533;s:23:\"video/style-rtl.min.css\";i:534;s:15:\"video/style.css\";i:535;s:19:\"video/style.min.css\";i:536;s:19:\"video/theme-rtl.css\";i:537;s:23:\"video/theme-rtl.min.css\";i:538;s:15:\"video/theme.css\";i:539;s:19:\"video/theme.min.css\";}}", "on");
INSERT INTO `wp_options` VALUES("125", "theme_mods_twentytwentyfive", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1740653345;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "off");
INSERT INTO `wp_options` VALUES("126", "_transient_wp_styles_for_blocks", "a:2:{s:4:\"hash\";s:32:\"2c0f9648eb7b5c3c5c7ff47e8b40a9c3\";s:6:\"blocks\";a:12:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:0:\"\";s:12:\"core/columns\";s:0:\"\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";s:15:\"core/site-title\";s:189:\":root :where(.wp-block-site-title){font-family: var(--wp--preset--font-family--roboto);font-size: clamp(2rem, 1.75rem + 1.25vw, 3rem);font-weight: 700;letter-spacing: 2px;line-height: 1.2;}\";s:32:\"f513d889cf971b13995cc3fffed2f39b\";s:162:\":root :where(.wp-block-site-title a:where(:not(.wp-element-button))){color: var(--wp--preset--color--secondary);;text-decoration: none;text-transform: uppercase;}\";s:15:\"core/navigation\";s:117:\":root :where(.wp-block-navigation){color: var(--wp--preset--color--secondary);;font-weight: 600;letter-spacing: 2px;}\";s:32:\"25289a01850f5a0264ddb79a9a3baf3d\";s:0:\"\";s:32:\"026c04da08398d655a95047f1f235d97\";s:118:\":root :where(.wp-block-navigation a:where(:not(.wp-element-button)):hover){color: var(--wp--preset--color--primary);;}\";s:32:\"d29336949e8ff45ab25278f69ae48aa5\";s:118:\":root :where(.wp-block-navigation a:where(:not(.wp-element-button)):focus){color: var(--wp--preset--color--primary);;}\";s:32:\"351cbe3371c430e0059260af4561e940\";s:119:\":root :where(.wp-block-navigation a:where(:not(.wp-element-button)):active){color: var(--wp--preset--color--primary);;}\";}}", "on");
INSERT INTO `wp_options` VALUES("127", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("135", "hostinger_show_onboarding", "1", "auto");
INSERT INTO `wp_options` VALUES("136", "optin_monster_api_activation_redirect_disabled", "true", "auto");
INSERT INTO `wp_options` VALUES("137", "wpforms_activation_redirect", "true", "auto");
INSERT INTO `wp_options` VALUES("138", "aioseo_activation_redirect", "false", "auto");
INSERT INTO `wp_options` VALUES("139", "hts_new_installation", "new", "auto");
INSERT INTO `wp_options` VALUES("141", "external_updates-hostinger-easy-onboarding", "O:8:\"stdClass\":5:{s:9:\"lastCheck\";i:1769838686;s:14:\"checkedVersion\";s:6:\"2.0.66\";s:6:\"update\";O:8:\"stdClass\":11:{s:4:\"slug\";s:25:\"hostinger-easy-onboarding\";s:7:\"version\";s:5:\"2.1.3\";s:12:\"download_url\";s:88:\"https://wp-update.hostinger.io/?action=download&slug=hostinger-easy-onboarding&ver=2.1.3\";s:12:\"translations\";a:0:{}s:2:\"id\";i:0;s:8:\"homepage\";s:21:\"https://hostinger.com\";s:6:\"tested\";s:3:\"6.9\";s:12:\"requires_php\";s:3:\"8.0\";s:14:\"upgrade_notice\";N;s:5:\"icons\";a:0:{}s:8:\"filename\";s:55:\"hostinger-easy-onboarding/hostinger-easy-onboarding.php\";}s:11:\"updateClass\";s:50:\"YahnisElsts\\PluginUpdateChecker\\v5p5\\Plugin\\Update\";s:15:\"updateBaseClass\";s:13:\"Plugin\\Update\";}", "off");
INSERT INTO `wp_options` VALUES("143", "hostinger_tools", "a:6:{s:16:\"maintenance_mode\";b:0;s:11:\"bypass_code\";s:16:\"fPugqMHbSCZJYnVi\";s:15:\"disable_xml_rpc\";b:0;s:11:\"force_https\";b:0;s:9:\"force_www\";b:0;s:31:\"disable_authentication_password\";b:1;}", "off");
INSERT INTO `wp_options` VALUES("151", "action_scheduler_hybrid_store_demarkation", "5", "auto");
INSERT INTO `wp_options` VALUES("152", "schema-ActionScheduler_StoreSchema", "8.0.1763723244", "auto");
INSERT INTO `wp_options` VALUES("153", "schema-ActionScheduler_LoggerSchema", "3.0.1740653333", "auto");
INSERT INTO `wp_options` VALUES("156", "aioseo_options_internal", "{\"internal\":{\"connectLicenseKey\":null,\"lastActiveVersion\":\"4.9.3\",\"migratedVersion\":null,\"siteAnalysis\":{\"connectToken\":null},\"headlineAnalysis\":{\"headlines\":[]},\"wizard\":null,\"category\":null,\"categoryOther\":null,\"deprecatedOptions\":[],\"searchStatistics\":{\"profile\":[],\"trustToken\":null,\"rolling\":\"last28Days\",\"site\":{\"verified\":false,\"lastFetch\":0},\"sitemap\":{\"list\":[],\"ignored\":[],\"lastFetch\":0}},\"ai\":{\"accessToken\":\"a5d9a98a28cbed618a4ed733805152c863fe962eb17fb1f1f7a145aa05ff8063\",\"isTrialAccessToken\":true,\"isManuallyConnected\":false,\"credits\":{\"total\":100,\"remaining\":100,\"orders\":[],\"license\":{\"total\":0,\"remaining\":0,\"expires\":0}},\"costPerFeature\":{\"aiAssistant\":\"50\",\"imageGenerator\":{\"low\":\"250\",\"medium\":\"1000\",\"high\":\"5000\"},\"faqs\":\"10\",\"keyPoints\":\"10\",\"socialPosts\":\"10\",\"titles\":\"10\",\"descriptions\":\"10\"}}},\"integrations\":{\"semrush\":{\"accessToken\":null,\"tokenType\":null,\"expires\":null,\"refreshToken\":null}}}", "auto");
INSERT INTO `wp_options` VALUES("157", "aioseo_options_internal_lite", "{\"internal\":{\"activated\":1740653333,\"firstActivated\":1740653333,\"installed\":0,\"connect\":{\"key\":null,\"time\":0,\"network\":false,\"token\":null}}}", "auto");
INSERT INTO `wp_options` VALUES("159", "aioseo_dynamic_settings_backup", "{}", "off");
INSERT INTO `wp_options` VALUES("162", "wpforms_version", "1.9.3.2", "auto");
INSERT INTO `wp_options` VALUES("163", "wpforms_version_lite", "1.9.3.2", "auto");
INSERT INTO `wp_options` VALUES("164", "wpforms_activated", "a:1:{s:4:\"lite\";i:1740653337;}", "auto");
INSERT INTO `wp_options` VALUES("172", "wpforms_versions_lite", "a:15:{s:5:\"1.5.9\";i:0;s:7:\"1.6.7.2\";i:0;s:5:\"1.6.8\";i:0;s:5:\"1.7.5\";i:0;s:7:\"1.7.5.1\";i:0;s:5:\"1.7.7\";i:0;s:5:\"1.8.2\";i:0;s:5:\"1.8.3\";i:0;s:5:\"1.8.4\";i:0;s:5:\"1.8.6\";i:0;s:5:\"1.8.7\";i:0;s:5:\"1.9.1\";i:0;s:5:\"1.9.2\";i:0;s:7:\"1.9.3.2\";i:1740653341;s:7:\"1.9.5.2\";i:1747392863;}", "auto");
INSERT INTO `wp_options` VALUES("173", "wpforms_constant_contact_version", "3", "auto");
INSERT INTO `wp_options` VALUES("174", "widget_wpforms-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("175", "wpforms_settings", "a:5:{s:11:\"disable-css\";s:1:\"2\";s:13:\"global-assets\";b:0;s:4:\"gdpr\";b:0;s:13:\"modern-markup\";s:1:\"0\";s:20:\"modern-markup-is-set\";b:1;}", "auto");
INSERT INTO `wp_options` VALUES("176", "aioseo_options_dynamic_localized", "a:4:{s:42:\"searchAppearance_taxonomies_category_title\";s:41:\"#taxonomy_title #separator_sa #site_title\";s:52:\"searchAppearance_taxonomies_category_metaDescription\";s:21:\"#taxonomy_description\";s:42:\"searchAppearance_taxonomies_post_tag_title\";s:41:\"#taxonomy_title #separator_sa #site_title\";s:52:\"searchAppearance_taxonomies_post_tag_metaDescription\";s:21:\"#taxonomy_description\";}", "auto");
INSERT INTO `wp_options` VALUES("179", "aioseo_options", "{\"internal\":[],\"webmasterTools\":{\"google\":null,\"bing\":null,\"yandex\":null,\"baidu\":null,\"pinterest\":null,\"microsoftClarityProjectId\":null,\"norton\":null,\"miscellaneousVerification\":null},\"breadcrumbs\":{\"separator\":\"&raquo;\",\"homepageLink\":true,\"homepageLabel\":\"Home\",\"breadcrumbPrefix\":\"\",\"archiveFormat\":\"Archives for #breadcrumb_archive_post_type_name\",\"searchResultFormat\":\"Search Results for \'#breadcrumb_search_string\'\",\"errorFormat404\":\"404 - Page Not Found\",\"showCurrentItem\":true,\"linkCurrentItem\":false,\"categoryFullHierarchy\":false,\"showBlogHome\":false},\"rssContent\":{\"before\":null,\"after\":\"&lt;p&gt;The post #post_link first appeared on #site_link.&lt;\\/p&gt;\"},\"advanced\":{\"truSeo\":true,\"headlineAnalyzer\":true,\"seoAnalysis\":true,\"dashboardWidgets\":[\"seoSetup\",\"seoOverview\",\"seoNews\"],\"announcements\":true,\"postTypes\":{\"all\":true,\"included\":[\"post\",\"page\",\"product\"]},\"taxonomies\":{\"all\":true,\"included\":[\"category\",\"post_tag\",\"product_cat\",\"product_tag\"]},\"uninstall\":false,\"emailSummary\":{\"enable\":false,\"recipients\":[{\"email\":\"kvarasamanatebi@gmail.com\",\"frequency\":\"monthly\"}]}},\"sitemap\":{\"general\":{\"enable\":true,\"filename\":\"sitemap\",\"indexes\":true,\"linksPerIndex\":1000,\"postTypes\":{\"all\":true,\"included\":[\"post\",\"page\",\"attachment\",\"product\"]},\"taxonomies\":{\"all\":true,\"included\":[\"category\",\"post_tag\",\"product_cat\",\"product_tag\"]},\"author\":false,\"date\":false,\"additionalPages\":{\"enable\":false,\"pages\":[]},\"advancedSettings\":{\"enable\":false,\"excludeImages\":false,\"excludePosts\":[],\"excludeTerms\":[],\"priority\":{\"homePage\":{\"priority\":\"{\\\"label\\\":\\\"default\\\",\\\"value\\\":\\\"default\\\"}\",\"frequency\":\"{\\\"label\\\":\\\"default\\\",\\\"value\\\":\\\"default\\\"}\"},\"postTypes\":{\"grouped\":true,\"priority\":\"{\\\"label\\\":\\\"default\\\",\\\"value\\\":\\\"default\\\"}\",\"frequency\":\"{\\\"label\\\":\\\"default\\\",\\\"value\\\":\\\"default\\\"}\"},\"taxonomies\":{\"grouped\":true,\"priority\":\"{\\\"label\\\":\\\"default\\\",\\\"value\\\":\\\"default\\\"}\",\"frequency\":\"{\\\"label\\\":\\\"default\\\",\\\"value\\\":\\\"default\\\"}\"},\"archive\":{\"priority\":\"{\\\"label\\\":\\\"default\\\",\\\"value\\\":\\\"default\\\"}\",\"frequency\":\"{\\\"label\\\":\\\"default\\\",\\\"value\\\":\\\"default\\\"}\"},\"author\":{\"priority\":\"{\\\"label\\\":\\\"default\\\",\\\"value\\\":\\\"default\\\"}\",\"frequency\":\"{\\\"label\\\":\\\"default\\\",\\\"value\\\":\\\"default\\\"}\"}}}},\"rss\":{\"enable\":true,\"linksPerIndex\":50,\"postTypes\":{\"all\":true,\"included\":[\"post\",\"page\",\"product\"]}},\"html\":{\"enable\":true,\"pageUrl\":\"\",\"postTypes\":{\"all\":true,\"included\":[\"post\",\"page\",\"product\"]},\"taxonomies\":{\"all\":true,\"included\":[\"category\",\"post_tag\",\"product_cat\",\"product_tag\"]},\"sortOrder\":\"publish_date\",\"sortDirection\":\"asc\",\"publicationDate\":true,\"compactArchives\":false,\"advancedSettings\":{\"enable\":false,\"nofollowLinks\":false,\"excludePosts\":[],\"excludeTerms\":[]}}},\"social\":{\"profiles\":{\"sameUsername\":{\"enable\":false,\"username\":null,\"included\":[\"facebookPageUrl\",\"twitterUrl\",\"tiktokUrl\",\"pinterestUrl\",\"instagramUrl\",\"youtubeUrl\",\"linkedinUrl\"]},\"urls\":{\"facebookPageUrl\":null,\"twitterUrl\":null,\"instagramUrl\":null,\"tiktokUrl\":null,\"pinterestUrl\":null,\"youtubeUrl\":null,\"linkedinUrl\":null,\"tumblrUrl\":null,\"yelpPageUrl\":null,\"soundCloudUrl\":null,\"wikipediaUrl\":null,\"myspaceUrl\":null,\"googlePlacesUrl\":null,\"wordPressUrl\":null},\"additionalUrls\":null},\"facebook\":{\"general\":{\"enable\":true,\"defaultImageSourcePosts\":\"default\",\"customFieldImagePosts\":null,\"defaultImagePosts\":\"\",\"defaultImagePostsWidth\":\"\",\"defaultImagePostsHeight\":\"\",\"showAuthor\":true,\"siteName\":\"#site_title #separator_sa #tagline\"},\"homePage\":{\"image\":\"\",\"title\":\"\",\"description\":\"\",\"imageWidth\":\"\",\"imageHeight\":\"\",\"objectType\":\"website\"},\"advanced\":{\"enable\":false,\"adminId\":\"\",\"appId\":\"\",\"authorUrl\":\"\",\"generateArticleTags\":false,\"useKeywordsInTags\":true,\"useCategoriesInTags\":true,\"usePostTagsInTags\":true}},\"twitter\":{\"general\":{\"enable\":true,\"useOgData\":false,\"defaultCardType\":\"summary_large_image\",\"defaultImageSourcePosts\":\"default\",\"customFieldImagePosts\":null,\"defaultImagePosts\":\"\",\"showAuthor\":true,\"additionalData\":false},\"homePage\":{\"image\":\"\",\"title\":\"\",\"description\":\"\",\"cardType\":\"summary\"}}},\"searchAppearance\":{\"global\":{\"separator\":\"&#45;\",\"siteTitle\":\"#site_title #separator_sa #tagline\",\"metaDescription\":\"#tagline\",\"keywords\":null,\"schema\":{\"websiteName\":\"#site_title\",\"websiteAlternateName\":null,\"siteRepresents\":\"organization\",\"person\":null,\"organizationName\":\"#site_title\",\"organizationDescription\":\"#tagline\",\"organizationLogo\":\"\",\"personName\":null,\"personLogo\":null,\"phone\":null,\"email\":null,\"foundingDate\":null,\"numberOfEmployees\":{\"isRange\":null,\"from\":null,\"to\":null,\"number\":null}}},\"advanced\":{\"globalRobotsMeta\":{\"default\":true,\"noindex\":false,\"nofollow\":false,\"noindexPaginated\":true,\"nofollowPaginated\":true,\"noindexFeed\":true,\"noarchive\":false,\"noimageindex\":false,\"notranslate\":false,\"nosnippet\":false,\"noodp\":false,\"maxSnippet\":-1,\"maxVideoPreview\":-1,\"maxImagePreview\":\"large\"},\"sitelinks\":true,\"noIndexEmptyCat\":true,\"removeStopWords\":false,\"useKeywords\":false,\"keywordsLooking\":true,\"useCategoriesForMetaKeywords\":false,\"useTagsForMetaKeywords\":false,\"dynamicallyGenerateKeywords\":false,\"pagedFormat\":\"#separator_sa Page #page_number\",\"runShortcodes\":false,\"crawlCleanup\":{\"enable\":false,\"feeds\":{\"global\":true,\"globalComments\":false,\"staticBlogPage\":true,\"authors\":true,\"postComments\":false,\"search\":false,\"attachments\":false,\"archives\":{\"all\":false,\"included\":[]},\"taxonomies\":{\"all\":false,\"included\":[\"category\"]},\"atom\":false,\"rdf\":false,\"paginated\":false}},\"blockArgs\":{\"enable\":false,\"logsRetention\":\"{\\\"label\\\":\\\"1 week\\\",\\\"value\\\":\\\"week\\\"}\"},\"removeCategoryBase\":false},\"archives\":{\"author\":{\"show\":true,\"title\":\"#author_name #separator_sa #site_title\",\"metaDescription\":\"#author_bio\",\"advanced\":{\"robotsMeta\":{\"default\":true,\"noindex\":false,\"nofollow\":false,\"noarchive\":false,\"noimageindex\":false,\"notranslate\":false,\"nosnippet\":false,\"noodp\":false,\"maxSnippet\":-1,\"maxVideoPreview\":-1,\"maxImagePreview\":\"large\"},\"showDateInGooglePreview\":true,\"showPostThumbnailInSearch\":true,\"showMetaBox\":true,\"keywords\":null}},\"date\":{\"show\":true,\"title\":\"#archive_date #separator_sa #site_title\",\"metaDescription\":\"\",\"advanced\":{\"robotsMeta\":{\"default\":true,\"noindex\":false,\"nofollow\":false,\"noarchive\":false,\"noimageindex\":false,\"notranslate\":false,\"nosnippet\":false,\"noodp\":false,\"maxSnippet\":-1,\"maxVideoPreview\":-1,\"maxImagePreview\":\"large\"},\"showDateInGooglePreview\":true,\"showPostThumbnailInSearch\":true,\"showMetaBox\":true,\"keywords\":null}},\"search\":{\"show\":false,\"title\":\"#search_term #separator_sa #site_title\",\"metaDescription\":\"\",\"advanced\":{\"robotsMeta\":{\"default\":false,\"noindex\":true,\"nofollow\":false,\"noarchive\":false,\"noimageindex\":false,\"notranslate\":false,\"nosnippet\":false,\"noodp\":false,\"maxSnippet\":-1,\"maxVideoPreview\":-1,\"maxImagePreview\":\"large\"},\"showDateInGooglePreview\":true,\"showPostThumbnailInSearch\":true,\"showMetaBox\":true,\"keywords\":null}}}},\"searchStatistics\":{\"postTypes\":{\"all\":true,\"included\":[\"post\",\"page\"]}},\"tools\":{\"robots\":{\"enable\":false,\"rules\":[],\"robotsDetected\":true},\"importExport\":{\"backup\":{\"lastTime\":null,\"data\":null}}},\"deprecated\":{\"breadcrumbs\":{\"enable\":true},\"searchAppearance\":{\"global\":{\"descriptionFormat\":null,\"schema\":{\"enableSchemaMarkup\":true}},\"advanced\":{\"autogenerateDescriptions\":true,\"runShortcodesInDescription\":true,\"useContentForAutogeneratedDescriptions\":false,\"excludePosts\":[],\"excludeTerms\":[],\"noPaginationForCanonical\":true}},\"sitemap\":{\"general\":{\"advancedSettings\":{\"dynamic\":true}}},\"tools\":{\"blocker\":{\"blockBots\":null,\"blockReferer\":null,\"track\":null,\"custom\":{\"enable\":null,\"bots\":\"Abonti\\naggregator\\nAhrefsBot\\nasterias\\nBDCbot\\nBLEXBot\\nBuiltBotTough\\nBullseye\\nBunnySlippers\\nca-crawler\\nCCBot\\nCegbfeieh\\nCheeseBot\\nCherryPicker\\nCopyRightCheck\\ncosmos\\nCrescent\\ndiscobot\\nDittoSpyder\\nDotBot\\nDownload Ninja\\nEasouSpider\\nEmailCollector\\nEmailSiphon\\nEmailWolf\\nEroCrawler\\nExtractorPro\\nFasterfox\\nFeedBooster\\nFoobot\\nGenieo\\ngrub-client\\nHarvest\\nhloader\\nhttplib\\nHTTrack\\nhumanlinks\\nieautodiscovery\\nInfoNaviRobot\\nIstellaBot\\nJava\\/1.\\nJennyBot\\nk2spider\\nKenjin Spider\\nKeyword Density\\/0.9\\nlarbin\\nLexiBot\\nlibWeb\\nlibwww\\nLinkextractorPro\\nlinko\\nLinkScan\\/8.1a Unix\\nLinkWalker\\nLNSpiderguy\\nlwp-trivial\\nmagpie\\nMata Hari\\nMaxPointCrawler\\nMegaIndex\\nMicrosoft URL Control\\nMIIxpc\\nMippin\\nMissigua Locator\\nMister PiX\\nMJ12bot\\nmoget\\nMSIECrawler\\nNetAnts\\nNICErsPRO\\nNiki-Bot\\nNPBot\\nNutch\\nOffline Explorer\\nOpenfind\\npanscient.com\\nPHP\\/5.{\\nProPowerBot\\/2.14\\nProWebWalker\\nPython-urllib\\nQueryN Metasearch\\nRepoMonkey\\nSISTRIX\\nsitecheck.Internetseer.com\\nSiteSnagger\\nSnapPreviewBot\\nSogou\\nSpankBot\\nspanner\\nspbot\\nSpinn3r\\nsuzuran\\nSzukacz\\/1.4\\nTeleport\\nTelesoft\\nThe Intraformant\\nTheNomad\\nTightTwatBot\\nTitan\\ntoCrawl\\/UrlDispatcher\\nTrue_Robot\\nturingos\\nTurnitinBot\\nUbiCrawler\\nUnisterBot\\nURLy Warning\\nVCI\\nWBSearchBot\\nWeb Downloader\\/6.9\\nWeb Image Collector\\nWebAuto\\nWebBandit\\nWebCopier\\nWebEnhancer\\nWebmasterWorldForumBot\\nWebReaper\\nWebSauger\\nWebsite Quester\\nWebster Pro\\nWebStripper\\nWebZip\\nWotbox\\nwsr-agent\\nWWW-Collector-E\\nXenu\\nZao\\nZeus\\nZyBORG\\ncoccoc\\nIncutio\\nlmspider\\nmemoryBot\\nserf\\nUnknown\\nuptime files\",\"referer\":\"semalt.com\\nkambasoft.com\\nsavetubevideo.com\\nbuttons-for-website.com\\nsharebutton.net\\nsoundfrost.org\\nsrecorder.com\\nsoftomix.com\\nsoftomix.net\\nmyprintscreen.com\\njoinandplay.me\\nfbfreegifts.com\\nopenmediasoft.com\\nzazagames.org\\nextener.org\\nopenfrost.com\\nopenfrost.net\\ngooglsucks.com\\nbest-seo-offer.com\\nbuttons-for-your-website.com\\nwww.Get-Free-Traffic-Now.com\\nbest-seo-solution.com\\nbuy-cheap-online.info\\nsite3.free-share-buttons.com\\nwebmaster-traffic.com\"}}}},\"writingAssistant\":{\"postTypes\":{\"all\":true,\"included\":[\"post\",\"page\"]}}}", "auto");
INSERT INTO `wp_options` VALUES("180", "aioseo_options_lite", "{\"advanced\":{\"usageTracking\":false}}", "auto");
INSERT INTO `wp_options` VALUES("181", "aioseo_options_dynamic", "{\"sitemap\":{\"priority\":{\"postTypes\":{\"post\":{\"priority\":\"{\\\"label\\\":\\\"default\\\",\\\"value\\\":\\\"default\\\"}\",\"frequency\":\"{\\\"label\\\":\\\"default\\\",\\\"value\\\":\\\"default\\\"}\"},\"page\":{\"priority\":\"{\\\"label\\\":\\\"default\\\",\\\"value\\\":\\\"default\\\"}\",\"frequency\":\"{\\\"label\\\":\\\"default\\\",\\\"value\\\":\\\"default\\\"}\"},\"attachment\":{\"priority\":\"{\\\"label\\\":\\\"default\\\",\\\"value\\\":\\\"default\\\"}\",\"frequency\":\"{\\\"label\\\":\\\"default\\\",\\\"value\\\":\\\"default\\\"}\"}},\"taxonomies\":{\"category\":{\"priority\":\"{\\\"label\\\":\\\"default\\\",\\\"value\\\":\\\"default\\\"}\",\"frequency\":\"{\\\"label\\\":\\\"default\\\",\\\"value\\\":\\\"default\\\"}\"},\"post_tag\":{\"priority\":\"{\\\"label\\\":\\\"default\\\",\\\"value\\\":\\\"default\\\"}\",\"frequency\":\"{\\\"label\\\":\\\"default\\\",\\\"value\\\":\\\"default\\\"}\"}}}},\"social\":{\"facebook\":{\"general\":{\"postTypes\":{\"post\":{\"objectType\":\"article\"},\"page\":{\"objectType\":\"article\"},\"attachment\":{\"objectType\":\"article\"}}}}},\"searchAppearance\":{\"postTypes\":{\"post\":{\"show\":true,\"advanced\":{\"robotsMeta\":{\"default\":true,\"noindex\":false,\"nofollow\":false,\"noarchive\":false,\"noimageindex\":false,\"notranslate\":false,\"nosnippet\":false,\"noodp\":false,\"maxSnippet\":-1,\"maxVideoPreview\":-1,\"maxImagePreview\":\"large\"},\"showDateInGooglePreview\":true,\"showPostThumbnailInSearch\":true,\"showMetaBox\":true,\"bulkEditing\":\"enabled\"},\"title\":\"#post_title #separator_sa #site_title\",\"metaDescription\":\"#post_excerpt\",\"schemaType\":\"Article\",\"webPageType\":\"WebPage\",\"articleType\":\"BlogPosting\",\"customFields\":null},\"page\":{\"show\":true,\"advanced\":{\"robotsMeta\":{\"default\":true,\"noindex\":false,\"nofollow\":false,\"noarchive\":false,\"noimageindex\":false,\"notranslate\":false,\"nosnippet\":false,\"noodp\":false,\"maxSnippet\":-1,\"maxVideoPreview\":-1,\"maxImagePreview\":\"large\"},\"showDateInGooglePreview\":true,\"showPostThumbnailInSearch\":true,\"showMetaBox\":true,\"bulkEditing\":\"enabled\"},\"title\":\"#post_title #separator_sa #site_title\",\"metaDescription\":\"#post_content\",\"schemaType\":\"WebPage\",\"webPageType\":\"WebPage\",\"articleType\":\"BlogPosting\",\"customFields\":null},\"attachment\":{\"show\":true,\"advanced\":{\"robotsMeta\":{\"default\":true,\"noindex\":false,\"nofollow\":false,\"noarchive\":false,\"noimageindex\":false,\"notranslate\":false,\"nosnippet\":false,\"noodp\":false,\"maxSnippet\":-1,\"maxVideoPreview\":-1,\"maxImagePreview\":\"large\"},\"showDateInGooglePreview\":true,\"showPostThumbnailInSearch\":true,\"showMetaBox\":true,\"bulkEditing\":\"enabled\"},\"title\":\"#post_title #separator_sa #site_title\",\"metaDescription\":\"#attachment_caption\",\"schemaType\":\"ItemPage\",\"webPageType\":\"ItemPage\",\"articleType\":\"BlogPosting\",\"customFields\":null,\"redirectAttachmentUrls\":\"attachment\"}},\"taxonomies\":{\"category\":{\"show\":true,\"advanced\":{\"robotsMeta\":{\"default\":true,\"noindex\":false,\"nofollow\":false,\"noarchive\":false,\"noimageindex\":false,\"notranslate\":false,\"nosnippet\":false,\"noodp\":false,\"maxSnippet\":-1,\"maxVideoPreview\":-1,\"maxImagePreview\":\"large\"},\"showDateInGooglePreview\":true,\"showPostThumbnailInSearch\":true,\"showMetaBox\":true},\"title\":\"#taxonomy_title #separator_sa #site_title\",\"metaDescription\":\"#taxonomy_description\"},\"post_tag\":{\"show\":true,\"advanced\":{\"robotsMeta\":{\"default\":true,\"noindex\":false,\"nofollow\":false,\"noarchive\":false,\"noimageindex\":false,\"notranslate\":false,\"nosnippet\":false,\"noodp\":false,\"maxSnippet\":-1,\"maxVideoPreview\":-1,\"maxImagePreview\":\"large\"},\"showDateInGooglePreview\":true,\"showPostThumbnailInSearch\":true,\"showMetaBox\":true},\"title\":\"#taxonomy_title #separator_sa #site_title\",\"metaDescription\":\"#taxonomy_description\"}},\"archives\":[]}}", "auto");
INSERT INTO `wp_options` VALUES("185", "hostinger_subscription_id", "169y4aUe02IpG27lS", "on");
INSERT INTO `wp_options` VALUES("187", "hostinger_hosting_plan", "hostinger_premium", "on");
INSERT INTO `wp_options` VALUES("188", "hostinger_client_type", "smb", "off");
INSERT INTO `wp_options` VALUES("189", "hostinger_website_type", "business", "off");
INSERT INTO `wp_options` VALUES("191", "hostinger_builder_type", "prebuilt", "off");
INSERT INTO `wp_options` VALUES("192", "current_theme", "Moving", "auto");
INSERT INTO `wp_options` VALUES("193", "theme_switched", "", "auto");
INSERT INTO `wp_options` VALUES("194", "theme_mods_astra", "a:4:{s:18:\"nav_menu_locations\";a:3:{s:7:\"primary\";i:2;s:11:\"mobile_menu\";i:2;s:11:\"footer_menu\";i:2;}s:11:\"custom_logo\";s:3:\"965\";s:18:\"custom_css_post_id\";i:7;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1740654861;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:9:\"sidebar-1\";a:5:{i:0;s:7:\"block-7\";i:1;s:7:\"block-8\";i:2;s:7:\"block-9\";i:3;s:8:\"block-10\";i:4;s:8:\"block-11\";}s:15:\"footer-widget-1\";a:2:{i:0;s:8:\"block-12\";i:1;s:8:\"block-13\";}}}}", "off");
INSERT INTO `wp_options` VALUES("195", "hostinger_template_id", "68171", "off");
INSERT INTO `wp_options` VALUES("196", "hostinger_plugins", "[\"omnisend\",\"all-in-one-seo-pack\",\"wpforms-lite\",\"google-site-kit\"]", "off");
INSERT INTO `wp_options` VALUES("197", "hostinger_website_id", "d29df3fb1a95cbd3eddae8d90fa70023", "off");
INSERT INTO `wp_options` VALUES("198", "hostinger_created_at", "2025-02-27 10:48:35", "off");
INSERT INTO `wp_options` VALUES("199", "astra_sites_recent_import_log_file", "/home/u940523010/domains/katerinasamanatebi.com/public_html/wp-content/uploads/astra-sites-import-katerinasamanatebi.com-27-Feb-2025-10-49-06.log", "on");
INSERT INTO `wp_options` VALUES("200", "hostinger_reseller", "hostinger.com", "off");
INSERT INTO `wp_options` VALUES("205", "__uagb_do_redirect", "1", "auto");
INSERT INTO `wp_options` VALUES("206", "__uagb_activated_before", "1", "auto");
INSERT INTO `wp_options` VALUES("207", "__uagb_asset_version", "1769770663", "auto");
INSERT INTO `wp_options` VALUES("208", "uagb_site_url", "katerinasamanatebi-com", "auto");
INSERT INTO `wp_options` VALUES("211", "__srfm_do_redirect", "1", "auto");
INSERT INTO `wp_options` VALUES("212", "astra_sites_wpforms_ids_mapping", "a:1:{i:14;i:5;}", "off");
INSERT INTO `wp_options` VALUES("213", "srfm_database_table_versions", "a:1:{s:7:\"entries\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("214", "srfm-version", "1.13.2", "auto");
INSERT INTO `wp_options` VALUES("215", "_astra_sites_old_customizer_data", "a:2:{s:14:\"astra-settings\";a:2157:{s:17:\"blog-single-width\";s:7:\"default\";s:21:\"blog-single-max-width\";i:1200;s:17:\"page-single-width\";s:7:\"default\";s:21:\"page-single-max-width\";i:1200;s:28:\"single-content-images-shadow\";b:0;s:30:\"single-post-ast-content-layout\";s:7:\"default\";s:25:\"single-post-sidebar-style\";s:7:\"default\";s:36:\"ast-dynamic-single-post-elements-gap\";i:10;s:38:\"ast-dynamic-single-post-meta-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:40:\"ast-dynamic-single-post-meta-font-weight\";s:0:\"\";s:32:\"ast-dynamic-single-post-metadata\";a:3:{i:0;s:8:\"comments\";i:1;s:32:\"ast-dynamic-single-post-taxonomy\";i:2;s:6:\"author\";}s:35:\"section-search-page-title-structure\";a:1:{i:0;s:31:\"section-search-page-title-title\";}s:38:\"section-search-page-title-custom-title\";s:19:\"Search Results for:\";s:50:\"section-search-page-title-found-custom-description\";s:44:\"Here are the search results for your search.\";s:54:\"section-search-page-title-not-found-custom-description\";s:85:\"Sorry, but we could not find anything related to your search terms. Please try again.\";s:43:\"section-search-page-title-title-font-weight\";s:0:\"\";s:41:\"section-search-page-title-title-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"ast-search-results-per-page\";i:10;s:46:\"section-search-page-title-horizontal-alignment\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"ast-search-live-search\";b:0;s:33:\"ast-search-live-search-post-types\";a:2:{s:4:\"post\";i:1;s:4:\"page\";i:1;}s:19:\"blog-post-structure\";a:5:{i:0;s:5:\"image\";i:1;s:5:\"title\";i:2;s:10:\"title-meta\";i:3;s:7:\"excerpt\";i:4;s:9:\"read-more\";}s:18:\"blog-post-per-page\";i:10;s:17:\"blog-hover-effect\";s:4:\"none\";s:11:\"blog-layout\";s:19:\"blog-layout-classic\";s:10:\"blog-width\";s:7:\"default\";s:19:\"blog-meta-date-type\";s:9:\"published\";s:21:\"blog-meta-date-format\";s:0:\"\";s:14:\"blog-max-width\";i:1200;s:17:\"blog-post-content\";s:7:\"excerpt\";s:9:\"blog-meta\";a:3:{i:0;s:8:\"comments\";i:1;s:8:\"category\";i:2;s:6:\"author\";}s:23:\"post-card-border-radius\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"post-card-featured-overlay\";s:0:\"\";s:19:\"blog-category-style\";s:7:\"default\";s:14:\"blog-tag-style\";s:7:\"default\";s:27:\"blog-post-meta-divider-type\";s:1:\"/\";s:24:\"blog-meta-category-style\";s:7:\"default\";s:19:\"blog-meta-tag-style\";s:7:\"default\";s:21:\"blog-image-ratio-type\";s:0:\"\";s:26:\"blog-image-ratio-pre-scale\";s:4:\"16/9\";s:29:\"blog-image-custom-scale-width\";i:16;s:30:\"blog-image-custom-scale-height\";i:9;s:10:\"text-color\";s:25:\"var(--ast-global-color-3)\";s:10:\"link-color\";s:7:\"#ffffff\";s:11:\"theme-color\";s:25:\"var(--ast-global-color-0)\";s:12:\"link-h-color\";s:25:\"var(--ast-global-color-1)\";s:18:\"heading-base-color\";s:25:\"var(--ast-global-color-2)\";s:12:\"border-color\";s:0:\"\";s:13:\"footer-bg-obj\";a:12:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:12:\"footer-color\";s:0:\"\";s:17:\"footer-link-color\";s:0:\"\";s:19:\"footer-link-h-color\";s:0:\"\";s:17:\"footer-adv-bg-obj\";a:12:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:21:\"footer-adv-text-color\";s:0:\"\";s:21:\"footer-adv-link-color\";s:0:\"\";s:23:\"footer-adv-link-h-color\";s:0:\"\";s:26:\"footer-adv-wgt-title-color\";s:0:\"\";s:12:\"button-color\";s:7:\"#ffffff\";s:14:\"button-h-color\";s:7:\"#ffffff\";s:15:\"button-bg-color\";s:25:\"var(--ast-global-color-0)\";s:17:\"button-bg-h-color\";s:25:\"var(--ast-global-color-0)\";s:27:\"secondary-button-bg-h-color\";s:25:\"var(--ast-global-color-0)\";s:25:\"secondary-button-bg-color\";s:0:\"\";s:22:\"secondary-button-color\";s:25:\"var(--ast-global-color-0)\";s:24:\"secondary-button-h-color\";s:7:\"#ffffff\";s:20:\"theme-button-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"14\";s:5:\"right\";s:2:\"28\";s:6:\"bottom\";s:2:\"14\";s:4:\"left\";s:2:\"28\";}s:6:\"tablet\";a:4:{s:3:\"top\";i:14;s:5:\"right\";i:28;s:6:\"bottom\";i:14;s:4:\"left\";i:28;}s:6:\"mobile\";a:4:{s:3:\"top\";i:12;s:5:\"right\";i:24;s:6:\"bottom\";i:12;s:4:\"left\";i:24;}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:30:\"secondary-theme-button-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"14\";s:5:\"right\";s:2:\"28\";s:6:\"bottom\";s:2:\"14\";s:4:\"left\";s:2:\"28\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:2:\"14\";s:5:\"right\";s:2:\"28\";s:6:\"bottom\";s:2:\"14\";s:4:\"left\";s:2:\"28\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:2:\"12\";s:5:\"right\";s:2:\"24\";s:6:\"bottom\";s:2:\"12\";s:4:\"left\";s:2:\"22\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:20:\"button-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:4;s:5:\"right\";i:4;s:6:\"bottom\";i:4;s:4:\"left\";i:4;}s:6:\"tablet\";a:4:{s:3:\"top\";s:1:\"4\";s:5:\"right\";s:1:\"4\";s:6:\"bottom\";s:1:\"4\";s:4:\"left\";s:1:\"4\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:1:\"4\";s:5:\"right\";s:1:\"4\";s:6:\"bottom\";s:1:\"4\";s:4:\"left\";s:1:\"4\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:30:\"secondary-button-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:4;s:5:\"right\";i:4;s:6:\"bottom\";i:4;s:4:\"left\";i:4;}s:6:\"tablet\";a:4:{s:3:\"top\";s:1:\"4\";s:5:\"right\";s:1:\"4\";s:6:\"bottom\";s:1:\"4\";s:4:\"left\";s:1:\"4\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:1:\"4\";s:5:\"right\";s:1:\"4\";s:6:\"bottom\";s:1:\"4\";s:4:\"left\";s:1:\"4\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:37:\"theme-button-border-group-border-size\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";}s:47:\"secondary-theme-button-border-group-border-size\";a:4:{s:3:\"top\";s:1:\"1\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:1:\"1\";}s:17:\"footer-sml-layout\";s:19:\"footer-sml-layout-1\";s:20:\"footer-sml-section-1\";s:6:\"custom\";s:27:\"footer-sml-section-1-credit\";s:72:\"Copyright &copy; [current_year] [site_title] | Powered by [theme_author]\";s:20:\"footer-sml-section-2\";s:0:\"\";s:27:\"footer-sml-section-2-credit\";s:72:\"Copyright &copy; [current_year] [site_title] | Powered by [theme_author]\";s:27:\"footer-sml-dist-equal-align\";b:1;s:18:\"footer-sml-divider\";i:1;s:24:\"footer-sml-divider-color\";s:7:\"#7a7a7a\";s:19:\"footer-layout-width\";s:7:\"content\";s:22:\"ast-header-retina-logo\";s:94:\"https://websitedemos.net/family-lawyer-08/wp-content/uploads/sites/932/2021/04/site-logo-1.svg\";s:17:\"use-logo-svg-icon\";b:0;s:13:\"logo-svg-icon\";a:2:{s:4:\"type\";s:0:\"\";s:5:\"value\";s:0:\"\";}s:23:\"logo-svg-site-title-gap\";a:3:{s:7:\"desktop\";s:1:\"5\";s:6:\"tablet\";s:1:\"5\";s:6:\"mobile\";s:1:\"5\";}s:21:\"ast-header-logo-width\";s:0:\"\";s:32:\"ast-header-responsive-logo-width\";a:4:{s:7:\"desktop\";i:115;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:18:\"desktop-svg-height\";i:29;}s:23:\"header-color-site-title\";s:0:\"\";s:25:\"header-color-h-site-title\";s:0:\"\";s:25:\"header-color-site-tagline\";s:0:\"\";s:29:\"display-site-title-responsive\";a:3:{s:7:\"desktop\";b:0;s:6:\"tablet\";b:0;s:6:\"mobile\";b:0;}s:31:\"display-site-tagline-responsive\";a:3:{s:7:\"desktop\";b:0;s:6:\"tablet\";i:0;s:6:\"mobile\";i:0;}s:17:\"logo-title-inline\";i:1;s:19:\"disable-primary-nav\";b:0;s:14:\"header-layouts\";s:20:\"header-main-layout-1\";s:22:\"header-main-rt-section\";s:4:\"none\";s:27:\"header-display-outside-menu\";b:0;s:27:\"header-main-rt-section-html\";s:27:\"<button>Contact Us</button>\";s:34:\"header-main-rt-section-button-text\";s:6:\"Button\";s:34:\"header-main-rt-section-button-link\";s:23:\"https://www.wpastra.com\";s:41:\"header-main-rt-section-button-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:35:\"header-main-rt-section-button-style\";s:12:\"theme-button\";s:40:\"header-main-rt-section-button-text-color\";s:0:\"\";s:40:\"header-main-rt-section-button-back-color\";s:0:\"\";s:42:\"header-main-rt-section-button-text-h-color\";s:0:\"\";s:42:\"header-main-rt-section-button-back-h-color\";s:0:\"\";s:37:\"header-main-rt-section-button-padding\";a:3:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}}s:41:\"header-main-rt-section-button-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:15:\"header-main-sep\";i:1;s:21:\"header-main-sep-color\";s:0:\"\";s:24:\"header-main-layout-width\";s:7:\"content\";s:22:\"primary-submenu-border\";a:4:{s:3:\"top\";s:1:\"2\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";}s:27:\"primary-submenu-item-border\";b:0;s:23:\"primary-submenu-b-color\";s:0:\"\";s:28:\"primary-submenu-item-b-color\";s:0:\"\";s:33:\"primary-header-button-font-family\";s:7:\"inherit\";s:33:\"primary-header-button-font-weight\";s:7:\"inherit\";s:31:\"primary-header-button-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"primary-header-button-text-transform\";s:0:\"\";s:33:\"primary-header-button-line-height\";i:1;s:36:\"primary-header-button-letter-spacing\";s:0:\"\";s:22:\"header-main-menu-label\";s:0:\"\";s:22:\"header-main-menu-align\";s:6:\"inline\";s:39:\"header-main-submenu-container-animation\";s:0:\"\";s:24:\"mobile-header-breakpoint\";s:0:\"\";s:18:\"mobile-header-logo\";s:0:\"\";s:24:\"mobile-header-logo-width\";s:0:\"\";s:11:\"site-layout\";s:21:\"ast-full-width-layout\";s:18:\"site-content-width\";i:1200;s:26:\"narrow-container-max-width\";i:750;s:37:\"site-layout-outside-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:11:{s:16:\"background-color\";s:7:\"#ffffff\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:25:\"content-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:11:{s:16:\"background-color\";s:25:\"var(--ast-global-color-5)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:11:{s:16:\"background-color\";s:25:\"var(--ast-global-color-5)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:11:{s:16:\"background-color\";s:25:\"var(--ast-global-color-5)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:12:\"wp-blocks-ui\";s:7:\"comfort\";s:24:\"wp-blocks-global-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:20:\"enable-comments-area\";b:1;s:22:\"comments-box-placement\";s:0:\"\";s:21:\"comment-form-position\";s:5:\"below\";s:28:\"comments-box-container-width\";s:0:\"\";s:31:\"ast-sub-section-comments-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:32:\"ast-sub-section-comments-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";i:3;s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:30:\"single-page-ast-content-layout\";s:7:\"default\";s:25:\"single-page-content-style\";s:7:\"default\";s:25:\"single-post-content-style\";s:7:\"default\";s:31:\"archive-post-ast-content-layout\";s:7:\"default\";s:23:\"ast-site-content-layout\";s:22:\"normal-width-container\";s:18:\"site-content-style\";s:5:\"boxed\";s:16:\"body-font-family\";s:21:\"\'Poppins\', sans-serif\";s:17:\"body-font-variant\";s:0:\"\";s:16:\"body-font-weight\";s:3:\"400\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-font-extras\";a:6:{s:11:\"line-height\";s:4:\"1.65\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:29:\"headings-font-height-settings\";a:6:{s:11:\"line-height\";i:1;s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:18:\"para-margin-bottom\";s:0:\"\";s:23:\"underline-content-links\";b:1;s:25:\"site-accessibility-toggle\";b:1;s:33:\"site-accessibility-highlight-type\";s:6:\"dotted\";s:39:\"site-accessibility-highlight-input-type\";s:7:\"disable\";s:19:\"body-text-transform\";s:0:\"\";s:20:\"headings-font-family\";s:14:\"\'Amiri\', serif\";s:20:\"headings-font-weight\";s:3:\"700\";s:20:\"font-size-site-title\";a:6:{s:7:\"desktop\";i:35;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"font-size-site-tagline\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"single-post-outside-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:20:\"font-size-page-title\";a:6:{s:7:\"desktop\";i:26;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:18:\"font-size-post-tax\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"font-size-post-meta\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h1\";a:6:{s:7:\"desktop\";s:2:\"55\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h2\";a:6:{s:7:\"desktop\";s:2:\"36\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h3\";a:6:{s:7:\"desktop\";s:2:\"28\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h4\";a:6:{s:7:\"desktop\";s:2:\"22\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h5\";a:6:{s:7:\"desktop\";i:20;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h6\";a:6:{s:7:\"desktop\";s:2:\"16\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"site-sidebar-layout\";s:10:\"no-sidebar\";s:18:\"site-sidebar-width\";i:30;s:26:\"single-page-sidebar-layout\";s:10:\"no-sidebar\";s:26:\"single-post-sidebar-layout\";s:7:\"default\";s:27:\"archive-post-sidebar-layout\";s:7:\"default\";s:19:\"site-sticky-sidebar\";b:0;s:18:\"site-sidebar-style\";s:5:\"boxed\";s:25:\"single-page-sidebar-style\";s:7:\"unboxed\";s:26:\"archive-post-sidebar-style\";s:7:\"default\";s:10:\"footer-adv\";s:8:\"disabled\";s:23:\"footer-adv-border-width\";s:0:\"\";s:23:\"footer-adv-border-color\";s:7:\"#7a7a7a\";s:30:\"mobile-header-toggle-btn-style\";s:7:\"minimal\";s:23:\"hide-custom-menu-mobile\";i:1;s:27:\"mobile-header-toggle-target\";s:4:\"icon\";s:19:\"enable-scroll-to-id\";b:0;s:37:\"ast-dynamic-single-download-structure\";a:3:{i:0;s:33:\"ast-dynamic-single-download-title\";i:1;s:32:\"ast-dynamic-single-download-meta\";i:2;s:33:\"ast-dynamic-single-download-image\";}s:20:\"enable-related-posts\";b:0;s:19:\"related-posts-title\";s:13:\"Related Posts\";s:29:\"releted-posts-title-alignment\";s:4:\"left\";s:25:\"related-posts-total-count\";i:2;s:28:\"enable-related-posts-excerpt\";b:0;s:27:\"related-posts-box-placement\";s:7:\"default\";s:30:\"related-posts-outside-location\";s:5:\"above\";s:29:\"related-posts-container-width\";s:8:\"fallback\";s:27:\"related-posts-excerpt-count\";i:25;s:22:\"related-posts-based-on\";s:10:\"categories\";s:22:\"related-posts-order-by\";s:4:\"date\";s:19:\"related-posts-order\";s:3:\"asc\";s:29:\"related-posts-grid-responsive\";a:3:{s:7:\"desktop\";s:7:\"2-equal\";s:6:\"tablet\";s:7:\"2-equal\";s:6:\"mobile\";s:4:\"full\";}s:23:\"related-posts-structure\";a:2:{i:0;s:14:\"featured-image\";i:1;s:10:\"title-meta\";}s:23:\"related-posts-tag-style\";s:4:\"none\";s:28:\"related-posts-category-style\";s:4:\"none\";s:25:\"related-posts-date-format\";s:0:\"\";s:28:\"related-posts-meta-date-type\";s:9:\"published\";s:32:\"related-posts-author-avatar-size\";s:0:\"\";s:27:\"related-posts-author-avatar\";b:0;s:33:\"related-posts-author-prefix-label\";s:3:\"By \";s:24:\"related-posts-image-size\";s:0:\"\";s:38:\"related-posts-image-custom-scale-width\";i:16;s:39:\"related-posts-image-custom-scale-height\";i:9;s:35:\"related-posts-image-ratio-pre-scale\";s:4:\"16/9\";s:30:\"related-posts-image-ratio-type\";s:0:\"\";s:28:\"related-posts-meta-structure\";a:3:{i:0;s:8:\"comments\";i:1;s:8:\"category\";i:2;s:6:\"author\";}s:24:\"related-posts-text-color\";s:0:\"\";s:24:\"related-posts-link-color\";s:0:\"\";s:25:\"related-posts-title-color\";s:0:\"\";s:30:\"related-posts-background-color\";s:0:\"\";s:24:\"related-posts-meta-color\";s:0:\"\";s:30:\"related-posts-link-hover-color\";s:0:\"\";s:35:\"related-posts-meta-link-hover-color\";s:0:\"\";s:39:\"related-posts-section-title-font-family\";s:7:\"inherit\";s:39:\"related-posts-section-title-font-weight\";s:7:\"inherit\";s:42:\"related-posts-section-title-text-transform\";s:0:\"\";s:39:\"related-posts-section-title-line-height\";s:0:\"\";s:39:\"related-posts-section-title-font-extras\";a:6:{s:11:\"line-height\";s:3:\"1.6\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:37:\"related-posts-section-title-font-size\";a:6:{s:7:\"desktop\";s:2:\"30\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"related-posts-title-font-family\";s:7:\"inherit\";s:31:\"related-posts-title-font-weight\";s:7:\"inherit\";s:34:\"related-posts-title-text-transform\";s:0:\"\";s:31:\"related-posts-title-line-height\";s:1:\"1\";s:29:\"related-posts-title-font-size\";a:6:{s:7:\"desktop\";s:2:\"20\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"related-posts-title-font-extras\";a:6:{s:11:\"line-height\";s:1:\"1\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:30:\"related-posts-meta-font-family\";s:7:\"inherit\";s:30:\"related-posts-meta-font-weight\";s:7:\"inherit\";s:33:\"related-posts-meta-text-transform\";s:0:\"\";s:30:\"related-posts-meta-line-height\";s:0:\"\";s:28:\"related-posts-meta-font-size\";a:6:{s:7:\"desktop\";s:2:\"14\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:30:\"related-posts-meta-font-extras\";a:6:{s:11:\"line-height\";s:3:\"1.6\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"related-posts-content-font-family\";s:7:\"inherit\";s:33:\"related-posts-content-font-weight\";s:7:\"inherit\";s:33:\"related-posts-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:31:\"related-posts-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:37:\"ast-sub-section-related-posts-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";d:2.5;s:5:\"right\";d:2.5;s:6:\"bottom\";d:2.5;s:4:\"left\";d:2.5;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:36:\"ast-sub-section-related-posts-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:2;s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:23:\"transparent-header-logo\";s:94:\"https://websitedemos.net/family-lawyer-08/wp-content/uploads/sites/932/2021/04/site-logo-1.svg\";s:30:\"transparent-header-retina-logo\";s:0:\"\";s:26:\"different-transparent-logo\";b:1;s:33:\"different-transparent-retina-logo\";i:0;s:29:\"transparent-header-logo-width\";a:4:{s:7:\"desktop\";i:115;s:6:\"tablet\";i:120;s:6:\"mobile\";i:100;s:18:\"desktop-svg-height\";i:46;}s:25:\"transparent-header-enable\";i:0;s:34:\"transparent-header-disable-archive\";i:1;s:45:\"transparent-header-disable-latest-posts-index\";i:1;s:29:\"transparent-header-on-devices\";s:4:\"both\";s:27:\"transparent-header-main-sep\";i:0;s:33:\"transparent-header-main-sep-color\";s:0:\"\";s:27:\"transparent-header-bg-color\";s:0:\"\";s:35:\"transparent-header-color-site-title\";s:0:\"\";s:37:\"transparent-header-color-h-site-title\";s:0:\"\";s:25:\"transparent-menu-bg-color\";s:0:\"\";s:22:\"transparent-menu-color\";s:0:\"\";s:24:\"transparent-menu-h-color\";s:0:\"\";s:28:\"transparent-submenu-bg-color\";s:0:\"\";s:25:\"transparent-submenu-color\";s:0:\"\";s:27:\"transparent-submenu-h-color\";s:0:\"\";s:29:\"transparent-header-logo-color\";s:0:\"\";s:38:\"transparent-header-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:42:\"hba-transparent-header-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:42:\"hbb-transparent-header-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:46:\"transparent-header-color-site-title-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:48:\"transparent-header-color-h-site-title-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:36:\"transparent-menu-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"transparent-menu-color-responsive\";a:3:{s:7:\"desktop\";s:7:\"#ffffff\";s:6:\"tablet\";s:7:\"#000000\";s:6:\"mobile\";s:0:\"\";}s:35:\"transparent-menu-h-color-responsive\";a:3:{s:7:\"desktop\";s:7:\"#cba557\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:39:\"transparent-submenu-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:36:\"transparent-submenu-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:38:\"transparent-submenu-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:49:\"transparent-content-section-text-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:49:\"transparent-content-section-link-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:51:\"transparent-content-section-link-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:32:\"breadcrumb-text-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"breadcrumb-active-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"breadcrumb-hover-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"breadcrumb-separator-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:19:\"breadcrumb-bg-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:18:\"breadcrumb-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"breadcrumb-font-family\";s:7:\"inherit\";s:22:\"breadcrumb-font-weight\";s:7:\"inherit\";s:20:\"breadcrumb-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"breadcrumb-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:29:\"breadcrumb-separator-selector\";s:7:\"unicode\";s:20:\"breadcrumb-separator\";s:4:\"\00bb\";s:20:\"scroll-to-top-enable\";b:0;s:23:\"scroll-to-top-icon-size\";i:15;s:27:\"scroll-to-top-icon-position\";s:5:\"right\";s:24:\"scroll-to-top-on-devices\";s:4:\"both\";s:32:\"scroll-to-top-icon-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"scroll-to-top-icon-color\";s:0:\"\";s:26:\"scroll-to-top-icon-h-color\";s:0:\"\";s:27:\"scroll-to-top-icon-bg-color\";s:0:\"\";s:29:\"scroll-to-top-icon-h-bg-color\";s:0:\"\";s:8:\"h1-color\";s:0:\"\";s:8:\"h2-color\";s:0:\"\";s:8:\"h3-color\";s:0:\"\";s:8:\"h4-color\";s:0:\"\";s:8:\"h5-color\";s:0:\"\";s:8:\"h6-color\";s:0:\"\";s:14:\"font-family-h1\";s:7:\"inherit\";s:14:\"font-weight-h1\";s:7:\"inherit\";s:14:\"font-extras-h1\";a:2:{s:11:\"line-height\";s:3:\"1.4\";s:16:\"line-height-unit\";s:2:\"em\";}s:14:\"font-family-h2\";s:7:\"inherit\";s:14:\"font-weight-h2\";s:7:\"inherit\";s:14:\"font-extras-h2\";a:2:{s:11:\"line-height\";s:3:\"1.3\";s:16:\"line-height-unit\";s:2:\"em\";}s:14:\"font-family-h3\";s:7:\"inherit\";s:14:\"font-weight-h3\";s:7:\"inherit\";s:14:\"font-extras-h3\";a:2:{s:11:\"line-height\";s:3:\"1.3\";s:16:\"line-height-unit\";s:2:\"em\";}s:14:\"font-family-h4\";s:7:\"inherit\";s:14:\"font-weight-h4\";s:7:\"inherit\";s:14:\"font-extras-h4\";a:2:{s:11:\"line-height\";s:3:\"1.2\";s:16:\"line-height-unit\";s:2:\"em\";}s:14:\"font-family-h5\";s:7:\"inherit\";s:14:\"font-weight-h5\";s:7:\"inherit\";s:14:\"font-extras-h5\";a:2:{s:11:\"line-height\";s:3:\"1.2\";s:16:\"line-height-unit\";s:2:\"em\";}s:14:\"font-family-h6\";s:7:\"inherit\";s:14:\"font-weight-h6\";s:7:\"inherit\";s:14:\"font-extras-h6\";a:2:{s:11:\"line-height\";s:4:\"1.25\";s:16:\"line-height-unit\";s:2:\"em\";}s:18:\"font-weight-button\";s:3:\"500\";s:28:\"secondary-font-weight-button\";s:3:\"500\";s:18:\"font-family-button\";s:7:\"inherit\";s:28:\"secondary-font-family-button\";s:7:\"inherit\";s:16:\"font-size-button\";a:6:{s:7:\"desktop\";s:2:\"13\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:2:\"13\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"secondary-font-size-button\";a:6:{s:7:\"desktop\";s:2:\"13\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:2:\"13\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:18:\"font-extras-button\";a:6:{s:11:\"line-height\";i:1;s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";i:1;s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:9:\"uppercase\";s:15:\"text-decoration\";s:0:\"\";}s:28:\"secondary-font-extras-button\";a:6:{s:11:\"line-height\";i:1;s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:9:\"uppercase\";s:15:\"text-decoration\";s:0:\"\";}s:20:\"header-desktop-items\";a:5:{s:5:\"popup\";a:1:{s:13:\"popup_content\";a:1:{i:0;s:11:\"mobile-menu\";}}s:5:\"above\";a:5:{s:10:\"above_left\";a:1:{i:0;s:4:\"logo\";}s:17:\"above_left_center\";a:0:{}s:12:\"above_center\";a:1:{i:0;s:6:\"menu-1\";}s:18:\"above_right_center\";a:0:{}s:11:\"above_right\";a:1:{i:0;s:8:\"button-1\";}}s:7:\"primary\";a:5:{s:12:\"primary_left\";a:0:{}s:19:\"primary_left_center\";a:0:{}s:14:\"primary_center\";a:0:{}s:20:\"primary_right_center\";a:0:{}s:13:\"primary_right\";a:0:{}}s:5:\"below\";a:5:{s:10:\"below_left\";a:0:{}s:17:\"below_left_center\";a:0:{}s:12:\"below_center\";a:0:{}s:18:\"below_right_center\";a:0:{}s:11:\"below_right\";a:0:{}}s:4:\"flag\";b:0;}s:19:\"header-mobile-items\";a:5:{s:5:\"popup\";a:1:{s:13:\"popup_content\";a:1:{i:0;s:11:\"mobile-menu\";}}s:5:\"above\";a:3:{s:10:\"above_left\";a:0:{}s:12:\"above_center\";a:0:{}s:11:\"above_right\";a:0:{}}s:7:\"primary\";a:3:{s:12:\"primary_left\";a:1:{i:0;s:4:\"logo\";}s:14:\"primary_center\";a:0:{}s:13:\"primary_right\";a:1:{i:0;s:14:\"mobile-trigger\";}}s:5:\"below\";a:3:{s:10:\"below_left\";a:0:{}s:12:\"below_center\";a:0:{}s:11:\"below_right\";a:0:{}}s:4:\"flag\";b:0;}s:27:\"hb-header-main-layout-width\";s:7:\"content\";s:16:\"hb-header-height\";a:3:{s:7:\"desktop\";i:70;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:8:\"hb-stack\";a:3:{s:7:\"desktop\";s:5:\"stack\";s:6:\"tablet\";s:5:\"stack\";s:6:\"mobile\";s:5:\"stack\";}s:18:\"hb-header-main-sep\";i:1;s:24:\"hb-header-main-sep-color\";s:7:\"#eaeaea\";s:25:\"hb-header-main-menu-align\";s:6:\"inline\";s:27:\"hb-header-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:7:\"#ffffff\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:17:\"hb-header-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:3:\"1.5\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:3:\"1.5\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:1:\"1\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:17:\"hba-header-layout\";s:21:\"above-header-layout-1\";s:17:\"hba-header-height\";a:3:{s:7:\"desktop\";i:50;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:9:\"hba-stack\";a:3:{s:7:\"desktop\";s:5:\"stack\";s:6:\"tablet\";s:5:\"stack\";s:6:\"mobile\";s:5:\"stack\";}s:20:\"hba-header-separator\";i:1;s:30:\"hba-header-bottom-border-color\";s:7:\"#eaeaea\";s:28:\"hba-header-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:7:\"#ffffff\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:32:\"hba-header-text-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:32:\"hba-header-link-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"hba-header-link-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:18:\"hba-header-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:3:\"0.5\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"em\";}s:17:\"hbb-header-layout\";s:21:\"below-header-layout-1\";s:17:\"hbb-header-height\";a:3:{s:7:\"desktop\";i:60;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:9:\"hbb-stack\";a:3:{s:7:\"desktop\";s:5:\"stack\";s:6:\"tablet\";s:5:\"stack\";s:6:\"mobile\";s:5:\"stack\";}s:20:\"hbb-header-separator\";i:1;s:30:\"hbb-header-bottom-border-color\";s:7:\"#eaeaea\";s:28:\"hbb-header-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:7:\"#eeeeee\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:18:\"hbb-header-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:1:\"1\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"px\";}s:37:\"section-footer-builder-layout-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"80\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"section-footer-builder-layout-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"section-above-header-builder-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"section-above-header-builder-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"section-below-header-builder-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"section-below-header-builder-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"section-header-mobile-trigger-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:38:\"section-primary-header-builder-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:37:\"section-primary-header-builder-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:20:\"title_tagline-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"section-header-search-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-account-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-mobile-menu-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:33:\"section-header-mobile-menu-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"section-above-footer-builder-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"section-above-footer-builder-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"section-below-footer-builder-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"section-footer-copyright-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:1:\"5\";s:5:\"right\";s:1:\"5\";s:6:\"bottom\";s:1:\"5\";s:4:\"left\";s:1:\"5\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-footer-menu-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"60\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:2:\"20\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:38:\"section-primary-footer-builder-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:2:\"25\";s:6:\"bottom\";s:1:\"3\";s:4:\"left\";s:2:\"25\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:2:\"50\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:2:\"50\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:2:\"25\";s:5:\"right\";s:2:\"25\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:2:\"25\";}s:12:\"desktop-unit\";s:1:\"%\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:37:\"section-primary-footer-builder-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"section-header-woo-cart-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:30:\"section-header-woo-cart-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button1-text\";s:18:\"Call: +1 2345 4445\";s:26:\"header-button1-link-option\";a:3:{s:3:\"url\";s:1:\"#\";s:7:\"new_tab\";s:0:\"\";s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button1-font-family\";s:7:\"inherit\";s:26:\"header-button1-font-weight\";s:7:\"inherit\";s:26:\"header-button1-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button1-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button1-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button1-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button1-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button1-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button1-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button1-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button1-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button1-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button1-border-radius\";s:0:\"\";s:27:\"section-hb-button-1-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button1-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button1-text\";s:6:\"Button\";s:26:\"footer-button1-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button1-font-family\";s:7:\"inherit\";s:26:\"footer-button1-font-weight\";s:7:\"inherit\";s:29:\"footer-button1-text-transform\";s:0:\"\";s:26:\"footer-button1-line-height\";s:0:\"\";s:24:\"footer-button1-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button1-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button1-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button1-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button1-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button1-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button1-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button1-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button1-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-1-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-1-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-1\";s:22:\"Insert HTML text here.\";s:18:\"header-html-1color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-1link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-1link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-1\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-1\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-1\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-1\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-1\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-1color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-1link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-1link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-1\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-1-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-1\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-1\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-1\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-1-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-1-bg-space\";s:0:\"\";s:20:\"header-social-1-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-1-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-1-color\";s:0:\"\";s:23:\"header-social-1-h-color\";s:0:\"\";s:24:\"header-social-1-bg-color\";s:0:\"\";s:26:\"header-social-1-bg-h-color\";s:0:\"\";s:28:\"header-social-1-label-toggle\";b:0;s:26:\"header-social-1-color-type\";s:6:\"custom\";s:34:\"header-social-1-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-1\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-1\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-1-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-1-bg-space\";s:0:\"\";s:20:\"footer-social-1-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-1-radius\";s:0:\"\";s:21:\"footer-social-1-color\";s:0:\"\";s:23:\"footer-social-1-h-color\";s:0:\"\";s:24:\"footer-social-1-bg-color\";s:0:\"\";s:26:\"footer-social-1-bg-h-color\";s:0:\"\";s:28:\"footer-social-1-label-toggle\";b:0;s:26:\"footer-social-1-color-type\";s:6:\"custom\";s:27:\"footer-social-1-brand-color\";s:0:\"\";s:33:\"footer-social-1-brand-label-color\";s:0:\"\";s:34:\"footer-social-1-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-1\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-1\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-1-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-1-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-1-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-1-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-1-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-1-font-family\";s:7:\"inherit\";s:27:\"header-widget-1-font-weight\";s:7:\"inherit\";s:25:\"header-widget-1-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-1-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-1-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-1-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-1-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-1-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-1-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-1-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-1-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-1-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-1-font-family\";s:7:\"inherit\";s:27:\"footer-widget-1-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-1-text-transform\";s:0:\"\";s:27:\"footer-widget-1-line-height\";s:0:\"\";s:25:\"footer-widget-1-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-1-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-1-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-1-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-1-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-1\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:38:\"sidebar-widgets-footer-widget-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu1-bg-color\";s:0:\"\";s:18:\"header-menu1-color\";s:0:\"\";s:23:\"header-menu1-h-bg-color\";s:0:\"\";s:20:\"header-menu1-h-color\";s:0:\"\";s:23:\"header-menu1-a-bg-color\";s:0:\"\";s:20:\"header-menu1-a-color\";s:0:\"\";s:30:\"header-menu1-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu1-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-4)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:7:\"#c2ad76\";}s:34:\"header-menu1-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu1-h-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-0)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu1-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu1-a-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-0)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu1-menu-hover-animation\";s:9:\"underline\";s:40:\"header-menu1-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu1-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu1-submenu-item-border\";b:0;s:32:\"header-menu1-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu1-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu1-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu1-submenu-top-offset\";s:0:\"\";s:26:\"header-menu1-submenu-width\";s:0:\"\";s:27:\"header-menu1-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu1-menu-stack-on-mobile\";b:1;s:22:\"header-menu1-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu1-font-weight\";s:7:\"inherit\";s:24:\"header-menu1-font-family\";s:7:\"inherit\";s:24:\"header-menu1-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button2-text\";s:6:\"Button\";s:26:\"header-button2-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button2-font-family\";s:7:\"inherit\";s:26:\"header-button2-font-weight\";s:7:\"inherit\";s:26:\"header-button2-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button2-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button2-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button2-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button2-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button2-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button2-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button2-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button2-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button2-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button2-border-radius\";s:0:\"\";s:27:\"section-hb-button-2-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button2-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button2-text\";s:6:\"Button\";s:26:\"footer-button2-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button2-font-family\";s:7:\"inherit\";s:26:\"footer-button2-font-weight\";s:7:\"inherit\";s:29:\"footer-button2-text-transform\";s:0:\"\";s:26:\"footer-button2-line-height\";s:0:\"\";s:24:\"footer-button2-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button2-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button2-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button2-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button2-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button2-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button2-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button2-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button2-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-2-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-2-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-2\";s:22:\"Insert HTML text here.\";s:18:\"header-html-2color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-2link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-2link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-2\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-2\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-2\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-2\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-2\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-2color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-2link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-2link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-2\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-2-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-2\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-2\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-2\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-2-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-2-bg-space\";s:0:\"\";s:20:\"header-social-2-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-2-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-2-color\";s:0:\"\";s:23:\"header-social-2-h-color\";s:0:\"\";s:24:\"header-social-2-bg-color\";s:0:\"\";s:26:\"header-social-2-bg-h-color\";s:0:\"\";s:28:\"header-social-2-label-toggle\";b:0;s:26:\"header-social-2-color-type\";s:6:\"custom\";s:34:\"header-social-2-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-2\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-2\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-2-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-2-bg-space\";s:0:\"\";s:20:\"footer-social-2-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-2-radius\";s:0:\"\";s:21:\"footer-social-2-color\";s:0:\"\";s:23:\"footer-social-2-h-color\";s:0:\"\";s:24:\"footer-social-2-bg-color\";s:0:\"\";s:26:\"footer-social-2-bg-h-color\";s:0:\"\";s:28:\"footer-social-2-label-toggle\";b:0;s:26:\"footer-social-2-color-type\";s:6:\"custom\";s:27:\"footer-social-2-brand-color\";s:0:\"\";s:33:\"footer-social-2-brand-label-color\";s:0:\"\";s:34:\"footer-social-2-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-2\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-2\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-2-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-2-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-2-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-2-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-2-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-2-font-family\";s:7:\"inherit\";s:27:\"header-widget-2-font-weight\";s:7:\"inherit\";s:25:\"header-widget-2-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-2-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-2-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-2-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-2-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-2-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-2-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-2-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-2-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-2-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-2-font-family\";s:7:\"inherit\";s:27:\"footer-widget-2-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-2-text-transform\";s:0:\"\";s:27:\"footer-widget-2-line-height\";s:0:\"\";s:25:\"footer-widget-2-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-2-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-2-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-2-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-2-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-2\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:38:\"sidebar-widgets-footer-widget-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu2-bg-color\";s:0:\"\";s:18:\"header-menu2-color\";s:0:\"\";s:23:\"header-menu2-h-bg-color\";s:0:\"\";s:20:\"header-menu2-h-color\";s:0:\"\";s:23:\"header-menu2-a-bg-color\";s:0:\"\";s:20:\"header-menu2-a-color\";s:0:\"\";s:30:\"header-menu2-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu2-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu2-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu2-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu2-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu2-a-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu2-menu-hover-animation\";s:0:\"\";s:40:\"header-menu2-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu2-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu2-submenu-item-border\";b:0;s:32:\"header-menu2-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu2-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu2-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu2-submenu-top-offset\";s:0:\"\";s:26:\"header-menu2-submenu-width\";s:0:\"\";s:27:\"header-menu2-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu2-menu-stack-on-mobile\";b:1;s:22:\"header-menu2-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu2-font-weight\";s:7:\"inherit\";s:24:\"header-menu2-font-family\";s:7:\"inherit\";s:24:\"header-menu2-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button3-text\";s:6:\"Button\";s:26:\"header-button3-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button3-font-family\";s:7:\"inherit\";s:26:\"header-button3-font-weight\";s:7:\"inherit\";s:26:\"header-button3-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button3-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button3-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button3-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button3-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button3-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button3-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button3-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button3-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button3-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button3-border-radius\";s:0:\"\";s:27:\"section-hb-button-3-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button3-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button3-text\";s:6:\"Button\";s:26:\"footer-button3-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button3-font-family\";s:7:\"inherit\";s:26:\"footer-button3-font-weight\";s:7:\"inherit\";s:29:\"footer-button3-text-transform\";s:0:\"\";s:26:\"footer-button3-line-height\";s:0:\"\";s:24:\"footer-button3-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button3-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button3-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button3-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button3-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button3-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button3-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button3-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button3-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-3-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-3-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-3\";s:22:\"Insert HTML text here.\";s:18:\"header-html-3color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-3link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-3link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-3\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-3\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-3\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-3\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-3\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-3color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-3link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-3link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-3\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-3-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-3\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-3\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-3\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-3-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-3-bg-space\";s:0:\"\";s:20:\"header-social-3-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-3-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-3-color\";s:0:\"\";s:23:\"header-social-3-h-color\";s:0:\"\";s:24:\"header-social-3-bg-color\";s:0:\"\";s:26:\"header-social-3-bg-h-color\";s:0:\"\";s:28:\"header-social-3-label-toggle\";b:0;s:26:\"header-social-3-color-type\";s:6:\"custom\";s:34:\"header-social-3-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-3\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-3\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-3-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-3-bg-space\";s:0:\"\";s:20:\"footer-social-3-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-3-radius\";s:0:\"\";s:21:\"footer-social-3-color\";s:0:\"\";s:23:\"footer-social-3-h-color\";s:0:\"\";s:24:\"footer-social-3-bg-color\";s:0:\"\";s:26:\"footer-social-3-bg-h-color\";s:0:\"\";s:28:\"footer-social-3-label-toggle\";b:0;s:26:\"footer-social-3-color-type\";s:6:\"custom\";s:27:\"footer-social-3-brand-color\";s:0:\"\";s:33:\"footer-social-3-brand-label-color\";s:0:\"\";s:34:\"footer-social-3-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-3\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-3\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-3-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-3-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-3-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-3-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-3-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-3-font-family\";s:7:\"inherit\";s:27:\"header-widget-3-font-weight\";s:7:\"inherit\";s:25:\"header-widget-3-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-3-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-3-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-3-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-3-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-3-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-3-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-3-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-3-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-3-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-3-font-family\";s:7:\"inherit\";s:27:\"footer-widget-3-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-3-text-transform\";s:0:\"\";s:27:\"footer-widget-3-line-height\";s:0:\"\";s:25:\"footer-widget-3-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-3-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-3-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-3-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-3-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-3\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:38:\"sidebar-widgets-footer-widget-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu3-bg-color\";s:0:\"\";s:18:\"header-menu3-color\";s:0:\"\";s:23:\"header-menu3-h-bg-color\";s:0:\"\";s:20:\"header-menu3-h-color\";s:0:\"\";s:23:\"header-menu3-a-bg-color\";s:0:\"\";s:20:\"header-menu3-a-color\";s:0:\"\";s:30:\"header-menu3-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu3-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu3-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu3-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu3-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu3-a-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu3-menu-hover-animation\";s:0:\"\";s:40:\"header-menu3-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu3-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu3-submenu-item-border\";b:0;s:32:\"header-menu3-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu3-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu3-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu3-submenu-top-offset\";s:0:\"\";s:26:\"header-menu3-submenu-width\";s:0:\"\";s:27:\"header-menu3-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu3-menu-stack-on-mobile\";b:1;s:22:\"header-menu3-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu3-font-weight\";s:7:\"inherit\";s:24:\"header-menu3-font-family\";s:7:\"inherit\";s:24:\"header-menu3-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button4-text\";s:6:\"Button\";s:26:\"header-button4-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button4-font-family\";s:7:\"inherit\";s:26:\"header-button4-font-weight\";s:7:\"inherit\";s:26:\"header-button4-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button4-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button4-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button4-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button4-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button4-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button4-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button4-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button4-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button4-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button4-border-radius\";s:0:\"\";s:27:\"section-hb-button-4-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button4-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button4-text\";s:6:\"Button\";s:26:\"footer-button4-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button4-font-family\";s:7:\"inherit\";s:26:\"footer-button4-font-weight\";s:7:\"inherit\";s:29:\"footer-button4-text-transform\";s:0:\"\";s:26:\"footer-button4-line-height\";s:0:\"\";s:24:\"footer-button4-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button4-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button4-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button4-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button4-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button4-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button4-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button4-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button4-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-4-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-4-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-4\";s:22:\"Insert HTML text here.\";s:18:\"header-html-4color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-4link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-4link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-4\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-4\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-4\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-4\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-4\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-4color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-4link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-4link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-4\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-4-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-4\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-4\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-4\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-4-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-4-bg-space\";s:0:\"\";s:20:\"header-social-4-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-4-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-4-color\";s:0:\"\";s:23:\"header-social-4-h-color\";s:0:\"\";s:24:\"header-social-4-bg-color\";s:0:\"\";s:26:\"header-social-4-bg-h-color\";s:0:\"\";s:28:\"header-social-4-label-toggle\";b:0;s:26:\"header-social-4-color-type\";s:6:\"custom\";s:34:\"header-social-4-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-4\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-4\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-4-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-4-bg-space\";s:0:\"\";s:20:\"footer-social-4-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-4-radius\";s:0:\"\";s:21:\"footer-social-4-color\";s:0:\"\";s:23:\"footer-social-4-h-color\";s:0:\"\";s:24:\"footer-social-4-bg-color\";s:0:\"\";s:26:\"footer-social-4-bg-h-color\";s:0:\"\";s:28:\"footer-social-4-label-toggle\";b:0;s:26:\"footer-social-4-color-type\";s:6:\"custom\";s:27:\"footer-social-4-brand-color\";s:0:\"\";s:33:\"footer-social-4-brand-label-color\";s:0:\"\";s:34:\"footer-social-4-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-4\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-4\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-4-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-4-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-4-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-4-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-4-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-4-font-family\";s:7:\"inherit\";s:27:\"header-widget-4-font-weight\";s:7:\"inherit\";s:25:\"header-widget-4-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-4-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-4-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-4-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-4-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-4-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-4-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-4-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-4-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-4-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-4-font-family\";s:7:\"inherit\";s:27:\"footer-widget-4-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-4-text-transform\";s:0:\"\";s:27:\"footer-widget-4-line-height\";s:0:\"\";s:25:\"footer-widget-4-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-4-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-4-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-4-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-4-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-4\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:38:\"sidebar-widgets-footer-widget-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu4-bg-color\";s:0:\"\";s:18:\"header-menu4-color\";s:0:\"\";s:23:\"header-menu4-h-bg-color\";s:0:\"\";s:20:\"header-menu4-h-color\";s:0:\"\";s:23:\"header-menu4-a-bg-color\";s:0:\"\";s:20:\"header-menu4-a-color\";s:0:\"\";s:30:\"header-menu4-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu4-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu4-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu4-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu4-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu4-a-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu4-menu-hover-animation\";s:0:\"\";s:40:\"header-menu4-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu4-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu4-submenu-item-border\";b:0;s:32:\"header-menu4-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu4-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu4-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu4-submenu-top-offset\";s:0:\"\";s:26:\"header-menu4-submenu-width\";s:0:\"\";s:27:\"header-menu4-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu4-menu-stack-on-mobile\";b:1;s:22:\"header-menu4-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu4-font-weight\";s:7:\"inherit\";s:24:\"header-menu4-font-family\";s:7:\"inherit\";s:24:\"header-menu4-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button5-text\";s:6:\"Button\";s:26:\"header-button5-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button5-font-family\";s:7:\"inherit\";s:26:\"header-button5-font-weight\";s:7:\"inherit\";s:26:\"header-button5-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button5-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button5-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button5-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button5-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button5-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button5-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button5-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button5-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button5-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button5-border-radius\";s:0:\"\";s:27:\"section-hb-button-5-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button5-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button5-text\";s:6:\"Button\";s:26:\"footer-button5-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button5-font-family\";s:7:\"inherit\";s:26:\"footer-button5-font-weight\";s:7:\"inherit\";s:29:\"footer-button5-text-transform\";s:0:\"\";s:26:\"footer-button5-line-height\";s:0:\"\";s:24:\"footer-button5-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button5-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button5-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button5-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button5-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button5-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button5-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button5-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button5-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-5-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-5-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-5\";s:22:\"Insert HTML text here.\";s:18:\"header-html-5color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-5link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-5link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-5\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-5\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-5\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-5\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-5\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-5color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-5link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-5link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-5\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-5-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-5\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-5\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-5\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-5-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-5-bg-space\";s:0:\"\";s:20:\"header-social-5-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-5-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-5-color\";s:0:\"\";s:23:\"header-social-5-h-color\";s:0:\"\";s:24:\"header-social-5-bg-color\";s:0:\"\";s:26:\"header-social-5-bg-h-color\";s:0:\"\";s:28:\"header-social-5-label-toggle\";b:0;s:26:\"header-social-5-color-type\";s:6:\"custom\";s:34:\"header-social-5-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-5\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-5\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-5-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-5-bg-space\";s:0:\"\";s:20:\"footer-social-5-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-5-radius\";s:0:\"\";s:21:\"footer-social-5-color\";s:0:\"\";s:23:\"footer-social-5-h-color\";s:0:\"\";s:24:\"footer-social-5-bg-color\";s:0:\"\";s:26:\"footer-social-5-bg-h-color\";s:0:\"\";s:28:\"footer-social-5-label-toggle\";b:0;s:26:\"footer-social-5-color-type\";s:6:\"custom\";s:27:\"footer-social-5-brand-color\";s:0:\"\";s:33:\"footer-social-5-brand-label-color\";s:0:\"\";s:34:\"footer-social-5-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-5\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-5\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-5-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-5-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-5-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-5-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-5-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-5-font-family\";s:7:\"inherit\";s:27:\"header-widget-5-font-weight\";s:7:\"inherit\";s:25:\"header-widget-5-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-5-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-5-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-5-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-5-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-5-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-5-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-5-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-5-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-5-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-5-font-family\";s:7:\"inherit\";s:27:\"footer-widget-5-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-5-text-transform\";s:0:\"\";s:27:\"footer-widget-5-line-height\";s:0:\"\";s:25:\"footer-widget-5-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-5-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-5-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-5-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-5-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-5\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:38:\"sidebar-widgets-footer-widget-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu5-bg-color\";s:0:\"\";s:18:\"header-menu5-color\";s:0:\"\";s:23:\"header-menu5-h-bg-color\";s:0:\"\";s:20:\"header-menu5-h-color\";s:0:\"\";s:23:\"header-menu5-a-bg-color\";s:0:\"\";s:20:\"header-menu5-a-color\";s:0:\"\";s:30:\"header-menu5-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu5-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu5-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu5-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu5-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu5-a-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu5-menu-hover-animation\";s:0:\"\";s:40:\"header-menu5-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu5-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu5-submenu-item-border\";b:0;s:32:\"header-menu5-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu5-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu5-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu5-submenu-top-offset\";s:0:\"\";s:26:\"header-menu5-submenu-width\";s:0:\"\";s:27:\"header-menu5-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu5-menu-stack-on-mobile\";b:1;s:22:\"header-menu5-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu5-font-weight\";s:7:\"inherit\";s:24:\"header-menu5-font-family\";s:7:\"inherit\";s:24:\"header-menu5-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button6-text\";s:6:\"Button\";s:26:\"header-button6-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button6-font-family\";s:7:\"inherit\";s:26:\"header-button6-font-weight\";s:7:\"inherit\";s:26:\"header-button6-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button6-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button6-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button6-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button6-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button6-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button6-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button6-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button6-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button6-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button6-border-radius\";s:0:\"\";s:27:\"section-hb-button-6-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button6-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button6-text\";s:6:\"Button\";s:26:\"footer-button6-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button6-font-family\";s:7:\"inherit\";s:26:\"footer-button6-font-weight\";s:7:\"inherit\";s:29:\"footer-button6-text-transform\";s:0:\"\";s:26:\"footer-button6-line-height\";s:0:\"\";s:24:\"footer-button6-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button6-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button6-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button6-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button6-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button6-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button6-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button6-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button6-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-6-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-6-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-6\";s:22:\"Insert HTML text here.\";s:18:\"header-html-6color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-6link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-6link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-6\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-6\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-6\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-6\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-6\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-6color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-6link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-6link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-6\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-6-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-6\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-6\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-6\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-6-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-6-bg-space\";s:0:\"\";s:20:\"header-social-6-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-6-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-6-color\";s:0:\"\";s:23:\"header-social-6-h-color\";s:0:\"\";s:24:\"header-social-6-bg-color\";s:0:\"\";s:26:\"header-social-6-bg-h-color\";s:0:\"\";s:28:\"header-social-6-label-toggle\";b:0;s:26:\"header-social-6-color-type\";s:6:\"custom\";s:34:\"header-social-6-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-6\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-6\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-6-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-6-bg-space\";s:0:\"\";s:20:\"footer-social-6-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-6-radius\";s:0:\"\";s:21:\"footer-social-6-color\";s:0:\"\";s:23:\"footer-social-6-h-color\";s:0:\"\";s:24:\"footer-social-6-bg-color\";s:0:\"\";s:26:\"footer-social-6-bg-h-color\";s:0:\"\";s:28:\"footer-social-6-label-toggle\";b:0;s:26:\"footer-social-6-color-type\";s:6:\"custom\";s:27:\"footer-social-6-brand-color\";s:0:\"\";s:33:\"footer-social-6-brand-label-color\";s:0:\"\";s:34:\"footer-social-6-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-6\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-6\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-6-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-6-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-6-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-6-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-6-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-6-font-family\";s:7:\"inherit\";s:27:\"header-widget-6-font-weight\";s:7:\"inherit\";s:25:\"header-widget-6-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-6-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-6-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-6-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-6-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-6-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-6-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-6-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-6-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-6-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-6-font-family\";s:7:\"inherit\";s:27:\"footer-widget-6-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-6-text-transform\";s:0:\"\";s:27:\"footer-widget-6-line-height\";s:0:\"\";s:25:\"footer-widget-6-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-6-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-6-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-6-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-6-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-6\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:38:\"sidebar-widgets-footer-widget-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu6-bg-color\";s:0:\"\";s:18:\"header-menu6-color\";s:0:\"\";s:23:\"header-menu6-h-bg-color\";s:0:\"\";s:20:\"header-menu6-h-color\";s:0:\"\";s:23:\"header-menu6-a-bg-color\";s:0:\"\";s:20:\"header-menu6-a-color\";s:0:\"\";s:30:\"header-menu6-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu6-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu6-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu6-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu6-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu6-a-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu6-menu-hover-animation\";s:0:\"\";s:40:\"header-menu6-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu6-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu6-submenu-item-border\";b:0;s:32:\"header-menu6-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu6-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu6-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu6-submenu-top-offset\";s:0:\"\";s:26:\"header-menu6-submenu-width\";s:0:\"\";s:27:\"header-menu6-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu6-menu-stack-on-mobile\";b:1;s:22:\"header-menu6-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu6-font-weight\";s:7:\"inherit\";s:24:\"header-menu6-font-family\";s:7:\"inherit\";s:24:\"header-menu6-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button7-text\";s:6:\"Button\";s:26:\"header-button7-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button7-font-family\";s:7:\"inherit\";s:26:\"header-button7-font-weight\";s:7:\"inherit\";s:26:\"header-button7-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button7-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button7-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button7-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button7-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button7-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button7-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button7-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button7-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button7-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button7-border-radius\";s:0:\"\";s:27:\"section-hb-button-7-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button7-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button7-text\";s:6:\"Button\";s:26:\"footer-button7-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button7-font-family\";s:7:\"inherit\";s:26:\"footer-button7-font-weight\";s:7:\"inherit\";s:29:\"footer-button7-text-transform\";s:0:\"\";s:26:\"footer-button7-line-height\";s:0:\"\";s:24:\"footer-button7-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button7-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button7-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button7-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button7-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button7-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button7-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button7-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button7-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-7-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-7-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-7\";s:22:\"Insert HTML text here.\";s:18:\"header-html-7color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-7link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-7link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-7\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-7\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-7\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-7\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-7\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-7color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-7link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-7link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-7\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-7-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-7\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-7\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-7\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-7-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-7-bg-space\";s:0:\"\";s:20:\"header-social-7-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-7-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-7-color\";s:0:\"\";s:23:\"header-social-7-h-color\";s:0:\"\";s:24:\"header-social-7-bg-color\";s:0:\"\";s:26:\"header-social-7-bg-h-color\";s:0:\"\";s:28:\"header-social-7-label-toggle\";b:0;s:26:\"header-social-7-color-type\";s:6:\"custom\";s:34:\"header-social-7-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-7\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-7\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-7-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-7-bg-space\";s:0:\"\";s:20:\"footer-social-7-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-7-radius\";s:0:\"\";s:21:\"footer-social-7-color\";s:0:\"\";s:23:\"footer-social-7-h-color\";s:0:\"\";s:24:\"footer-social-7-bg-color\";s:0:\"\";s:26:\"footer-social-7-bg-h-color\";s:0:\"\";s:28:\"footer-social-7-label-toggle\";b:0;s:26:\"footer-social-7-color-type\";s:6:\"custom\";s:27:\"footer-social-7-brand-color\";s:0:\"\";s:33:\"footer-social-7-brand-label-color\";s:0:\"\";s:34:\"footer-social-7-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-7\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-7\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-7-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-7-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-7-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-7-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-7-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-7-font-family\";s:7:\"inherit\";s:27:\"header-widget-7-font-weight\";s:7:\"inherit\";s:25:\"header-widget-7-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-7-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-7-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-7-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-7-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-7-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-7-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-7-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-7-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-7-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-7-font-family\";s:7:\"inherit\";s:27:\"footer-widget-7-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-7-text-transform\";s:0:\"\";s:27:\"footer-widget-7-line-height\";s:0:\"\";s:25:\"footer-widget-7-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-7-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-7-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-7-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-7-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-7\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:38:\"sidebar-widgets-footer-widget-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu7-bg-color\";s:0:\"\";s:18:\"header-menu7-color\";s:0:\"\";s:23:\"header-menu7-h-bg-color\";s:0:\"\";s:20:\"header-menu7-h-color\";s:0:\"\";s:23:\"header-menu7-a-bg-color\";s:0:\"\";s:20:\"header-menu7-a-color\";s:0:\"\";s:30:\"header-menu7-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu7-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu7-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu7-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu7-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu7-a-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu7-menu-hover-animation\";s:0:\"\";s:40:\"header-menu7-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu7-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu7-submenu-item-border\";b:0;s:32:\"header-menu7-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu7-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu7-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu7-submenu-top-offset\";s:0:\"\";s:26:\"header-menu7-submenu-width\";s:0:\"\";s:27:\"header-menu7-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu7-menu-stack-on-mobile\";b:1;s:22:\"header-menu7-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu7-font-weight\";s:7:\"inherit\";s:24:\"header-menu7-font-family\";s:7:\"inherit\";s:24:\"header-menu7-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button8-text\";s:6:\"Button\";s:26:\"header-button8-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button8-font-family\";s:7:\"inherit\";s:26:\"header-button8-font-weight\";s:7:\"inherit\";s:26:\"header-button8-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button8-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button8-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button8-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button8-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button8-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button8-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button8-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button8-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button8-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button8-border-radius\";s:0:\"\";s:27:\"section-hb-button-8-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button8-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button8-text\";s:6:\"Button\";s:26:\"footer-button8-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button8-font-family\";s:7:\"inherit\";s:26:\"footer-button8-font-weight\";s:7:\"inherit\";s:29:\"footer-button8-text-transform\";s:0:\"\";s:26:\"footer-button8-line-height\";s:0:\"\";s:24:\"footer-button8-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button8-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button8-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button8-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button8-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button8-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button8-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button8-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button8-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-8-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-8-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-8\";s:22:\"Insert HTML text here.\";s:18:\"header-html-8color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-8link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-8link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-8\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-8\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-8\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-8\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-8\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-8color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-8link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-8link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-8\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-8-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-8\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-8\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-8\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-8-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-8-bg-space\";s:0:\"\";s:20:\"header-social-8-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-8-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-8-color\";s:0:\"\";s:23:\"header-social-8-h-color\";s:0:\"\";s:24:\"header-social-8-bg-color\";s:0:\"\";s:26:\"header-social-8-bg-h-color\";s:0:\"\";s:28:\"header-social-8-label-toggle\";b:0;s:26:\"header-social-8-color-type\";s:6:\"custom\";s:34:\"header-social-8-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-8\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-8\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-8-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-8-bg-space\";s:0:\"\";s:20:\"footer-social-8-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-8-radius\";s:0:\"\";s:21:\"footer-social-8-color\";s:0:\"\";s:23:\"footer-social-8-h-color\";s:0:\"\";s:24:\"footer-social-8-bg-color\";s:0:\"\";s:26:\"footer-social-8-bg-h-color\";s:0:\"\";s:28:\"footer-social-8-label-toggle\";b:0;s:26:\"footer-social-8-color-type\";s:6:\"custom\";s:27:\"footer-social-8-brand-color\";s:0:\"\";s:33:\"footer-social-8-brand-label-color\";s:0:\"\";s:34:\"footer-social-8-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-8\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-8\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-8-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-8-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-8-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-8-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-8-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-8-font-family\";s:7:\"inherit\";s:27:\"header-widget-8-font-weight\";s:7:\"inherit\";s:25:\"header-widget-8-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-8-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-8-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-8-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-8-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-8-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-8-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-8-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-8-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-8-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-8-font-family\";s:7:\"inherit\";s:27:\"footer-widget-8-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-8-text-transform\";s:0:\"\";s:27:\"footer-widget-8-line-height\";s:0:\"\";s:25:\"footer-widget-8-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-8-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-8-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-8-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-8-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-8\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:38:\"sidebar-widgets-footer-widget-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu8-bg-color\";s:0:\"\";s:18:\"header-menu8-color\";s:0:\"\";s:23:\"header-menu8-h-bg-color\";s:0:\"\";s:20:\"header-menu8-h-color\";s:0:\"\";s:23:\"header-menu8-a-bg-color\";s:0:\"\";s:20:\"header-menu8-a-color\";s:0:\"\";s:30:\"header-menu8-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu8-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu8-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu8-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu8-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu8-a-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu8-menu-hover-animation\";s:0:\"\";s:40:\"header-menu8-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu8-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu8-submenu-item-border\";b:0;s:32:\"header-menu8-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu8-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu8-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu8-submenu-top-offset\";s:0:\"\";s:26:\"header-menu8-submenu-width\";s:0:\"\";s:27:\"header-menu8-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu8-menu-stack-on-mobile\";b:1;s:22:\"header-menu8-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu8-font-weight\";s:7:\"inherit\";s:24:\"header-menu8-font-family\";s:7:\"inherit\";s:24:\"header-menu8-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button9-text\";s:6:\"Button\";s:26:\"header-button9-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button9-font-family\";s:7:\"inherit\";s:26:\"header-button9-font-weight\";s:7:\"inherit\";s:26:\"header-button9-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button9-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button9-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button9-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0: